<?php

require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

class Plugins_BannerTypeHTML_Outstream_Outstream extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
     
    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
     
    function getOptionDescription()
    {
        return $this->translate("Outstream video Ads");
    }

    function validateForm(&$form)
    {
        return true;
    }

    function processForm($insert, $bannerid, $aFields , $aVariables)
    {

        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $rm_video = '';


        if($_FILES['rm_video']['name'] != '' && $_POST['vid_upload_type'] == "Internal")
        { 
            $target_dir =  $GLOBALS['_MAX']['CONF']['webpath']['images'];
            $target_file = $target_dir ."/". basename($_FILES["rm_video"]["name"]);

            $image = $_FILES['rm_video']['tmp_name'];
            $rm_video = $_FILES['rm_video']['name'];
            $location = "../images/";
    
            if (!file_exists($location.$rm_video)) 
            {
                move_uploaded_file($image,$location.$rm_video);
            }

            $video_url = "";
        }

        else if($_POST['vid_upload_type'] == "External" && $_POST['video_url'] != '')
        {
            $rm_video = '';
            $video_url = $_POST['video_url'];
        }

        else if($_FILES['rm_video']['name'] == '' && $_POST['vid_upload_type'] == "Internal" && $_POST['adupload_type'] != '')
        {
            $rm_video = $_POST['pre_vid'];
        }

        if($_POST['vid_type'] == "Internal"){


            $inlinefields = array(

                        'vid_type'          => $_POST['vid_type'],
                        'vid_upload_type'   => $_POST['vid_upload_type'],
                        'video_url'         => $video_url,
                        'rm_video'          => $rm_video,
                        'destination_url'   => $_POST['destination_url'],
                        'extension_type'    => $_POST['extension_type'],
                        'skip'              => $_POST['skip'],
                        'external_wrapper'  => '',
                        'vast_version'      => '',

                    );

        } else{


            $inlinefields = array(

                        'vid_type'          => $_POST['vid_type'],
                        'vid_upload_type'   => '',
                        'video_url'         => '',
                        'rm_video'          => '',
                        'destination_url'   => '',
                        'extension_type'    => '',
                        'external_wrapper'  => $_POST['external_wrapper'],
                        'skip'              => '',
                        'vast_version'      => $_POST['vast_version'],

                    );
        }

        // echo "<prE>";print_r($inlinefields);exit;

        OA_Dal_Delivery_query("UPDATE {$table_prefix}banners SET parameters = '".serialize($inlinefields)."',url='".$_POST['destination_url']."', width = '-10', height='-10' WHERE bannerid = ".$bannerid);

        return true;
    }
     
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
        return true;
    }
    
    function buildForm(&$form, &$row)
    {
        //FETCH VALUE 
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $array = OA_Dal_Delivery_query("select parameters from {$table_prefix}banners where bannerid ='".$row['bannerid']."' ");
        $values1 = OA_Dal_Delivery_fetchAssoc($array);

        $values = unserialize($values1['parameters']);

        $form->addElement('hidden','vidplay_type',"","");
        $form->addElement('hidden','adplay_type',"","");
        $form->addElement('hidden','adupload_type',"","");
        $form->addElement('hidden','pre_vid',"","");

        //~INTERNAL / EXTERNAL TYPE 
        $Vtype[] = $form->createElement('radio', 'vid_type',"", "Internal", "Internal", array("id" => "internal","values" => "Internal"));
        $Vtype[] = $form->createElement('radio', 'vid_type',"", "External", "External", array("id"=>"external","values"=> "External"));
        $form->addGroup($Vtype, 'vid_type', 'Select Ad Type', "&nbsp;", false);

        //~INTERNAL / EXTERNAL VIDEO TYPE
        $VUtype[] = $form->createElement('radio', 'vid_upload_type',"", "Video Upload", "Internal", array("id" => "vid_internal","values" => "Internal"));
        $VUtype[] = $form->createElement('radio', 'vid_upload_type',"", "Video URL", "External", array("id"=>"vid_external","values"=> "External"));

        $form->addGroup($VUtype, 'vid_upload_type', 'Select Video Upload Type', "&nbsp;", false);
        $front_image = _getContentTypeIconImageName($row['contenttype']);
        $front_size = _getBannerSizeText($type, $row['filename']);

        addUploadGroup($form, $row,
            array(
                'uploadName' => 'rm_video',
                'radioName' => 'rm_rvideo',
                'imageName'  => $front_image,
                'fileName'  => $values['rm_video'],
                'fileSize'  => $front_size,
                'newLabel'  => "Select the <b>Video </b> you want to use for this banner",
                'updateLabel'  => "Do you wish to keep your existing <b>Video</b>, or do you want to upload another?",
                'handleSWF' => true
              )
        );
        $form->addElement('text', 'video_url', 'Video URL');
        $extension_type = array("MP4" => "MP4","WEBM" => "WEBM","HLS" => "HLS");
        $form->addElement('select', 'extension_type','Extension Type',$extension_type); 
        $form->addElement('text', 'skip', 'Skip (In Secs.)', array("placeholder"=> "00:00:00"));
        $form->addElement('text', 'destination_url',"Destination URL");

        $vast_version = array("2" => "Vast 2.0","3" => "Vast 3.0");
        $form->addElement('select', 'vast_version','Vast Version',$vast_version); 
        $form->addElement('textarea', 'external_wrapper', 'Third Party Wrapper');
        
        $form->addElement('header', 'header_b_links', "Banner link");
        $form->addElement('text', 'tp_tag', 'Third Party Tags (optional)',$tp_tag);

        //~DEFAULT VALUES
        $form->setDefaults(array(vidplay_type => $values['vid_type']));
        $form->setDefaults(array(adupload_type => $values['vid_upload_type']));
        $form->setDefaults(array(video_url => $values['video_url'])); 
        $form->setDefaults(array(destination_url => $values['destination_url'])); 
        $form->setDefaults(array(external_wrapper => $values['external_wrapper']));
        $form->setDefaults(array(vast_version => $values['vast_version']));
        $form->setDefaults(array(pre_vid => $values['rm_video']));
        $form->setDefaults(array(skip => $values['skip']));
        
        //~UNIQUE BANNER FOR BANNER LINK
        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());

        //~JS
        $form->addElement('html', 'jsForOUTSTREAMVIDEO', '

            <script>
                
                $("input[name=vid_type]").click(function(){

                    if($(this).val() == "Internal"){

                        hide_attr(1);

                    }else{
                        hide_attr(2);
                    }

                });
                
                var vid_type = "'.$values['vid_type'].'";
                var vid_upload_type = "'.$values['vid_upload_type'].'";

                if(vid_type == ""){

                    hide_attr(0);
                }else{


                    if(vid_upload_type == "Internal"){

                        show_attr(1);
                        $("#vid_internal").attr("checked", true);
                    }else{

                        show_attr(2);
                        $("#vid_external").attr("checked", true);
                    }

                    if(vid_type == "Internal"){

                        hide_attr(1);
                        $("#internal").attr("checked", true);

                    }else{
                        hide_attr(2);
                        $("#external").attr("checked", true);
                        $("#external").trigger("click");
                    }
                }

                function hide_attr(type){

                    if(type == 0){

                        $("input[name=rm_video]").parent().parent().hide();
                        $("#vid_internal").parent().parent().hide();
                        $("#video_url").parent().parent().hide();
                        $("#extension_type").parent().parent().hide();
                        $("#skip").parent().parent().hide();
                        $("#destination_url").parent().parent().hide();
                        $("#external_wrapper").parent().parent().hide();
                        $("#vast_version").parent().parent().hide();
                    }

                    if(type == 1){

                        $("#vid_internal").parent().parent().show();
                        $("#external_wrapper").parent().parent().hide();
                        $("#vast_version").parent().parent().hide();
                    }

                    else if(type == 2){

                        $("#external_wrapper").parent().parent().show();
                        $("#vast_version").parent().parent().show();
                        $("input[name=rm_video]").parent().parent().hide();
                        $("#vid_internal").parent().parent().hide();
                        $("#video_url").parent().parent().hide();
                        $("#extension_type").parent().parent().hide();
                        $("#skip").parent().parent().hide();
                        $("#destination_url").parent().parent().hide();
                    }
                }


                $("input[name=vid_upload_type]").click(function(){

                    if($(this).val() == "Internal"){

                        show_attr(1);
                    }else if ($(this).val() == "External"){
                        show_attr(2);
                    }
                });

                function show_attr(type){

                    if($("input[name=vid_type]").val() == "Internal"){


                        if(type == 1){

                            $("#video_url").parent().parent().hide();
                            $("input[name=rm_video]").parent().parent().show();

                            $("#skip").parent().parent().show();
                            $("#destination_url").parent().parent().show();
                            $("#extension_type").parent().parent().show();
                        }

                        if(type == 2){

                            $("#video_url").parent().parent().show();
                            $("input[name=rm_video]").parent().parent().hide();

                            $("#skip").parent().parent().show();
                            $("#destination_url").parent().parent().show();
                            $("#extension_type").parent().parent().show();
                        }
                    }
                }

            </script>

        ');
             
    }


    
}
