<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-storage.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

// Register input variables
phpAds_registerGlobal ('returnurl');

// Security check
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_ADVERTISER);
OA_Permission::enforceAccessToObject('clients', $clientid, false, OA_Permission::OPERATION_VIEW);

// CVE-2013-5954 - see OA_Permission::checkSessionToken() method for details
OA_Permission::checkSessionToken();

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

if (!empty($campaignid)) {
    $ids = explode(',', $campaignid);
    while (list(,$campaignid) = each($ids)) {

        // Security check
        OA_Permission::enforceAccessToObject('campaigns', $campaignid);

        $doCampaigns = OA_Dal::factoryDO('campaigns');
        $doCampaigns->campaignid = $campaignid;
        if ($doCampaigns->get($campaignid)) {
            $aCampaign = $doCampaigns->toArray();
        }
        
        //  country stats delete ///
         $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $deleval=OA_Dal_Delivery_query("SELECT ban.bannerid FROM {$table_prefix}clients as cli
		JOIN {$table_prefix}campaigns as camp ON cli.clientid = camp.clientid 
		JOIN {$table_prefix}banners as ban ON ban.campaignid = camp.campaignid and camp.campaignid = '".$campaignid."'");
		while($rowdelete = OA_Dal_Delivery_fetchAssoc($deleval))
		{
			
		
		OA_Dal_Delivery_query("delete from {$table_prefix}data_bkt_country_m where creative_id='".$rowdelete['bannerid']."'");
		OA_Dal_Delivery_query("delete from {$table_prefix}data_bkt_country_c where creative_id='".$rowdelete['bannerid']."'");
		OA_Dal_Delivery_query("delete from {$table_prefix}stats_country where creative_id='".$rowdelete['bannerid']."'");
		
		}
		
		//  country stats delete ///
	

        $doCampaigns->delete();
    }

    // Queue confirmation message
    $translation = new OX_Translation ();

    if (count($ids) == 1) {
        $translated_message = $translation->translate ($GLOBALS['strCampaignHasBeenDeleted'], array(
            htmlspecialchars($aCampaign['campaignname'])
        ));
    } else {
        $translated_message = $translation->translate ($GLOBALS['strCampaignsHaveBeenDeleted']);
    }

    OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
}

// Run the Maintenance Priority Engine process
OA_Maintenance_Priority::scheduleRun();

// Rebuild cache
// include_once MAX_PATH . '/lib/max/deliverycache/cache-'.$conf['delivery']['cache'].'.inc.php';
// phpAds_cacheDelete();


/*-------------------------------------------------------*/
/* Return to the index page                              */
/*-------------------------------------------------------*/

if (empty($returnurl)) {
    $returnurl = 'advertiser-campaigns.php';
}

header ("Location: ".$returnurl."?clientid=".$clientid);

?>
