<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

// Register input variables
phpAds_registerGlobal ('returnurl');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);

// CVE-2013-5954 - see OA_Permission::checkSessionToken() method for details
OA_Permission::checkSessionToken();

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

if (!empty($affiliateid)) {
    $ids = explode(',', $affiliateid);
    while (list(,$affiliateid) = each($ids)) {

        // Security check
        OA_Permission::enforceAccessToObject('affiliates', $affiliateid);

        $doAffiliates = OA_Dal::factoryDO('affiliates');
        $doAffiliates->affiliateid = $affiliateid;
        if ($doAffiliates->get($affiliateid)) {
            $aAffiliate = $doAffiliates->toArray();
        }
        
        
        /*Country stats Delete*/
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
       
		$deleval=OA_Dal_Delivery_query("SELECT zoneid FROM {$table_prefix}zones where affiliateid = '".$_GET['affiliateid']."'");

		while($rowdelete = OA_Dal_Delivery_fetchAssoc($deleval))
		{
		
			OA_Dal_Delivery_query("delete from {$table_prefix}data_bkt_country_m where zone_id='".$rowdelete['zoneid']."'");
			OA_Dal_Delivery_query("delete from {$table_prefix}data_bkt_country_c where zone_id='".$rowdelete['zoneid']."'");
			OA_Dal_Delivery_query("delete from {$table_prefix}stats_country where zone_id='".$rowdelete['zoneid']."'");
			
		}
		/*Country stats Delete*/

        $doAffiliates->delete();
    }

    // Queue confirmation message
    $translation = new OX_Translation ();

    if (count($ids) == 1) {
        $translated_message = $translation->translate ( $GLOBALS['strWebsiteHasBeenDeleted'], array(
            htmlspecialchars($aAffiliate['name'])
        ));
    } else {
        $translated_message = $translation->translate ( $GLOBALS['strWebsitesHaveBeenDeleted']);
    }

    OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
}

if (empty($returnurl))
    $returnurl = 'website-index.php';

Header("Location: ".$returnurl);

?>
