<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/
//DAC102 - Connect DB
  require_once '../../init.php';
	
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

	//DAC102 - Connect DB
require_once MAX_PATH . '/lib/OA/Admin/Statistics/Delivery/Common.php';

/**
 * A common class that defines a common "interface" and common methods for
 * classes that display history delivery statistics.
 *
 * @package    OpenXAdmin
 * @subpackage StatisticsDelivery
 */
class OA_Admin_Statistics_Delivery_CommonHistory extends OA_Admin_Statistics_Delivery_Common
{

    /**
     * The starting day of the page's report span.
     *
     * @var PEAR::Date
     */
    var $oStartDate;

    /**
     * The number of days that the page's report spans.
     *
     * @var integer
     */
    var $spanDays;

    /**
     * The number of weeks that the page's report spans.
     *
     * @var integer
     */
    var $spanWeeks;

    /**
     * The number of months that the page's report spans.
     *
     * @var integer
     */
    var $spanMonths;

    /**
     * The type of statistics breakdown to display. One of:
     *  - hour
     *  - day
     *  - week
     *  - month
     *  - dow (ie. Day of Week)
     *
     * @var string
     */
    var $statsBreakdown;

    /**
     * Enter description here...
     *
     * @var unknown_type
     */
    var $statsKey;

    /**
     * Enter description here...
     *
     * @var unknown_type
     */
    var $averageDesc;

    /**
     * PHP5-style constructor
     */
    function __construct($aParams)
    {
        // Set the output type "history" style delivery statistcs
        $this->outputType = 'deliveryHistory';

        // Get list order and direction
        $this->listOrderField     = MAX_getStoredValue('listorder', 'key');
        $this->listOrderDirection = MAX_getStoredValue('orderdirection', 'down');

        // Ensure the history class is prepared
        $this->useHistoryClass = true;

        parent::__construct($aParams);

        // Store the preferences
        $this->aPagePrefs['listorder']      = $this->listOrderField;
        $this->aPagePrefs['orderdirection'] = $this->listOrderDirection;
    }

    /**
     * The final "child" implementation of the parental abstract method,
     * to test if the appropriate data array is empty, or not.
     *
     * @see OA_Admin_Statistics_Common::_isEmptyResultArray()
     *
     * @access private
     * @return boolean True on empty, false if at least one row of data.
     */
    function _isEmptyResultArray()
    {
        if (!is_array($this->aStatsData)) {
            return true;
        }
        foreach($this->aStatsData as $aRecord) {
            if (
                $aRecord['sum_requests'] != '-' ||
                $aRecord['sum_views']    != '-' ||
                $aRecord['sum_clicks']   != '-'
            ) {
                return false;
            }
        }
        return true;
    }

    /**
     * Fetch and decorates the history stats using the specified parameters
     *
     * @param array  $aParams Query parameters
     * @param string $link    Optional link for the leftmost column content
     */
    function prepare(&$aParams, $link = '')
    {
        parent::prepare($aParams);

        // Set the span requirements
        // Disable this for now, since these queries can be very slow
        // $this->oHistory->getSpan($this, $aParams);

        // Get the historical stats
        $aStats = $this->getHistory($aParams, $link);

        if ($this->noStatsAvailable) {
            $this->aStatsData = array();
            return;
        }

        if ($this->disablePager) {
            $use_pager = false;
        } elseif ($this->statsBreakdown == 'week') {
            $per_page  = 4;
            $use_pager = count($stats) > $per_page;
        } elseif ($this->aGlobalPrefs['period_preset'] == 'this_month' || $this->aGlobalPrefs['period_preset'] == 'last_month') {
            // Do not use pager when showing last or current month
            $use_pager = false;
        } elseif ($this->statsBreakdown == 'hour' || $this->statsBreakdown == 'dow') {
            $use_pager = false;
        } else {
            $per_page  = 15;
            $use_pager = count($stats) > $per_page;
        }

        if ($use_pager) {
            $params = array(
                'itemData' => $stats,
                'perPage' => htmlspecialchars(MAX_getStoredValue('setPerPage', $per_page)),
                'delta' => 8,
                'append' => true,
                'clearIfVoid' => false,
                'urlVar' => 'page',
                'useSessions' => false,
                'mode'  => 'Jumping'
            );

            if ($params['perPage'] % $per_page || $params['perPage'] > $per_page * 4) {
                // Reset the perPage and the request parameters when not matching the available values
                $params['perPage']      = $per_page;
                $_REQUEST['setPerPage'] = $per_page;
            }

            $pager =& Pager::factory($params);
            $this->aStatsData = $pager->getPageData();
            $this->pagerLinks = $pager->getLinks();
            $this->pagerLinks = $this->pagerLinks['all'];

            $this->pagerSelect = preg_replace('/(<select.*?)(>)/i', '$1 onchange="this.form.submit()"$2',
                $pager->getPerPageSelectBox($per_page, $per_page * 4, $per_page));
        } else {
            $this->aStatsData = $aStats;
            $this->pagerLinks = false;
            $this->pagerSelect = false;
        }

        $this->aPagePrefs['setPerPage'] = $params['perPage'];

        // Format the rows appropriately for output
        $this->oHistory->formatRows($this->aStatsData, $this);
    }

    function getColspan()
    {
        return count($this->aColumns) + 1;
    }

    /**
     * Fetch the history stats using the specified parameters
     *
     * @param array  $aParams Query parameters
     * @param string $link    Optional link for the leftmost column content
     */
    function getHistory($aParams, $link = '')
    {
        $oNow = new Date();
        $aParams['tz'] = $oNow->tz->getID();

        $method = $this->oHistory->setBreakdownInfo($this);

        // Add plugin aParams
        $pluginParams = array();
        foreach ($this->aPlugins as $oPlugin) {
            $oPlugin->addQueryParams($pluginParams);
        }

        $aStats = Admin_DA::fromCache($method, $aParams + $this->aDates + $pluginParams);



/* Openx Mods - DAC009 */

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$query = OA_Dal_Delivery_query("select * from oxm_realtime") or die("Error->");
$row = OA_Dal_Delivery_fetchAssoc($query);

if($row['realtime'] == 1) {


if($this->aDates['day_begin'] == date('Y-m-d') || $this->aDates['day_end'] == date('Y-m-d') || empty($this->aDates['day_begin'])) {


		if(!empty($aParams['agency_id'])) {

		$viewsel = OA_Dal_Delivery_query("select SUM(count) as count from ".$table_prefix."data_bkt_m as m, ". $table_prefix."campaigns AS ca, ". $table_prefix."banners AS b, ". $table_prefix."clients AS c , ". $table_prefix ."zones as z, ". $table_prefix ."affiliates af where m.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid and c.agencyid = ".$aParams['agency_id']." and m.zone_id = z.zoneid and z.affiliateid = af.affiliateid and af.agencyid =".$aParams['agency_id']." ") or die("Error->");

		$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);

		$clicksel = OA_Dal_Delivery_query("select SUM(count) as count from ".$table_prefix."data_bkt_c as bktc, ". $table_prefix."campaigns AS ca, ". $table_prefix."banners AS b, ". $table_prefix."clients AS c , ". $table_prefix ."zones as z, ". $table_prefix ."affiliates af where bktc.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid and c.agencyid = ".$aParams['agency_id']." and bktc.zone_id = z.zoneid and z.affiliateid = af.affiliateid and af.agencyid =".$aParams['agency_id']." ") or die("Error->");

		$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

		} elseif(!empty($aParams['advertiser_id'])) {

			$banner_list = $this->getbanidbyadvertiser($aParams['advertiser_id']);

					if(!empty($aParams['publisher_id'])) {

						$zone_list = $this->getzoneidbypub($aParams['publisher_id']);

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") and zone_id IN(".$zone_list.") ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") and zone_id IN(".$zone_list.") "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


					} elseif(!empty($aParams['zone_id'])) {

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") and zone_id = ".$aParams['zone_id']." ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") and zone_id = ".$aParams['zone_id']." "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


					} else {

					$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") ") or die("Error->");
					$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
					$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") "); 
					$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

					}


		} elseif(!empty($aParams['placement_id'])) {


				$banner_list = $this->getbanidbycamp($aParams['placement_id']);

				if(!empty($aParams['publisher_id'])) {

					$zone_list = $this->getzoneidbypub($aParams['publisher_id']);

					$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") and zone_id IN(".$zone_list.") ") or die("Error->");
					$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
					$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") and zone_id IN(".$zone_list.") "); 
					$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


				} elseif(!empty($aParams['zone_id'])) {

					$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") and zone_id = ".$aParams['zone_id']." ") or die("Error->");
					$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
					$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") and zone_id = ".$aParams['zone_id']." "); 
					$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


				} else {


					$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") ") or die("Error->");
					$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
					$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") "); 
					$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

				}

		} elseif(!empty($aParams['ad_id'])) {

				if(!empty($aParams['publisher_id'])) {

						$zone_list = $this->getzoneidbypub($aParams['publisher_id']);

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id = ".$aParams['ad_id']." and zone_id IN(".$zone_list.") ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id = ".$aParams['ad_id']." and zone_id IN(".$zone_list.") "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


					} elseif(!empty($aParams['zone_id'])) {

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id = ".$aParams['ad_id']." and zone_id = ".$aParams['zone_id']." ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id = ".$aParams['ad_id']." and zone_id = ".$aParams['zone_id']." "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


					} else {

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id = ".$aParams['ad_id']." ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id = ".$aParams['ad_id']." "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

					}


		} elseif(!empty($aParams['publisher_id'])) {

			$zone_list = $this->getzoneidbypub($aParams['publisher_id']);

			$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id IN(".$zone_list.") ") or die("Error->");
			$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
			$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id IN(".$zone_list.") "); 
			$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

		} elseif(!empty($aParams['zone_id'])) {

			$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id = ".$aParams['zone_id']." ") or die("Error->");
			$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
			$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id = ".$aParams['zone_id']." "); 
			$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


		} else {

			$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m ") or die("Error->");
			$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
			$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c "); 
			$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


		}

			if($method == "getDayHistory") {

				if(empty($this->aDates['day_begin'])) {

					$aStats[date('Y-m-d')]['sum_views'] += $rowview['count'];
					$aStats[date('Y-m-d')]['sum_clicks'] += $rowclick['count'];

				} elseif(!empty($this->aDates['day_end'])) {

					$aStats[date('Y-m-d')]['sum_views'] += $rowview['count'];
					$aStats[date('Y-m-d')]['sum_clicks'] += $rowclick['count'];

				} else {

					$aStats[$this->aDates['day_begin']]['sum_views'] += $rowview['count'];
					$aStats[$this->aDates['day_begin']]['sum_clicks'] += $rowclick['count'];

				}

			} elseif($method == "getMonthHistory") {

				if(!empty($this->aDates['day_begin'])) {

						$month = explode("-",$this->aDates['day_begin']);
						$newMonth = $month[0]."-".$month[1];
						$aStats[$newMonth]['sum_views'] += $rowview['count'];
						$aStats[$newMonth]['sum_clicks'] += $rowclick['count'];

				} else {

						$month = explode("-",date('Y-m-d'));
						$newMonth = $month[0]."-".$month[1];
						$aStats[$newMonth]['sum_views'] += $rowview['count'];
						$aStats[$newMonth]['sum_clicks'] += $rowclick['count'];

				}




			} elseif($method == "getDayOfWeekHistory") {

				$today = getdate();

				$aStats[$today['wday']]['sum_views'] += $rowview['count'];
				$aStats[$today['wday']]['sum_clicks'] += $rowclick['count'];

			} elseif($method == "getHourHistory") {


				$today = getdate();


				$aStats[$today['hours']]['sum_views'] += $rowview['count'];
				$aStats[$today['hours']]['sum_clicks'] += $rowclick['count'];

			}





}

}


/* Openx Mods - DAC009 */
        // Merge plugin additional $oPlugin
        foreach ($this->aPlugins as $oPlugin) {
            $oPlugin->mergeData($aStats, $method, $aParams + $this->aDates, $this->aEmptyRow);
        }

        if (count($aStats) == 0) {
            $this->noStatsAvailable = true;
            return $aStats;
        }

        // Fill unused plugins columns
        foreach (array_keys($aStats) as $k) {
            $aStats[$k] += $this->aEmptyRow;
        }

        // Set some of the variables that used to be set by getSpan
        if (!empty($aStats)) {
            $dates = array_keys ($aStats);

            // assumes first row has earliest date
            $firstDate = new Date ($dates[0]);

            // Convert to current TZ
            $firstDate->setTZbyID('UTC');
            $firstDate->convertTZ($oNow->tz);
            $firstDate->setHour(0);
            $firstDate->setMinute(0);
            $firstDate->setSecond(0);

            if (empty($this->aDates)) {
                $this->aDates['day_begin'] = $firstDate->format('%Y-%m-%d');
                $this->aDates['day_end']   = $oNow->format('%Y-%m-%d');
            }

            $this->oStartDate = new Date($firstDate);
        }

        $aDates = $this->oHistory->getDatesArray($this->aDates, $this->statsBreakdown, $this->oStartDate);
        $this->oHistory->fillGapsAndLink($aStats, $aDates, $this, $link);

        if (!in_array($this->listOrderField, array_merge(array($this->statsBreakdown), array_keys($this->aColumns)))) {
            $this->listOrderField = $this->statsBreakdown;
            $this->listOrderDirection = $this->statsBreakdown == 'hour' || $this->statsBreakdown == 'dow' ? 'up' : 'down';
        }

        // If required, re-format the data in the weekly breakdown format
        if ($this->statsBreakdown == 'week') {
            $this->oHistory->prepareWeekBreakdown($aStats, $this);
        }

        MAX_sortArray($aStats, $this->listOrderField, $this->listOrderDirection == 'up');

        // Summarise the values into a the totals array, & format
        $this->_summariseTotalsAndFormat($aStats, true);

        return $aStats;
    }


/* Openx Mods - DAC009 */

	function getbanidbyadvertiser($advid)
	{

		$banarr = array();


		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

		$advres =OA_Dal_Delivery_query("select * from ".$table_prefix."campaigns c,".$table_prefix."banners b where b.campaignid = c.campaignid and c.clientid =".$advid) or die("Error1 :-->"."Error->");
		
		$advnum = OA_Dal_Delivery_numRows($advres);
		if($advnum>0)
		{
			while($advrow = OA_Dal_Delivery_fetchAssoc($advres))
			{
				$banarr[] = $advrow['bannerid'];
			}
			$banids = implode(",",$banarr);
			return $banids;
		}
		else
		{
		return 0;
		}
	}
		
	function getbanidbycamp($campid)
	{
		


		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

		$banarr = array();


		$advres = OA_Dal_Delivery_query("select * from  ".$table_prefix."banners  where campaignid = ".$campid) or die("something is wrong2");
		$advnum = OA_Dal_Delivery_numRows($advres);
		if($advnum>0)
		{
			while($advrow =OA_Dal_Delivery_fetchAssoc($advres))
			{
				$banarr[] = $advrow['bannerid'];
			}
			$banids = implode(",",$banarr);
			return $banids;
		}
		else
		{
			return 0;
		}
	}
	
	function getzoneidbypub($pubid)
	{
		


		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

		$zonarr = array();
		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix']; 
		$zonres = OA_Dal_Delivery_query("select * from  ".$table_prefix."zones  where affiliateid = ".$pubid) or die("something is wrong1");
		
		$zonnum = OA_Dal_Delivery_numRows($zonres);
		
		if($zonnum>0)
		{
			while($zonrow = OA_Dal_Delivery_fetchAssoc($zonres))
			{
				$zonarr[] = $zonrow['zoneid'];
			}
			$zoneids = implode(",",$zonarr);
			return $zoneids;
		}
		else
		{
			return 0;
		}
	}
	/* Openx Mods - DAC009 */

    /**
     * Exports stats data to an array
     *
     * The array will look like:
     *
     * Array (
     *     'headers' => Array ( 0 => 'Col1', 1 => 'Col2', ... )
     *     'formats' => Array ( 0 => 'date', 1 => 'default', ... )
     *     'data'    => Array (
     *         0 => Array ( 0 => '2006-08-03', 1 => '5', ...),
     *         ...
     *     )
     * )
     *
     * @param array Stats array
     */
    function exportArray()
    {
        $parent = parent::exportArray();

        switch ($this->statsBreakdown) {
            case 'day':
                $key_format = 'date';
                break;
            case 'hour':
                $key_format = 'time';
                break;
            default:
                $key_format = 'text';
                break;
        }

        $headers = array_merge(array($this->statsKey), $parent['headers']);
        $formats = array_merge(array($key_format), $parent['formats']);
        $data    = array();

        $headers[] = $this->statsKey;

        foreach ($this->aStatsData as $h) {
            $row = array();
            if ($this->statsBreakdown == 'week') {
                $row[] = $h['week'];
            } else {
                $row[] = $h['date_f'];
            }
            foreach (array_keys($this->aColumns) as $ck) {
                if ($this->showColumn($ck)) {
                    $row[] = $h[$ck];
                }
            }

            $data[] = $row;
        }

        return array(
            'headers' => $headers,
            'formats' => $formats,
            'data'    => $data
        );
    }
}

?>
