<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/
//DAC102 - Connect DB
  require_once '../../init.php';
	
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

	//DAC102 - Connect DB
require_once MAX_PATH . '/lib/OA/Admin/Statistics/Delivery/Common.php';

/**
 * A common class that defines a common "interface" and common methods for
 * classes that display entity delivery statistics.
 *
 * @package    OpenXAdmin
 * @subpackage StatisticsDelivery
 */
class OA_Admin_Statistics_Delivery_CommonEntity extends OA_Admin_Statistics_Delivery_Common
{

    /** @var boolean */
    var $showHideInactive = false;
    /** @var int */
    var $startLevel;
    /** @var boolean */
    var $hideInactive;
    /** @var int */
    var $hiddenEntities = 0;
    /** @var array */
    var $showHideLevels;

    /** @var array */
    var $data;
    /** @var array */
    var $childrendata;

    /** @var array */
    var $entityLinks = array(
            'a' => 'stats.php?entity=advertiser&breakdown=history',
            'c' => 'stats.php?entity=campaign&breakdown=history',
            'b' => 'stats.php?entity=banner&breakdown=history',
            'p' => 'stats.php?entity=affiliate&breakdown=history',
            'z' => 'stats.php?entity=zone&breakdown=history'
        );

    /**
     * The array of "entity" style delivery statistics data to
     * display in the Flexy template.
     *
     * @var array
     */
    var $aEntitiesData;

    /**
     * PHP5-style constructor
     */
    function __construct($params)
    {
        // Set the output type "entity" style delivery statistcs
        $this->outputType = 'deliveryEntity';

        // Get list order and direction
        $this->listOrderField     = MAX_getStoredValue('listorder', 'name');
        $this->listOrderDirection = MAX_getStoredValue('orderdirection', 'up');

        parent::__construct($params);

        // Store the preferences
        $this->aPagePrefs['listorder']      = $this->listOrderField;
        $this->aPagePrefs['orderdirection'] = $this->listOrderDirection;

        // load the Banners DO class (to be used in entityLink)
        $do = DB_DataObject::factory('Banners');
    }

    /**
     * The final "child" implementation of the parental abstract method,
     * to test if the appropriate data array is empty, or not.
     *
     * @see OA_Admin_Statistics_Common::_isEmptyResultArray()
     *
     * @access private
     * @return boolean True on empty, false if at least one row of data.
     */
    function _isEmptyResultArray()
    {
        if (!is_array($this->aEntitiesData)) {
            return true;
        }
        foreach($this->aEntitiesData as $aRecord) {
            if (
                $aRecord['sum_requests'] != '-' ||
                $aRecord['sum_views']    != '-' ||
                $aRecord['sum_clicks']   != '-'
            ) {
                return false;
            }
        }
        return true;
    }

    /**
     * Recursively convert the tree-style entities array to a flat array
     * suitable for displaying it in a template
     */
    function flattenEntities()
    {
        $i = 0;
        $this->aEntitiesData = $this->_flattenEntities($this->aEntitiesData, $i);
        if (count($this->aEntitiesData)) {
            $this->aEntitiesData[count($this->aEntitiesData) - 1]['htmlclass'] .= ' last';
            $this->aEntitiesData[count($this->aEntitiesData) - 1]['nameclass'] .= ' last';
            foreach (array_keys($this->aEntitiesData) as $k) {
                if ($k && $this->aEntitiesData[$k]['level'] != 0) {
                    $this->aEntitiesData[$k-1]['nameclass'] = 'nb'.$this->aEntitiesData[$k-1]['nameclass'];
                }
            }
        }
    }

    /**
     * Internal function to convert a tree-style entities array to a flat array
     *
     * @param array Entities array
     * @param int Entities array
     * @param array Reference to the parent entity
     *
     * @return array Flat entities array
     */
    function _flattenEntities($aEntitiesData, &$cycle_var, $parent = null)
    {
        $ret = array();

        foreach ($aEntitiesData as $e) {
            if (is_null($parent)) {
                $e['level'] = 0;
                $e['padding'] = 0;

                $e['htmlclass'] = ($cycle_var++ % 2 == 0) ? 'dark' : 'light';
            } else {
                $e['level'] = $parent['level'] + 1;

                $e['htmlclass'] = $parent['htmlclass'];
                $e['padding'] = $parent['padding'] + 16;
            }

            $e['nameclass'] = $e['htmlclass'];

            $sub = null;
            if (isset($e['subentities'])) {
                if (count($e['subentities'])) {
                    $sub = $this->_flattenEntities($e['subentities'], $cycle_var, $e);
                }

                unset($e['subentities']);
            }

            $ret[] = $e;

            if (is_array($sub))
                $ret = array_merge($ret, $sub);
        }

        return $ret;
    }

    /**
     * Return the appriopriate link for an entity -- helper function for Flexy
     */
    function entityLink($key, $type = null)
    {
        return empty($this->entityLinks[$key])
            || $type == DataObjects_Banners::BANNER_TYPE_MARKET
            || $type == MAX_ZoneMarketMigrated
                ?  false
                : $this->entityLinks[$key];
    }

    /**
     * Internal function to aggregate the stats data
     *
     * @param array Entities array
     * @param array Stats row
     * @param string Key name
     */
    function _prepareDataAdd(&$entity, $row, $key)
    {
        if (!isset($entity[$row[$key]])) {
            $entity[$row[$key]][$key] = $row[$key];
            foreach (array_keys($this->aColumns) as $s) {
                $entity[$row[$key]][$s] = 0;
            }
        }

        // Use $row keys instead of $this->column to preserve non visible data
        foreach (array_keys($row) as $s) {
            if (isset($row[$s])) {
                if (!isset($entity[$row[$key]][$s])) {
                    $entity[$row[$key]][$s] = $row[$s];
                }
                if (substr($s, -3) != '_id') {
                    $entity[$row[$key]][$s] += $row[$s];
                }
            }
        }
    }

    /**
     * Fetch and aggregate stats using the specified parameters
     *
     * @param array Query parameters
     */
    function prepareData($aParams)
    {
        if (is_null($this->data))
        {
            $oNow = new Date();
            $aParams['tz'] = $oNow->tz->getID();

            // Get plugin aParams
            $pluginParams = array();
            foreach ($this->aPlugins as $oPlugin) {
                $oPlugin->addQueryParams($pluginParams);
            }

            $aRows = Admin_DA::fromCache('getEntitiesStats', $aParams + $this->aDates + $pluginParams);

 
/* Openx Mods - DAC009 */
		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

$query = OA_Dal_Delivery_query("select * from oxm_realtime") or die("Error->");
$row = OA_Dal_Delivery_fetchAssoc($query);

if($row['realtime'] == 1) {

if(($this->aDates['day_begin'] == date('Y-m-d') || $this->aDates['day_end'] == date('Y-m-d') || empty($this->aDates['day_begin']) ) && empty($aRows)) {


		if(!empty($aParams['agency_id'])) {

if($aParams['include'][0] == "advertiser_id" && $aParams['include'][1] == "placement_id") {


				$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where m.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid and c.agencyid = ".$aParams['agency_id']."  group by m.creative_id , b.campaignid, ca.clientid") or die("Error->");

				while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

					$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where cl.creative_id = ".$rowview['creative_id']." and cl.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by cl.creative_id, b.campaignid, ca.clientid"); 
					if(OA_Dal_Delivery_numRows($clicksel) > 0) {

						while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

						$aRows[$rowview['creative_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '', 'pkey' => $rowview['creative_id']); 

						}

					} else {

						$aRows[$rowview['creative_id']] = array('advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0, 'pkey' => $rowview['creative_id']); 


					}


				}
		

			} elseif($aParams['include'][0] == "publisher_id") {



			$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where m.zone_id = z.zoneid and z.affiliateid = a.affiliateid and a.agencyid = ".$aParams['agency_id']."  group by m.zone_id, a.affiliateid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {


							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where cl.zone_id = ".$rowview['zone_id']." and cl.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by cl.zone_id, a.affiliateid"); 

							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '', 'pkey' => $rowview['zone_id']); 

								}

							} else {

				$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0, 'sum_conversions' => '',  'pkey' => $rowview['zone_id']); 


							}


						}

			}



		} elseif(!empty($aParams['advertiser_id'])) {

			$banner_list = $this->getbanidbyadvertiser($aParams['advertiser_id']);


					if($aParams['include'][0] =='publisher_id') {

$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions,  m.zone_id,a.affiliateid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where m.creative_id IN(".$banner_list.") and m.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by  m.zone_id,a.affiliateid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where cl.zone_id = ".$rowview['zone_id']." and cl.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by cl.zone_id, a.affiliateid"); 
							if(OA_Dal_Delivery_numRows($clicksel) > 0) {



								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '', 'pkey' => $rowview['zone_id']); 

								}

							} else {

				$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0, 'sum_conversions' => '',  'pkey' => $rowview['zone_id']); 


							}


						}


					}  else {


		$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where m.creative_id IN(".$banner_list.") and  m.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by  m.creative_id, b.campaignid, ca.clientid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where cl.creative_id = ".$rowview['creative_id']." and cl.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by cl.creative_id, b.campaignid, ca.clientid"); 
							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['creative_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '',  'pkey' => $rowview['creative_id']); 

								}

							} else {

								$aRows[$rowview['creative_id']] = array('advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0,   'pkey' => $rowview['creative_id']); 


							}


						}
		


					}


		} elseif(!empty($aParams['placement_id'])) {


				$banner_list = $this->getbanidbycamp($aParams['placement_id']);

				if($aParams['include'][0] =='publisher_id') {


$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where m.creative_id IN(".$banner_list.") and m.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by m.zone_id, a.affiliateid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {


							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks,cl.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where cl.zone_id = ".$rowview['zone_id']." and cl.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by cl.zone_id, a.affiliateid"); 
							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '', 'pkey' => $rowview['zone_id']); 

								}

							} else {

				$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0, 'sum_conversions' => '',  'pkey' => $rowview['zone_id']); 


							}


						}


					}  else {

$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where m.creative_id IN(".$banner_list.") and  m.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by m.creative_id, b.campaignid, ca.clientid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.creative_id,  b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where cl.creative_id = ".$rowview['creative_id']." and cl.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by cl.creative_id, b.campaignid, ca.clientid"); 
							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['creative_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '',  'pkey' => $rowview['creative_id']); 

								}

							} else {

								$aRows[$rowview['creative_id']] = array('advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0,   'pkey' => $rowview['creative_id']); 


							}


						}


				}

		} elseif(!empty($aParams['ad_id'])) {



					if($aParams['include'][0] == 'publisher_id') {


$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where m.creative_id = ".$aParams['ad_id']." and m.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by m.zone_id, a.affiliateid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

// changes 
							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks,cl.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where cl.zone_id = ".$rowview['zone_id']." and cl.creative_id = ".$aParams['ad_id']." and cl.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by cl.zone_id, a.affiliateid"); 

							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '', 'pkey' => $rowview['zone_id']); 

								}

							} else {

				$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0, 'sum_conversions' => '',  'pkey' => $rowview['zone_id']); 


							}


						}


					}  else {


$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where m.creative_id = ".$aParams['ad_id']." and  m.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by m.creative_id, b.campaignid, ca.clientid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.creative_id,b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where cl.creative_id = ".$rowview['creative_id']." and cl.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by cl.creative_id, b.campaignid, ca.clientid"); 
							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['creative_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '',  'pkey' => $rowview['creative_id']); 

								}

							} else {

								$aRows[$rowview['creative_id']] = array('advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0,  'pkey' => $rowview['creative_id']); 


							}


						}


					}


		} elseif(!empty($aParams['publisher_id'])) {

			$zone_list = $this->getzoneidbypub($aParams['publisher_id']);

		if($aParams['exclude'][0] == "ad_id") {

				$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where m.zone_id IN(".$zone_list.") and m.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by m.zone_id, a.affiliateid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {


							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.zone_id,a.affiliateid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where cl.zone_id = ".$rowview['zone_id']." and cl.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by cl.zone_id, a.affiliateid"); 

							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '', 'pkey' => $rowview['zone_id']); 

								}

							} else {

				$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0, 'sum_conversions' => '',  'pkey' => $rowview['zone_id']); 


							}


						}
		} elseif($aParams['include'][0] == "placement_id") {

			$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where m.zone_id IN(".$zone_list.") and  m.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by m.creative_id, b.campaignid, ca.clientid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where cl.creative_id = ".$rowview['creative_id']." and cl.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by cl.creative_id, b.campaignid, ca.clientid"); 
							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['creative_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '',  'pkey' => $rowview['creative_id']); 

								}

							} else {

								$aRows[$rowview['creative_id']] = array('advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0,   'pkey' => $rowview['creative_id']); 


							}


						}


		}


	} elseif(!empty($aParams['zone_id'])) {





			if($aParams['include'][0] == "placement_id") {

						$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where m.zone_id =".$aParams['zone_id']." and  m.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by m.creative_id, b.campaignid, ca.clientid") or die("Error->");

// changes
									while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

										$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where cl.creative_id = ".$rowview['creative_id']." and cl.zone_id = ".$aParams['zone_id']." and cl.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by cl.creative_id,  b.campaignid, ca.clientid"); 
										if(OA_Dal_Delivery_numRows($clicksel) > 0) {

											while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

											$aRows[$rowview['creative_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '',  'pkey' => $rowview['creative_id']); 

											}

										} else {

											$aRows[$rowview['creative_id']] = array('advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0,   'pkey' => $rowview['creative_id']); 


										}


									}


					}


		} else {

			if($aParams['include'][0] == "advertiser_id" && $aParams['include'][1] == "placement_id" && empty($aRows)) {


				$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where m.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by m.creative_id,  b.campaignid, ca.clientid") or die("Error->");

				while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {

					$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks, cl.creative_id, b.campaignid, ca.clientid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."banners as b, ".$table_prefix."campaigns as ca, ".$table_prefix."clients as c where cl.creative_id = ".$rowview['creative_id']." and cl.creative_id = b.bannerid and b.campaignid = ca.campaignid and ca.clientid = c.clientid  group by cl.creative_id,  b.campaignid, ca.clientid"); 
					if(OA_Dal_Delivery_numRows($clicksel) > 0) {

						while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

						$aRows[$rowview['creative_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '',  'add' => '1', 'pkey' => $rowview['creative_id']); 

						}

					} else {

						$aRows[$rowview['creative_id']] = array('advertiser_id' => $rowview['clientid'], 'placement_id' => $rowview['campaignid'], 'ad_id' => $rowview['creative_id'], 'sum_views' => $rowview['impressions'], 'add' => '1', 'sum_clicks' => 0, 'pkey' => $rowview['creative_id']); 


					}


				}
		

			} elseif($aParams['include'][0] == "publisher_id"  && empty($aRows)) {

			$viewsel = OA_Dal_Delivery_query( "SELECT sum(m.count) as impressions, m.zone_id, a.affiliateid FROM  ".$table_prefix."data_bkt_m as m, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where m.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by m.zone_id, a.affiliateid") or die("Error->");

						while($rowview = OA_Dal_Delivery_fetchAssoc($viewsel)) {


							$clicksel = OA_Dal_Delivery_query( "SELECT sum(cl.count) as clicks,cl.zone_id,a.affiliateid FROM  ".$table_prefix."data_bkt_c as cl, ".$table_prefix."zones as z, ".$table_prefix."affiliates as a where cl.zone_id = ".$rowview['zone_id']." and cl.zone_id = z.zoneid and z.affiliateid = a.affiliateid  group by cl.zone_id, a.affiliateid"); 

							if(OA_Dal_Delivery_numRows($clicksel) > 0) {

								while($rowclick = OA_Dal_Delivery_fetchAssoc($clicksel)) {

								$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => $rowclick['clicks'], 'sum_conversions' => '', 'pkey' => $rowview['zone_id']); 

								}

							} else {

				$aRows[$rowview['zone_id']] = array('sum_revenue' => '', 'sum_bv' => '', 'sum_num_items' => '','publisher_id' => $rowview['affiliateid'], 'zone_id' => $rowview['zone_id'], 'sum_requests' => '', 'sum_views' => $rowview['impressions'],  'sum_clicks' => 0, 'sum_conversions' => '',  'pkey' => $rowview['zone_id']); 


							}


						}

			}


		}


}

}


/* Openx Mods - DAC009 */

            // Merge plugin additional data
            foreach ($this->aPlugins as $oPlugin) {
                $oPlugin->mergeData($aRows, 'getEntitiesStats', $aParams + $this->aDates, $this->aEmptyRow);
            }

            $this->data = array(
                'advertiser_id' => array(),
                'placement_id'  => array(),
                'ad_id'         => array(),
                'publisher_id'  => array(),
                'zone_id'       => array()
            );

            if (!count($aRows)) {
                $this->noStatsAvailable = true;
                return;
            }

            $aggregates = array('ad_id', 'zone_id');
            if (isset($aParams['exclude'])) {
                $aggregates = array_diff($aggregates, $aParams['exclude']);
            }
            if (isset($aParams['include'])) {
                $aggregates = array_merge($aggregates, $aParams['include']);
            }

            $this->childrendata = array();
            if (array_search('ad_id', $aggregates) !== false) {
                $this->childrendata['ad_id'] = Admin_DA::fromCache('getAds', $aParams);
                // Plugins can set their own ads in the array
                foreach ($this->aPlugins as $oPlugin) {
                    $oPlugin->mergeAds($this->childrendata['ad_id']);
                }
            }
            if (array_search('placement_id', $aggregates) !== false) {
                $this->childrendata['placement_id'] = Admin_DA::fromCache('getPlacementsChildren', $aParams);

                if (isset($this->childrendata['ad_id'])) {
                    foreach ($this->childrendata['ad_id'] as $key => $item) {
                        $this->childrendata['placement_id'][$item['placement_id']]['children'][$key] =& $this->childrendata['ad_id'][$key];
                        $this->childrendata['ad_id'][$key]['advertiser_id'] = $this->childrendata['placement_id'][$item['placement_id']]['advertiser_id'];
                    }
                }
            }
            if (array_search('advertiser_id', $aggregates) !== false) {
                $this->childrendata['advertiser_id'] = Admin_DA::fromCache('getAdvertisersChildren', $aParams);

                if (isset($this->childrendata['placement_id'])) {
                    foreach ($this->childrendata['placement_id'] as $key => $item) {
                        $this->childrendata['advertiser_id'][$item['advertiser_id']]['children'][$key] =& $this->childrendata['placement_id'][$key];
                    }
                }
            }
            if (array_search('zone_id', $aggregates) !== false) {
                $this->childrendata['zone_id'] = Admin_DA::fromCache('getZones', $aParams);
                // Plugins can set their own zones in the array
                foreach ($this->aPlugins as $oPlugin) {
                    $oPlugin->mergeZones($this->childrendata['zone_id']);
                }
            }
            if (array_search('publisher_id', $aggregates) !== false) {
                $this->childrendata['publisher_id'] = Admin_DA::fromCache('getPublishersChildren', $aParams);

                if (isset($this->childrendata['zone_id'])) {
                    foreach ($this->childrendata['zone_id'] as $key => $item) {
                        $this->childrendata['publisher_id'][$item['publisher_id']]['children'][$key] =& $this->childrendata['zone_id'][$key];
                    }
                }
            }

            foreach ($aRows as $row) {
                foreach ($aggregates as $agg) {
                    $this->_prepareDataAdd($this->data[$agg], $row, $agg);
                }
            }
        }
    }

    /**
     * Merge aggregate stats with entity properties (name, children, etc)
     *
     * @param array Query parameters
     * @param string Key name
     * @return array Full entity stats with entity data
     */
    function mergeData($aParams, $key)
    {
        $aEntitiesData = array();

        if (isset($this->childrendata[$key])) {
            if ($key == 'placement_id' && !empty($aParams['advertiser_id'])) {
                if (isset($this->childrendata['advertiser_id'][$aParams['advertiser_id']]['children'])) {
                    $aEntitiesData = $this->childrendata['advertiser_id'][$aParams['advertiser_id']]['children'];
                }
            } elseif ($key == 'ad_id' && !empty($aParams['placement_id'])) {
                if (isset($this->childrendata['placement_id'][$aParams['placement_id']]['children'])) {
                    $aEntitiesData = $this->childrendata['placement_id'][$aParams['placement_id']]['children'];
                }
            } elseif ($key == 'zone_id' && !empty($aParams['publisher_id'])) {
                if (isset($this->childrendata['publisher_id'][$aParams['publisher_id']]['children'])) {
                    $aEntitiesData = $this->childrendata['publisher_id'][$aParams['publisher_id']]['children'];
                }
            } else {
                $aEntitiesData = $this->childrendata[$key];
            }
            foreach (array_keys($aEntitiesData) as $entityId) {
                if (isset($this->data[$key][$entityId])) {
                    $aEntitiesData[$entityId] += $this->data[$key][$entityId];
                } else {
                    foreach (array_keys($this->aColumns) as $s) {
                        $aEntitiesData[$entityId][$s] = 0;
                    }
                }
            }
        }

        return $aEntitiesData;
    }
/* Openx Mods - DAC009 */

	function getbanidbyadvertiser($advid)
	{

		$banarr = array();

		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

		$advres =OA_Dal_Delivery_query("select * from ".$table_prefix."campaigns c,".$table_prefix."banners b where b.campaignid = c.campaignid and c.clientid =".$advid) or die("Error1 :-->"."Error->");
		
		$advnum = OA_Dal_Delivery_numRows($advres);
		if($advnum>0)
		{
			while($advrow = OA_Dal_Delivery_fetchAssoc($advres))
			{
				$banarr[] = $advrow['bannerid'];
			}
			$banids = implode(",",$banarr);
			return $banids;
		}
		else
		{
		return 0;
		}
	}
		
	function getbanidbycamp($campid)
	{
		

	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

		$banarr = array();


		$advres = OA_Dal_Delivery_query("select * from  ".$table_prefix."banners  where campaignid = ".$campid) or die("something is wrong2");
		$advnum = OA_Dal_Delivery_numRows($advres);
		if($advnum>0)
		{
			while($advrow =OA_Dal_Delivery_fetchAssoc($advres))
			{
				$banarr[] = $advrow['bannerid'];
			}
			$banids = implode(",",$banarr);
			return $banids;
		}
		else
		{
			return 0;
		}
	}
	
	function getzoneidbypub($pubid)
	{
		

		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

		$zonarr = array();
		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix']; 
		$zonres = OA_Dal_Delivery_query("select * from  ".$table_prefix."zones  where affiliateid = ".$pubid) or die("something is wrong1");
		
		$zonnum = OA_Dal_Delivery_numRows($zonres);
		
		if($zonnum>0)
		{
			while($zonrow = OA_Dal_Delivery_fetchAssoc($zonres))
			{
				$zonarr[] = $zonrow['zoneid'];
			}
			$zoneids = implode(",",$zonarr);
			return $zoneids;
		}
		else
		{
			return 0;
		}
	}
	/* Openx Mods - DAC009 */

    /**
     * Get advertiser stats
     *
     * @param array Query parameters
     * @param int Tree level
     * @param string Expand GET parameter, used only when called from other get methods
     * @return Entities array
     */
    function getAdvertisers($aParams, $level, $expand = '')
    {
		
		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $aParams['include'] = array('advertiser_id', 'placement_id');
        $aParams['exclude'] = array('zone_id');
        $this->prepareData($aParams);
        $period_preset = MAX_getStoredValue('period_preset', 'today');
        $aAdvertisers = $this->mergeData($aParams, 'advertiser_id');
        MAX_sortArray(
            $aAdvertisers,
            ($this->listOrderField == 'id' ? 'advertiser_id' : $this->listOrderField),
            $this->listOrderDirection == 'up'
        );

        $aEntitiesData = array();
        foreach ($aAdvertisers as $advertiserId => $advertiser) {
 
/* openXmods - DAC009 */


if ($period_preset != "last_week" && $period_preset != "last_7_days" && $period_preset != "last_month" && $period_preset != "specific" && $period_preset != "yesterday") { //1

		$query = OA_Dal_Delivery_query("select * from oxm_realtime") or die("Error->");
		$row = OA_Dal_Delivery_fetchAssoc($query);

		if($row['realtime'] == 1) {//2

			$banner_list = $this->getbanidbyadvertiser($advertiserId);

		$starttime = date('Y-m-d');

		$starttime .= ' 00:00:00';

		$endtime = date('Y-m-d');

		$endtime .= ' 23:00:00';

		$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where ad_id IN(".$banner_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");


		if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($advertiser['sum_views'])) {   //3

			$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") ") or die("Error->");
			$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
			$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") "); 
			$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

	$consel = OA_Dal_Delivery_query("SELECT count(*) as count FROM  ".$table_prefix."data_bkt_a WHERE creative_id IN(".$banner_list.") AND action='1' AND status='4' "); 
			$rowcon = OA_Dal_Delivery_fetchAssoc($consel);
	//Dac102
	
	
		$query =OA_Dal_Delivery_query("SELECT a.bannerid AS ad_id,
                a.campaignid AS campaign_id,
                c.clientid AS advertiser_id,
                c.revenue AS revenue,
                c.revenue_type AS revenue_type
     FROM 
           ".$table_prefix."banners AS a
     JOIN  ".$table_prefix."campaigns AS c
      ON   a.bannerid IN(".$banner_list.")  
      AND  a.campaignid = c.campaignid Where c.revenue!='Null'");
    
    //Parameter Passing    

			$advertiser['sum_views'] +=  $rowview['count'];
			$advertiser['sum_clicks'] +=  $rowclick['count'];
			$advertiser['sum_conversions'] +=  $rowcon['count'];
			
			
			$country_query = OA_Dal_Delivery_query("SELECT revenue,pricing_model from rv_country_bkt_m where creative_id IN(".$banner_list.") ");
			//~ echo "SELECT revenue,pricing_model from rv_country_bkt_m where creative_id IN(".$banner_list.") ";
			//~ echo "<br/>";
			//~ echo $advertiserId;
			//~ echo "<br/>";
			
			
			 while($fetch=OA_Dal_Delivery_fetchAssoc($query))
      {
         $revenue=$fetch['revenue'];
         $ad_id=$fetch['ad_id'];
         
         $revenue_type=$fetch['revenue_type'];
      
       
         	if($revenue_type=='2')
         {
			 			   
			    $revenresult=($revenue*$advertiser['sum_clicks']);
			 
		  }
      
       elseif($revenue_type=='3')
          {
			  
			      $revenresult=($revenue*$advertiser['sum_conversions']);
		 
	       }
		
		 elseif($revenue_type=='1')
          {
			  
	
			    
			    $revenresult=(($revenue*$advertiser['sum_views'])/1000);
		
		 
	       }
        } 
			
			
					
			$advertiser['sum_revenue'] = $revenresult;
		
			
			
//DAc102
		}

	 }



}

/* openXmods - DAC009 */
            $advertiser['active'] = $this->_hasActiveStats($advertiser);

            $this->_summarizeStats($advertiser);

            if ($this->startLevel > $level || !$this->hideInactive || $advertiser['active']) {
                $advertiser['prefix'] = 'a';
                $advertiser['id'] = $advertiserId;
                $advertiser['linkparams'] = "clientid={$advertiserId}&";
                if (is_array($aParams) && count($aParams) > 0) {
                    foreach ($aParams as $key => $value) {
                        if ($key != "include" && $key != "exclude") {
                            $advertiser['linkparams'] .= $key . "=" . $value . "&";
                        }
                    }
                } else {
                    $advertiser['linkparams'] .= "&";
                }
                $advertiser['linkparams'] .= "period_preset={$period_preset}&period_start=" . MAX_getStoredValue('period_start', date('Y-m-d'))
                                          . "&period_end=" . MAX_getStoredValue('period_end', date('Y-m-d'));

                $advertiser['conversionslink'] = "stats.php?entity=conversions&clientid={$advertiserId}";
                $advertiser['expanded'] = MAX_isExpanded($advertiserId, $expand, $this->aNodes, $advertiser['prefix']);
                $advertiser['icon'] = MAX_getEntityIcon('advertiser', $advertiser['active'], $advertiser['type']);

                if ($advertiser['expanded'] || $this->startLevel > $level) {
                    $aParams2 = $aParams + array('advertiser_id' => $advertiserId);
                    $advertiser['subentities'] = $this->getCampaigns($aParams2, $level + 1, $expand);
                }

                $aEntitiesData[] = $advertiser;
            } elseif ($this->startLevel == $level) {
                $this->hiddenEntities++;
            }
        }

        return $aEntitiesData;
    }

    /**
     * Get campaign stats
     *
     * @param array Query parameters
     * @param int Tree level
     * @param string Expand GET parameter, used only when called from other get methods
     * @return Entities array
     */
    function getCampaigns($aParams, $level, $expand = '')
    {
  	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $aParams['include'] = array('placement_id', 'advertiser_id');
        $aParams['exclude'] = array('zone_id');
        $this->prepareData($aParams);
        $period_preset = MAX_getStoredValue('period_preset', 'today');

        $aPlacements = $this->mergeData($aParams, 'placement_id');
        MAX_sortArray(
            $aPlacements,
            ($this->listOrderField == 'id' ? 'placement_id' : $this->listOrderField),
            $this->listOrderDirection == 'up'
        );

        $aEntitiesData = array();
        foreach ($aPlacements as $campaignId => $campaign) {
/* openXmods - DAC009 */

       if ($period_preset != "last_week" && $period_preset != "last_7_days" && $period_preset != "last_month" && $period_preset != "specific" && $period_preset != "yesterday") { //1


		$query = OA_Dal_Delivery_query("select * from oxm_realtime") or die("Error->");
		$row = OA_Dal_Delivery_fetchAssoc($query);

		if($row['realtime'] == 1) { //2

			$banner_list = $this->getbanidbycamp($campaignId);

			if(!empty($aParams['publisher_id'])) { //3

				$zone_list = $this->getzoneidbypub($aParams['publisher_id']);

				$starttime = date('Y-m-d');

				$starttime .= ' 00:00:00';

				$endtime = date('Y-m-d');

				$endtime .= ' 23:00:00';

				$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where ad_id IN(".$banner_list.") and zone_id IN(".$zone_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->123");
	

				if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($campaign['sum_views'])) { //4

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") and zone_id IN(".$zone_list.")  ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") and zone_id IN(".$zone_list.") "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

					$campaign['sum_views'] +=  $rowview['count'];
					$campaign['sum_clicks'] +=  $rowclick['count'];

			      } 



			} elseif(!empty($aParams['zone_id'])) {

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where ad_id IN(".$banner_list.") and zone_id = ".$aParams['zone_id']." and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->in zone cam");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($campaign['sum_views'])) {

							$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") and zone_id = ".$aParams['zone_id']." ") or die("Error->in zone cam");
							$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
							$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") zone_id = ".$aParams['zone_id']." "); 
							$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

						$campaign['sum_views'] +=  $rowview['count'];
						$campaign['sum_clicks'] +=  $rowclick['count'];

					}



			} else {

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where ad_id IN(".$banner_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error-> empty ");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($campaign['sum_views']) ) {

							$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id IN(".$banner_list.") ") or die("Error->empty");
							$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
							$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id IN(".$banner_list.") "); 
							$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

						$campaign['sum_views'] +=  $rowview['count'];
						$campaign['sum_clicks'] +=  $rowclick['count'];
					}

			}



		}



}

/* openXmods - DAC009 */
            $campaign['active'] = $this->_hasActiveStats($campaign);

            if ($this->startLevel > $level || !$this->hideInactive || $campaign['active']) {

                $this->_summarizeStats($campaign);
                // mask anonymous campaigns if advertiser
                if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
                    // a) mask campaign name
                    $campaign['name'] = MAX_getPlacementName($campaign);
                    // b) mask ad names
                    if ($campaign['anonymous'] == 't') {
                        if(isset($campaign['children'])) {
		                    foreach ($campaign['children'] as $ad_id => $ad) {
		                        $campaign['children'][$ad_id]['name'] = MAX_getAdName($ad['name'], null, null, $campaign['anonymous'], $ad_id);
		                    }
                        }
                    }
                }

                $campaign['prefix'] = 'c';
                $campaign['id'] = $campaignId;
                $campaign['linkparams'] = "clientid={$campaign['advertiser_id']}&campaignid={$campaignId}&";
                if (is_array($aParams) && count($aParams) > 0) {
                    foreach ($aParams as $key => $value) {
                        if ($key != "include" && $key != "exclude") {
                            $campaign['linkparams'] .= $key . "=" . $value . "&";
                        }
                    }
                } else {
                    $campaign['linkparams'] .= "&";
                }
                $campaign['linkparams'] .= "period_preset={$period_preset}&period_start=" . MAX_getStoredValue('period_start', date('Y-m-d'))
                                          . "&period_end=" . MAX_getStoredValue('period_end', date('Y-m-d'));
                $campaign['expanded'] = MAX_isExpanded($campaignId, $expand, $this->aNodes, $campaign['prefix']);
                $campaign['icon'] = MAX_getEntityIcon('placement', $campaign['active'], $campaign['type']);

                $htmlToAppend = '';
                if($campaign['mtype'] == DataObjects_Campaigns::CAMPAIGN_TYPE_MARKET_CAMPAIGN_OPTIN) {
                    $htmlToAppend = $this->getHtmlHelpLink('help-market-optin-campaign');
                } else if($campaign['mtype'] == DataObjects_Campaigns::CAMPAIGN_TYPE_MARKET_ZONE_OPTIN) {
                    $htmlToAppend = $this->getHtmlHelpLink('help-market-optin-zone');
                }
                $campaign['html-append'] = $htmlToAppend;


                // mask anonymous campaigns
                // a) mask campaign name
                $campaign['name'] = MAX_getPlacementName($campaign);
                if($campaign['mtype'] == DataObjects_Campaigns::CAMPAIGN_TYPE_MARKET_CAMPAIGN_OPTIN) {
                    $campaign['name'] = $GLOBALS['strMarketCampaignOptin'];
                } else if($campaign['mtype'] == DataObjects_Campaigns::CAMPAIGN_TYPE_MARKET_ZONE_OPTIN) {
                    $campaign['name'] = $GLOBALS['strMarketZoneOptin'];
                }

                // b) mask ad names
                if(isset($campaign['children'])) {
	                foreach ($campaign['children'] as $ad_id => $ad) {
	                    $campaign['children'][$ad_id]['name'] = MAX_getAdName($ad['name'], null, null, $campaign['anonymous'], $ad_id);
	                }
                }
                if ($campaign['expanded'] || $this->startLevel > $level) {
                    $aParams2 = $aParams + array('placement_id' => $campaignId);
                    $campaign['subentities'] = $this->getBanners($aParams2, $level + 1, $expand);
                }

                $aEntitiesData[] = $campaign;
            } elseif ($this->startLevel == $level) {
                $this->hiddenEntities++;
            }
        }

        return $aEntitiesData;
    }

    /**
     * Returns the HTML used to display the help icon triggering the tooltip
     * @param $id ID of the html div to show on hover
     * @return string
     */
    private function getHtmlHelpLink($id)
    {
        return '<span class="link" help="'. $id .'"><span class="icon icon-info"></span></span>';
    }

    /**
     * Get banner stats
     *
     * @param array Query parameters
     * @param int Tree level
     * @param string Expand GET parameter, used only when called from other get methods
     * @return Entities array
     */
    function getBanners($aParams, $level, $expand = '')
    {
				$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        global $phpAds_IAB;
        require_once MAX_PATH . '/www/admin/lib-size.inc.php';

        $aParams['include'] = array('placement_id'); // Needed to fetch the advertiser_id
        $aParams['exclude'] = array('zone_id');
        $this->prepareData($aParams);
        $period_preset = MAX_getStoredValue('period_preset', 'today');

        $aAds = $this->mergeData($aParams, 'ad_id');
        MAX_sortArray(
            $aAds,
            ($this->listOrderField == 'id' ? 'ad_id' : $this->listOrderField),
            $this->listOrderDirection == 'up'
        );

        $aEntitiesData = array();
        foreach ($aAds as $bannerId => $banner) {
 
/* openXmods - DAC009 */


 if ($period_preset != "last_week" && $period_preset != "last_7_days" && $period_preset != "last_month" && $period_preset != "specific" && $period_preset != "yesterday") {


$query = OA_Dal_Delivery_query("select * from oxm_realtime") or die("Error->");
$row = OA_Dal_Delivery_fetchAssoc($query);

if($row['realtime'] == 1) {

			if(!empty($aParams['publisher_id'])) {


			$zone_list = $this->getzoneidbypub($aParams['publisher_id']);


				$starttime = date('Y-m-d');

				$starttime .= ' 00:00:00';

				$endtime = date('Y-m-d');

				$endtime .= ' 23:00:00';

				$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where ad_id = ".$bannerId."  and zone_id IN(".$zone_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->ban1");
	

						if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($banner['sum_views'])) {

								$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id = ".$bannerId." and zone_id IN(".$zone_list.")  ") or die("Error->ban1");
								$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
								$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id = ".$bannerId." and zone_id IN(".$zone_list.") "); 
								$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


		

							$banner['sum_views'] +=  $rowview['count'];
							$banner['sum_clicks'] +=  $rowclick['count'];

						}



			} elseif(!empty($aParams['zone_id'])) {

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where ad_id = ".$bannerId." and zone_id = ".$aParams['zone_id']." and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->ban2");
	

							if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($banner['sum_views'])) {


									$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id = ".$bannerId." and zone_id = ".$aParams['zone_id']." ") or die("Error->ban2");
									$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
									$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id = ".$bannerId." and zone_id = ".$aParams['zone_id']." "); 
									$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


		

								$banner['sum_views'] +=  $rowview['count'];
								$banner['sum_clicks'] +=  $rowclick['count'];


							} 



			} else {


					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where ad_id = ".$bannerId." and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->ban3");
	

								if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($banner['sum_views'])) {

										$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE creative_id = ".$bannerId." ") or die("Error->ban3");
										$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
										$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE creative_id = ".$bannerId." "); 
										$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);


		

									$banner['sum_views'] +=  $rowview['count'];
								$banner['sum_clicks'] +=  $rowclick['count'];


								}


			}


		}



}

/* openXmods - DAC009 */
            $banner['active'] = $this->_hasActiveStats($banner);

            if ($this->startLevel > $level || !$this->hideInactive || $banner['active']) {

                $this->_summarizeStats($banner);
                // mask banner name if anonymous campaign
                $campaign = Admin_DA::getPlacement($banner['placement_id']);
                $campaignAnonymous = $campaign['anonymous'] == 't' ? true : false;

                if($banner['type'] == DataObjects_Banners::BANNER_TYPE_MARKET) {
                    $marketBannerNameAndAdvertiserId = $this->getMarketBannerName($banner['name']);
                    $banner['name'] = $marketBannerNameAndAdvertiserId['name'];
                    $banner['marketAdvertiserId'] = $marketBannerNameAndAdvertiserId['marketAdvertiserId'];

                }
                $banner['name'] = MAX_getAdName($banner['name'], null, null, $campaignAnonymous, $bannerId);

                $banner['prefix'] = 'b';
                $banner['id'] = $bannerId;
                $banner['linkparams'] = "clientid={$banner['advertiser_id']}&campaignid={$banner['placement_id']}&bannerid={$bannerId}&";
                if (is_array($aParams) && count($aParams) > 0) {
                    foreach ($aParams as $key => $value) {
                        if ($key != "include" && $key != "exclude") {
                            $banner['linkparams'] .= $key . "=" . $value . "&";
                        }
                    }
                } else {
                    $banner['linkparams'] .= "&";
                }
                $banner['linkparams'] .= "period_preset={$period_preset}&period_start=" . MAX_getStoredValue('period_start', date('Y-m-d'))
                                          . "&period_end=" . MAX_getStoredValue('period_end', date('Y-m-d'));
                $banner['expanded'] = false;
                $banner['icon'] = MAX_getEntityIcon('ad', $banner['active'], $banner['type'], $banner['marketAdvertiserId']);

                $aEntitiesData[] = $banner;
            } elseif ($this->startLevel == $level) {
                $this->hiddenEntities++;
            }
        }

        return $aEntitiesData;
    }

    function getMarketBannerName($bannerName)
    {
        $marketAdvertiserId = false;
        // Market ads are written in the array as "campaignid-$NAME" which is a unique ID
        // across this manager
        $startRealBannerName = 1 + strpos($bannerName, '_');
        if($startRealBannerName !== false) {
            $bannerName = substr($bannerName, $startRealBannerName);
            // the banner $NAME can be
            // - "$ADVERTISERID_$ADWIDTH x $ADHEIGHT"
            // - or "$AD_WIDTH x $AD_HEIGHT"
            $startBannerDimension = strpos($bannerName, '_');

            $marketAdvertiserName = false;
            if($startBannerDimension === false) {
                $bannerDimensions = $bannerName;
            } else {
                $bannerDimensions = substr($bannerName, $startBannerDimension + 1);
                $marketAdvertiserId = substr($bannerName, 0, $startBannerDimension);

                if(!empty($marketAdvertiserId)) {
                    $marketAdvertiserName = $this->getMarketAdvertiserNameFromId($marketAdvertiserId);
                }
                if($marketAdvertiserName) {
                    $bannerName = $marketAdvertiserName . ' - ' .$bannerDimensions;
                }
            }
            if($marketAdvertiserName === false)
            {
                $bannerDimensions = explode('x', $bannerDimensions);
                $width = trim($bannerDimensions[0]);
                $height = trim($bannerDimensions[1]);
                $bannerName = phpAds_getBannerSize($width, $height);
                $bannerName = $bannerName;
            }
        }
        return array(
            'name' => $bannerName,
            'marketAdvertiserId' => $marketAdvertiserId
        );
    }
    /**
     * Loads the list of market advertisers once, and returns the name for the given market advertiser ID
     * @param $marketAdvertiserId
     * @return string or false
     */
    protected function getMarketAdvertiserNameFromId($marketAdvertiserId)
    {
        static $advertiserList = null;
        if(is_null($advertiserList)) {
            $oDbh = OA_DB::singleton();
            $query = 'SELECT market_advertiser_id, name
            			FROM '.$GLOBALS['_MAX']['CONF']['table']['prefix'].'ext_market_advertiser
            			';
            $rows = $oDbh->queryAll($query);
            foreach($rows as $row) {
                $advertiserList[$row['market_advertiser_id']] = utf8_encode($row['name']);
            }
        }
        if(isset($advertiserList[$marketAdvertiserId])) {
            return $advertiserList[$marketAdvertiserId];
        }
        return false;
    }

    /**
     * Get publisher stats
     *
     * @param array Query parameters
     * @param int Tree level
     * @param string Expand GET parameter, used only when called from other get methods
     * @return Entities array
     */
    function getPublishers($aParams, $level, $expand = '')
    {
  
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $aParams['include'] = array('publisher_id');
        $aParams['exclude'] = array('ad_id');
        $this->prepareData($aParams);
        $period_preset = MAX_getStoredValue('period_preset', 'today');

        $aPublishers = $this->mergeData($aParams, 'publisher_id');
        MAX_sortArray(
            $aPublishers,
            ($this->listOrderField == 'id' ? 'publisher_id' : $this->listOrderField),
            $this->listOrderDirection == 'up'
        );

        $aEntitiesData = array();
        foreach ($aPublishers as $publisherId => $publisher) {
	 /* openXmods - DAC009 */





       if ($period_preset != "last_week" && $period_preset != "last_7_days" && $period_preset != "last_month" && $period_preset != "specific" && $period_preset != "yesterday") {


		$query = OA_Dal_Delivery_query("select * from oxm_realtime") or die("Error->");
		$row = OA_Dal_Delivery_fetchAssoc($query);

		if($row['realtime'] == 1) {

			$zone_list = $this->getzoneidbypub($publisherId);


			if(!empty($aParams['advertiser_id'])) {



			$banner_list = $this->getbanidbyadvertiser($aParams['advertiser_id']);

						$starttime = date('Y-m-d');

						$starttime .= ' 00:00:00';

						$endtime = date('Y-m-d');

						$endtime .= ' 23:00:00';

						$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where zone_id IN(".$zone_list.") and ad_id IN(".$banner_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");
	

						if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($publisher['sum_views'])) {

							$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id IN(".$zone_list.") and creative_id IN(".$banner_list.") ") or die("Error->");
							$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
							$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id IN(".$zone_list.") and creative_id IN(".$banner_list.") "); 
							$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

							$publisher['sum_views'] +=  $rowview['count'];
							$publisher['sum_clicks'] +=  $rowclick['count'];

						}



			} elseif(!empty($aParams['placement_id'])) {



			$banner_list = $this->getbanidbycamp($aParams['placement_id']);

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where zone_id IN(".$zone_list.") and ad_id IN(".$banner_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($publisher['sum_views'])) {

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id IN(".$zone_list.") and creative_id IN(".$banner_list.") ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id IN(".$zone_list.") and creative_id IN(".$banner_list.") "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

						$publisher['sum_views'] +=  $rowview['count'];
						$publisher['sum_clicks'] +=  $rowclick['count'];


					}



			} elseif(!empty($aParams['ad_id'])) {

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where zone_id IN(".$zone_list.") and ad_id =".$aParams['ad_id']."  and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($publisher['sum_views'])) {

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id IN(".$zone_list.") and creative_id =".$aParams['ad_id']." ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id IN(".$zone_list.") and creative_id =".$aParams['ad_id']." "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

						$publisher['sum_views'] +=  $rowview['count'];
						$publisher['sum_clicks'] +=  $rowclick['count'];


					}

			

			} else {


					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where zone_id IN(".$zone_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($publisher['sum_views'])) {


						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id IN(".$zone_list.") ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id IN(".$zone_list.") "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

						$publisher['sum_views'] +=  $rowview['count'];
						$publisher['sum_clicks'] +=  $rowclick['count'];

					}


			}


      

		}


}

/* openXmods - DAC009 */
            $publisher['active'] = $this->_hasActiveStats($publisher);

            $this->_summarizeStats($publisher);

            if ($this->startLevel > $level || !$this->hideInactive || $publisher['active']) {
                $publisher['prefix'] = 'p';
                $publisher['id'] = $publisherId;
                $publisher['linkparams'] = "affiliateid={$publisherId}&";
                if (is_array($aParams) && count($aParams) > 0) {
                    foreach ($aParams as $key => $value) {
                        if ($key != "include" && $key != "exclude") {
                            $publisher['linkparams'] .= $key . "=" . $value . "&";
                        }
                    }
                } else {
                    $publisher['linkparams'] .= "&";
                }
                $publisher['linkparams'] .= "period_preset={$period_preset}&period_start=" . MAX_getStoredValue('period_start', date('Y-m-d'))
                                          . "&period_end=" . MAX_getStoredValue('period_end', date('Y-m-d'));
                $publisher['expanded'] = MAX_isExpanded($publisherId, $expand, $this->aNodes, $publisher['prefix']);
                $publisher['icon'] = MAX_getEntityIcon('publisher', $publisher['active']);

                if ($publisher['expanded'] || $this->startLevel > $level) {
                    $aParams2 = $aParams + array('publisher_id' => $publisherId);
                    $publisher['subentities'] = $this->getZones($aParams2, $level + 1, $expand);
                }

                $aEntitiesData[] = $publisher;
            } elseif ($this->startLevel == $level) {
                $this->hiddenEntities++;
            }
        }

        return $aEntitiesData;
    }

    /**
     * Get zone stats
     *
     * @param array Query parameters
     * @param int Tree level
     * @param string Expand GET parameter, used only when called from other get methods
     * @return Entities array
     */
    function getZones($aParams, $level, $expand)
    {
		$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $aParams['exclude'] = array('ad_id');
        $aParams['include'] = array('publisher_id');
        $this->prepareData($aParams);
        $period_preset = MAX_getStoredValue('period_preset', 'today');

        $aZones = $this->mergeData($aParams, 'zone_id');
        MAX_sortArray(
            $aZones,
            ($this->listOrderField == 'id' ? 'zone_id' : $this->listOrderField),
            $this->listOrderDirection == 'up'
        );

        $aEntitiesData = array();
        foreach ($aZones as $zoneId => $zone) {
/* openXmods - DAC009 */


       if ($period_preset != "last_week" && $period_preset != "last_7_days" && $period_preset != "last_month" && $period_preset != "specific" && $period_preset != "yesterday") {



		$query = OA_Dal_Delivery_query("select * from oxm_realtime") or die("Error->");
		$row = OA_Dal_Delivery_fetchAssoc($query);

		if($row['realtime'] == 1) {

			if(!empty($aParams['advertiser_id'])) {

			$banner_list = $this->getbanidbyadvertiser($aParams['advertiser_id']);

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where zone_id = ".$zoneId." and ad_id IN(".$banner_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($zone['sum_views'])) {

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id = ".$zoneId." and creative_id IN(".$banner_list.") ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id = ".$zoneId." and creative_id IN(".$banner_list.") "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

			$zone['sum_views'] +=  $rowview['count'];
			$zone['sum_clicks'] +=  $rowclick['count'];

					}



			} elseif(!empty($aParams['placement_id'])) {

			$banner_list = $this->getbanidbycamp($aParams['placement_id']);

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where zone_id = ".$zoneId."  and ad_id IN(".$banner_list.") and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($zone['sum_views'])) {

						$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id = ".$zoneId." and creative_id IN(".$banner_list.") ") or die("Error->");
						$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
						$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id zone_id = ".$zoneId." and creative_id IN(".$banner_list.") "); 
						$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

			$zone['sum_views'] +=  $rowview['count'];
			$zone['sum_clicks'] +=  $rowclick['count'];

					}



			} elseif(!empty($aParams['ad_id'])) {

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where zone_id = ".$zoneId."  and ad_id =".$aParams['ad_id']." and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($zone['sum_views'])) {

							$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id = ".$zoneId." and creative_id =".$aParams['ad_id']." ") or die("Error->");
							$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
							$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id = ".$zoneId." and creative_id =".$aParams['ad_id']." "); 
							$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

			$zone['sum_views'] +=  $rowview['count'];
			$zone['sum_clicks'] +=  $rowclick['count'];

					}



			

			} else {

					$starttime = date('Y-m-d');

					$starttime .= ' 00:00:00';

					$endtime = date('Y-m-d');

					$endtime .= ' 23:00:00';

					$queryCheck = OA_Dal_Delivery_query("select * from ".$table_prefix."data_summary_ad_hourly where zone_id = ".$zoneId." and date_time >='".$starttime."' and date_time <='".$endtime."' ") or die("Error->");
	

					if(OA_Dal_Delivery_numRows($queryCheck) > 0 || empty($zone['sum_views'])) {

			
							$viewsel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_m WHERE zone_id = ".$zoneId." ") or die("Error->");
							$rowview = OA_Dal_Delivery_fetchAssoc($viewsel);
		
							$clicksel = OA_Dal_Delivery_query("SELECT sum(count) as count FROM  ".$table_prefix."data_bkt_c WHERE zone_id = ".$zoneId." "); 
							$rowclick = OA_Dal_Delivery_fetchAssoc($clicksel);

			$zone['sum_views'] +=  $rowview['count'];
			$zone['sum_clicks'] +=  $rowclick['count'];

					}


			}




		}



}

/* openXmods - DAC009 */
            $zone['active'] = $this->_hasActiveStats($zone);

            if ($this->startLevel > $level || !$this->hideInactive || $zone['active']) {

                $this->_summarizeStats($zone);

                $zone['prefix'] = 'z';
                $zone['id'] = $zoneId;
                $zone['linkparams'] = "affiliateid={$zone['publisher_id']}&zoneid={$zoneId}&";
                if (is_array($aParams) && count($aParams) > 0) {
                    foreach ($aParams as $key => $value) {
                        if ($key != "include" && $key != "exclude") {
                            $zone['linkparams'] .= $key . "=" . $value . "&";
                        }
                    }
                } else {
                    $zone['linkparams'] .= "&";
                }
                $zone['linkparams'] .= "period_preset={$period_preset}&period_start=" . MAX_getStoredValue('period_start', date('Y-m-d'))
                                          . "&period_end=" . MAX_getStoredValue('period_end', date('Y-m-d'));
                $zone['expanded'] = MAX_isExpanded($zoneId, $expand, $this->aNodes, $zone['prefix']);;
                $zone['icon'] = MAX_getEntityIcon('zone', $zone['active'], $zone['type']);

                $aEntitiesData[] = $zone;
            } elseif ($this->startLevel == $level) {
                $this->hiddenEntities++;
            }
        }

        return $aEntitiesData;
    }

    /**
     * Exports stats data to an array
     *
     * The array will look like:
     *
     * Array (
     *     'headers' => Array ( 0 => 'Col1', 1 => 'Col2', ... )
     *     'formats' => Array ( 0 => 'text', 1 => 'default', ... )
     *     'data'    => Array (
     *         0 => Array ( 0 => 'Entity 1', 1 => '5', ...),
     *         ...
     *     )
     * )
     *
     * @param array Stats array
     */
    function exportArray()
    {
        $parent = parent::exportArray();

        $headers = array_merge(array($GLOBALS['strName']), $parent['headers']);
        $formats = array_merge(array('text'), $parent['formats']);
        $data    = array();

        foreach ($this->aEntitiesData as $e) {
            $row = array();
            $row[] = $e['name'];
            foreach (array_keys($this->aColumns) as $ck) {
                if ($this->showColumn($ck)) {
                    $row[] = $e[$ck];
                }
            }

            $data[] = $row;
        }

        return array(
            'headers' => $headers,
            'formats' => $formats,
            'data'    => $data
        );
    }
}

?>
