<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/max/Admin/Invocation.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

// Security check
// OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_TRAFFICKER);
// OA_Permission::enforceAccessToObject('affiliates', $affiliateid);
OA_Permission::enforceAccessToObject('zones', $zoneid);

if (OA_Permission::isAccount(OA_ACCOUNT_TRAFFICKER)) {
    OA_Permission::enforceAllowed(OA_PERM_ZONE_INVOCATION);
}

/*-------------------------------------------------------*/
/* Store preferences                   */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

// Initialise some parameters

$query =OA_Dal_Delivery_query("select * from {$table_prefix}zones  where zoneid='$zoneid'");
$values= OA_Dal_Delivery_fetchAssoc($query);

$select=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select * from {$table_prefix}dj_admin_configuration"));
$url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https://' : 'http://';
  
if( $values['delivery']==10 ||  $values['delivery']==0 )
{
  
  if($values['app_select'] == 1)
  {
    if($values['mobileapptype'] == 'android')
    {
      if(!empty($select['SDK_Androidpath']))
      {   
        header("Location:".$select['SDK_Androidpath']);
      }
    }
    elseif($values['mobileapptype'] == 'ios')
    {
      if(!empty($select['SDK_iOSpath']))  
      {
      
        header("Location:".$select['SDK_iOSpath']);
      }
    }
    else
    {
      $url=$url.$GLOBALS['_MAX']['CONF']['webpath']['admin']."account-settings-adminconfiguration.php";
      echo "<b><i>Please configure the App path in Admin($url)</i></b>";
    }
  }
  else
  {
    invocation();
  }
}
else
{
invocation();
}

function invocation()
{
$pageName = basename($_SERVER['SCRIPT_NAME']);
$tabIndex = 1;
$agencyId = OA_Permission::getAgencyId();
$aEntities = array('affiliateid' => $affiliateid, 'zoneid' => $zoneid);

$aOtherPublishers = Admin_DA::getPublishers(array('agency_id' => $agencyId));
$aOtherZones = Admin_DA::getZones(array('publisher_id' => $affiliateid));
MAX_displayNavigationZone($pageName, $aOtherPublishers, $aOtherZones, $aEntities);

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

$dalZones = OA_Dal::factoryDAL('zones');
$zoneid=$_GET['zoneid'];
if ($zone = $dalZones->getZoneForInvocationForm($zoneid)) {
    $extra = array('affiliateid' => $affiliateid,
                   'zoneid' => $zoneid,
                   'width' => $zone['width'],
                   'height' => $zone['height'],
                   'delivery' => $zone['delivery'],
                   'website' => $zone['website']
    );
    // Ensure 3rd Party Click Tracking defaults to the preference for this agency
    if (!isset($thirdpartytrack)) {
        $thirdpartytrack = $GLOBALS['_MAX']['CONF']['delivery']['clicktracking'];
    }
    $maxInvocation = new MAX_Admin_Invocation();
    echo $maxInvocation->placeInvocationForm($extra, true);
}
}
/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

phpAds_PageFooter();

?>
