<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    Plugin
 * @subpackage openxDeliveryLog
 */

function Plugin_deliveryLog_OxLogDev_LogImpressionViewDev_Delivery_logImpression($adId = 0, $zoneId = 0, $okToLog = true)
{
    if (!$okToLog) { return false; }
    
    $custom_data = $GLOBALS['_MAX']['custom_data'];
     $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
    
    if(!$custom_data)
    {
	    $custom_data = $GLOBALS['_MAX']['custom_data'] = OX_bucket_customData();
	
	}
	$aData = $GLOBALS['_MAX']['deliveryData'];
	//keyword tracking start
     $keyword_str = $_GET['targetkeyword']; 
  
   
     if($keyword_str)
    {
		
		$keywords = explode(",", $keyword_str);
    
    
		$query = array();
		foreach($keywords as $key)
		{
			if(!empty($key))
			{
				$interval_start = date('Y-m-d H:00:00');
				$creative_id = $aData['creative_id'];
				$zone_id = $aData['zone_id'];
				
				$query[] = ' ("'.$interval_start.'","'.$creative_id.'" ,"'.$zone_id.'" ,"'.$key.'" , 1 ) ';
			}
		}
	
		if($query)
		{
		
		 $mainQuery = "INSERT INTO  {$table_prefix}data_bkt_keyword_v VALUES  ".implode(',',$query)."  ON DUPLICATE KEY UPDATE count=count+1 ";
		 
			OA_Dal_Delivery_query($mainQuery); 
		}
		
	} 
	//keyword tracking end
	
    
    
    $aQuery = array(
        'interval_start' => $aData['interval_start'],
        'creative_id'    => (int)$aData['creative_id'],
        'zone_id'        => (int)$aData['zone_id'],
        'country'      	 => $custom_data['country'],
        'os'      	 	 =>  $custom_data['os'],
        'category'       =>  $_REQUEST['category'],

        'device'      	 =>  $custom_data['device']
    );   


	if($_REQUEST['event'] =="view")
	{
		   return OX_bucket_updateTable('data_bkt_Dev_v', $aQuery);
	}
	
    
    
}

if(!function_exists('OX_bucket_customData'))
{
	
	function OX_bucket_customData()
	{
	
	$data = $GLOBALS['_MAX']['deliveryData'];
    $ip = $data['ip_address'];

    $ipdat = @json_decode(file_get_contents( 
        "http://www.geoplugin.net/json.gp?ip=" . $ip));
        
        
        
        $clientinfo = $GLOBALS['_MAX']['CLIENT'];
    $browser = $clientinfo['wrapper']->getBrowserName();
    $os = $clientinfo['wrapper']->getOsName();
    $os_version = $clientinfo['wrapper']->getOsVersion();

    $useragent=$clientinfo['ua'];

    ## DEVICE DETECTION
        
    $tablet_browser = 0;
    $mobile_browser = 0;
     
    if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
        $tablet_browser++;
    }
     
    if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
        $mobile_browser++;
    }
     
    if ((strpos(strtolower($_SERVER['HTTP_ACCEPT']),'application/vnd.wap.xhtml+xml') > 0) or ((isset($_SERVER['HTTP_X_WAP_PROFILE']) or isset($_SERVER['HTTP_PROFILE'])))) {
        $mobile_browser++;
    }
     
    $mobile_ua = strtolower(substr($_SERVER['HTTP_USER_AGENT'], 0, 4));
    $mobile_agents = array(
        'w3c ','acs-','alav','alca','amoi','audi','avan','benq','bird','blac',
        'blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno',
        'ipaq','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-',
        'maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-',
        'newt','noki','palm','pana','pant','phil','play','port','prox',
        'qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar',
        'sie-','siem','smal','smar','sony','sph-','symb','t-mo','teli','tim-',
        'tosh','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp',
        'wapr','webc','winw','winw','xda ','xda-');
     
    if (in_array($mobile_ua,$mobile_agents)) {
        $mobile_browser++;
    }
     
    if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'opera mini') > 0) {
        $mobile_browser++;

        //Check for tablets on opera mini alternative headers
        $stock_ua = strtolower(isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])?$_SERVER['HTTP_X_OPERAMINI_PHONE_UA']:(isset($_SERVER['HTTP_DEVICE_STOCK_UA'])?$_SERVER['HTTP_DEVICE_STOCK_UA']:''));
        if (preg_match('/(tablet|ipad|playbook)|(android(?!.*mobile))/i', $stock_ua)) {
          $tablet_browser++;
        }
    }

    $device = '';
    $device_version = '';
     
    if ($tablet_browser > 0) {
       $device = 'Tablet';
    }
    else if ($mobile_browser > 0) {
       $device = 'Mobile';
    }
    else {
       $device = 'Desktop';
    }   

    ## LANGUAGE DETECTION
    $language = '';
     
    if (empty($_REQUEST['language'])) {
        $language = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
    } else {
        $language = $_REQUEST['language'];
    }

    $language = preg_replace('/;q=[0-9\.]+$/', '', $language);
    $host = $_SERVER['REMOTE_HOST'];
    if(!empty($_REQUEST['loc']))
    {
        $domain = parse_url($_GET['loc']);
        $full_domain = $domain['host']; 

    }
    else
    {
        $full_domain = $_SERVER['REMOTE_HOST'];    
    } 
    
    
    return array( 'country'      	  => $ipdat->geoplugin_countryName,
        'os'      	 	 => $os,
        'device'      	  => $device);
        
	
	}
}
 
 
