<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// This is by no means a complete list of all ISO-3166-2 level 2 subdivisions,
// but rather an unofficial list compiled by the Revive Adserver developers.

$RV_Geo_ISO3166_2_S2 = [
    'AZ' => [
        'AZ-NX' => [
            'AZ-BAB' => 'Babək',
            'AZ-CUL' => 'Culfa',
            'AZ-KAN' => 'Kǝngǝrli',
            'AZ-NV' => 'Naxçıvan',
            'AZ-ORD' => 'Ordubad',
            'AZ-SAD' => 'Sədərək',
            'AZ-SAH' => 'Şahbuz',
            'AZ-SAR' => 'Şərur',
        ],
    ],
    'BD' => [
        'BD-D' => [
            'BD-05' => 'Bagerhat',
            'BD-12' => 'Chuadanga',
            'BD-22' => 'Jessore',
            'BD-23' => 'Jhenaidah',
            'BD-27' => 'Khulna',
            'BD-30' => 'Kushtia',
            'BD-37' => 'Magura',
            'BD-39' => 'Meherpur',
            'BD-43' => 'Narail',
            'BD-58' => 'Satkhira',
        ],
        'BD-B' => [
            'BD-01' => 'Bandarban',
            'BD-04' => 'Brahmanbaria',
            'BD-09' => 'Chandpur',
            'BD-10' => 'Chittagong',
            'BD-08' => 'Comilla',
            'BD-11' => 'Cox\'s Bazar',
            'BD-16' => 'Feni',
            'BD-29' => 'Khagrachhari',
            'BD-31' => 'Lakshmipur',
            'BD-47' => 'Noakhali',
            'BD-56' => 'Rangamati',
        ],
        'BD-A' => [
            'BD-02' => 'Barguna',
            'BD-06' => 'Barisal',
            'BD-07' => 'Bhola',
            'BD-25' => 'Jhalakathi',
            'BD-51' => 'Patuakhali',
            'BD-50' => 'Pirojpur',
        ],
        'BD-E' => [
            'BD-03' => 'Bogra',
            'BD-45' => 'Chapai Nawabganj',
            'BD-24' => 'Joypurhat',
            'BD-48' => 'Naogaon',
            'BD-44' => 'Natore',
            'BD-49' => 'Pabna',
            'BD-54' => 'Rajshahi',
            'BD-59' => 'Sirajganj',
        ],
        'BD-C' => [
            'BD-13' => 'Dhaka',
            'BD-15' => 'Faridpur',
            'BD-18' => 'Gazipur',
            'BD-17' => 'Gopalganj',
            'BD-26' => 'Kishoreganj',
            'BD-36' => 'Madaripur',
            'BD-33' => 'Manikganj',
            'BD-35' => 'Munshiganj',
            'BD-40' => 'Narayanganj',
            'BD-42' => 'Narsingdi',
            'BD-53' => 'Rajbari',
            'BD-62' => 'Shariatpur',
            'BD-63' => 'Tangail',
        ],
        'BD-F' => [
            'BD-14' => 'Dinajpur',
            'BD-19' => 'Gaibandha',
            'BD-28' => 'Kurigram',
            'BD-32' => 'Lalmonirhat',
            'BD-46' => 'Nilphamari',
            'BD-52' => 'Panchagarh',
            'BD-55' => 'Rangpur',
            'BD-64' => 'Thakurgaon',
        ],
        'BD-G' => [
            'BD-20' => 'Habiganj',
            'BD-38' => 'Moulvibazar',
            'BD-61' => 'Sunamganj',
            'BD-60' => 'Sylhet',
        ],
        'BD-H' => [
            'BD-21' => 'Jamalpur',
            'BD-34' => 'Mymensingh',
            'BD-41' => 'Netrakona',
            'BD-57' => 'Sherpur',
        ],
    ],
    'BF' => [
        'BF-01' => [
            'BF-BAL' => 'Balé',
            'BF-BAN' => 'Banwa',
            'BF-KOS' => 'Kossi',
            'BF-MOU' => 'Mouhoun',
            'BF-NAY' => 'Nayala',
            'BF-SOR' => 'Sourou',
        ],
        'BF-05' => [
            'BF-BAM' => 'Bam',
            'BF-NAM' => 'Namentenga',
            'BF-SMT' => 'Sanmatenga',
        ],
        'BF-07' => [
            'BF-BAZ' => 'Bazèga',
            'BF-NAO' => 'Nahouri',
            'BF-ZOU' => 'Zoundwéogo',
        ],
        'BF-13' => [
            'BF-BGR' => 'Bougouriba',
            'BF-IOB' => 'Ioba',
            'BF-NOU' => 'Noumbiel',
            'BF-PON' => 'Poni',
        ],
        'BF-04' => [
            'BF-BLG' => 'Boulgou',
            'BF-KOP' => 'Koulpélogo',
            'BF-KOT' => 'Kouritenga',
        ],
        'BF-06' => [
            'BF-BLK' => 'Boulkiemdé',
            'BF-SNG' => 'Sanguié',
            'BF-SIS' => 'Sissili',
            'BF-ZIR' => 'Ziro',
        ],
        'BF-02' => [
            'BF-COM' => 'Comoé',
            'BF-LER' => 'Léraba',
        ],
        'BF-11' => [
            'BF-GAN' => 'Ganzourgou',
            'BF-KOW' => 'Kourwéogo',
            'BF-OUB' => 'Oubritenga',
        ],
        'BF-08' => [
            'BF-GNA' => 'Gnagna',
            'BF-GOU' => 'Gourma',
            'BF-KMD' => 'Komondjari',
            'BF-KMP' => 'Kompienga',
            'BF-TAP' => 'Tapoa',
        ],
        'BF-09' => [
            'BF-HOU' => 'Houet',
            'BF-KEN' => 'Kénédougou',
            'BF-TUI' => 'Tuy',
        ],
        'BF-03' => [
            'BF-KAD' => 'Kadiogo',
        ],
        'BF-10' => [
            'BF-LOR' => 'Loroum',
            'BF-PAS' => 'Passoré',
            'BF-YAT' => 'Yatenga',
            'BF-ZON' => 'Zondoma',
        ],
        'BF-12' => [
            'BF-OUD' => 'Oudalan',
            'BF-SOM' => 'Soum',
            'BF-SEN' => 'Séno',
            'BF-YAG' => 'Yagha',
        ],
    ],
    'CV' => [
        'CV-B' => [
            'CV-BV' => 'Boa Vista',
            'CV-PA' => 'Paul',
            'CV-PN' => 'Porto Novo',
            'CV-RB' => 'Ribeira Brava',
            'CV-RG' => 'Ribeira Grande',
            'CV-SL' => 'Sal',
            'CV-SV' => 'São Vicente',
            'CV-TS' => 'Tarrafal de São Nicolau',
        ],
        'CV-S' => [
            'CV-BR' => 'Brava',
            'CV-MA' => 'Maio',
            'CV-MO' => 'Mosteiros',
            'CV-PR' => 'Praia',
            'CV-RS' => 'Ribeira Grande de Santiago',
            'CV-CA' => 'Santa Catarina',
            'CV-CF' => 'Santa Catarina do Fogo',
            'CV-CR' => 'Santa Cruz',
            'CV-SD' => 'São Domingos',
            'CV-SF' => 'São Filipe',
            'CV-SO' => 'São Lourenço dos Órgãos',
            'CV-SM' => 'São Miguel',
            'CV-SS' => 'São Salvador do Mundo',
            'CV-TA' => 'Tarrafal',
        ],
    ],
    'CZ' => [
        'CZ-20' => [
            'CZ-201' => 'Benešov',
            'CZ-202' => 'Beroun',
            'CZ-203' => 'Kladno',
            'CZ-204' => 'Kolín',
            'CZ-205' => 'Kutná Hora',
            'CZ-207' => 'Mladá Boleslav',
            'CZ-206' => 'Mělník',
            'CZ-208' => 'Nymburk',
            'CZ-209' => 'Praha-východ',
            'CZ-20A' => 'Praha-západ',
            'CZ-20B' => 'Příbram',
            'CZ-20C' => 'Rakovník',
        ],
        'CZ-64' => [
            'CZ-641' => 'Blansko',
            'CZ-642' => 'Brno-město',
            'CZ-643' => 'Brno-venkov',
            'CZ-644' => 'Břeclav',
            'CZ-645' => 'Hodonín',
            'CZ-646' => 'Vyškov',
            'CZ-647' => 'Znojmo',
        ],
        'CZ-80' => [
            'CZ-801' => 'Bruntál',
            'CZ-802' => 'Frýdek Místek',
            'CZ-803' => 'Karviná',
            'CZ-804' => 'Nový Jičín',
            'CZ-805' => 'Opava',
            'CZ-806' => 'Ostrava-město',
        ],
        'CZ-41' => [
            'CZ-411' => 'Cheb',
            'CZ-412' => 'Karlovy Vary',
            'CZ-413' => 'Sokolov',
        ],
        'CZ-42' => [
            'CZ-422' => 'Chomutov',
            'CZ-421' => 'Děčín',
            'CZ-423' => 'Litoměřice',
            'CZ-424' => 'Louny',
            'CZ-425' => 'Most',
            'CZ-426' => 'Teplice',
            'CZ-427' => 'Ústí nad Labem',
        ],
        'CZ-53' => [
            'CZ-531' => 'Chrudim',
            'CZ-532' => 'Pardubice',
            'CZ-533' => 'Svitavy',
            'CZ-534' => 'Ústí nad Orlicí',
        ],
        'CZ-32' => [
            'CZ-321' => 'Domažlice',
            'CZ-322' => 'Klatovy',
            'CZ-324' => 'Plzeň-jih',
            'CZ-323' => 'Plzeň-město',
            'CZ-325' => 'Plzeň-sever',
            'CZ-326' => 'Rokycany',
            'CZ-327' => 'Tachov',
        ],
        'CZ-63' => [
            'CZ-631' => 'Havlíčkův Brod',
            'CZ-632' => 'Jihlava',
            'CZ-633' => 'Pelhřimov',
            'CZ-634' => 'Třebíč',
            'CZ-635' => 'Žďár nad Sázavou',
        ],
        'CZ-52' => [
            'CZ-521' => 'Hradec Králové',
            'CZ-522' => 'Jičín',
            'CZ-523' => 'Náchod',
            'CZ-524' => 'Rychnov nad Kněžnou',
            'CZ-525' => 'Trutnov',
        ],
        'CZ-51' => [
            'CZ-512' => 'Jablonec nad Nisou',
            'CZ-513' => 'Liberec',
            'CZ-514' => 'Semily',
            'CZ-511' => 'Česká Lípa',
        ],
        'CZ-71' => [
            'CZ-711' => 'Jeseník',
            'CZ-712' => 'Olomouc',
            'CZ-713' => 'Prostějov',
            'CZ-714' => 'Přerov',
            'CZ-715' => 'Šumperk',
        ],
        'CZ-31' => [
            'CZ-313' => 'Jindřichův Hradec',
            'CZ-315' => 'Prachatice',
            'CZ-314' => 'Písek',
            'CZ-316' => 'Strakonice',
            'CZ-317' => 'Tábor',
            'CZ-311' => 'České Budějovice',
            'CZ-312' => 'Český Krumlov',
        ],
        'CZ-72' => [
            'CZ-721' => 'Kroměříž',
            'CZ-722' => 'Uherské Hradiště',
            'CZ-723' => 'Vsetín',
            'CZ-724' => 'Zlín',
        ],
        'CZ-10' => [
            'CZ-101' => 'Praha 1',
            'CZ-110' => 'Praha 10',
            'CZ-111' => 'Praha 11',
            'CZ-112' => 'Praha 12',
            'CZ-113' => 'Praha 13',
            'CZ-114' => 'Praha 14',
            'CZ-115' => 'Praha 15',
            'CZ-116' => 'Praha 16',
            'CZ-117' => 'Praha 17',
            'CZ-118' => 'Praha 18',
            'CZ-119' => 'Praha 19',
            'CZ-102' => 'Praha 2',
            'CZ-120' => 'Praha 20',
            'CZ-121' => 'Praha 21',
            'CZ-122' => 'Praha 22',
            'CZ-103' => 'Praha 3',
            'CZ-104' => 'Praha 4',
            'CZ-105' => 'Praha 5',
            'CZ-106' => 'Praha 6',
            'CZ-107' => 'Praha 7',
            'CZ-108' => 'Praha 8',
            'CZ-109' => 'Praha 9',
        ],
    ],
    'DO' => [
        'DO-41' => [
            'DO-02' => 'Azua',
            'DO-17' => 'Peravia',
            'DO-21' => 'San Cristóbal',
            'DO-31' => 'San José de Ocoa',
        ],
        'DO-38' => [
            'DO-03' => 'Baoruco',
            'DO-04' => 'Barahona',
            'DO-10' => 'Independencia',
            'DO-16' => 'Pedernales',
        ],
        'DO-34' => [
            'DO-05' => 'Dajabón',
            'DO-15' => 'Monte Cristi',
            'DO-26' => 'Santiago Rodríguez',
            'DO-27' => 'Valverde',
        ],
        'DO-40' => [
            'DO-01' => 'Distrito Nacional (Santo Domingo)',
            'DO-32' => 'Santo Domingo',
        ],
        'DO-33' => [
            'DO-06' => 'Duarte',
            'DO-19' => 'Hermanas Mirabal',
            'DO-14' => 'María Trinidad Sánchez',
            'DO-20' => 'Samaná',
        ],
        'DO-42' => [
            'DO-08' => 'El Seibo',
            'DO-11' => 'La Altagracia',
            'DO-12' => 'La Romana',
        ],
        'DO-37' => [
            'DO-07' => 'Elías Piña',
            'DO-22' => 'San Juan',
        ],
        'DO-35' => [
            'DO-09' => 'Espaillat',
            'DO-18' => 'Puerto Plata',
            'DO-25' => 'Santiago',
        ],
        'DO-39' => [
            'DO-30' => 'Hato Mayor',
            'DO-29' => 'Monte Plata',
            'DO-23' => 'San Pedro de Macorís',
        ],
        'DO-36' => [
            'DO-13' => 'La Vega',
            'DO-28' => 'Monseñor Nouel',
            'DO-24' => 'Sánchez Ramírez',
        ],
    ],
    'ES' => [
        'ES-CM' => [
            'ES-AB' => 'Albacete',
            'ES-CR' => 'Ciudad Real',
            'ES-CU' => 'Cuenca',
            'ES-GU' => 'Guadalajara',
            'ES-TO' => 'Toledo',
        ],
        'ES-VC' => [
            'ES-A' => 'Alicante',
            'ES-CS' => 'Castellón',
            'ES-V' => 'Valencia',
        ],
        'ES-AN' => [
            'ES-AL' => 'Almería',
            'ES-CA' => 'Cádiz',
            'ES-CO' => 'Córdoba',
            'ES-GR' => 'Granada',
            'ES-H' => 'Huelva',
            'ES-J' => 'Jaén',
            'ES-MA' => 'Málaga',
            'ES-SE' => 'Sevilla',
        ],
        'ES-AS' => [
            'ES-O' => 'Asturias',
        ],
        'ES-EX' => [
            'ES-BA' => 'Badajoz',
            'ES-CC' => 'Cáceres',
        ],
        'ES-CT' => [
            'ES-B' => 'Barcelona',
        ],
        'ES-CL' => [
            'ES-BU' => 'Burgos',
            'ES-LE' => 'León',
            'ES-P' => 'Palencia',
            'ES-SA' => 'Salamanca',
            'ES-SG' => 'Segovia',
            'ES-SO' => 'Soria',
            'ES-VA' => 'Valladolid',
            'ES-ZA' => 'Zamora',
            'ES-AV' => 'Ávila',
        ],
        'ES-CB' => [
            'ES-S' => 'Cantabria',
        ],
        'ES-AR' => [
            'ES-HU' => 'Huesca',
            'ES-TE' => 'Teruel',
            'ES-Z' => 'Zaragoza',
        ],
        'ES-RI' => [
            'ES-LO' => 'La Rioja',
        ],
        'ES-CN' => [
            'ES-GC' => 'Las Palmas',
            'ES-TF' => 'Santa Cruz de Tenerife',
        ],
        'ES-MD' => [
            'ES-M' => 'Madrid',
        ],
        'ES-MC' => [
            'ES-MU' => 'Murcia',
        ],
        'ES-NC' => [
            'ES-NA' => 'Navarra',
        ],
        'ES-PV' => [
            'ES-VI' => 'Álava',
        ],
    ],
    'FJ' => [
        'FJ-W' => [
            'FJ-01' => 'Ba',
            'FJ-08' => 'Nadroga and Navosa',
            'FJ-11' => 'Ra',
        ],
        'FJ-N' => [
            'FJ-02' => 'Bua',
            'FJ-03' => 'Cakaudrove',
            'FJ-07' => 'Macuata',
        ],
        'FJ-E' => [
            'FJ-04' => 'Kadavu',
            'FJ-05' => 'Lau',
            'FJ-06' => 'Lomaiviti',
        ],
        'FJ-C' => [
            'FJ-09' => 'Naitasiri',
            'FJ-10' => 'Namosi',
            'FJ-12' => 'Rewa',
            'FJ-13' => 'Serua',
            'FJ-14' => 'Tailevu',
        ],
    ],
    'FR' => [
        'FR-ARA' => [
            'FR-01' => 'Ain',
            'FR-03' => 'Allier',
            'FR-07' => 'Ardèche',
            'FR-15' => 'Cantal',
            'FR-26' => 'Drôme',
            'FR-43' => 'Haute-Loire',
            'FR-74' => 'Haute-Savoie',
            'FR-38' => 'Isère',
            'FR-42' => 'Loire',
            'FR-63' => 'Puy-de-Dôme',
            'FR-69' => 'Rhône',
            'FR-73' => 'Savoie',
        ],
        'FR-HDF' => [
            'FR-02' => 'Aisne',
            'FR-59' => 'Nord',
            'FR-60' => 'Oise',
            'FR-62' => 'Pas-de-Calais',
            'FR-80' => 'Somme',
        ],
        'FR-PAC' => [
            'FR-06' => 'Alpes-Maritimes',
            'FR-04' => 'Alpes-de-Haute-Provence',
            'FR-13' => 'Bouches-du-Rhône',
            'FR-05' => 'Hautes-Alpes',
            'FR-83' => 'Var',
            'FR-84' => 'Vaucluse',
        ],
        'FR-GES' => [
            'FR-08' => 'Ardennes',
            'FR-10' => 'Aube',
            'FR-67' => 'Bas-Rhin',
            'FR-68' => 'Haut-Rhin',
            'FR-52' => 'Haute-Marne',
            'FR-51' => 'Marne',
            'FR-54' => 'Meurthe-et-Moselle',
            'FR-55' => 'Meuse',
            'FR-57' => 'Moselle',
            'FR-88' => 'Vosges',
        ],
        'FR-OCC' => [
            'FR-09' => 'Ariège',
            'FR-11' => 'Aude',
            'FR-12' => 'Aveyron',
            'FR-30' => 'Gard',
            'FR-32' => 'Gers',
            'FR-31' => 'Haute-Garonne',
            'FR-65' => 'Hautes-Pyrénées',
            'FR-34' => 'Hérault',
            'FR-46' => 'Lot',
            'FR-48' => 'Lozère',
            'FR-66' => 'Pyrénées-Orientales',
            'FR-81' => 'Tarn',
            'FR-82' => 'Tarn-et-Garonne',
        ],
        'FR-NOR' => [
            'FR-14' => 'Calvados',
            'FR-27' => 'Eure',
            'FR-50' => 'Manche',
            'FR-61' => 'Orne',
            'FR-76' => 'Seine-Maritime',
        ],
        'FR-NAQ' => [
            'FR-16' => 'Charente',
            'FR-17' => 'Charente-Maritime',
            'FR-19' => 'Corrèze',
            'FR-23' => 'Creuse',
            'FR-79' => 'Deux-Sèvres',
            'FR-24' => 'Dordogne',
            'FR-33' => 'Gironde',
            'FR-87' => 'Haute-Vienne',
            'FR-40' => 'Landes',
            'FR-47' => 'Lot-et-Garonne',
            'FR-64' => 'Pyrénées-Atlantiques',
            'FR-86' => 'Vienne',
        ],
        'FR-CVL' => [
            'FR-18' => 'Cher',
            'FR-28' => 'Eure-et-Loir',
            'FR-36' => 'Indre',
            'FR-37' => 'Indre-et-Loire',
            'FR-41' => 'Loir-et-Cher',
            'FR-45' => 'Loiret',
        ],
        'FR-COR' => [
            'FR-2A' => 'Corse-du-Sud',
            'FR-2B' => 'Haute-Corse',
        ],
        'FR-BFC' => [
            'FR-21' => 'Côte-d\'Or',
            'FR-25' => 'Doubs',
            'FR-70' => 'Haute-Saône',
            'FR-39' => 'Jura',
            'FR-58' => 'Nièvre',
            'FR-71' => 'Saône-et-Loire',
            'FR-90' => 'Territoire de Belfort',
            'FR-89' => 'Yonne',
        ],
        'FR-BRE' => [
            'FR-22' => 'Côtes-d\'Armor',
            'FR-29' => 'Finistère',
            'FR-35' => 'Ille-et-Vilaine',
            'FR-56' => 'Morbihan',
        ],
        'FR-IDF' => [
            'FR-91' => 'Essonne',
            'FR-92' => 'Hauts-de-Seine',
            'FR-75' => 'Paris',
            'FR-93' => 'Seine-Saint-Denis',
            'FR-77' => 'Seine-et-Marne',
            'FR-95' => 'Val-d\'Oise',
            'FR-94' => 'Val-de-Marne',
            'FR-78' => 'Yvelines',
        ],
        'FR-PDL' => [
            'FR-44' => 'Loire-Atlantique',
            'FR-49' => 'Maine-et-Loire',
            'FR-53' => 'Mayenne',
            'FR-72' => 'Sarthe',
            'FR-85' => 'Vendée',
        ],
    ],
    'GB' => [
        'GB-SCT' => [
            'GB-ABE' => 'Aberdeen City',
            'GB-ABD' => 'Aberdeenshire',
            'GB-ANS' => 'Angus',
            'GB-AGB' => 'Argyll and Bute',
            'GB-CLK' => 'Clackmannanshire',
            'GB-DGY' => 'Dumfries and Galloway',
            'GB-DND' => 'Dundee City',
            'GB-EAY' => 'East Ayrshire',
            'GB-EDU' => 'East Dunbartonshire',
            'GB-ELN' => 'East Lothian',
            'GB-ERW' => 'East Renfrewshire',
            'GB-EDH' => 'Edinburgh, City of',
            'GB-ELS' => 'Eilean Siar',
            'GB-FAL' => 'Falkirk',
            'GB-FIF' => 'Fife',
            'GB-GLG' => 'Glasgow City',
            'GB-HLD' => 'Highland',
            'GB-IVC' => 'Inverclyde',
            'GB-MLN' => 'Midlothian',
            'GB-MRY' => 'Moray',
            'GB-NAY' => 'North Ayrshire',
            'GB-NLK' => 'North Lanarkshire',
            'GB-ORK' => 'Orkney Islands',
            'GB-PKN' => 'Perth and Kinross',
            'GB-RFW' => 'Renfrewshire',
            'GB-SCB' => 'Scottish Borders, The',
            'GB-ZET' => 'Shetland Islands',
            'GB-SAY' => 'South Ayrshire',
            'GB-SLK' => 'South Lanarkshire',
            'GB-STG' => 'Stirling',
            'GB-WDU' => 'West Dunbartonshire',
            'GB-WLN' => 'West Lothian',
        ],
        'GB-NIR' => [
            'GB-ANN' => 'Antrim and Newtownabbey',
            'GB-AND' => 'Ards and North Down',
            'GB-ABC' => 'Armagh, Banbridge and Craigavon',
            'GB-BFS' => 'Belfast',
            'GB-CCG' => 'Causeway Coast and Glens',
            'GB-DRS' => 'Derry and Strabane',
            'GB-FMO' => 'Fermanagh and Omagh',
            'GB-LBC' => 'Lisburn and Castlereagh',
            'GB-MUL' => 'Mid Ulster',
            'GB-MEA' => 'Mid and East Antrim',
            'GB-NMD' => 'Newry, Mourne and Down',
        ],
        'GB-ENG' => [
            'GB-BDG' => 'Barking and Dagenham',
            'GB-BNE' => 'Barnet',
            'GB-BNS' => 'Barnsley',
            'GB-BAS' => 'Bath and North East Somerset',
            'GB-BDF' => 'Bedford',
            'GB-BEX' => 'Bexley',
            'GB-BIR' => 'Birmingham',
            'GB-BBD' => 'Blackburn with Darwen',
            'GB-BPL' => 'Blackpool',
            'GB-BOL' => 'Bolton',
            'GB-BMH' => 'Bournemouth',
            'GB-BRC' => 'Bracknell Forest',
            'GB-BRD' => 'Bradford',
            'GB-BEN' => 'Brent',
            'GB-BNH' => 'Brighton and Hove',
            'GB-BST' => 'Bristol, City of',
            'GB-BRY' => 'Bromley',
            'GB-BKM' => 'Buckinghamshire',
            'GB-BUR' => 'Bury',
            'GB-CLD' => 'Calderdale',
            'GB-CAM' => 'Cambridgeshire',
            'GB-CMD' => 'Camden',
            'GB-CBF' => 'Central Bedfordshire',
            'GB-CHE' => 'Cheshire East',
            'GB-CHW' => 'Cheshire West and Chester',
            'GB-CON' => 'Cornwall',
            'GB-COV' => 'Coventry',
            'GB-CRY' => 'Croydon',
            'GB-CMA' => 'Cumbria',
            'GB-DAL' => 'Darlington',
            'GB-DER' => 'Derby',
            'GB-DBY' => 'Derbyshire',
            'GB-DEV' => 'Devon',
            'GB-DNC' => 'Doncaster',
            'GB-DOR' => 'Dorset',
            'GB-DUD' => 'Dudley',
            'GB-DUR' => 'Durham County',
            'GB-EAL' => 'Ealing',
            'GB-ERY' => 'East Riding of Yorkshire',
            'GB-ESX' => 'East Sussex',
            'GB-ENF' => 'Enfield',
            'GB-ESS' => 'Essex',
            'GB-GAT' => 'Gateshead',
            'GB-GLS' => 'Gloucestershire',
            'GB-GRE' => 'Greenwich',
            'GB-HCK' => 'Hackney',
            'GB-HAL' => 'Halton',
            'GB-HMF' => 'Hammersmith and Fulham',
            'GB-HAM' => 'Hampshire',
            'GB-HRY' => 'Haringey',
            'GB-HRW' => 'Harrow',
            'GB-HPL' => 'Hartlepool',
            'GB-HAV' => 'Havering',
            'GB-HEF' => 'Herefordshire',
            'GB-HRT' => 'Hertfordshire',
            'GB-HIL' => 'Hillingdon',
            'GB-HNS' => 'Hounslow',
            'GB-IOW' => 'Isle of Wight',
            'GB-IOS' => 'Isles of Scilly',
            'GB-ISL' => 'Islington',
            'GB-KEC' => 'Kensington and Chelsea',
            'GB-KEN' => 'Kent',
            'GB-KHL' => 'Kingston upon Hull',
            'GB-KTT' => 'Kingston upon Thames',
            'GB-KIR' => 'Kirklees',
            'GB-KWL' => 'Knowsley',
            'GB-LBH' => 'Lambeth',
            'GB-LAN' => 'Lancashire',
            'GB-LDS' => 'Leeds',
            'GB-LCE' => 'Leicester',
            'GB-LEC' => 'Leicestershire',
            'GB-LEW' => 'Lewisham',
            'GB-LIN' => 'Lincolnshire',
            'GB-LIV' => 'Liverpool',
            'GB-LND' => 'London, City of',
            'GB-LUT' => 'Luton',
            'GB-MAN' => 'Manchester',
            'GB-MDW' => 'Medway',
            'GB-MRT' => 'Merton',
            'GB-MDB' => 'Middlesbrough',
            'GB-MIK' => 'Milton Keynes',
            'GB-NET' => 'Newcastle upon Tyne',
            'GB-NWM' => 'Newham',
            'GB-NFK' => 'Norfolk',
            'GB-NEL' => 'North East Lincolnshire',
            'GB-NLN' => 'North Lincolnshire',
            'GB-NSM' => 'North Somerset',
            'GB-NTY' => 'North Tyneside',
            'GB-NYK' => 'North Yorkshire',
            'GB-NTH' => 'Northamptonshire',
            'GB-NBL' => 'Northumberland',
            'GB-NGM' => 'Nottingham',
            'GB-NTT' => 'Nottinghamshire',
            'GB-OLD' => 'Oldham',
            'GB-OXF' => 'Oxfordshire',
            'GB-PTE' => 'Peterborough',
            'GB-PLY' => 'Plymouth',
            'GB-POL' => 'Poole',
            'GB-POR' => 'Portsmouth',
            'GB-RDG' => 'Reading',
            'GB-RDB' => 'Redbridge',
            'GB-RCC' => 'Redcar and Cleveland',
            'GB-RIC' => 'Richmond upon Thames',
            'GB-RCH' => 'Rochdale',
            'GB-ROT' => 'Rotherham',
            'GB-RUT' => 'Rutland',
            'GB-SLF' => 'Salford',
            'GB-SAW' => 'Sandwell',
            'GB-SFT' => 'Sefton',
            'GB-SHF' => 'Sheffield',
            'GB-SHR' => 'Shropshire',
            'GB-SLG' => 'Slough',
            'GB-SOL' => 'Solihull',
            'GB-SOM' => 'Somerset',
            'GB-SGC' => 'South Gloucestershire',
            'GB-STY' => 'South Tyneside',
            'GB-STH' => 'Southampton',
            'GB-SOS' => 'Southend-on-Sea',
            'GB-SWK' => 'Southwark',
            'GB-SHN' => 'St. Helens',
            'GB-STS' => 'Staffordshire',
            'GB-SKP' => 'Stockport',
            'GB-STT' => 'Stockton-on-Tees',
            'GB-STE' => 'Stoke-on-Trent',
            'GB-SFK' => 'Suffolk',
            'GB-SND' => 'Sunderland',
            'GB-SRY' => 'Surrey',
            'GB-STN' => 'Sutton',
            'GB-SWD' => 'Swindon',
            'GB-TAM' => 'Tameside',
            'GB-TFW' => 'Telford and Wrekin',
            'GB-THR' => 'Thurrock',
            'GB-TOB' => 'Torbay',
            'GB-TWH' => 'Tower Hamlets',
            'GB-TRF' => 'Trafford',
            'GB-WKF' => 'Wakefield',
            'GB-WLL' => 'Walsall',
            'GB-WFT' => 'Waltham Forest',
            'GB-WND' => 'Wandsworth',
            'GB-WRT' => 'Warrington',
            'GB-WAR' => 'Warwickshire',
            'GB-WBK' => 'West Berkshire',
            'GB-WSX' => 'West Sussex',
            'GB-WSM' => 'Westminster',
            'GB-WGN' => 'Wigan',
            'GB-WIL' => 'Wiltshire',
            'GB-WNM' => 'Windsor and Maidenhead',
            'GB-WRL' => 'Wirral',
            'GB-WOK' => 'Wokingham',
            'GB-WLV' => 'Wolverhampton',
            'GB-WOR' => 'Worcestershire',
            'GB-YOR' => 'York',
        ],
        'GB-WLS' => [
            'GB-BGW' => 'Blaenau Gwent',
            'GB-BGE' => 'Bridgend [Pen-y-bont ar Ogwr]',
            'GB-CAY' => 'Caerphilly [Caerffili]',
            'GB-CRF' => 'Cardiff [Caerdydd]',
            'GB-CMN' => 'Carmarthenshire [Sir Gaerfyrddin]',
            'GB-CGN' => 'Ceredigion [Sir Ceredigion]',
            'GB-CWY' => 'Conwy',
            'GB-DEN' => 'Denbighshire [Sir Ddinbych]',
            'GB-FLN' => 'Flintshire [Sir y Fflint]',
            'GB-GWN' => 'Gwynedd',
            'GB-AGY' => 'Isle of Anglesey [Sir Ynys Môn]',
            'GB-MTY' => 'Merthyr Tydfil [Merthyr Tudful]',
            'GB-MON' => 'Monmouthshire [Sir Fynwy]',
            'GB-NTL' => 'Neath Port Talbot [Castell-nedd Port Talbot]',
            'GB-NWP' => 'Newport [Casnewydd]',
            'GB-PEM' => 'Pembrokeshire [Sir Benfro]',
            'GB-POW' => 'Powys',
            'GB-RCT' => 'Rhondda, Cynon, Taff [Rhondda, Cynon,Taf]',
            'GB-SWA' => 'Swansea [Abertawe]',
            'GB-TOF' => 'Torfaen [Tor-faen]',
            'GB-VGL' => 'Vale of Glamorgan, The [Bro Morgannwg]',
            'GB-WRX' => 'Wrexham [Wrecsam]',
        ],
    ],
    'GN' => [
        'GN-N' => [
            'GN-BE' => 'Beyla',
            'GN-GU' => 'Guékédou',
            'GN-LO' => 'Lola',
            'GN-MC' => 'Macenta',
            'GN-NZ' => 'Nzérékoré',
            'GN-YO' => 'Yomou',
        ],
        'GN-B' => [
            'GN-BF' => 'Boffa',
            'GN-BK' => 'Boké',
            'GN-FR' => 'Fria',
            'GN-GA' => 'Gaoual',
            'GN-KN' => 'Koundara',
        ],
        'GN-D' => [
            'GN-CO' => 'Coyah',
            'GN-DU' => 'Dubréka',
            'GN-FO' => 'Forécariah',
            'GN-KD' => 'Kindia',
            'GN-TE' => 'Télimélé',
        ],
        'GN-F' => [
            'GN-DB' => 'Dabola',
            'GN-DI' => 'Dinguiraye',
            'GN-FA' => 'Faranah',
            'GN-KS' => 'Kissidougou',
        ],
        'GN-M' => [
            'GN-DL' => 'Dalaba',
            'GN-MM' => 'Mamou',
            'GN-PI' => 'Pita',
        ],
        'GN-K' => [
            'GN-KA' => 'Kankan',
            'GN-KO' => 'Kouroussa',
            'GN-KE' => 'Kérouané',
            'GN-MD' => 'Mandiana',
            'GN-SI' => 'Siguiri',
        ],
        'GN-L' => [
            'GN-KB' => 'Koubia',
            'GN-LA' => 'Labé',
            'GN-LE' => 'Lélouma',
            'GN-ML' => 'Mali',
            'GN-TO' => 'Tougué',
        ],
    ],
    'GQ' => [
        'GQ-I' => [
            'GQ-AN' => 'Annobón',
            'GQ-BN' => 'Bioko Norte',
            'GQ-BS' => 'Bioko Sur',
        ],
        'GQ-C' => [
            'GQ-CS' => 'Centro Sur',
            'GQ-KN' => 'Kié-Ntem',
            'GQ-LI' => 'Litoral',
            'GQ-WN' => 'Wele-Nzas',
        ],
    ],
    'GW' => [
        'GW-L' => [
            'GW-BA' => 'Bafatá',
            'GW-GA' => 'Gabú',
        ],
        'GW-N' => [
            'GW-BM' => 'Biombo',
            'GW-CA' => 'Cacheu',
            'GW-OI' => 'Oio',
        ],
        'GW-S' => [
            'GW-BL' => 'Bolama',
            'GW-QU' => 'Quinara',
            'GW-TO' => 'Tombali',
        ],
    ],
    'ID' => [
        'ID-SM' => [
            'ID-AC' => 'Aceh',
            'ID-BE' => 'Bengkulu',
            'ID-JA' => 'Jambi',
            'ID-BB' => 'Kepulauan Bangka Belitung',
            'ID-KR' => 'Kepulauan Riau',
            'ID-LA' => 'Lampung',
            'ID-RI' => 'Riau',
            'ID-SB' => 'Sumatera Barat',
            'ID-SS' => 'Sumatera Selatan',
            'ID-SU' => 'Sumatera Utara',
        ],
        'ID-NU' => [
            'ID-BA' => 'Bali',
            'ID-NB' => 'Nusa Tenggara Barat',
            'ID-NT' => 'Nusa Tenggara Timur',
        ],
        'ID-JW' => [
            'ID-BT' => 'Banten',
            'ID-JK' => 'Jakarta Raya',
            'ID-JB' => 'Jawa Barat',
            'ID-JT' => 'Jawa Tengah',
            'ID-JI' => 'Jawa Timur',
            'ID-YO' => 'Yogyakarta',
        ],
        'ID-SL' => [
            'ID-GO' => 'Gorontalo',
            'ID-SR' => 'Sulawesi Barat',
            'ID-SN' => 'Sulawesi Selatan',
            'ID-ST' => 'Sulawesi Tengah',
            'ID-SG' => 'Sulawesi Tenggara',
            'ID-SA' => 'Sulawesi Utara',
        ],
        'ID-KA' => [
            'ID-KB' => 'Kalimantan Barat',
            'ID-KS' => 'Kalimantan Selatan',
            'ID-KT' => 'Kalimantan Tengah',
            'ID-KI' => 'Kalimantan Timur',
            'ID-KU' => 'Kalimantan Utara',
        ],
        'ID-ML' => [
            'ID-MA' => 'Maluku',
            'ID-MU' => 'Maluku Utara',
        ],
        'ID-PP' => [
            'ID-PA' => 'Papua',
            'ID-PB' => 'Papua Barat',
        ],
    ],
    'IE' => [
        'IE-L' => [
            'IE-CW' => 'Carlow',
            'IE-D' => 'Dublin',
            'IE-KE' => 'Kildare',
            'IE-KK' => 'Kilkenny',
            'IE-LS' => 'Laois',
            'IE-LD' => 'Longford',
            'IE-LH' => 'Louth',
            'IE-MH' => 'Meath',
            'IE-OY' => 'Offaly',
            'IE-WH' => 'Westmeath',
            'IE-WX' => 'Wexford',
            'IE-WW' => 'Wicklow',
        ],
        'IE-U' => [
            'IE-CN' => 'Cavan',
            'IE-DL' => 'Donegal',
            'IE-MN' => 'Monaghan',
        ],
        'IE-M' => [
            'IE-CE' => 'Clare',
            'IE-CO' => 'Cork',
            'IE-KY' => 'Kerry',
            'IE-LK' => 'Limerick',
            'IE-TA' => 'Tipperary',
            'IE-WD' => 'Waterford',
        ],
        'IE-C' => [
            'IE-G' => 'Galway',
            'IE-LM' => 'Leitrim',
            'IE-MO' => 'Mayo',
            'IE-RN' => 'Roscommon',
            'IE-SO' => 'Sligo',
        ],
    ],
    'IT' => [
        'IT-82' => [
            'IT-AG' => 'Agrigento',
            'IT-CL' => 'Caltanissetta',
            'IT-CT' => 'Catania',
            'IT-EN' => 'Enna',
            'IT-ME' => 'Messina',
            'IT-PA' => 'Palermo',
            'IT-RG' => 'Ragusa',
            'IT-SR' => 'Siracusa',
            'IT-TP' => 'Trapani',
        ],
        'IT-21' => [
            'IT-AL' => 'Alessandria',
            'IT-AT' => 'Asti',
            'IT-BI' => 'Biella',
            'IT-CN' => 'Cuneo',
            'IT-NO' => 'Novara',
            'IT-TO' => 'Torino',
            'IT-VB' => 'Verbano-Cusio-Ossola',
            'IT-VC' => 'Vercelli',
        ],
        'IT-57' => [
            'IT-AN' => 'Ancona',
            'IT-AP' => 'Ascoli Piceno',
            'IT-FM' => 'Fermo',
            'IT-MC' => 'Macerata',
            'IT-PU' => 'Pesaro e Urbino',
        ],
        'IT-23' => [
            'IT-AO' => 'Aosta',
        ],
        'IT-52' => [
            'IT-AR' => 'Arezzo',
            'IT-FI' => 'Firenze',
            'IT-GR' => 'Grosseto',
            'IT-LI' => 'Livorno',
            'IT-LU' => 'Lucca',
            'IT-MS' => 'Massa-Carrara',
            'IT-PI' => 'Pisa',
            'IT-PT' => 'Pistoia',
            'IT-PO' => 'Prato',
            'IT-SI' => 'Siena',
        ],
        'IT-72' => [
            'IT-AV' => 'Avellino',
            'IT-BN' => 'Benevento',
            'IT-CE' => 'Caserta',
            'IT-NA' => 'Napoli',
            'IT-SA' => 'Salerno',
        ],
        'IT-75' => [
            'IT-BA' => 'Bari',
            'IT-BT' => 'Barletta-Andria-Trani',
            'IT-BR' => 'Brindisi',
            'IT-FG' => 'Foggia',
            'IT-LE' => 'Lecce',
            'IT-TA' => 'Taranto',
        ],
        'IT-34' => [
            'IT-BL' => 'Belluno',
            'IT-PD' => 'Padova',
            'IT-RO' => 'Rovigo',
            'IT-TV' => 'Treviso',
            'IT-VE' => 'Venezia',
            'IT-VR' => 'Verona',
            'IT-VI' => 'Vicenza',
        ],
        'IT-25' => [
            'IT-BG' => 'Bergamo',
            'IT-BS' => 'Brescia',
            'IT-CO' => 'Como',
            'IT-CR' => 'Cremona',
            'IT-LC' => 'Lecco',
            'IT-LO' => 'Lodi',
            'IT-MN' => 'Mantova',
            'IT-MI' => 'Milano',
            'IT-MB' => 'Monza e Brianza',
            'IT-PV' => 'Pavia',
            'IT-SO' => 'Sondrio',
            'IT-VA' => 'Varese',
        ],
        'IT-45' => [
            'IT-BO' => 'Bologna',
            'IT-FE' => 'Ferrara',
            'IT-FC' => 'Forlì-Cesena',
            'IT-MO' => 'Modena',
            'IT-PR' => 'Parma',
            'IT-PC' => 'Piacenza',
            'IT-RA' => 'Ravenna',
            'IT-RE' => 'Reggio Emilia',
            'IT-RN' => 'Rimini',
        ],
        'IT-32' => [
            'IT-BZ' => 'Bolzano',
            'IT-TN' => 'Trento',
        ],
        'IT-88' => [
            'IT-CA' => 'Cagliari',
            'IT-CI' => 'Carbonia-Iglesias',
            'IT-VS' => 'Medio Campidano',
            'IT-NU' => 'Nuoro',
            'IT-OG' => 'Ogliastra',
            'IT-OT' => 'Olbia-Tempio',
            'IT-OR' => 'Oristano',
            'IT-SS' => 'Sassari',
        ],
        'IT-67' => [
            'IT-CB' => 'Campobasso',
            'IT-IS' => 'Isernia',
        ],
        'IT-78' => [
            'IT-CZ' => 'Catanzaro',
            'IT-CS' => 'Cosenza',
            'IT-KR' => 'Crotone',
            'IT-RC' => 'Reggio Calabria',
            'IT-VV' => 'Vibo Valentia',
        ],
        'IT-65' => [
            'IT-CH' => 'Chieti',
            'IT-AQ' => 'L\'Aquila',
            'IT-PE' => 'Pescara',
            'IT-TE' => 'Teramo',
        ],
        'IT-62' => [
            'IT-FR' => 'Frosinone',
            'IT-LT' => 'Latina',
            'IT-RI' => 'Rieti',
            'IT-RM' => 'Roma',
            'IT-VT' => 'Viterbo',
        ],
        'IT-42' => [
            'IT-GE' => 'Genova',
            'IT-IM' => 'Imperia',
            'IT-SP' => 'La Spezia',
            'IT-SV' => 'Savona',
        ],
        'IT-36' => [
            'IT-GO' => 'Gorizia',
            'IT-PN' => 'Pordenone',
            'IT-TS' => 'Trieste',
            'IT-UD' => 'Udine',
        ],
        'IT-77' => [
            'IT-MT' => 'Matera',
            'IT-PZ' => 'Potenza',
        ],
        'IT-55' => [
            'IT-PG' => 'Perugia',
            'IT-TR' => 'Terni',
        ],
    ],
    'KN' => [
        'KN-K' => [
            'KN-01' => 'Christ Church Nichola Town',
            'KN-02' => 'Saint Anne Sandy Point',
            'KN-03' => 'Saint George Basseterre',
            'KN-06' => 'Saint John Capisterre',
            'KN-08' => 'Saint Mary Cayon',
            'KN-09' => 'Saint Paul Capisterre',
            'KN-11' => 'Saint Peter Basseterre',
            'KN-13' => 'Saint Thomas Middle Island',
            'KN-15' => 'Trinity Palmetto Point',
        ],
        'KN-N' => [
            'KN-04' => 'Saint George Gingerland',
            'KN-05' => 'Saint James Windward',
            'KN-07' => 'Saint John Figtree',
            'KN-10' => 'Saint Paul Charlestown',
            'KN-12' => 'Saint Thomas Lowland',
        ],
    ],
    'LK' => [
        'LK-1' => [
            'LK-52' => 'Ampara',
            'LK-71' => 'Anuradhapura',
            'LK-81' => 'Badulla',
        ],
        'LK-2' => [
            'LK-51' => 'Batticaloa',
            'LK-11' => 'Colombo',
            'LK-31' => 'Galle',
        ],
        'LK-3' => [
            'LK-12' => 'Gampaha',
            'LK-33' => 'Hambantota',
            'LK-41' => 'Jaffna',
        ],
        'LK-4' => [
            'LK-13' => 'Kalutara',
            'LK-21' => 'Kandy',
            'LK-92' => 'Kegalla',
            'LK-42' => 'Kilinochchi',
            'LK-61' => 'Kurunegala',
        ],
        'LK-5' => [
            'LK-43' => 'Mannar',
            'LK-22' => 'Matale',
            'LK-32' => 'Matara',
        ],
        'LK-6' => [
            'LK-82' => 'Monaragala',
            'LK-45' => 'Mullaittivu',
        ],
        'LK-7' => [
            'LK-23' => 'Nuwara Eliya',
            'LK-72' => 'Polonnaruwa',
        ],
        'LK-8' => [
            'LK-62' => 'Puttalam',
            'LK-91' => 'Ratnapura',
        ],
        'LK-9' => [
            'LK-53' => 'Trincomalee',
            'LK-44' => 'Vavuniya',
        ],
    ],
    'MA' => [
        'MA-09' => [
            'MA-AGD' => 'Agadir-Ida-Ou-Tanane',
            'MA-INE' => 'Inezgane-Ait Melloul',
            'MA-TAR' => 'Taroudant',
            'MA-TAT' => 'Tata',
            'MA-TIZ' => 'Tiznit',
        ],
        'MA-07' => [
            'MA-HAO' => 'Al Haouz',
            'MA-CHI' => 'Chichaoua',
            'MA-KES' => 'El Kelâa des Sraghna',
            'MA-ESI' => 'Essaouira',
            'MA-MAR' => 'Marrakech',
            'MA-REH' => 'Rehamna',
            'MA-SAF' => 'Safi',
            'MA-YUS' => 'Youssoufia',
        ],
        'MA-01' => [
            'MA-HOC' => 'Al Hoceïma',
            'MA-CHE' => 'Chefchaouen',
            'MA-FAH' => 'Fahs-Anjra',
            'MA-LAR' => 'Larache',
            'MA-MDF' => 'M’diq-Fnideq',
            'MA-OUZ' => 'Ouezzane',
            'MA-TNG' => 'Tanger-Assilah',
            'MA-TET' => 'Tétouan',
        ],
        'MA-12' => [
            'MA-AOU' => 'Aousserd (EH)',
            'MA-OUD' => 'Oued Ed-Dahab (EH)',
        ],
        'MA-10' => [
            'MA-ASZ' => 'Assa-Zag (EH-partial)',
            'MA-GUE' => 'Guelmim',
            'MA-SIF' => 'Sidi Ifni',
            'MA-TNT' => 'Tan-Tan (EH-partial)',
        ],
        'MA-05' => [
            'MA-AZI' => 'Azilal',
            'MA-BEM' => 'Béni Mellal',
            'MA-FQH' => 'Fquih Ben Salah',
            'MA-KHN' => 'Khenifra',
            'MA-KHO' => 'Khouribga',
        ],
        'MA-06' => [
            'MA-BES' => 'Benslimane',
            'MA-BRR' => 'Berrechid',
            'MA-CHT' => 'Chtouka-Ait Baha',
            'MA-JDI' => 'El Jadida',
            'MA-MOH' => 'Mohammadia',
            'MA-MED' => 'Médiouna',
            'MA-SIB' => 'Sidi Bennour',
            'MA-SIK' => 'Sidi Kacem',
        ],
        'MA-02' => [
            'MA-BER' => 'Berkane',
            'MA-DRI' => 'Driouch',
            'MA-FIG' => 'Figuig',
            'MA-GUF' => 'Guercif',
            'MA-JRA' => 'Jerada',
            'MA-NAD' => 'Nador',
            'MA-OUJ' => 'Oujda-Angad',
            'MA-TAI' => 'Taourirt',
        ],
        'MA-11' => [
            'MA-BOD' => 'Boujdour (EH)',
            'MA-ESM' => 'Es-Semara (EH)',
            'MA-LAA' => 'Laâyoune (EH)',
            'MA-TAF' => 'Tarfaya (EH-partial)',
        ],
        'MA-03' => [
            'MA-BOM' => 'Boulemane',
            'MA-HAJ' => 'El Hajeb',
            'MA-FES' => 'Fès',
            'MA-IFR' => 'Ifrane',
            'MA-MEK' => 'Meknès',
            'MA-MOU' => 'Moulay Yacoub',
            'MA-SEF' => 'Sefrou',
            'MA-TAO' => 'Taounate',
            'MA-TAZ' => 'Taza',
        ],
        'MA-08' => [
            'MA-CAS' => 'Casablanca',
            'MA-ERR' => 'Errachidia',
            'MA-MID' => 'Midelt',
            'MA-OUA' => 'Ouarzazate',
            'MA-SET' => 'Settat',
            'MA-TIN' => 'Tinghir',
            'MA-ZAG' => 'Zagora',
        ],
        'MA-04' => [
            'MA-KHE' => 'Khemisset',
            'MA-KEN' => 'Kénitra',
            'MA-NOU' => 'Nouaceur',
            'MA-RAB' => 'Rabat',
            'MA-SAL' => 'Salé',
            'MA-SIL' => 'Sidi Slimane',
            'MA-SKH' => 'Skhirate-Témara',
        ],
    ],
    'MH' => [
        'MH-L' => [
            'MH-ALL' => 'Ailinglaplap',
            'MH-KIL' => 'Bikini &amp; Kili',
            'MH-EBO' => 'Ebon',
            'MH-ENI' => 'Enewetak &amp; Ujelang',
            'MH-JAB' => 'Jabat',
            'MH-JAL' => 'Jaluit',
            'MH-KWA' => 'Kwajalein',
            'MH-LAE' => 'Lae',
            'MH-LIB' => 'Lib',
            'MH-NMK' => 'Namdrik',
            'MH-NMU' => 'Namu',
            'MH-RON' => 'Rongelap',
            'MH-UJA' => 'Ujae',
            'MH-WTH' => 'Wotho',
        ],
        'MH-T' => [
            'MH-ALK' => 'Ailuk',
            'MH-ARN' => 'Arno',
            'MH-AUR' => 'Aur',
            'MH-LIK' => 'Likiep',
            'MH-MAJ' => 'Majuro',
            'MH-MAL' => 'Maloelap',
            'MH-MEJ' => 'Mejit',
            'MH-MIL' => 'Mili',
            'MH-UTI' => 'Utrik',
            'MH-WTJ' => 'Wotje',
        ],
    ],
    'MV' => [
        'MV-SU' => [
            'MV-01' => 'Addu Atholhu',
            'MV-29' => 'Fuvammulah',
        ],
        'MV-NC' => [
            'MV-00' => 'Ari Atholhu Dhekunuburi',
            'MV-02' => 'Ari Atholhu Uthuruburi',
            'MV-04' => 'Felidhu Atholhu',
            'MV-26' => 'Maale Atholhu',
        ],
        'MV-NO' => [
            'MV-03' => 'Faadhippolhu',
            'MV-20' => 'Maalhosmadulu Dhekunuburi',
            'MV-13' => 'Maalhosmadulu Uthuruburi',
            'MV-25' => 'Miladhunmadulu Dhekunuburi',
        ],
        'MV-US' => [
            'MV-05' => 'Hahdhunmathi',
            'MV-08' => 'Kolhumadulu',
        ],
        'MV-SC' => [
            'MV-28' => 'Huvadhu Atholhu Dhekunuburi',
            'MV-27' => 'Huvadhu Atholhu Uthuruburi',
        ],
        'MV-UN' => [
            'MV-24' => 'Miladhunmadulu Uthuruburi',
            'MV-23' => 'Thiladhunmathee Dhekunuburi',
            'MV-07' => 'Thiladhunmathee Uthuruburi',
        ],
        'MV-CE' => [
            'MV-12' => 'Mulakatholhu',
            'MV-17' => 'Nilandhe Atholhu Dhekunuburi',
            'MV-14' => 'Nilandhe Atholhu Uthuruburi',
        ],
    ],
    'MW' => [
        'MW-S' => [
            'MW-BA' => 'Balaka',
            'MW-BL' => 'Blantyre',
            'MW-CK' => 'Chikwawa',
            'MW-CR' => 'Chiradzulu',
            'MW-MH' => 'Machinga',
            'MW-MG' => 'Mangochi',
            'MW-MU' => 'Mulanje',
            'MW-MW' => 'Mwanza',
            'MW-NE' => 'Neno',
            'MW-NS' => 'Nsanje',
            'MW-PH' => 'Phalombe',
            'MW-TH' => 'Thyolo',
            'MW-ZO' => 'Zomba',
        ],
        'MW-N' => [
            'MW-CT' => 'Chitipa',
            'MW-KR' => 'Karonga',
            'MW-LK' => 'Likoma',
            'MW-MZ' => 'Mzimba',
            'MW-NB' => 'Nkhata Bay',
            'MW-RU' => 'Rumphi',
        ],
        'MW-C' => [
            'MW-DE' => 'Dedza',
            'MW-DO' => 'Dowa',
            'MW-KS' => 'Kasungu',
            'MW-LI' => 'Lilongwe',
            'MW-MC' => 'Mchinji',
            'MW-NK' => 'Nkhotakota',
            'MW-NU' => 'Ntcheu',
            'MW-NI' => 'Ntchisi',
            'MW-SA' => 'Salima',
        ],
    ],
    'NP' => [
        'NP-1' => [
            'NP-BA' => 'Bagmati',
            'NP-JA' => 'Janakpur',
            'NP-NA' => 'Narayani',
        ],
        'NP-2' => [
            'NP-BH' => 'Bheri',
            'NP-KA' => 'Karnali',
            'NP-RA' => 'Rapti',
        ],
        'NP-3' => [
            'NP-DH' => 'Dhawalagiri',
            'NP-GA' => 'Gandaki',
            'NP-LU' => 'Lumbini',
        ],
        'NP-4' => [
            'NP-KO' => 'Kosi',
            'NP-ME' => 'Mechi',
            'NP-SA' => 'Sagarmatha',
        ],
        'NP-5' => [
            'NP-MA' => 'Mahakali',
            'NP-SE' => 'Seti',
        ],
    ],
    'PH' => [
        'PH-15' => [
            'PH-ABR' => 'Abra',
            'PH-APA' => 'Apayao',
            'PH-BEN' => 'Benguet',
            'PH-IFU' => 'Ifugao',
            'PH-KAL' => 'Kalinga',
            'PH-MOU' => 'Mountain Province',
        ],
        'PH-13' => [
            'PH-AGN' => 'Agusan del Norte',
            'PH-AGS' => 'Agusan del Sur',
            'PH-DIN' => 'Dinagat Islands',
            'PH-SUN' => 'Surigao del Norte',
            'PH-SUR' => 'Surigao del Sur',
        ],
        'PH-06' => [
            'PH-AKL' => 'Aklan',
            'PH-ANT' => 'Antique',
            'PH-CAP' => 'Capiz',
            'PH-GUI' => 'Guimaras',
            'PH-ILI' => 'Iloilo',
            'PH-NEC' => 'Negros Occidental',
        ],
        'PH-05' => [
            'PH-ALB' => 'Albay',
            'PH-CAN' => 'Camarines Norte',
            'PH-CAS' => 'Camarines Sur',
            'PH-CAT' => 'Catanduanes',
            'PH-MAS' => 'Masbate',
            'PH-SOR' => 'Sorsogon',
        ],
        'PH-03' => [
            'PH-AUR' => 'Aurora',
            'PH-BAN' => 'Bataan',
            'PH-BUL' => 'Bulacan',
            'PH-NUE' => 'Nueva Ecija',
            'PH-PAM' => 'Pampanga',
            'PH-TAR' => 'Tarlac',
            'PH-ZMB' => 'Zambales',
        ],
        'PH-09' => [
            'PH-BAS' => 'Basilan',
            'PH-ZSI' => 'Zamboanga Sibugay',
            'PH-ZAN' => 'Zamboanga del Norte',
            'PH-ZAS' => 'Zamboanga del Sur',
        ],
        'PH-02' => [
            'PH-BTN' => 'Batanes',
            'PH-CAG' => 'Cagayan',
            'PH-ISA' => 'Isabela',
            'PH-NUV' => 'Nueva Vizcaya',
            'PH-QUI' => 'Quirino',
        ],
        'PH-40' => [
            'PH-BTG' => 'Batangas',
            'PH-CAV' => 'Cavite',
            'PH-LAG' => 'Laguna',
            'PH-QUE' => 'Quezon',
            'PH-RIZ' => 'Rizal',
        ],
        'PH-08' => [
            'PH-BIL' => 'Biliran',
            'PH-EAS' => 'Eastern Samar',
            'PH-LEY' => 'Leyte',
            'PH-NSA' => 'Northern Samar',
            'PH-WSA' => 'Samar',
            'PH-SLE' => 'Southern Leyte',
        ],
        'PH-07' => [
            'PH-BOH' => 'Bohol',
            'PH-CEB' => 'Cebu',
            'PH-NER' => 'Negros Oriental',
            'PH-SIG' => 'Siquijor',
        ],
        'PH-10' => [
            'PH-BUK' => 'Bukidnon',
            'PH-CAM' => 'Camiguin',
            'PH-MSC' => 'Misamis Occidental',
            'PH-MSR' => 'Misamis Oriental',
        ],
        'PH-11' => [
            'PH-COM' => 'Compostela Valley',
            'PH-DVO' => 'Davao Occidental',
            'PH-DAO' => 'Davao Oriental',
            'PH-DAV' => 'Davao del Norte',
            'PH-DAS' => 'Davao del Sur',
            'PH-SAR' => 'Sarangani',
            'PH-SCO' => 'South Cotabato',
        ],
        'PH-12' => [
            'PH-NCO' => 'Cotabato',
            'PH-LAN' => 'Lanao del Norte',
            'PH-SUK' => 'Sultan Kudarat',
        ],
        'PH-01' => [
            'PH-ILN' => 'Ilocos Norte',
            'PH-ILS' => 'Ilocos Sur',
            'PH-LUN' => 'La Union',
            'PH-PAN' => 'Pangasinan',
        ],
        'PH-14' => [
            'PH-LAS' => 'Lanao del Sur',
            'PH-MAG' => 'Maguindanao',
            'PH-SLU' => 'Sulu',
            'PH-TAW' => 'Tawi-Tawi',
        ],
        'PH-41' => [
            'PH-MAD' => 'Marinduque',
            'PH-MDC' => 'Mindoro Occidental',
            'PH-MDR' => 'Mindoro Oriental',
            'PH-PLW' => 'Palawan',
            'PH-ROM' => 'Romblon',
        ],
    ],
    'RS' => [
        'RS-VO' => [
            'RS-04' => 'Južnobanatski okrug',
            'RS-06' => 'Južnobački okrug',
            'RS-03' => 'Severnobanatski okrug',
            'RS-01' => 'Severnobački okrug',
            'RS-02' => 'Srednjebanatski okrug',
            'RS-07' => 'Sremski okrug',
            'RS-05' => 'Zapadnobački okrug',
        ],
        'RS-KM' => [
            'RS-25' => 'Kosovski okrug',
            'RS-28' => 'Kosovsko-Mitrovački okrug',
            'RS-29' => 'Kosovsko-Pomoravski okrug',
            'RS-26' => 'Pećki okrug',
            'RS-27' => 'Prizrenski okrug',
        ],
    ],
    'UG' => [
        'UG-N' => [
            'UG-314' => 'Abim',
            'UG-301' => 'Adjumani',
            'UG-322' => 'Agago',
            'UG-323' => 'Alebtong',
            'UG-315' => 'Amolatar',
            'UG-324' => 'Amudat',
            'UG-316' => 'Amuru',
            'UG-302' => 'Apac',
            'UG-303' => 'Arua',
            'UG-317' => 'Dokolo',
            'UG-304' => 'Gulu',
            'UG-318' => 'Kaabong',
            'UG-305' => 'Kitgum',
            'UG-319' => 'Koboko',
            'UG-325' => 'Kole',
            'UG-306' => 'Kotido',
            'UG-326' => 'Lamwo',
            'UG-307' => 'Lira',
            'UG-320' => 'Maracha',
            'UG-308' => 'Moroto',
            'UG-309' => 'Moyo',
            'UG-311' => 'Nakapiripirit',
            'UG-327' => 'Napak',
            'UG-310' => 'Nebbi',
            'UG-328' => 'Nwoya',
            'UG-331' => 'Omoro',
            'UG-329' => 'Otuke',
            'UG-321' => 'Oyam',
            'UG-312' => 'Pader',
            'UG-332' => 'Pakwach',
            'UG-313' => 'Yumbe',
            'UG-330' => 'Zombo',
        ],
        'UG-E' => [
            'UG-216' => 'Amuria',
            'UG-217' => 'Budaka',
            'UG-218' => 'Bududa',
            'UG-201' => 'Bugiri',
            'UG-219' => 'Bukedea',
            'UG-220' => 'Bukwa',
            'UG-225' => 'Bulambuli',
            'UG-202' => 'Busia',
            'UG-221' => 'Butaleja',
            'UG-233' => 'Butebo',
            'UG-226' => 'Buyende',
            'UG-203' => 'Iganga',
            'UG-204' => 'Jinja',
            'UG-213' => 'Kaberamaido',
            'UG-222' => 'Kaliro',
            'UG-205' => 'Kamuli',
            'UG-206' => 'Kapchorwa',
            'UG-207' => 'Katakwi',
            'UG-227' => 'Kibuku',
            'UG-208' => 'Kumi',
            'UG-228' => 'Kween',
            'UG-229' => 'Luuka',
            'UG-223' => 'Manafwa',
            'UG-214' => 'Mayuge',
            'UG-209' => 'Mbale',
            'UG-230' => 'Namayingo',
            'UG-234' => 'Namisindwa',
            'UG-224' => 'Namutumba',
            'UG-231' => 'Ngora',
            'UG-210' => 'Pallisa',
            'UG-232' => 'Serere',
            'UG-215' => 'Sironko',
            'UG-211' => 'Soroti',
            'UG-212' => 'Tororo',
        ],
        'UG-W' => [
            'UG-420' => 'Buhweju',
            'UG-416' => 'Buliisa',
            'UG-401' => 'Bundibugyo',
            'UG-430' => 'Bunyangabu',
            'UG-402' => 'Bushenyi',
            'UG-403' => 'Hoima',
            'UG-417' => 'Ibanda',
            'UG-418' => 'Isingiro',
            'UG-404' => 'Kabale',
            'UG-405' => 'Kabarole',
            'UG-427' => 'Kagadi',
            'UG-428' => 'Kakumiro',
            'UG-413' => 'Kamwenge',
            'UG-414' => 'Kanungu',
            'UG-406' => 'Kasese',
            'UG-407' => 'Kibaale',
            'UG-419' => 'Kiruhura',
            'UG-421' => 'Kiryandongo',
            'UG-408' => 'Kisoro',
            'UG-422' => 'Kyegegwa',
            'UG-415' => 'Kyenjojo',
            'UG-409' => 'Masindi',
            'UG-410' => 'Mbarara',
            'UG-423' => 'Mitooma',
            'UG-424' => 'Ntoroko',
            'UG-411' => 'Ntungamo',
            'UG-429' => 'Rubanda',
            'UG-425' => 'Rubirizi',
            'UG-431' => 'Rukiga',
            'UG-412' => 'Rukungiri',
            'UG-426' => 'Sheema',
        ],
        'UG-C' => [
            'UG-117' => 'Buikwe',
            'UG-118' => 'Bukomansibi',
            'UG-119' => 'Butambala',
            'UG-120' => 'Buvuma',
            'UG-121' => 'Gomba',
            'UG-101' => 'Kalangala',
            'UG-122' => 'Kalungu',
            'UG-102' => 'Kampala',
            'UG-112' => 'Kayunga',
            'UG-103' => 'Kiboga',
            'UG-123' => 'Kyankwanzi',
            'UG-125' => 'Kyotera',
            'UG-104' => 'Luwero',
            'UG-124' => 'Lwengo',
            'UG-114' => 'Lyantonde',
            'UG-105' => 'Masaka',
            'UG-115' => 'Mityana',
            'UG-106' => 'Mpigi',
            'UG-107' => 'Mubende',
            'UG-108' => 'Mukono',
            'UG-116' => 'Nakaseke',
            'UG-109' => 'Nakasongola',
            'UG-110' => 'Rakai',
            'UG-111' => 'Sembabule',
            'UG-113' => 'Wakiso',
        ],
    ],
];
