<?php

require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

class Plugins_BannerTypeHTML_richMedia_rotatingCube extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
	 
    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
	 
    function getOptionDescription()
    {
        return $this->translate("Rotating Cube");
    }

    function validateForm(&$form)
    {
        return true;
    }

	function processForm($insert, $bannerid, $aFields)
    {

        //UPDATE RECORD

        if($_POST['bannerid'] != '' && $_POST['bannerid'] != NULL)
        {

            $set = "";
            $cube_sides = ['front','back','right','left','top','bottom'];

            for($j=0;$j<sizeof($cube_sides);$j++)
            {
                //UPDATE WHEN INPUT IS IMAGE

                if ($_FILES[$cube_sides[$j].'s'])
                { 
                    if($_POST['replace'.$cube_sides[$j]] == 't')
                    {
                        //TODO refactor upload to be a valid quickform elem
                        $oFile = OA_Creative_File::factoryUploadedFile($cube_sides[$j].'s');
                        checkForErrorFileUploaded($oFile);
                        $oFile->store('web');
                        $aFile = $oFile->getFileDetails();

                        $front_img = $aFile['filename'];
                        $front_type = '1';

                        $set .= $cube_sides[$j].'s'."="."'".$front_img."',".$cube_sides[$j]."_type="."'".$front_type."',";
                    }
                }

                //UPDATE WHEN INPUT IS VIDEO

                else
                {
                    $front_img = $_POST[$cube_sides[$j].'vid'];
                    $front_type = '2';

                    $set .= $cube_sides[$j].'s'."="."'".$front_img."',".$cube_sides[$j]."_type="."'".$front_type."',";
                }
            }

            //UPDATE QUERY
            OA_Dal_Delivery_query(" update rv_rotating_cube set banner_name = '".$_POST['description']."',".$set." destination_url = '".$_POST['url']."',third_party_tag = '".$_POST['tp_tag']."',keyword ='".$_POST['keyword']."',weight = '".$_POST['weight']."',comment = '".$_POST['comments']."' where bannerid = '".$_POST['bannerid']."'  ");
        }
        
        //INSERT RECORD

        else
        {

            $cube_sides = ['front','back','right','left','top','bottom'];

            $banner = [];
            $types = [];

            for($k=0;$k<sizeof($cube_sides);$k++)
            {
                if ($_FILES[$cube_sides[$k].'s'])
                { 
                    //TODO refactor upload to be a valid quickform elem
                    $oFile = OA_Creative_File::factoryUploadedFile($cube_sides[$k].'s');
                    checkForErrorFileUploaded($oFile);
                    $oFile->store('web');
                    $aFile = $oFile->getFileDetails();

                    $banner[$k] = $aFile['filename'];
                    $types[$k] = '1';
                }

                else
                {
                    $banner[$k] = $_POST[$cube_sides[$k].'vid'];
                    $types[$k] = '2';
                }
            }

            OA_Dal_Delivery_query("insert into rv_rotating_cube (banner_name,fronts,backs,rights,lefts,tops,bottoms,destination_url,third_party_tag,keyword,weight,comment,bannerid,front_type,back_type,right_type,left_type,top_type,bottom_type) values ('".$_POST['description']."','".$banner[0]."','".$banner[1]."','".$banner[2]."','".$banner[3]."','".$banner[4]."','".$banner[5]."','".$_POST['url']."','".$_POST['tp_tag']."','".$_POST['keyword']."','".$_POST['weight']."','".$_POST['comments']."','".$bannerid."','".$types[0]."','".$types[1]."','".$types[2]."','".$types[3]."','".$types[4]."','".$types[5]."') ");
        }

   

		return true;
    }
	 
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
		
		return true;
			
    }
	
    function buildForm(&$form, &$row)
    {
		
        //FETCH VALUE 
        $array = OA_Dal_Delivery_query("select * from rv_rotating_cube where bannerid ='".$row['bannerid']."' ");
        $values = OA_Dal_Delivery_fetchAssoc($array);

        if(isset($values))
        {
            $action = 'update';
        }
        else
        {
            $action = 'insert';
        }

        $cube_sides = ['front','back','right','left','top','bottom'];
        $default = [];

        for($i=0;$i<sizeof($cube_sides);$i++) 
        {    
            
            $form->addElement('html', 'select_banner', "<b>".ucfirst($cube_sides[$i])."  Banner</b>");
            $form->addElement('html', 'select_banner', "<hr></hr>");

            $sides = array();
            $type = 'web';
            $front_image = _getContentTypeIconImageName($row['contenttype']);
            $front_size = _getBannerSizeText($type, $row['filename']);
           
            $sides[] = $form->createElement('radio',$cube_sides[$i].'sides','',"Image","image_view", array('id' => $cube_sides[$i].'-img','onClick' =>"image_viewer('".$cube_sides[$i]."')")); 

            $sides[] = $form->createElement('radio',$cube_sides[$i].'sides','',"Video","video_view", array('id' => $cube_sides[$i].'-vid','onClick' => "video_viewer('".$cube_sides[$i]."')"));  

            // SET DEFAULT BANNER TYPE (RADIO BUTTON)
            if($values[$cube_sides[$i].'_type'] == '1')
            {
                $default[$i] = $form->setDefaults(array($cube_sides[$i].'sides' => 'image_view'));
            }
            else if($values[$cube_sides[$i].'_type'] == '2')
            {
                $default[$i] = $form->setDefaults(array($cube_sides[$i].'sides' => 'video_view'));
                $form->setDefaults(array($cube_sides[$i].'vid' => $values[$cube_sides[$i].'s'])); //UPDATING VALUE 
            }
            else
            {
                $default[$i] = $form->setDefaults(array($cube_sides[$i].'sides' => 'image_view'));
            }
            // SET DEFAULT BANNER TYPE (RADIO BUTTON)

            $form->addGroup($sides, 'overlayFormat', 'Select the "'.ucfirst($cube_sides[$i]).'" Side type', "<br/>");
            addUploadGroup($form, $row,
                array(
                    'uploadName' => $cube_sides[$i].'s',
                    'radioName' => 'replace'.$cube_sides[$i] ,
                    'imageName'  => $front_image,
                    'fileName'  => $values[$cube_sides[$i].'s'],
                    'fileSize'  => $front_size,
                    'newLabel'  => "Select the <b>".ucfirst($cube_sides[$i])." Image</b> you want to use for this banner",
                    'updateLabel'  => "Do you wish to keep your existing <b>".ucfirst($cube_sides[$i])." Image</b>, or do you want to upload another?",
                    'handleSWF' => true
                  )
            );
                 
            $form->addElement('text', $cube_sides[$i].'vid', 'Video (url)');

        }
        
        $form->addElement('html', 'jsForRotatingCubeFormat', '
            
            <script>
                $(document).ready(function()
                {
                    var sides = ["front","back","right","left","top","bottom"];
                    for(var l=0; l<=5;l++)
                    {
                        var side1 = sides[l]+"_type";
                        var values = ["'.$values["front_type"].'","'.$values["back_type"].'","'.$values["right_type"].'","'.$values["left_type"].'","'.$values["top_type"].'","'.$values["bottom_type"].'"];
                        
                        if(values[l] == 2)
                        {
                            video_viewer(sides[l]);
                        }
                        else
                        {
                            image_viewer(sides[l]);
                            // document.getElementsByName(sides[l]+"s")[0].disabled = true; 
                        }
                    }
                });

                function image_viewer(side)
                {
                    var side = side;
                    var show_vid_field = "#"+side+"vid";
                    var show_img_field = "input[name="+side+"s]";

                    document.getElementsByName(side+"s")[0].disabled = false; 
                    $(show_vid_field).parent().parent().hide();
                    $(show_img_field).parent().parent().show();
                    
                }   
                function video_viewer(side)
                {
                    var side = side;
                    var show_vid_field = "#"+side+"vid";
                    var show_img_field = "input[name="+side+"s]";

                    document.getElementsByName(side+"s")[0].disabled = true; 
                    $(show_vid_field).parent().parent().show();
                    $(show_img_field).parent().parent().hide();
                }
            </script>' );

        $form->setDefaults(array(tp_tag => $values['third_party_tag'])); //VALUE FOR UPDATING

        $form->addElement('header', 'header_b_links', "Banner link");
        $form->addElement('text', 'url', $GLOBALS['strURL']);
        $form->addElement('text', 'tp_tag', 'Third Party Tags (optional)',$tp_tag);


        // $targetElem = $form->createElement('text', 'target', $GLOBALS['strTarget']);

        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());
 
    }


	
}
