<?php

/**
 * TargetiX for Revive Adserver and OpenX Source
 *
 * @author Matteo Beccati
 * @copyright 2009-2014 AdserverPlugins.com - All rights reserved
 */

/* SourceGuardian:DO_NOT_ENCODE */

class apRetargeting
{
    protected $api = 'api';
    protected $baseUrl;
    protected $key;
    protected $aVariables;

    public function __construct($fcUrl, $key)
    {
        $this->baseUrl = $fcUrl;
        $this->key = $key;
        $this->varInit();
    }

    public function varSet($variable, $value)
    {
        $this->aVariables[$variable] = array(':', $value);
    }

    public function varUnset($variable)
    {
        $this->varSet($variable, '');
    }

    public function varInc($variable, $value)
    {
        $value = (int)$value;
        if ($value) {
            $this->aVariables[$variable] = array('^', $value);
        }
    }

    protected function varInit()
    {
        $this->aVariables = array();
    }

    public function generateBeacon()
    {
        $url = "{$this->baseUrl}?script=apRetargeting:".$this->api."&key=".urlencode($this->key);
        foreach ($this->aVariables as $k => $v) {
            $url .= '&'.$v[0].urlencode($k).'='.urlencode($v[1]);
        }
        // Add cachebuster
        $url .= '&cb='.substr(md5(uniqid('', true)), 0, 10);
        $this->varInit();

        return '<div style="position: absolute; width: 0; height: 0; overflow: hidden"><img src="'.
            htmlspecialchars($url).
            '" alt="" /></div>';
    }
}
