<?php 

/**
 * apDeliveryLogRedis for Revive Adserver and OpenX Source
 *
 * @author Matteo Beccati
 * @copyright 2013-2015 AdserverPlugins.com - All rights reserved
 *
 */

require_once MAX_PATH.'/plugins/apDeliveryLogRedis/DAL/Delivery.php';

function Plugin_postInit_apDeliveryLogRedis_override_Delivery_postInit()
{
    $conf = &$GLOBALS['_MAX']['CONF'];

    if (empty($conf['apDeliveryLogRedis']['disableDbLogging'])) {
        return;
    }

    $aDisable = array(
		'logViewer'				=> 'oxLogViewer',
		'logRequest'            => 'oxLogRequest',
        'logImpression'         => 'oxLogImpression',
        'logClick'              => 'oxLogClick',
        'logConversion'         => 'oxLogConversion',
        'logConversionVariable' => 'oxLogConversion',
        'logImpressionVast'     => 'oxLogVast'
    );

	
    foreach ($aDisable as $hook => $plugin) {
        $final = array();
        foreach (explode('|', $conf['deliveryHooks'][$hook]) as $current) {
            if ($current != "deliveryLog:{$plugin}:{$hook}") {
                $final[] = $current;
            }
        }
        $conf['deliveryHooks'][$hook] = join('|', $final);
    }
}
function Plugin_deliveryLog_apLogRequestRedis_logRequest_Delivery_logRequest($adId = 0, $zoneId = 0, $aAd = array(), $okToLog = true)
{
    if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aQuery = array(
        'creative_id'    => $aData['creative_id'],
        'zone_id'        => $aData['zone_id'],
    );
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryLogRedisRequest', array($oDal, $adId, $zoneId));

        return $oDal->logCount('requests', $aData['interval_start'], $aQuery,true);
    } catch (Exception $e) {

    }
}

function Plugin_deliveryLog_apLogImpressionRedis_logImpression_Delivery_logImpression($adId = 0, $zoneId = 0, $okToLog = true)
{    
    if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aConf = $GLOBALS['_MAX']['CONF']; 
	if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aQuery = array(
        'creative_id'    => $aData['creative_id'],
        'zone_id'        => $aData['zone_id'],
    );
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryLogRedisImpression', array($oDal, $adId, $zoneId));
        return $oDal->logCount('impressions', $aData['interval_start'], $aQuery,true);
    } catch (Exception $e) {

    }
}

function Plugin_deliveryLog_apLogClickRedis_logClick_Delivery_logClick($adId = 0, $zoneId = 0, $okToLog = true)
{	
	if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aConf = $GLOBALS['_MAX']['CONF']; 
	if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aQuery = array(
        'creative_id'    => $aData['creative_id'],
        'zone_id'        => $aData['zone_id'],
    );
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryLogRedisClick', array($oDal, $adId, $zoneId));

        return $oDal->logCount('clicks', $aData['interval_start'], $aQuery,true);
    } catch (Exception $e) {

    }
}

function Plugin_deliveryLog_apLogConversionRedis_logConversion_Delivery_logConversion($trackerId, $serverRawIp, $aConversion, $okToLog = true)
{	
    if (!$okToLog) { return false; }

    if (empty($GLOBALS['_MAX']['NOW'])) {
        $GLOBALS['_MAX']['NOW'] = time();
    }
    $time = $GLOBALS['_MAX']['NOW'];
	
	$tracker_parameter=$aConversion['cid'].'_'. $aConversion['zid']; 
	
	$request_id=$_COOKIE['OXLCR'][$tracker_parameter];
	
	$djax_win_bid_cpa=djax_win_bid_calc($aConversion['cid']);	
	
	/* Special bidding options */
	$traffic_bid_rate=0;
	$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from ".$table_prefix."affiliates as oxa join ".$table_prefix."zones as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$aConversion['zid'].") AND campaign_id IN (select campaignid from ".$table_prefix."banners where bannerid=".$aConversion['cid'].")";
	$special_bidding=OA_Dal_Delivery_query($traffic_query);
	$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
	$traffic_bid_rate=$traffic_result['bid_rate']; 
				
														
	/* Countrywise bidding based on the campaign */	
	$country_val=$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
				
				
	if(!empty($traffic_bid_rate))
	{
		$djax_win_bid_cpa['win_bid_amount']=$traffic_bid_rate;
	}	
	else
	{
	    if($djax_win_bid_cpa['revenue_type']==3 || $djax_win_bid_cpa['revenue_type']==4 || $djax_win_bid_cpa['revenue_type']==5 || $djax_win_bid_cpa['revenue_type']==6 )
		{
	     		$djax_win_bid_cpa['win_bid_amount'] = $djax_win_bid_cpa['win_bid_amount'];
		}
		else
		{
				$djax_win_bid_cpa['win_bid_amount'] =0;
		}
	}
							
	if($aConversion['zid']==0 || empty($aConversion['zid']))
	{
	   		$zonequery=OA_Dal_Delivery_query("SELECT zone_id FROM djax_track_ad_requests WHERE request_id ='".$request_id."'")or die("SELECT query djax_track_ad_requests");
			$rowzoneid=OA_Dal_Delivery_fetchAssoc($zonequery);
			$aConversion['zid']= $rowzoneid['zone_id'];
	}
		
	/* DAC020 - Find the campaign type */
	$campaign_type=OA_Dal_Delivery_query("Select revenue_type FROM ".$GLOBALS['_MAX']['CONF']['table']['prefix']."campaigns as c join ".$GLOBALS['_MAX']['CONF']['table']['prefix']."banners as b ON b.campaignid=c.campaignid where b.bannerid=".$aConversion['cid']);
	$camp_type=OA_Dal_Delivery_fetchAssoc($campaign_type);
	$cam_type=$camp_type['revenue_type'];
	
	/* DAC020 - Tracker */
	$tracker_type=OA_Dal_Delivery_query("Select pixel_category,pixel_goal FROM ".$GLOBALS['_MAX']['CONF']['table']['prefix']."trackers as t join ".$GLOBALS['_MAX']['CONF']['table']['prefix']."campaigns_trackers as ct ON ct.trackerid=t.trackerid where t.trackerid=".$trackerId);
	$track_type=OA_Dal_Delivery_fetchAssoc($tracker_type);
	$track_con_type=$track_type['pixel_category'];
	$pixel_goal=$track_type['pixel_goal'];
				
	if($cam_type=='3')
	{   
		$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='3' AND country_value='$country_val'";								
		$special_country_bidding=OA_Dal_Delivery_query($country_query);
		$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
		$country_bid_rate=$bidding_result['bidding_value']; 
		
		if(!empty($country_bid_rate))
		{
			$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;
			
		}
		else		
		{		
			if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
			{
				$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
			}
		}
		//OA_Dal_Delivery_query("update djax_track_ad_requests set bidding_price='".$djax_win_bid_cpa['win_bid_amount']."' where request_id='".$request_id."'") or die("update_error");		
	}
	elseif($cam_type=='4')
	{   
		if($track_con_type=="lead")
		{
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='4' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 		
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}
			//OA_Dal_Delivery_query("update djax_track_ad_requests set bidding_price='".$djax_win_bid_cpa['win_bid_amount']."' where request_id='".$request_id."'") or die("update_error");
		}
		else
		{
			return false;
		}
	}	
	elseif($cam_type=='5')
	{
		if($track_con_type=="sale")
		{		
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='5' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 		
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}
			//OA_Dal_Delivery_query("update djax_track_ad_requests set bidding_price='".$djax_win_bid_cpa['win_bid_amount']."' where request_id='".$request_id."'") or die("update_error");		
		}
		else
		{
			return false;
		}	
	}	
	elseif($cam_type=='6')
	{
		
		if($track_con_type=="install")
		{		
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='6' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 		
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}
			//OA_Dal_Delivery_query("update djax_track_ad_requests set bidding_price='".$djax_win_bid_cpa['win_bid_amount']."' where request_id='".$request_id."'") or die("update_error");		
		}	
		else
		{
			return false;
		}
	}	
	
	if(!empty($djax_win_bid_cpa))
	{
	    $detect_spent_amt=djax_detect_spent_amt_cpa($djax_win_bid_cpa);
	}
	
	$publisher_percentage=djax_publisher_share($aConversion['zid']);
	
	$publisershare=$djax_win_bid_cpa['win_bid_amount']*($publisher_percentage/100);
	
	$admin_revenue=$djax_win_bid_cpa['win_bid_amount']-$publisershare;
		if(!$detect_spent_amt){
			return false;
		}			
	
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();
        $aIds = $oDal->getUniqueIds('conversion');
				
        $aValues = $aIds + array(
			'server_ip'        => $serverRawIp,
            'tracker_id'       => $trackerId,
            'date_time'        => gmdate('Y-m-d H:i:s', $time),
            'action_date_time' => gmdate('Y-m-d H:i:s', $aConversion['dt']),
            'creative_id'      => $aConversion['cid'],
            'zone_id'          => $aConversion['zid'],
            'ip_address'       => $_SERVER['REMOTE_ADDR'],
            'action'           => $aConversion['action_type'],
            'window'           => $aConversion['window'],
            'status'           => $aConversion['status'],
			'dj_request_id'    => $request_id,
			'dj_win_bid'	   => $djax_win_bid_cpa['win_bid_amount'],
			'dj_publisher_revenue'=>$publisershare,
			'dj_admin_revenue' => $admin_revenue,
			'action_type'  	   => $aConversion['category']
        
        );

        $oDal->logRaw('conversions', $aValues);
        return array(
            'server_conv_id' => $aIds['server_conv_id'],
            'server_raw_ip' => $aIds['server_ip'],
        );
    } catch (Exception $e) {
        return false;
    }
}

function Plugin_deliveryLog_apLogConversionRedis_logConversionVariable_Delivery_logConversionVariable($aVariables, $trackerId, $serverConvId, $serverRawIp, $okToLog=true)
{
    if (!$okToLog) { return false; }

    if (empty($aVariables)) {
        return;
    }

    if (empty($GLOBALS['_MAX']['NOW'])) {
        $GLOBALS['_MAX']['NOW'] = time();
    }
    $time = $GLOBALS['_MAX']['NOW'];

    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        $date_time = gmdate('Y-m-d H:i:s', $time);

        $aData = array(
            'server_conv_id'    => (int)$serverConvId,
            'server_ip'         => $serverRawIp,
            'date_time'         => $date_time,
        );

        $res = 0;
        foreach ($aVariables as $aVariable) {
            $res |= (bool)$oDal->logRaw('conversion_vars', $aData + array(
                'tracker_variable_id' => (int)$aVariable['variable_id'],
                'value' => $aVariable['value'],
            ));
        }

        return $res;
    } catch (Exception $e) {

    }
}

function Plugin_deliveryLog_apLogVastRedis_logImpressionVast_Delivery_logImpressionVast($adId = 0, $zoneId = 0, $okToLog = true)
{
    if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aQuery = array(
        'creative_id'    => $aData['creative_id'],
        'zone_id'        => $aData['zone_id'],
        'vast_event_id'  => $aData['vast_event_id'],
    );
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryRedisVastEvent', array($oDal, $adId, $zoneId, $eventId));

        return $oDal->logCount('vast_events', $aData['interval_start'], $aQuery);
    } catch (Exception $e) {

    }
}

/* Additional functions For Impressions - Start */
function djax_publisher_share($zoneid)
	{
		$aConf = $GLOBALS['_MAX']['CONF'];
		
		$chk_pub_share="select a.dj_share_per as dj_share_per from 
		
		".$aConf['table']['prefix'].$aConf['table']['affiliates']." AS a,
		".$aConf['table']['prefix'].$aConf['table']['zones']." AS z
		
		where z.affiliateid=a.affiliateid and z.zoneid='$zoneid'";
		
		$rsResult = OA_Dal_Delivery_query($chk_pub_share);
					       
		$fetch_record=OA_Dal_Delivery_fetchAssoc($rsResult);
					
		if(!empty($fetch_record['dj_share_per']))
		{
							return $fetch_record['dj_share_per'];
		}
		else
		{
							
							$fetch_record=app_config();
						
							return $fetch_record['pub_min_share'];
		}
		
	}

function djax_win_count($request_id)
{
		$aConf = $GLOBALS['_MAX']['CONF'];

		$query="select r.win_bid_amount as win_bid_amount from 
		".OX_escapeIdentifier($aConf['table']['djax_track_ad_responses'])." AS r,  
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  AS c,
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])."  AS b
		where r.request_id='$request_id' and  b.bannerid=r.ad_id and r.win_status='1' and c.revenue_type='1' and b.campaignid=c.campaignid";
		
		$rAdResponse=OA_Dal_Delivery_query($query);

		$result=OA_Dal_Delivery_numRows($rAdResponse);
		
		
		return $result;
}

function djax_win_bid_calc($bannerid)
{	
		
		$aConf = $GLOBALS['_MAX']['CONF'];

		$query="select c.campaignname,c.impression_count,c.conversion_count,c.clientid,c.revenue as win_bid_amount,c.revenue_type as revenuetype,c.clientid as clientid,c.campaignid as campaignid,c.dj_campaign_remain_budget as dj_campaign_remain_budget,c.dj_campaign_remain_total_budget as dj_campaign_remain_total_budget,c.dj_campaign_budget as dj_campaign_budget,c.dj_daily_budget as dj_daily_budget,cl.dj_cur_balance as dj_cur_balance,cl.dj_is_default as dj_is_default,cl.account_id as account_id,cl.clientname as clientname,cl.email as email from 
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." AS cl,  
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  AS c,
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])."  AS b
		where b.bannerid='$bannerid' and  c.clientid=cl.clientid and b.campaignid=c.campaignid";		
				
		$rAdResponse=OA_Dal_Delivery_query($query);

		$result=OA_Dal_Delivery_fetchAssoc($rAdResponse);
				
		return $result;
}
function djax_detect_spent_amt($results)
{  
		
		$aConf = $GLOBALS['_MAX']['CONF'];

		$status='and dj_is_default!=1';
		
		$query="select dj_cur_balance,dj_is_default from
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." 
		where clientid='".$results['clientid']."' $status ";	
				
		$rAdResponse=OA_Dal_Delivery_query($query);
						
		if(OA_Dal_Delivery_numRows($rAdResponse) > 0)
		{
			$res=OA_Dal_Delivery_fetchAssoc($rAdResponse);
									
			if($res['dj_cur_balance']>0)
			{
				$remain_balance=$results['dj_campaign_remain_budget'] + $results['win_bid_amount'];
				
				$current_balance=$res['dj_cur_balance'] - $results['win_bid_amount'];
							
				$remain_total_balance=$results['dj_campaign_remain_total_budget'] + $results['win_bid_amount'];
								
				//////Update Remain budget
				$budget = OA_Dal_Delivery_query("SELECT dj_campaign_budget,dj_daily_budget FROM 				
				".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
				where campaignid='".$results['campaignid']."'");
				
				$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);

				$campaign_budget = $fetch_budget['dj_campaign_budget'];

				$campaign_daily_budget = $fetch_budget['dj_daily_budget'];
				
				$campaign_remaining_budget = $campaign_budget - $remain_total_balance;    

				$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance;  

				if($campaign_remaining_budget > 0 && $campaign_remaining_daily_budget > 0)
				{	
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");

					if($res['dj_is_default']!='2')
					{
							OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])."  
							set dj_cur_balance='$current_balance' where clientid='".$results['clientid']."'");
					}
					return true;					
				}
				else
				{    

					/* Code for issue fixing - 172681 - start*/
					
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");
					
					/* Code for issue fixing - 172681 - end*/
					
					if($campaign_remaining_budget <= 0)
					{
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=3 where campaignid='".$results['campaignid']."'") or die("error");
					}					
					if($campaign_remaining_daily_budget <= 0)
					{						
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=8,dj_budget_status=1 where campaignid='".$results['campaignid']."'") or die("error");
					}
					
					return true;					
				}
				
				
			}
		}
}
/* Additional Functions for Impressions - End */

/* Clicks - Start */

function djax_fraud_click($adId,$zoneId,$loc)
{
		
		$aConf = $GLOBALS['_MAX']['CONF'];
		$clk_reset = 0;
		$clk_cap = 0;
		
		$djax_affiliate=OA_Dal_Delivery_query("SELECT affiliateid FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])."  where zoneid='$zoneId'");
			
		$djax_res = OA_Dal_Delivery_fetchAssoc($djax_affiliate);
		
		$pub_id=$djax_res['affiliateid'];
		
		$getbanrow=app_config();

		if($getbanrow>0)
		{
			$clicknum = $getbanrow['antifraud_clicknum'];
			$resettime = $getbanrow['antifraud_reset_time'];
			$threshold=$getbanrow['antifraud_threshold'];
		}
		
		$djax_resettime = time() - $resettime;
		
		$djax_imp_resettime = date("Y-m-d H:i:s",$djax_resettime);
		
		$datetime=date("Y-m-d H:i:s");

		$country_name = $GLOBALS['_MAX']['CLIENT_GEO'];

		$countryname = $country_name['country_code'];
	
		$current_viewerid=$_COOKIE['viewer_id'];

		$logclicks=1;
		
		$campaign_id=OA_Dal_Delivery_query("SELECT campaignid FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." WHERE bannerid='$adId'");

		$fetch_campaign_id = OA_Dal_Delivery_fetchAssoc($campaign_id);

		$budget = OA_Dal_Delivery_query("SELECT * FROM 
			".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
			where campaignid='".$fetch_campaign_id['campaignid']."'");
			
		$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);

		$campaign_budget = $fetch_budget['dj_campaign_budget'];

		$campaign_daily_budget = $fetch_budget['dj_daily_budget'];
			
		$campaign_revenue_type = $fetch_budget['revenue_type'];
			
		if($campaign_revenue_type=="1")
		{
			$campaign_revenue = $fetch_budget['revenue']/1000;
		}
		else
		{
			$campaign_revenue = $fetch_budget['revenue'];
		}
			
		$remain_balance=$fetch_budget['dj_campaign_remain_budget'];	 
		
		$remain_total_balance=$fetch_budget['dj_campaign_remain_total_budget'];
			
		$campaign_remaining_budget = $campaign_budget - $remain_total_balance;   
	
		$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance; 
										
		if($campaign_budget > $campaign_revenue && $campaign_daily_budget > $campaign_revenue)
		{    		
			if($campaign_remaining_budget > 0 && $campaign_remaining_daily_budget > 0)
			{
				
				if($clicknum!=0 && $resettime!=0)
				{	
					
					$getimpres = OA_Dal_Delivery_query("Select * from ".OX_escapeIdentifier('djax_ad_zone_click')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC") or die("Here:");
																					
					if(OA_Dal_Delivery_numRows($getimpres)>=$clicknum)
					{  
						$logclicks = 0;
					}
					
				}
				
				
				if($logclicks!=0)
				{		
					$host=$_SERVER['REMOTE_ADDR'];
					OA_Dal_Delivery_query("insert into ".OX_escapeIdentifier('djax_ad_zone_click')."(viewer_id,date_time,ad_id,zone_id,pub_id,country,ipaddress,url) values('".$current_viewerid."','".$datetime."','".$adId."','".$zoneId."','$pub_id','$countryname','".$_SERVER['REMOTE_ADDR']."','".$loc."')") or die(mysql_error());			
					return 1;  
					
				}
				else
				{						
			
					////////Djax Adexchange Valid click//////


					$penalty=OA_Dal_Delivery_query("Select count(viewer_id) as count from ".OX_escapeIdentifier('djax_ad_zone_click')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC") or die(mysql_error());
					$putpenalty=OA_Dal_Delivery_fetchAssoc($penalty);
				
					///////fraud click///////////////////


					$fraud=OA_Dal_Delivery_query("Select count(viewer_id) as count from ".OX_escapeIdentifier('djax_ad_fraud_click')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC")or die(mysql_error());
					$frudpoint=OA_Dal_Delivery_fetchAssoc($fraud);

					   
					$totalpenalty=$putpenalty['count']+$frudpoint['count'];
			  
			   
					if($frudpoint['count']>=$threshold)
					{
			
						$getpubdetails=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])." AS z, ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['affiliates'])." AS a where z.zoneid='$zoneId' and z.affiliateid=a.affiliateid"));

						$penaltyval=OA_Dal_Delivery_query("select pubid,zone_id,penaltypoint from ".OX_escapeIdentifier($aConf['table']['djax_penalty'])." where zone_id='".$zoneId."' and pubid='".$getpubdetails['affiliateid']."'");

						$penaltyres=OA_Dal_Delivery_fetchAssoc($penaltyval);
						
						
						$date_time=date("Y-m-d H");

						if(OA_Dal_Delivery_numRows($penaltyval)>0)
						{

							$point=$penaltyres['penaltypoint']+1;

							OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['djax_penalty'])." set penaltypoint='$point' where zone_id='".$penaltyres['zone_id']."' and pubid='".$penaltyres['pubid']."'");
						}
						else
						{
						
							OA_Dal_Delivery_query("INSERT INTO ".OX_escapeIdentifier($aConf['table']['djax_penalty'])."(id,interval_start,pubname,penaltypoint,pubid,zone_id,country) VALUES ('','$date_time','".$getpubdetails['name']."', '1','".$getpubdetails['affiliateid']."','".$zoneId."','".$countryname."')");
						}

						$current_date=date('Y-m-d',mktime(0,0,0,date('m'),date('d'),date('Y')));

						///////////////////////////Sent - Fraud Click Mail Once a Day//////////////////////

						$check_mail_sent=mysql_query("select * from ".OX_escapeIdentifier($aConf['table']['djax_anti_fraud_mail'])."  where  publisher_id='".$getpubdetails['affiliateid']."' and date='$current_date' and viewer_id='$current_viewerid'");


						if(mysql_num_rows($check_mail_sent)>0)
						{

							$adminquery=mysql_query("SELECT * FROM  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['users'])." WHERE default_account_id=1")or die("sre");

							$fetchemail=mysql_fetch_array($adminquery);


							if($zoneId!=0)
							{
								$to      =$getpubdetails['email_address'];
								$subject = 'Regarding Ad delivery';
								$message = 'Your website getting more traffic from this IP for example '.$_SERVER['REMOTE_ADDR'].',Can you block  this IP for particular period or block this ip permanently? ';
								$headers = 'From: '.$fetchemail['email_address'].'' . "\r\n";


								mail($to, $subject, $message, $headers);

							}
							
						}
						else
						{
							OA_Dal_Delivery_query("INSERT INTO ".OX_escapeIdentifier('djax_anti_fraud_mail')."(date,publisher_id,status,viewer_id) VALUES ('$current_date', '".$getpubdetails['affiliateid']."','1','$current_viewerid')") or die("error1");

							OA_Dal_Delivery_query("delete from ".OX_escapeIdentifier('djax_anti_fraud_mail')." where publisher_id='".$getpubdetails['affiliateid']."' and date<='".$current_date."' and viewer_id='".$current_viewerid."'" ) or die("error2");

						}
				///////////////////////////Sent - Fraud Click Mail Once a Day//////////////////////			
				}
			
						OA_Dal_Delivery_query("insert into ".OX_escapeIdentifier('djax_ad_fraud_click')."(viewer_id,date_time,ad_id,zone_id,pub_id,country,ipaddress,url) values('".$current_viewerid."','".$datetime."','".$adId."','".$zoneId."','$pub_id','$countryname','".$_SERVER['REMOTE_ADDR']."','".$loc."')") or die(mysql_error());

					return 0;
			
				}
			
			}

		}

}


function app_config()
{
	$app_config = 'select * from djax_app_configurations';
				
	$config_query = OA_Dal_Delivery_query($app_config);
				
	$data_config  = OA_Dal_Delivery_fetchAssoc($config_query);		

	return $data_config;
	
}
/*Clicks - End*/
function djax_detect_spent_amt_cpa($results)
{
	
		$aConf = $GLOBALS['_MAX']['CONF'];

		$status='and dj_is_default!=1';
		
		$query="select dj_cur_balance,dj_is_default from
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." 
		where clientid='".$results['clientid']."' $status ";	
				
		$rAdResponse=OA_Dal_Delivery_query($query);
		//print_r($rAdResponse);die("khlkhl");				
		if(OA_Dal_Delivery_numRows($rAdResponse) > 0)
		{
			$res=OA_Dal_Delivery_fetchAssoc($rAdResponse);
									
			if($res['dj_cur_balance']>0)
			{
				$remain_balance=$results['dj_campaign_remain_budget'] + $results['win_bid_amount'];
				
				$current_balance=$res['dj_cur_balance'] - $results['win_bid_amount'];
							
				$remain_total_balance=$results['dj_campaign_remain_total_budget'] + $results['win_bid_amount'];
								
				//////Update Remain budget
				$budget = OA_Dal_Delivery_query("SELECT dj_campaign_budget,dj_daily_budget FROM 				
				".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
				where campaignid='".$results['campaignid']."'");
				
				$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);

				$campaign_budget = $fetch_budget['dj_campaign_budget'];

				$campaign_daily_budget = $fetch_budget['dj_daily_budget'];
				
				$campaign_remaining_budget = $campaign_budget - $remain_total_balance;    

				$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance;  

				if($campaign_remaining_budget >= 0 && $campaign_remaining_daily_budget >= 0)
				{						
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");

					if($res['dj_is_default']!='2')
					{
							OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])."  
							set dj_cur_balance='$current_balance' where clientid='".$results['clientid']."'");
					}
					//return true;					
				}
				else
				{      
					/* Code for issue fixing - 172681 - start*/
					
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");
					
					/* Code for issue fixing - 172681 - end*/
					
					if($campaign_remaining_budget <= 0)
					{
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=3 where campaignid='".$results['campaignid']."'") or die("error");
					}					
					if($campaign_remaining_daily_budget <= 0)
					{						
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=8,dj_budget_status=1 where campaignid='".$results['campaignid']."'") or die("error");
					}
					
					//return true;					
				}
				
				//*******************************Update conversion in rv_campaign table and to send mail on reaching conversion limit****************************************//
			
			
			//select conversion_count from rv_campaigns
			$rsResult_conv = OA_Dal_Delivery_query("select campaignname,impression_count,conversion_count,clientid from  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."   where campaignid=".$results['campaignid']);
			
			$fetch_record2=OA_Dal_Delivery_fetchAssoc($rsResult_conv);
			
		
			//select account_id from clients 
			$account = OA_Dal_Delivery_query('select account_id,clientname,email from '.OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients']).' where clientid='.$fetch_record2['clientid']);
				
			$dj_acoount_id  = OA_Dal_Delivery_fetchAssoc($account);
			
			//selecting advertiser/publisher message settings			
			$db = 'select * from djax_adv_pub_notification_settings where account_id='.$dj_acoount_id['account_id'];
			
			$jb = OA_Dal_Delivery_query($db);
				
			$djax_adv_pub  = OA_Dal_Delivery_fetchAssoc($jb);
			
			
			$enable_disable = $djax_adv_pub['msg_adv_pub_enable'];
			
			//selecting app configuration settings
				
			$app_config = 'select * from djax_app_configurations';
				
			$config_query = OA_Dal_Delivery_query($app_config);
				
			$data_config  = OA_Dal_Delivery_fetchAssoc($config_query);
			$user_details      = djax_admin_detail();
			$admin_name        = $user_details['first_name'] . ' ' . $user_details['last_name'];
			$admin_email       = $user_details['email_address'];
			if($data_config['adv_pub_msg'] == 'enable')
			{
				if($enable_disable)
					{
						$string = 'conversion';
				
						if(strpos($djax_adv_pub['campaign_tracking'],$string)!== false)
						{
						$msg_type = $djax_adv_pub['msg_type'];
						}
						else{
						$msg_type = null;
						}
			   
					}
					else{
						$msg_type = null;
						}
			
			}
			else{
					$msg_type = $data_config['message_type'];
			}
	
			
//Hi, Conversion Limit  has been reached for the campaign <b>".$fetch_record2['campaignname']."</b><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thanks and Regards,<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" ;
				
			if(($fetch_record2['conversion_count']===$djax_adv_pub['conversion_limit'])==TRUE)
			{
				
				
				OA_Dal_Delivery_query("update  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." set conversion_count='0',status=8 where campaignid=".$results['campaignid']);

				$message = "Conversion Limit  has been reached for the campaign <b>".$fetch_record2['campaignname']."</b><br>" ;
				$mails = '<table border="0" width="600" cellpadding="0" cellspacing="0">
								<tr>
								<td style="color:#333333 !important; padding-left:20px;" height="40">
								
								 Conversion Limit  has been reached for the campaign <b>'.$fetch_record2['campaignname'].'</b><br>
								</td>
								</tr>
								</table>
								
								';
			$mail_content = '<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<tr>
											<td>
											<table border="0" width="600" cellpadding="0" cellspacing="0">
											<tr>
											<td font-size:24px; font-family: Arial, Verdana, sans-serif;  height="40">
												<p style="line-height:12px;">Hi ' . $dj_acoount_id['clientname'] . ',</p></td>
											</tr>
											</table>
											</td>
											</tr>
											</table>'.$mails.'
											<table border="0" width="600" cellpadding="0" cellspacing="0">
											<tr>
											<td style="color:#333333 !important; padding-right:45px; font-size:20px; font-family: Arial, Verdana, sans-serif;  height="40">
											<p line-height:12px;">With Regards,</p>
											<p  line-height:12px;">' . $admin_name . '</p>
											</td>
											</tr>
											</table>';
				if($msg_type=='email' || $msg_type=='both')
				{
					$mail='';
					$from_add = $admin_email; 
					$to_add = $dj_acoount_id['email']; 
					$subject = "Warning: Conversion Limit Reached";
					$headers = "MIME-Version: 1.0" . "\r\n";
					$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
					$headers .= "From: $from_add \r\n";
					$headers .= "Reply-To: $from_add \r\n";
					$headers .= "Return-Path: $from_add\r\n";
					$headers .= "X-Mailer: PHP \r\n";
					mail($to_add,$subject,$mail_content,$headers);

				}
				if($msg_type=='both' || $msg_type=='msg')
				{
					$msg_query1 = "INSERT INTO `rv_djax_messages` (`id` ,`sender_id` ,`receiver_id` ,`subject` ,`content` ,
	`date` ,`image_name` ,`file_name` ,`account_type` ,`status` ,`network_id` ,`is_deleted` ,`sender_is_deleted` ,`msg_type`
	)VALUES (NULL , '2', '".$dj_acoount_id['account_id']."', 'Conversion Limit Reached','".$message."', '".date('Y-m-d H:i:s')."', 'NULL', 'NULL', 'ADVERTISER', '0', '1', '0', '', '')";
					$msg_query=OA_Dal_Delivery_query($msg_query1); 
				}
				return false;
			}
			else{
				//$con_count = $fetch_record2['conversion_count']+1;
			OA_Dal_Delivery_query("update  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." set conversion_count=".$fetch_record2['conversion_count']."+1 where campaignid=".$results['campaignid']);
				return true;
			}
			
			//*******************************Update conversion in rv_campaign table and to send mail on reaching conversion limit****************************************//
			
			}
		}
}
function djax_admin_detail()
{
    $conf = $GLOBALS['_MAX']['CONF'];
    
    $query = "select first_name,last_name,email_address from  djax_networks";
    
    $rsresult = OA_Dal_Delivery_query($query);
    
    $rs_admin = OA_Dal_Delivery_fetchAssoc($rsresult);
    
    return $rs_admin;
    
}
