<?php

/**
 * apDeliveryLogRedis for Revive Adserver and OpenX Source
 *
 * @author Matteo Beccati
 * @copyright 2013-2015 AdserverPlugins.com - All rights reserved
 *
 */


require_once MAX_PATH.'/plugins/apRedis/Redis.php';


class AP_DeliveryLogRedis_DAL_Delivery extends AP_Redis
{
    protected $prefix;

    public function __construct($aConf = null, $section = 'apDeliveryLogRedis')
    {
        parent::__construct($aConf, $section);

        if (!isset($aConf)) {
            $aConf = $GLOBALS['_MAX']['CONF'][$section];
        }
        $this->setPrefix(empty($aConf['prefix']) ? '' : $aConf['prefix']);
    }

    public function getPrefix()
    {
        return $this->prefix;
    }

    public function setPrefix($prefix)
    {
        $this->prefix =  strlen($prefix) ? rtrim($prefix, '_').'_' : '';
    }

    public function getUniqueIds($action)
    {
        $aIds = array();
        $key = $this->prefix."{$action}_ids";

        $aIds['server_ip'] = $this->hGet($key, 'server_ip');
        if (empty($aIds['server_ip'])) {
            $aIds['server_ip'] = substr(md5(uniqid('', true)), 0, 16);
            if (!$this->hSetNx($key, 'server_ip', $aIds['server_ip'])) {
                $aIds['server_ip'] = $this->hGet($key, 'server_ip');
            }
        }

        $aIds['server_conv_id'] = $this->hIncrBy($key, 'server_conv_id', 1);

        return $aIds;
    }

    public function logCount($action, $dateTime, $aData,$i,$count = 1)
    { 
	    $key   = $this->prefix.$action.'_'.$dateTime;
        $field = join("\t", $aData);		
       	return $this->hincrby($key,$field,$count); 
	}

    public function getCount($action, $dateTime, $aData)
    {
        $key   = $this->prefix.$action.'_'.$dateTime;
        $field = join("\t", $aData);
        return $this->hGet($key, $field);
    }

    public function logRaw($action, $aData)
    {	
        return $this->rPush($this->prefix.$action, json_encode($aData));
    }

    /**
     * @deprecated
     */
    public function logConversion($action, $aData)
    {
        return $this->logRaw($action, $aData);
    }
}
