<?php

/**
 * apDeliveryLogRedis for Revive Adserver and OpenX Source
 *
 * @author Matteo Beccati
 * @copyright 2013-2015 AdserverPlugins.com - All rights reserved
 *
 */


require_once MAX_PATH.'/lib/pear/Date.php';
require_once MAX_PATH.'/lib/OA/Cache.php';
require_once MAX_PATH.'/lib/OX/Plugin/Component.php';


class AP_DeliveryLogRedis_DAL_Admin
{
    protected $oDbh;

    protected $aBuckets = array(
	 'requests' => array(
            'table'  => 'data_bkt_r',
            'fields' => array(
                'creative_id',
                'zone_id'
            ),
            't_stamp' => 'interval_start',
        ),
        'impressions' => array(
            'table'  => 'data_bkt_m',
            'fields' => array(
                'creative_id',
                'zone_id',
            ),
            't_stamp' => 'interval_start',
        ),
        'clicks' => array(
            'table'  => 'data_bkt_c',
            'fields' => array(
                'creative_id',
                'zone_id'
            ),
            't_stamp' => 'interval_start',
        ),		
		'vast_events' => array(
            'table'  => 'data_bkt_vast_e',
            'fields' => array(
                'creative_id',
                'zone_id',
                'vast_event_id',
            ),
            't_stamp' => 'interval_start',
        ),
    );

    protected $aRawBuckets = array(
        'conversions' => 'data_bkt_a',
        'conversion_vars' => 'data_bkt_a_var',
    );

    public function __construct($oDbh)
    {
        $this->oDbh = $oDbh;

        // Get additional buckets
        $aComponents = OX_Component::getListOfRegisteredComponentsForHook('apDeliveryLogRedisMaintenance');	
        if (!empty($aComponents) && is_array($aComponents)) {
            foreach ($aComponents as $componentId) {
                if ($obj = OX_Component::factoryByComponentIdentifier($componentId)) {
                    $plugin = $obj->apDeliveryLogRedisMaintenance();
                    $this->aBuckets += $plugin->getBuckets();
                    $this->aRawBuckets += $plugin->getRawBuckets();
                }
            }
        }
    }

    static function factory()
    {
        $oDbh = OA_DB::singleton();
        if (PEAR::isError($oDbh)) {
            throw new Exception($oDbh->getMessage(), $oDbh->getCode());
        }
				
        $dbtype = 'Mysqli';
        require_once dirname(__FILE__) . "/Admin/{$dbtype}.php";
		
		$class = __CLASS__.'_'.$dbtype;
        return new $class($oDbh);
    }

    public function migrate($oRedis, $oNow = null)
    {
        if (empty($oNow)) {
            $oNow = new Date();
        }
        $oNow->toUTC();
        $oNow->setMinute(0);
        $oNow->setSecond(0);

        // Migrate buckets
        foreach (array_keys($this->aBuckets) as $type) {
			
			//echo $type;  echo "<br/>";  echo "<br/>";
			
					
            $this->migrateBucket($oRedis, $oNow, $type);
        }

        // Migrate conversions
        foreach ($this->aRawBuckets as $bucket => $table) {
            $this->migrateRawBucket($oRedis, $bucket, $table);
        }

        // Run plugin hooks
        $aComponents = OX_Component::getListOfRegisteredComponentsForHook('apDeliveryLogRedisMaintenance');
        if (!empty($aComponents) && is_array($aComponents)) {
            foreach ($aComponents as $componentId) {
                if ($obj = OX_Component::factoryByComponentIdentifier($componentId)) {
                    $this->migrateComponent(
                        $obj->apDeliveryLogRedisMaintenance(),
                        $oRedis,
                        $oNow
                    );
                }
            }
        }
    }

    protected function migrateComponent(AP_DeliveryLogRedis_MaintenanceTask $task, $oRedis, $oNow)
    {
        $task->migrate($oRedis, $oNow);
    }

    protected function migrateBucket($oRedis, $oNow, $type)
    {
        $prefix = $oRedis->getPrefix()."{$type}_"; 
								
        foreach ($oRedis->keys($prefix.'*') as $key) {
            // Get bucket timestamp
            $t_stamp = substr($key, strlen($prefix));

            $oDate = new Date($t_stamp);
            $oDate->setTZbyID('UTC');
			
			//echo "key-->".$key; 
			
			//echo "<br/>";

            // Skip if the bucket is active
            /*if (!$oDate->before($oNow)) {
                continue;
            }*/

            try {
                $oRedis->watch($key);
                $this->migrateBucketKey($oRedis, $type, $key, $t_stamp);
            } catch (RedisException $e) {
                echo "It looks like another process is running. Skipping";
            }
        }
    }

    protected function migrateBucketKey($oRedis, $type, $key, $t_stamp)
    {
		
		//echo "type-->".$type;
		
		//echo "<br/>";
		
        $res = $oRedis->multi()
            ->hgetall($key)
            ->del($key)
            ->exec();
			
		
        if (is_array($res[0])) {
            for ($aData = $res[0]; current($aData) !== false; next($aData)) {
                if ($oRedis->getType() == AP_Redis::TYPE_PHP) {
                    $pkey = current($aData);
                    $count = next($aData);

                    if ($count === false) {
                        // Missing value?
                        break;
                    }
                } else {
                    $pkey = key($aData);
                    $count = current($aData);
                }
				
				//echo $pkey; 
				
				//echo "<br/>";

                $result = $this->updateBucketTable($oRedis, $type, $pkey, $t_stamp, $count);

                if (!$result) {
                    $oRedis->hset($key, $pkey, $count); 
                }
            }
        }
    }

    protected function migrateRawBucket($oRedis, $bucket, $table)
    {
        while ($data = $oRedis->lPop($oRedis->getPrefix().$bucket)) {
            $this->updateRawTable($oRedis, $bucket, $table, $data);
        }
    }

    protected function updateBucketTable($oRedis, $type, $pkey, $t_stamp, $count)
    {
        $prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $aMap = $this->aBuckets[$type];
		
		/*echo "<br/>";
		
		echo "--------------------------------------";
		
		echo "<br/>";
		
		print_r($aMap['fields']);
		
		echo "<br/>"; 

		echo "------------------------------------";  
		
		echo "<br/>";  
		
		print_r($pkey);  echo "<br/>";
		
		echo "------------------------------------";
		
		echo "<br/>";
		
		print_r($t_stamp);
				
		
		echo "<br/>";
	*/
		

        $aQuery = array(
            $aMap['t_stamp'] => $t_stamp,
        ) + array_combine($aMap['fields'], explode("\t", $pkey));
				
		//print_r($aQuery); echo "<br/>";		

        $query = $this->prepareUpdateQuery($prefix.$aMap['table'], $aQuery, $count);
		
		//echo $query; echo "<br/>"; echo "<br/>";

        $result = $this->oDbh->exec($query);

        return !PEAR::isError($result);
    }

    protected function updateRawTable($oRedis, $bucket, $table, $data)
    {
		$aData = json_decode($data, true);

        if (!empty($aData)) {
            $prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
            $tableName = $this->oDbh->quoteIdentifier($prefix.$table);

            $fields = array_map(array($this->oDbh, 'quoteIdentifier'), array_keys($aData));
            $values = array_map(array($this->oDbh, 'quote'), array_values($aData));

            $query = "INSERT INTO {$tableName} (".join(', ', $fields).") VALUES (".join(', ', $values).")";

            $result = $this->oDbh->exec($query);

            if (PEAR::isError($result)) {
                $oRedis->rPush($oRedis->getPrefix().$bucket.'_errors', $data);
            }
        }
    }

    protected function prepareUpdateQuery($tableName, $aQuery, $count)
    {
        throw new Exception("Needs to be overridden");
    }
}
