<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/www/admin/lib-size.inc.php';
require_once MAX_PATH . '/lib/max/Admin_DA.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH .'/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Admin/NumberFormat.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
// Register input variables
phpAds_registerGlobalUnslashed(
    'zonename',
    'description',
    'delivery',
    'sizetype',
    'size',
    'width',
    'height',
    'submit',
    'comments'
);

/*-------------------------------------------------------*/
/* Affiliate interface security                          */
/*-------------------------------------------------------*/

OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_TRAFFICKER);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid);
OA_Permission::enforceAccessToObject('zones', $zoneid, true);

if (OA_Permission::isAccount(OA_ACCOUNT_TRAFFICKER)) {
    if (!empty($zoneid)) {
        OA_Permission::enforceAllowed(OA_PERM_ZONE_EDIT);
    } else {
        OA_Permission::enforceAllowed(OA_PERM_ZONE_ADD);
    }
}

/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* Initialise data                                       */
/*-------------------------------------------------------*/
if (!empty($zoneid)) {
    $doZones = OA_Dal::factoryDO('zones');
    $doZones->zoneid = $zoneid;
    if ($doZones->find() && $doZones->fetch()) {
        $zone = $doZones->toArray();
    }

    if ($zone['width'] == -1) $zone['width'] = '*';
    if ($zone['height'] == -1) $zone['height'] = '*';
}
else {
    $doAffiliates = OA_Dal::factoryDO('affiliates');
    $doAffiliates->affiliateid = $affiliateid;

    if ($doAffiliates->find() && $doAffiliates->fetch() && $affiliate = $doAffiliates->toArray())
        $zone["zonename"] = $affiliate['name'].' - ';
    else {
        $zone["zonename"] = '';
    }

    $zone['zonename']        .= $GLOBALS['strDefault'];
    $zone['description']     = '';
    $zone['width']           = '468';
    $zone['height']          = '60';
    $zone['delivery']        = phpAds_ZoneBanner;
    $zone['comments'] = null;
}
$zone['affiliateid']     = $affiliateid;


/*-------------------------------------------------------*/
/* MAIN REQUEST PROCESSING                               */
/*-------------------------------------------------------*/
//build form
$zoneForm = buildZoneForm($zone, $oComponent);

if ($zoneForm->validate()) {
    //process submitted values
    $errors = processForm($zoneForm, $oComponent);

    if(!empty($errors)) {
    }
}
//display the page - show any validation errors that may have occurred
displayPage($zone, $zoneForm, $errors);


/*-------------------------------------------------------*/
/* Build form                                            */
/*-------------------------------------------------------*/
function buildZoneForm($zone, $oComponent = null)
{
    global $conf;
    $newZone = empty($zone['zoneid']);

    $form = new OA_Admin_UI_Component_Form("zoneform", "POST", $_SERVER['SCRIPT_NAME']);
    $form->forceClientValidation(true);
    $form->addElement('hidden', 'zoneid', $zone['zoneid']);
    $form->addElement('hidden', 'affiliateid', $zone['affiliateid']);

    $form->addElement('header', 'zone_basic_info', $GLOBALS['strBasicInformation']);
    $form->addElement('text', 'zonename', $GLOBALS['strName']);
    $form->addElement('text', 'description', $GLOBALS['strDescription']);

    //zone type group
    $zoneTypes[] = $form->createElement('radio', 'delivery', '',
        "<img src='".OX::assetPath()."/images/icon-zone.gif' align='absmiddle'>&nbsp;".$GLOBALS['strBannerButtonRectangle'],
        phpAds_ZoneBanner, array('id' => 'delivery-b',
            'onClick' => 'phpAds_formEnableSize();',
            'onChange' => 'oa_hide("warning_change_zone_type");'));
    if ($conf['oxInvocationTags']['isAllowedAdlayer'] || $zone['delivery'] == phpAds_ZoneInterstitial) {
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-interstitial.gif' align='absmiddle'>&nbsp;".$GLOBALS['strInterstitial'],
            phpAds_ZoneInterstitial, array('id' => 'delivery-i',
                'onClick' => 'phpAds_formEnableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
    }
    if ($conf['oxInvocationTags']['isAllowedPopup'] || $zone['delivery'] == phpAds_ZonePopup) {
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-popup.gif' align='absmiddle'>&nbsp;".$GLOBALS['strPopup'],
            phpAds_ZonePopup, array('id' => 'delivery-p',
                'onClick' => 'phpAds_formEnableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
    }
    $zoneTypes[] = $form->createElement('radio', 'delivery', '',
        "<img src='".OX::assetPath()."/images/icon-textzone.gif' align='absmiddle'>&nbsp;".$GLOBALS['strTextAdZone'],
        phpAds_ZoneText, array('id' => 'delivery-t', 'onClick' => 'phpAds_formDisableSize();',
            'onChange' => 'oa_hide("warning_change_zone_type");'));
    $zoneTypes[] = $form->createElement('radio', 'delivery', '',
        "<img src='".OX::assetPath()."/images/icon-zone-email.gif' align='absmiddle'>&nbsp;".$GLOBALS['strEmailAdZone'],
        MAX_ZoneEmail, array('id' => 'delivery-e', 'onClick' => 'phpAds_formEnableSize();',
            'onChange' => 'oa_hide("warning_change_zone_type");'));
    if (!empty($conf['allowedBanners']['video'])) {
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-zone-video-instream.png' align='absmiddle'>&nbsp;".$GLOBALS['strZoneVideoInstream'],
            OX_ZoneVideoInstream, array('id' => 'delivery-vi', 'onClick' => 'phpAds_formDisableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
        $zoneTypes[] = $form->createElement('radio', 'delivery', '',
            "<img src='".OX::assetPath()."/images/icon-zone-video-overlay.png' align='absmiddle'>&nbsp;".$GLOBALS['strZoneVideoOverlay'],
            OX_ZoneVideoOverlay, array('id' => 'delivery-vo', 'onClick' => 'phpAds_formDisableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
    }
       /**** - nativead new zone type add ***/
     $zoneTypes[] = $form->createElement('radio', 'delivery', '',
        "<img src='".OX::assetPath()."/images/icon-zones.png' align='absmiddle'>&nbsp;"."Native Ad",
        OX_nativead, array('id' => 'delivery-native','onClick' => 'phpAds_formEnableSize();',
                'onChange' => 'oa_hide("warning_change_zone_type");'));
                
              
				
		// 	print_r($zoneTypes);die('hai');

     /****  - nativead new zone type end***/
    $form->addGroup($zoneTypes, 'zone_types', $GLOBALS['strZoneType'], "<br/>");

    //size
    global $phpAds_IAB;
    switch ($zone['delivery']) {
        case phpAds_ZoneText:
        case OX_ZoneVideoInstream:
       // case OX_nativead:
        case OX_ZoneVideoOverlay:
            $sizeDisabled = true;
            $zone['width'] = '*';
            $zone['height'] = '*';
        break;
        default:
            $sizeDisabled = false;
        break;

    }

    $aDefaultSize['radio'] = $form->createElement('radio', 'sizetype', '', '',
        'default', array('id' => 'size-d'));
    foreach (array_keys($phpAds_IAB) as $key)
    {
        $iabSizes[$phpAds_IAB[$key]['width']."x".$phpAds_IAB[$key]['height']] =
            $GLOBALS['strIab'][$key];
    }
    $iabSizes['-'] = $GLOBALS['strCustom'];
    $aDefaultSize['select'] = $form->createElement('select', 'size', null, $iabSizes,
        array('onchange' => 'phpAds_formSelectSize(this); oa_sizeChangeUpdateMessage("warning_change_zone_size");', 'class' => 'medium'));


    $aCustomSize['radio'] = $form->createElement('radio', 'sizetype', '', '', 'custom',
        array('id' => 'size-c'));

    $aCustomSize['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].':',
        array('onkeydown' => 'phpAds_formEditSize();',
            'onChange' => 'oa_sizeChangeUpdateMessage("warning_change_zone_size");'));
    $aCustomSize['width']->setSize(5);
    $aCustomSize['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].':',
        array('onkeydown' => 'phpAds_formEditSize();',
            'onChange' => 'oa_sizeChangeUpdateMessage("warning_change_zone_size"),enable_infeed(this.value)'));
    $aCustomSize['height']->setSize(5);

    $sizeTypes['default'] = $form->createElement('group', 'defaultSizeG', null, $aDefaultSize, null, false);
    $sizeTypes['custom'] = $form->createElement('group', 'customSizeG', null, $aCustomSize, null, false);

    //disable fields if necessary
    if ($sizeDisabled) {
        $aDefaultSize['radio']->setAttribute('disabled', $sizeDisabled);
        $aDefaultSize['select']->setAttribute('disabled', $sizeDisabled);
        $aCustomSize['radio']->setAttribute('disabled', $sizeDisabled);
        $aCustomSize['width']->setAttribute('disabled', $sizeDisabled);
        $aCustomSize['height']->setAttribute('disabled', $sizeDisabled);
    }
	
	/** Native adformat - start **/
	
	$zone['native_type'] = (!empty($zone['infeed_type'])) ? 1 : (!empty($zone['recommend_type'])? 2 : (!empty($zone['content_stream'])? 3 : '' ) );
	//~ echo"<pre>";print_r($zone);exit;
	$native_type['infeed'] = $form->createElement('radio', 'native_type',null,'In-Feed units','1');
	//~ $native_type['infeed']->setAttribute("checked",$nativeInfeedType);
	$native_type['infeed']->setAttribute("id",'native_infeed');
	
	$native_type['recommend'] = $form->createElement('radio', 'native_type',null,'Recommended Widget','2');
	//~ $native_type['recommend']->setAttribute("checked",$nativeRecommendType);
	$native_type['recommend']->setAttribute("id",'native_recommend');
	
	$native_type['streaming'] = $form->createElement('radio', 'native_type',null,'Content streaming','3');
	//~ $native_type['recommend']->setAttribute("checked",$nativeRecommendType);
	$native_type['streaming']->setAttribute("id",'native_streaming');
	
	$form->addGroup($native_type,'native_type','Native ad format type','',false);
	
	
    $adtype=array('1'=>'In feed image','2'=>'In feed text');
    //~ $adtype=array('1'=>'In feed image','2'=>'In feed text','3'=>'In feed video'); 
			
	foreach($adtype as $id=>$value)
			{
					$arrayadtype[$id]= $value;	
			}		
    $addbannertype = $form->addElement('select', 'infeed_type', 'Select Infeed Adformat Type',$arrayadtype,array('onchange'=>'disable_size(this.value,this)','id' => 'infeed_type'));
    
    $adtype1=array('1'=>'Image','2'=>'Text','3'=>'Article');
			
	foreach($adtype1 as $id=>$value)
			{
					$arrayadtype1[$id]= $value;	
			}		
    $addbannertype1 = $form->addElement('select', 'recommend_type', 'Select Recommended Adformat Type',$arrayadtype1,array('onchange'=>'disable_size(this.value,this)','id' => 'Recommend_type'));
    
    $widgetsize = array(1=>'1x4',2=>'2x2',3=>'2x3',4=>'2x4');
	$form->addElement('select','article_type','Widget size', $widgetsize);
    
    $form->addElement('text', 'csspath', "Template css path");
    
    /** Native adformat - end **/

    $form->addGroup($sizeTypes, 'size_types', $GLOBALS['strSize'], "<br/>");

    $form->addElement('textarea', 'comments', $GLOBALS['strComments']);

    if ($oComponent && method_exists($oComponent, 'extendZoneForm')) {
        $oComponent->extendZoneForm($form, $zone, $newZone);
    }

    $form->addElement('controls', 'form-controls');
    $form->addElement('submit', 'submit', $GLOBALS['strSaveChanges']);


    //validation rules
    $translation = new OX_Translation();
    $urlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strName']));
    $form->addRule('zonename', $urlRequiredMsg, 'required');


    /*
    TODO
    max_formSetRequirements('width', '<?php echo addslashes($strWidth); ?>', true, 'number*');
    max_formSetRequirements('height', '<?php echo addslashes($strHeight); ?>', true, 'number*');
    */

    //set form values
    $form->setDefaults($zone);

        //sizes radio
    if (phpAds_sizeExists ($zone['width'], $zone['height'])) {
        $size = $zone['width']."x".$zone['height'];
        $sizeType = 'default';
    }
    else {
        $size = "-";
        $sizeType = 'custom';
    }
    $form->setDefaults(array('size' => $size, 'sizetype' => $sizeType));


    return $form;
}

?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>

<script>
	var jq = $.noConflict(true);
	jq(document).ready(function(){
		
		/** size enable or disable - start **/
		jq("#article_type").parent().parent().hide();
		jq("#article_type").parent().parent().next().hide();
		
		if((document.getElementById('native_infeed').checked==true) )
		{
			var infeed_type=document.getElementById('infeed_type').value;	
			
			if(infeed_type==2 || infeed_type==3)
			{
				
				jq("#size-d").attr('disabled', true);
				jq("#size").attr('disabled', true);
				jq("#size-c").attr('disabled', true);
				jq("#width").attr('disabled', true);
				jq("#height").attr('disabled', true);
			}
			else
			{
				jq("#size-d").attr('disabled', false);
				jq("#size").attr('disabled', false);
				jq("#size-c").attr('disabled', false);
				jq("#width").attr('disabled', false);
				jq("#height").attr('disabled', false);
			}
		}
		if((document.getElementById('native_recommend').checked==true) )
		{
			
			var infeed_type=document.getElementById('Recommend_type').value;	
		
			if(infeed_type==2)
			{				
				jq("#size-d").attr('disabled', true);
				jq("#size").attr('disabled', true);
				jq("#size-c").attr('disabled', true);
				jq("#width").attr('disabled', true);
				jq("#height").attr('disabled', true);
			}
			else
			{
				if(infeed_type==3)
				{
				jq("#article_type").parent().parent().show();
				jq("#article_type").parent().parent().next().show();
			}else
				{
				jq("#article_type").parent().parent().hide();
				jq("#article_type").parent().parent().next().hide();
			}			
				jq("#size-d").attr('disabled', false);
				jq("#size").attr('disabled', false);
				jq("#size-c").attr('disabled', false);
				jq("#width").attr('disabled', false);
				jq("#height").attr('disabled', false);
			}
		}
		/** size enable or disable - end **/
	
		/** native type disable enable -start **/
		jq("#infeed_type").parent().parent().hide();
		jq("#infeed_type").parent().parent().next().hide();
		jq("#Recommend_type").parent().parent().hide();
		jq("#Recommend_type").parent().parent().next().hide();
		
	
		if((document.getElementById('delivery-native').checked==true) )
		{
			
			jq("#csspath").attr('required', true);
			jq("input[name='native_type']").parent().parent().show();
			jq("input[name='native_type']").parent().parent().next().show();
			jq("input[name='csspath']").parent().parent().show();
			jq("input[name='csspath']").parent().parent().next().show();
			//~ jq("input[name='native_type']").parent().parent().show();
			//~ jq("input[name='native_type']").parent().parent().next().show();
		}
		else
		{
			jq("#csspath").attr('required', false);
			
			jq("input[name='native_type']").parent().parent().hide();
			jq("input[name='native_type']").parent().parent().next().hide();
			jq("input[name='csspath']").parent().parent().hide();
			jq("input[name='csspath']").parent().parent().next().hide();
		}
		
		jq("input[name='delivery']").change(function(){
			
			jq("#infeed_type").parent().parent().hide();
			jq("#infeed_type").parent().parent().next().hide();
			jq("#Recommend_type").parent().parent().hide();
			jq("#Recommend_type").parent().parent().next().hide();
			
			if(jq(this).attr('id') == 'delivery-native'){
				jq("#csspath").attr('required', true);
				jq("input[name='native_type']").parent().parent().show();
				jq("input[name='native_type']").parent().parent().next().show();
				jq("#native_infeed").attr('checked',true);
				jq("input[name='csspath']").parent().parent().show();
				jq("input[name='csspath']").parent().parent().next().show();
			
			}else{
				jq("#article_type").parent().parent().hide();
				jq("#article_type").parent().parent().next().hide();
				jq("#csspath").attr('required', false);
				jq("input[name='native_type']").parent().parent().hide();
				jq("input[name='native_type']").parent().parent().next().hide();
				jq("#native_infeed").attr('checked',false);
				jq("input[name='csspath']").parent().parent().hide();
				jq("input[name='csspath']").parent().parent().next().hide();
				
			}
			
			if(jq("#native_infeed").attr('checked') == 'checked'){
			
				jq("#infeed_type").parent().parent().show();
				jq("#infeed_type").parent().parent().next().show();
				jq("#Recommend_type").parent().parent().hide();
				jq("#Recommend_type").parent().parent().next().hide();
			}
		
		});
		/** native type enable disable - end **/
		
		/** native format type - start **/
		
		if(jq("#native_infeed").attr('checked') == 'checked'){
			
			jq("#infeed_type").parent().parent().show();
			jq("#infeed_type").parent().parent().next().show();
			jq("#Recommend_type").parent().parent().hide();
			jq("#Recommend_type").parent().parent().next().hide();
		}
		if(jq("#native_recommend").attr('checked') == 'checked'){
			jq("#infeed_type").parent().parent().hide();
			jq("#infeed_type").parent().parent().next().hide();
			jq("#Recommend_type").parent().parent().show();
			jq("#Recommend_type").parent().parent().next().show();
			//~ jq("#article_type").parent().parent().show();
			//~ jq("#article_type").parent().parent().next().show();
		}
		if(jq("#native_streaming").attr('checked') == 'checked'){
			
			jq("#infeed_type").parent().parent().hide();
			jq("#infeed_type").parent().parent().next().hide();
			jq("#Recommend_type").parent().parent().hide();
			jq("#Recommend_type").parent().parent().next().hide();
		}
		jq("input[name='native_type']").change(function(){
			
			if(jq(this).attr('id') == 'native_infeed'){
				
				jq("#infeed_type").parent().parent().show();
				jq("#infeed_type").parent().parent().next().show();
				jq("#Recommend_type").parent().parent().hide();
				jq("#Recommend_type").parent().parent().next().hide();
				jq("#article_type").parent().parent().hide();
				jq("#article_type").parent().parent().next().hide();
			
			}else if(jq(this).attr('id') == 'native_recommend'){
				
				jq("#infeed_type").parent().parent().hide();
				jq("#infeed_type").parent().parent().next().hide();
				jq("#Recommend_type").parent().parent().show();
				jq("#Recommend_type").parent().parent().next().show();
			
			}else{
				
				jq("#infeed_type").parent().parent().hide();
				jq("#infeed_type").parent().parent().next().hide();
				jq("#Recommend_type").parent().parent().hide();
				jq("#Recommend_type").parent().parent().next().hide();
				
			}
		
		});
		/** native format type - end **/
	});
	
	
	function enable_infeed(invalue)
	{
		jq("#infeed_type").attr('disabled', false);
	}

    //~ jq("input[id=delivery-native]:radio").click(function () {
	 //~ 
	 //~ jq("#infeed_type").attr('disabled', false);
	 //~ 
    //~ });
  
	function disable_size(value,e)
		{
			if((jq(e).attr('id') == 'infeed_type' && (value == 2 || value==3)) || (jq(e).attr('id') == 'Recommend_type' && value == 2))
			{
				//~ alert("if");
				jq("#article_type").parent().parent().hide();
				jq("#article_type").parent().parent().next().hide();
				jq("#size-d").attr('disabled', true);
				jq("#size").attr('disabled', true);
				jq("#size-c").attr('disabled', true);
				jq("#width").attr('disabled', true);
				jq("#height").attr('disabled', true);
			}
			else
			{
				//~ alert("hai");
				if((jq(e).attr('id') == 'Recommend_type' && value == 3))
				{
				jq("#article_type").parent().parent().show();
				jq("#article_type").parent().parent().next().show();
				}else
				{
					jq("#article_type").parent().parent().hide();
				jq("#article_type").parent().parent().next().hide();
				}
				
				jq("#size-d").attr('disabled', false);
				jq("#size").attr('disabled', false);
				jq("#size-c").attr('disabled', false);
				jq("#width").attr('disabled', false);
				jq("#height").attr('disabled', false);
				jq("#width").val('468');
				jq("#height").val('60'); 
				jq('select[name="size"] option[value="468x60"]').attr("selected","selected");
				jq("#size-c").attr('checked', false);
				jq("#size-d").attr('checked', true);
			}
			
			
		}
	</script>
		<?php
/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/
/**
 * Processes submit values of zone form
 *
 * @param OA_Admin_UI_Component_Form $form form to process
 * @return An array of Pear::Error objects if any
 */
function processForm($form, $oComponent = null)
{
    $aFields = $form->exportValues();

    switch ($aFields['delivery']) {
        case phpAds_ZoneText:
            $aFields['width'] = $aFields['height'] = 0;
            break;
        case OX_ZoneVideoOverlay:
            $aFields['width'] = $aFields['height'] = -2;
            break;
        case OX_ZoneVideoInstream:
            $aFields['width'] = $aFields['height'] = -3;
            break;
        default:
            if ($aFields['sizetype'] == 'custom') {
                if (isset($aFields['width']) && $aFields['width'] == '*') {
                    $aFields['width'] = -1;
                }
                if (isset($aFields['height']) && $aFields['height'] == '*') {
                    $aFields['height'] = -1;
                }
            } else {
                list($aFields['width'], $aFields['height']) = explode ('x', $aFields['size']);
            }
        break;
    }

    if (!(is_numeric($aFields['oac_category_id'])) || ($aFields['oac_category_id'] <= 0)) {
            $aFields['oac_category_id'] = 'NULL';
    }

    if (empty($errors)) {
       $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        // Edit
        if (!empty($aFields['zoneid']))
        {
            // before we commit any changes to db, store whether the size has changed
            $aZone = Admin_DA::getZone($aFields['zoneid']);
            $size_changed = ($aFields['width'] != $aZone['width'] || $aFields['height'] != $aZone['height']) ? true : false;
            $type_changed = ($aFields['delivery'] != $aZone['type']) ? true : false;

            $doZones = OA_Dal::factoryDO('zones');
            $doZones->zonename = $aFields['zonename'];
            $doZones->description = $aFields['description'];
            $doZones->width = $aFields['width'];
            $doZones->height = $aFields['height'];
            $doZones->comments = $aFields['comments'];
            $doZones->delivery = $aFields['delivery'];
            if ($aFields['delivery'] != phpAds_ZoneText && $aFields['delivery'] != phpAds_ZoneBanner) {
                $doZones->prepend = '';
                $doZones->append = '';
            }
            $doZones->oac_category_id  = $aFields['oac_category_id'];
            $doZones->zoneid = $aFields['zoneid'];
            
            $doZones->update();
            
			if($aFields['delivery'] == 8){
				
				switch($aFields['native_type']){
					
					case 1:
				
						$infeed_width = ($_POST['infeed_type'] == 2) ? -9 : ($_POST['infeed_type'] == 3 ? -10 : $_POST['width']);
           
						$infeed_height = ($_POST['infeed_type'] == 2) ? -9 : ($_POST['infeed_type'] == 3 ? -10 : $_POST['height']); 
           
						OA_Dal_Delivery_query("update rv_zones set infeed_type='".$_POST['infeed_type']."',recommend_type='',width='".$infeed_width."',height='".$infeed_height."',csspath='".$_POST['csspath']."',content_stream='' where zoneid =".$aFields['zoneid']);
						break;
						
					case 2:
					
						$recommend_width = ($_POST['recommend_type'] == 2) ? -11 :$_POST['width'];
           
						$recommend_height = ($_POST['recommend_type'] == 2) ? -11 :$_POST['height']; 
          
						OA_Dal_Delivery_query("update rv_zones set recommend_type='".$_POST['recommend_type']."',article_type='".$_POST['article_type']."',infeed_type='',width='".$recommend_width."',height='".$recommend_height."',csspath='".$_POST['csspath']."',content_stream='' where zoneid =".$aFields['zoneid']);
						OA_Dal_Delivery_query("DELETE FROM rv_ad_zone_assoc where zone_id =".$aFields['zoneid']);
						break;
					case 3:
					
						$streaming_width = ($_POST['content_stream'] == 3) ? -11 :$_POST['width'];
           
						$streaming_height = ($_POST['content_stream'] == 3) ? -11 :$_POST['height']; 
          //~ die(("update rv_zones set recommend_type='',article_type='',infeed_type='',width='".$streaming_width."',height='".$streaming_height."',csspath='".$_POST['csspath']."' where zoneid =".$aFields['zoneid']));
						OA_Dal_Delivery_query("update rv_zones set  content_stream='1',recommend_type='',article_type='',infeed_type='',width='".$streaming_width."',height='".$streaming_height."',csspath='".$_POST['csspath']."' where zoneid =".$aFields['zoneid']);
						//~ OA_Dal_Delivery_query("DELETE FROM rv_ad_zone_assoc where zone_id =".$aFields['zoneid']);
						break;
				}
				
			}else{
				OA_Dal_Delivery_query("update rv_zones set recommend_type='',infeed_type='',csspath='' where zoneid =".$aFields['zoneid']);
			}
			/** Native ad -End **/

            // Reset append codes which called this zone
            $doZones = OA_Dal::factoryDO('zones');
            $doZones->appendtype = phpAds_ZoneAppendZone;

            if (OA_Permission::isAccount(OA_ACCOUNT_MANAGER))
            {
                $doZones->addReferenceFilter('agency', OA_Permission::getEntityId());
            }
            elseif (OA_Permission::isAccount(OA_ACCOUNT_TRAFFICKER))
            {
                  $doZones->addReferenceFilter('affiliates', OA_Permission::getEntityId());
            }
            $doZones->find();

            while ($doZones->fetch() && $row = $doZones->toArray())
            {
                $append = phpAds_ZoneParseAppendCode($row['append']);

                if ($append[0]['zoneid'] == $aFields['zoneid'])
                {
                    $doZonesClone = clone($doZones);
                    $doZonesClone->appendtype = phpAds_ZoneAppendRaw;
                    $doZonesClone->append = '';
                    $doZonesClone->update();
                    
                }
            }
            
            
            //DAC linking start
            
             if ($type_changed && ($aFields['delivery'] == OX_nativead && $aZone['type'] == phpAds_ZoneBanner) ||($aFields['delivery'] == phpAds_ZoneBanner && $aZone['type'] == OX_nativead) ) {
                // Unlink all campaigns/banners linked to this zone
                $aPlacementZones = Admin_DA::getPlacementZones(array('zone_id' => $aFields['zoneid']), true, 'placement_id');
                if (!empty($aPlacementZones)) {
                    foreach ($aPlacementZones as $placementId => $aPlacementZone) {
                        Admin_DA::deletePlacementZones(array('zone_id' => $aFields['zoneid'], 'placement_id' => $placementId));
                    }
                }
                $aAdZones = Admin_DA::getAdZones(array('zone_id' => $aFields['zoneid']), false, 'ad_id');
                if (!empty($aAdZones)) {
                    foreach ($aAdZones as $adId => $aAdZone) {
                        Admin_DA::deleteAdZones(array('zone_id' => $aFields['zoneid'], 'ad_id' => $adId));
                    }
                }
            }           
            
            //DAC linking end
            if ($type_changed && $aFields['delivery'] == MAX_ZoneEmail) {
                // Unlink all campaigns/banners linked to this zone
                $aPlacementZones = Admin_DA::getPlacementZones(array('zone_id' => $aFields['zoneid']), true, 'placement_id');
                if (!empty($aPlacementZones)) {
                    foreach ($aPlacementZones as $placementId => $aPlacementZone) {
                        Admin_DA::deletePlacementZones(array('zone_id' => $aFields['zoneid'], 'placement_id' => $placementId));
                    }
                }
                $aAdZones = Admin_DA::getAdZones(array('zone_id' => $aFields['zoneid']), false, 'ad_id');
                if (!empty($aAdZones)) {
                    foreach ($aAdZones as $adId => $aAdZone) {
                        Admin_DA::deleteAdZones(array('zone_id' => $aFields['zoneid'], 'ad_id' => $adId));
                    }
                }
            }
            

            if ($type_changed && $aFields['delivery'] == MAX_ZoneEmail) {
                // Unlink all campaigns/banners linked to this zone
                $aPlacementZones = Admin_DA::getPlacementZones(array('zone_id' => $aFields['zoneid']), true, 'placement_id');
                if (!empty($aPlacementZones)) {
                    foreach ($aPlacementZones as $placementId => $aPlacementZone) {
                        Admin_DA::deletePlacementZones(array('zone_id' => $aFields['zoneid'], 'placement_id' => $placementId));
                    }
                }
                $aAdZones = Admin_DA::getAdZones(array('zone_id' => $aFields['zoneid']), false, 'ad_id');
                if (!empty($aAdZones)) {
                    foreach ($aAdZones as $adId => $aAdZone) {
                        Admin_DA::deleteAdZones(array('zone_id' => $aFields['zoneid'], 'ad_id' => $adId));
                    }
                }
            }
            else if ($size_changed) {
                $aZone = Admin_DA::getZone($aFields['zoneid']);

                // Loop through all appended banners and make sure that they still fit...
                $aAds = Admin_DA::getAdZones(array('zone_id' => $aFields['zoneid']), false, 'ad_id');
                if (!empty($aAds)) {
                 foreach ($aAds as $adId => $aAd) {
                    $aAd = Admin_DA::getAd($adId);
                        if ( (($aZone['type'] == phpAds_ZoneText) && ($aAd['type'] != 'txt'))
                        || (($aAd['width'] != $aZone['width']) && ($aZone['width'] != -1))
                        || (($aAd['height'] != $aZone['height']) && ($aZone['height'] != -1)) ) {
                            Admin_DA::deleteAdZones(array('zone_id' => $aFields['zoneid'], 'ad_id' => $adId));
                        }
                    }
                }

                // Check if any campaigns linked to this zone have ads that now fit.
                // If so, link them to the zone.
                $aPlacementZones = Admin_DA::getPlacementZones(array('zone_id' => $aFields['zoneid']), true);
                if (!empty($aPlacementZones)) {
                    foreach($aPlacementZones as $aPlacementZone) {
                    // get ads in this campaign
                    $aAds = Admin_DA::getAds(array('placement_id' => $aPlacementZone['placement_id']), true);
                        foreach ($aAds as $adId => $aAd) {
                            Admin_DA::addAdZone(array('zone_id' => $aFields['zoneid'], 'ad_id' => $adId));
                        }
                    }
                }
            }
            if ($oComponent && method_exists($oComponent, 'processZoneForm')) {
                $oComponent->processZoneForm($aFields);
            }

            // Queue confirmation message
            $translation = new OX_Translation();
            $translated_message = $translation->translate ( $GLOBALS['strZoneHasBeenUpdated'],
                array(
                MAX::constructURL(MAX_URL_ADMIN, "zone-edit.php?affiliateid=".$aFields['affiliateid']."&zoneid=".$aFields['zoneid']),
                htmlspecialchars($aFields['zonename'])
                ));
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

            OX_Admin_Redirect::redirect("zone-edit.php?affiliateid=".$aFields['affiliateid']."&zoneid=".$aFields['zoneid']);
        }
        // Add
        else
        {
            $doZones = OA_Dal::factoryDO('zones');
            $doZones->affiliateid = $aFields['affiliateid'];
            $doZones->zonename = $aFields['zonename'];
            $doZones->zonetype = phpAds_ZoneCampaign;
            $doZones->description = $aFields['description'];
            $doZones->comments = $aFields['comments'];
            $doZones->width = $aFields['width'];
            $doZones->height = $aFields['height'];
            $doZones->delivery = $aFields['delivery'];
            $doZones->oac_category_id  = $aFields['oac_category_id'];

            // The following fields are NOT NULL but do not get values set in the form.
            // Should these fields be changed to NULL in the schema or should they have a default value?
            $doZones->category = '';
            $doZones->ad_selection = '';
            $doZones->chain = '';
            $doZones->prepend = '';
            $doZones->append = '';

            $doZones->show_capped_no_cookie = 0;

            $aFields['zoneid'] = $doZones->insert();
			//~ print_r($_POST);exit;
			/** Native Ads - start **/
			if($aFields['delivery'] == 8){
				
				switch($aFields['native_type']){
					
					case 1:
				
						$infeed_width = ($_POST['infeed_type'] == 2) ? -9 : ($_POST['infeed_type'] == 3 ? -10 : $_POST['width']);
           
						$infeed_height = ($_POST['infeed_type'] == 2) ? -9 : ($_POST['infeed_type'] == 3 ? -10 : $_POST['height']); 
           
						OA_Dal_Delivery_query("update rv_zones set infeed_type='".$_POST['infeed_type']."',width='".$infeed_width."',height='".$infeed_height."',csspath='".$_POST['csspath']."',content_stream='' where zoneid =".$aFields['zoneid']);
						break;
						
					case 2:
					
						$recommend_width = ($_POST['recommend_type'] == 2) ? -11 :$_POST['width'];
           
						$infeed_height = ($_POST['recommend_type'] == 2) ? -11 :$_POST['height']; 
           
						OA_Dal_Delivery_query("update rv_zones set recommend_type='".$_POST['recommend_type']."',article_type='".$_POST['article_type']."',width='".$recommend_width."',height='".$infeed_height."',csspath='".$_POST['csspath']."', content_stream='' where zoneid =".$aFields['zoneid']);
						break;
					case 3:
					
						$streaming_width = ($_POST['content_stream'] == 3) ? -11 :$_POST['width'];
           
						$streaming_height = ($_POST['content_stream'] == 3) ? -11 :$_POST['height']; 
          //~ die("update rv_zones set recommend_type='',article_type='',infeed_type='',width='".$streaming_width."',height='".$streaming_height."',csspath='".$_POST['csspath']."' where zoneid =".$aFields['zoneid']);
						OA_Dal_Delivery_query("update rv_zones set content_stream='1', recommend_type='',article_type='',infeed_type='',width='".$streaming_width."',height='".$streaming_height."',csspath='".$_POST['csspath']."' where zoneid =".$aFields['zoneid']);
						//~ OA_Dal_Delivery_query("DELETE FROM rv_ad_zone_assoc where zone_id =".$aFields['zoneid']);
						break;
				}
				
			}
			/** Native Ads - End **/
   
            if ($oComponent && method_exists($oComponent, 'processZoneForm')) {
                $oComponent->processZoneForm($aFields);
            }

            // Queue confirmation message
            $translation = new OX_Translation ();
            $translated_message = $translation->translate ( $GLOBALS['strZoneHasBeenAdded'], array(
                MAX::constructURL(MAX_URL_ADMIN, 'zone-edit.php?affiliateid=' .  $aFields['affiliateid'] . '&zoneid=' . $aFields['zoneid']),
                htmlspecialchars($aFields['zonename'])
            ));
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

            OX_Admin_Redirect::redirect("affiliate-zones.php?affiliateid=".$aFields['affiliateid']);
        }
    }

    return $errors;
}


/*-------------------------------------------------------*/
/* Display page                                          */
/*-------------------------------------------------------*/
function displayPage($zone, $form, $zoneErrors = null)
{
    //header and breadcrumbs
    $pageName = basename($_SERVER['SCRIPT_NAME']);
    $agencyId = OA_Permission::getAgencyId();
    $aEntities = array('affiliateid' => $zone['affiliateid'], 'zoneid' => $zone['zoneid']);

    $aOtherPublishers = Admin_DA::getPublishers(array('agency_id' => $agencyId));
    $aOtherZones = Admin_DA::getZones(array('publisher_id' => $zone['affiliateid']));
    MAX_displayNavigationZone($pageName, $aOtherPublishers, $aOtherZones, $aEntities);

    //get template and display form
    $oTpl = new OA_Admin_Template('zone-edit.html');
    $oTpl->assign('zoneid', $zone['zoneid']);
    $oTpl->assign('zoneHeight', $zone["height"]);
    $oTpl->assign('zoneWidth', $zone["width"]);

    $oTpl->assign('zoneErrors', $zoneErrors);
    $oTpl->assign('form', $form->serialize());

    $oTpl->display();

    //footer
    phpAds_PageFooter();
}

?>
