<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/OA/Creative/File.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/max/other/common.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';

require_once MAX_PATH . '/www/admin/lib-size.inc.php';

require_once LIB_PATH . '/Plugin/Component.php';
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')

    {

      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';

     }

    else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')

    {

      require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';

     }

    else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')

    {

      require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';

     }
$htmltemplate = MAX_commonGetValueUnslashed('htmltemplate');

// Register input variables
phpAds_registerGlobalUnslashed(
     'alink'
    ,'alink_chosen'
    ,'alt'
    ,'alt_imageurl'
    ,'asource'
    ,'atar'
    ,'adserver'
    ,'bannertext'
    ,'campaignid'
    ,'checkswf'
    ,'clientid'
    ,'comments'
    ,'description'
    ,'ext_bannertype'
    ,'height'
    ,'imageurl'
    ,'keyword'
    ,'message'
    ,'replaceimage'
    ,'replacealtimage'
    ,'status'
    ,'statustext'
    ,'type'
    ,'submit'
    ,'target'
    ,'transparent'
    ,'upload'
    ,'url'
    ,'weight'
    ,'width'
);

/*-------------------------------------------------------*/
/* Client interface security                             */
/*-------------------------------------------------------*/
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_ADVERTISER);
OA_Permission::enforceAccessToObject('clients',   $clientid);
OA_Permission::enforceAccessToObject('campaigns', $campaignid);

if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
    OA_Permission::enforceAllowed(OA_PERM_BANNER_EDIT);
    OA_Permission::enforceAccessToObject('banners', $bannerid, true);//DAC015-All permisison mod
} else {
    OA_Permission::enforceAccessToObject('banners', $bannerid, true);
}


/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
phpAds_SessionDataStore();

/*
storage type / media type
sql gif
sql png
sql jpeg
sql swf
sql mov
web gif
web png
web jpeg
web swf
web mov
url gif
url png
url jpeg
url swf
url mov
txt text
html html
*/

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

// Decide whether this is add or edit, get banner data or initialise it
if($_GET['reload'] !='')
{
	$imgsize = explode("x",$_GET['reload']);
	OA_Dal_Delivery_query("update ".$table_prefix."banners set width='".$imgsize[0]."',height='".$imgsize[1]."' where bannerid='".$bannerid."'");
	
	OA_Dal_Delivery_query("DELETE FROM ".$table_prefix."nativead_article WHERE banner_id='".$bannerid."'");

}
if ($bannerid != '') {
    // Fetch the data from the database
    $doBanners = OA_Dal::factoryDO('banners');
    if ($doBanners->get($bannerid)) {
        $aBanner = $doBanners->toArray();
    }

    // Set basic values
    $type               = $aBanner['storagetype'];
    $ext_bannertype     = $aBanner['ext_bannertype'];
    $hardcoded_links    = array();
    $hardcoded_targets  = array();
    $hardcoded_sources  = array();

    if (empty($ext_bannertype)) {
        if ($type == 'html') {
            $ext_bannertype = 'bannerTypeHtml:oxHtml:genericHtml';
        } elseif ($type == 'txt') {
            $ext_bannertype = 'bannerTypeText:oxText:genericText';
        }
    }
    // Check for hard-coded links
    if (!empty($aBanner['parameters'])) {
        $aSwfParams = unserialize($aBanner['parameters']);
        if (!empty($aSwfParams['swf'])) {
            foreach ($aSwfParams['swf'] as $iKey => $aSwf) {
                $hardcoded_links[$iKey]   = $aSwf['link'];
                $hardcoded_targets[$iKey] = $aSwf['tar'];
                $hardcoded_sources[$iKey] = '';
            }
        }
    }
    if (!empty($aBanner['filename'])) {
        $aBanner['replaceimage'] = "f"; //select keep image by default
    }

    if (!empty($aBanner['alt_filename'])) {
        $aBanner['replacealtimage'] = "f"; //select keep backup image by default
    }

    $aBanner['hardcoded_links'] = $hardcoded_links;
    $aBanner['hardcoded_targets'] = $hardcoded_targets;
    $aBanner['hardcoded_sources'] = $hardcoded_sources;
    $aBanner['clientid']   = $clientid;

}
else {
    // Set default values for new banner
    $aBanner['bannerid']     = '';
    $aBanner['campaignid']   = $campaignid;
    $aBanner['clientid']     = $clientid;
    $aBanner['alt']          = '';
    $aBanner['status']       = '';
    $aBanner['bannertext']   = '';
    $aBanner['url']          = "http://";
    $aBanner['target']       = '';
    $aBanner['imageurl']     = "http://";
    $aBanner['width']        = '';
    $aBanner['height']       = '';
    $aBanner['htmltemplate'] = '';
    $aBanner['description']  = '';
    $aBanner['comments']     = '';
    $aBanner['contenttype']  = '';
    $aBanner['adserver']     = '';
    $aBanner['keyword']      = '';
    $aBanner["weight"]       = $pref['default_banner_weight'];
    $aBanner['native_type']  = 	"native_in_feed"; //native ads
    //~ $aBanner['infeed_type']  = 	"in_feed_image"; //native ads
    
    $aBanner['dj_emb_check']  = 1;
    $aBanner['xml_url']  = 	'';
    $aBanner['iframe_friendly'] = true;

    $aBanner['hardcoded_links'] = array();
    $aBanner['hardcoded_targets'] = array();
}
if ($ext_bannertype)
{
    $oComponent = OX_Component::factoryByComponentIdentifier($ext_bannertype);
    //  we may want to use the ancestor class for some sort of generic functionality
    if (!$oComponent)
    {
        $oComponent = OX_Component::getFallbackHandler($extension);
    }
    $formDisabled = (!$oComponent || !$oComponent->enabled);
}
if ((!$ext_bannertype) && $type && (!in_array($type, array('sql','web','url','html','txt','native')))) //Native Ads
{
    $oComponent = OX_Component::factoryByComponentIdentifier($type);
    $formDisabled = (!$oComponent || !$oComponent->enabled);
    if ($oComponent)
    {
        $ext_bannertype = $type;
        $type = $oComponent->getStorageType();
    }
    else
    {
        $ext_bannertype = '';
        $type = '';
    }
}


// If adding a new banner or used storing type is disabled
// determine which bannertype to show as default
$show_sql   = $conf['allowedBanners']['sql'];
$show_web   = $conf['allowedBanners']['web'];
$show_url   = $conf['allowedBanners']['url'];
$show_html  = $conf['allowedBanners']['html'];
$show_txt   = $conf['allowedBanners']['text'];

//Native Ads
$show_native = 1;
//Native Ads



if (isset($type) && $type == "sql")      $show_sql     = true;
if (isset($type) && $type == "web")      $show_web     = true;
if (isset($type) && $type == "url")      $show_url     = true;
if (isset($type) && $type == "html")     $show_html    = true;
if (isset($type) && $type == "txt")      $show_txt     = true;
if (isset($type) && $type == "native")   $show_native  = true; //Native Ads


$bannerTypes = array();
if ($show_web) {
    $bannerTypes['web']['web'] = $GLOBALS['strWebBanner'];
}
if ($show_sql) {
    $bannerTypes['sql']['sql'] = $GLOBALS['strMySQLBanner'];
}
if ($show_url) {
    $bannerTypes['url']['url']= $GLOBALS['strURLBanner'];
}
/*Native*/
if ($show_native) {
    $bannerTypes['native']['native'] = "Provide details for Native Ad";
}
/*Native*/
if ($show_html) {
    $aBannerTypeHtml = OX_Component::getComponents('bannerTypeHtml');
    foreach ($aBannerTypeHtml AS $tmpComponent)
    {
        $componentIdentifier = $tmpComponent->getComponentIdentifier();
        $bannerTypes['html'][$componentIdentifier] = $tmpComponent->getOptionDescription();
    }
}
if ($show_txt) {
    $aBannerTypeText = OX_Component::getComponents('bannerTypeText');
    foreach ($aBannerTypeText AS $tmpComponent)
    {
        $componentIdentifier = $tmpComponent->getComponentIdentifier();
        $bannerTypes['text'][$componentIdentifier] = $tmpComponent->getOptionDescription();
    }
}

if (!$type)
{
    if ($show_txt)     $type = "txt";
    if ($show_html)    $type = "html";
    if ($show_native)  $type = "native"; //Native Ads
    if ($show_url)     $type = "url";
    if ($show_sql)     $type = "sql";
    if ($show_web)     $type = "web";
    
}

// Build banner form
$form = buildBannerForm($type, $aBanner, $oComponent, $formDisabled);

$valid = $form->validate();
if ($valid && $oComponent && $oComponent->enabled)
{
    $valid = $oComponent->validateForm($form);
}
if ($valid)
{
    //process submitted values
    processForm($bannerid, $form, $oComponent, $formDisabled);
}
else { //either validation failed or form was not submitted, display the form
    displayPage($bannerid, $campaignid, $clientid, $bannerTypes, $aBanner, $type, $form, $ext_bannertype, $formDisabled);
}



function displayPage($bannerid, $campaignid, $clientid, $bannerTypes, $aBanner, $type, $form, $ext_bannertype, $formDisabled=false)
{
    // Initialise some parameters
    $pageName = basename($_SERVER['SCRIPT_NAME']);
    $aEntities = array('clientid' => $clientid, 'campaignid' => $campaignid, 'bannerid' => $bannerid);

    $entityId = OA_Permission::getEntityId();
    if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
        $entityType = 'advertiser_id';
    } else {
        $entityType = 'agency_id';
    }

    // Display navigation
    $aOtherCampaigns = Admin_DA::getPlacements(array($entityType => $entityId));
    $aOtherBanners = Admin_DA::getAds(array('placement_id' => $campaignid), false);

    // Display banner preview
    MAX_displayNavigationBanner($pageName, $aOtherCampaigns, $aOtherBanners, $aEntities);

    //actual page content - type chooser and form
    /*-------------------------------------------------------*/
    /* Main code                                             */
    /*-------------------------------------------------------*/
    $oTpl = new OA_Admin_Template('banner-edit.html');

    $oTpl->assign('clientId',  $clientid);
    $oTpl->assign('campaignId',  $campaignid);
    $oTpl->assign('bannerId',  $bannerid);
    $oTpl->assign('bannerTypes', $bannerTypes);
    $oTpl->assign('bannerType', ($ext_bannertype ? $ext_bannertype : $type));
    $oTpl->assign('bannerHeight', $aBanner["height"]);
    $oTpl->assign('bannerWidth', $aBanner["width"]);
    $oTpl->assign('disabled', $formDisabled);
    $oTpl->assign('form', $form->serialize());


    $oTpl->display();
    ?>
   
<!--
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
-->
<script>
 
 

$(document).ready(function(){
	
	$('input[name="dj_iconimageurl11"]').parent().parent().hide();
	$('input[name="native_cta"]').parent().parent().hide();
	$('#icon_sizes11').parent().parent().hide();
	
	$('#vid_type').parent().parent().parent().parent().hide();
	
	$('#dj_data_desc1').parent().parent().parent().parent().hide();
	
	//~ $('#dj_data_ctatext').parent().parent().parent().parent().hide();
	//~ $('#dj_data_sponsored').parent().parent().hide();
	//~ $('#title').parent().parent().hide();
	//~ $('#dj_data_rating').parent().parent().hide();
	//~ $('#dj_data_ctatext').parent().parent().hide();
	
	
	$('#article_img_size').parent().parent().hide();
		
	//During page loading 
	$("#article_type").parent().parent().hide();
	$("#dj_data_sponsored1").parent().parent().parent().parent().hide();
	$("input[name='upload1']").parent().parent().parent().parent().hide();
	$("input[name='upload2']").parent().parent().parent().parent().hide();
	$("input[name='upload3']").parent().parent().parent().parent().hide();
	$("input[name='upload4']").parent().parent().parent().parent().hide();
	$("input[name='upload5']").parent().parent().parent().parent().hide();
	$("input[name='upload6']").parent().parent().parent().parent().hide();
	$("input[name='upload7']").parent().parent().parent().parent().hide();
	$("input[name='upload8']").parent().parent().parent().parent().hide();
	
	//~ $("input[name='upload']").parent().parent().parent().parent().hide();
	//~ $("input[name='dj_data_sponsored']").parent().parent().parent().parent().hide();
	//~ $("input[name='title']").parent().parent().parent().parent().hide();
	//~ $("input[name='dj_data_desc']").parent().parent().parent().parent().hide();
	//~ $("input[name='destination_url']").parent().parent().parent().parent().hide();
	//~ $('#dj_data_desc').attr('required',true);
	//~ $('#dj_data_sponsored').attr('required',true);
	//~ $('#title').attr('required',true);
	//~ $('#videourl').attr('required',false);
	
	if($('input[name="native_type"]:checked').val() == 'native_in_feed') {
		
		$('input[name="recommend_type"]').parent().parent().hide();
		$('input[name="infeed_type"]').parent().parent().show();
		

		
	}else if($('input[name="native_type"]:checked').val() == 'native_recommend') {
		
		$('input[name="recommend_type"]').parent().parent().show();
		$('input[name="infeed_type"]').parent().parent().hide();
		//~ if($('input[name="native_type"]:checked').val())
		//~ {
			//~ 
		//~ }
		
	}else {
		
		$('input[name="recommend_type"]').parent().parent().hide();
		$('input[name="infeed_type"]').parent().parent().hide();		
	}

	if($('#in_feed_image').is(':checked') || $('#recommend_image').is(':checked')){		
		
		$('#dj_data_desc').parent().parent().show();
		$("#dj_data_desc").parent().parent().parent().parent().show();
		$('#videourl').parent().parent().hide();
		
	}else if($('#in_feed_text').is(':checked') || $('#recommend_text').is(':checked')){	
			
		$('input[name="upload"]').parent().parent().hide();
		$('#dj_data_desc').parent().parent().show(); 
		$('#videourl').parent().parent().hide();
		
	}else if($('#in_feed_video').is(':checked')){
		
		$('input[name="upload"]').parent().parent().hide();
		$('#dj_data_desc').parent().parent().show();
		$('#dj_data_desc').attr('required',false); 
		$('#videourl').parent().parent().show();
		$('#videourl').attr('required',true);
		
	}else if($('#recommend_article').is(':checked')){
		$('#article_img_size').parent().parent().show();
		//~ $("#dj_data_sponsored").val('1');
		//~ $("#title").val('1');
		//~ $("#dj_data_desc").val('1');
		//~ $("#destination_url").val('1');
		
		$("#dj_data_desc").parent().parent().parent().parent().hide();
		$('#dj_data_desc').parent().parent().show(); 
		//~ $('#article_type').parent().parent().show(); 
		$('#videourl').parent().parent().hide();
		//~ alert("f"+$('#article_type').val());
			$("#article_type").parent().parent().show();
			 $("#dj_data_sponsored1").parent().parent().parent().parent().show();
			 $("input[name='upload1']").parent().parent().parent().parent().show();
			 $("input[name='upload2']").parent().parent().parent().parent().show();
			 $("input[name='upload3']").parent().parent().parent().parent().show();
			 $("input[name='upload4']").parent().parent().parent().parent().show();
			 
			 $("#dj_data_desc").parent().parent().parent().parent().hide();
			 //~ $('#videourl').attr('required',true);
		if($('#article_type').val() == "3"){
			 $("input[name='upload5']").parent().parent().parent().parent().show();
			 $("input[name='upload6']").parent().parent().parent().parent().show();
		 }
		 if($('#article_type').val() == "4"){
			 $("input[name='upload5']").parent().parent().parent().parent().show();
			 $("input[name='upload6']").parent().parent().parent().parent().show();
			 $("input[name='upload7']").parent().parent().parent().parent().show();
			 $("input[name='upload8']").parent().parent().parent().parent().show();
		 }
			 
	}else{
		
		 $('input[name="emb_check"]').parent().parent().parent().parent().hide();
		 $('input[name="dj_video_width').parent().parent().parent().parent().hide();
		 //$('input[name="dj_data_ctatext').parent().parent().parent().parent().hide();
		 $('#dj_data_ctatext').parent().parent().hide();
		 $('#dj_data_rating').parent().parent().hide();
		 // $('input[name="dj_data_sponsored').parent().parent().show();
		 //$('input[name="upload"]').parent().parent().parent().parent().hide(); 
	}

if($('#native_adformat_content').is(':checked')) {
	$('input[name="emb_check"]').parent().parent().parent().parent().show();
	$('input[name="dj_video_width').parent().parent().parent().parent().show();
	$('#dj_data_desc').parent().parent().hide(); 
	
	//~ $('input[name="upload"]').parent().parent().parent().parent().hide(); 
	$('input[name="dj_iconimageurl11"]').parent().parent().show();
	$('input[name="native_cta"]').parent().parent().show();
	$('#icon_sizes11').parent().parent().show();
	$('#vid_type').parent().parent().parent().parent().show();
	$('#destination_url').parent().parent().hide();
	//~ $('#dj_data_desc1').parent().parent().parent().parent().show();
}

    $('input[type="radio"]').click(function(){

        if($(this).attr("value")=="native_recommend"){			
			
			$("#url").parent().parent().parent().parent().show();
			$('input[name="infeed_type"]').parent().parent().hide();
			$('input[name="recommend_type"]').parent().parent().show();
			$('#recommend_image').attr('checked',true); 
			$('input[name="upload"]').parent().parent().show(); 
			$("#dj_data_desc").parent().parent().parent().parent().show();
			$('#videourl').parent().parent().hide();
			$("#article_type").parent().parent().hide();
			$("#article_img_size").parent().parent().hide();
			$('input[name="dj_iconimageurl11"]').parent().parent().hide();
			$('input[name="native_cta"]').parent().parent().hide();
			$('#icon_sizes11').parent().parent().hide();
			
			$('#vid_type').parent().parent().parent().parent().hide();
			
			$('#dj_data_desc1').parent().parent().parent().parent().hide();
			$("#dj_data_sponsored1").parent().parent().parent().parent().hide();
			$("input[name='upload1']").parent().parent().parent().parent().hide();
			$("input[name='upload2']").parent().parent().parent().parent().hide();
			$("input[name='upload3']").parent().parent().parent().parent().hide();
			$("input[name='upload4']").parent().parent().parent().parent().hide();
			$("input[name='upload5']").parent().parent().parent().parent().hide();
			$("input[name='upload6']").parent().parent().parent().parent().hide();
			$("input[name='upload7']").parent().parent().parent().parent().hide();
			$("input[name='upload8']").parent().parent().parent().parent().hide();
        }else if($(this).attr("id")=="native_in_feed"){
			
			$('input[name="infeed_type"]').parent().parent().show();
			$('input[name="recommend_type"]').parent().parent().hide();
			$('#in_feed_image').attr('checked',true); 
			$('#videourl').parent().parent().hide();
			$('#dj_data_desc').parent().parent().show();
			$("#article_type").parent().parent().hide();
			$("#article_img_size").parent().parent().hide();
			$('input[name="dj_iconimageurl11"]').parent().parent().hide();
			$('input[name="native_cta"]').parent().parent().hide();
			$('#icon_sizes11').parent().parent().hide();
			
			$('#vid_type').parent().parent().parent().parent().hide();
			
			$('#dj_data_desc1').parent().parent().parent().parent().hide();
			// $('#dj_data_rating').parent().parent().show();
			$('input[name="upload"]').parent().parent().parent().parent().show(); 
			$("#dj_data_sponsored1").parent().parent().parent().parent().hide();
			$("input[name='upload1']").parent().parent().parent().parent().hide();
			$("input[name='upload2']").parent().parent().parent().parent().hide();
			$("input[name='upload3']").parent().parent().parent().parent().hide();
			$("input[name='upload4']").parent().parent().parent().parent().hide();
			$("input[name='upload5']").parent().parent().parent().parent().hide();
			$("input[name='upload6']").parent().parent().parent().parent().hide();
			$("input[name='upload7']").parent().parent().parent().parent().hide();
			$("input[name='upload8']").parent().parent().parent().parent().hide();
		}else if($(this).attr("id")=="in_feed_image"){
			//~ alert('hide');			
			 $('input[name="upload"]').parent().parent().show(); 
			 $('#videourl').parent().parent().hide();
			 $("#article_type").parent().parent().hide();
			 $("#article_img_size").parent().parent().hide();
			 $('input[name="dj_iconimageurl11"]').parent().parent().hide();
			 $('input[name="native_cta"]').parent().parent().hide();
			$('#icon_sizes11').parent().parent().hide();
			
			$('#vid_type').parent().parent().parent().parent().hide();
			
			$('#dj_data_desc1').parent().parent().parent().parent().hide();
	
			 $("#dj_data_sponsored1").parent().parent().parent().parent().hide();
			$("input[name='upload1']").parent().parent().parent().parent().hide();
			$("input[name='upload2']").parent().parent().parent().parent().hide();
			$("input[name='upload3']").parent().parent().parent().parent().hide();
			$("input[name='upload4']").parent().parent().parent().parent().hide();
			$("input[name='upload5']").parent().parent().parent().parent().hide();
			$("input[name='upload6']").parent().parent().parent().parent().hide();
			$("input[name='upload7']").parent().parent().parent().parent().hide();
			$("input[name='upload8']").parent().parent().parent().parent().hide();
			
		}else if($(this).attr("id")=="in_feed_text"){
						
			 $('input[name="upload"]').parent().parent().hide(); 			 
			 $('#videourl').parent().parent().hide();
			 $("#article_type").parent().parent().hide();
			 $("#article_img_size").parent().parent().hide();
			 $('input[name="dj_iconimageurl11"]').parent().parent().hide();
			 $('input[name="native_cta"]').parent().parent().hide();
			$('#icon_sizes11').parent().parent().hide();
			
			$('#vid_type').parent().parent().parent().parent().hide();
			
			$('#dj_data_desc1').parent().parent().parent().parent().hide();
			 $("#dj_data_sponsored1").parent().parent().parent().parent().hide();
			$("input[name='upload1']").parent().parent().parent().parent().hide();
			$("input[name='upload2']").parent().parent().parent().parent().hide();
			$("input[name='upload3']").parent().parent().parent().parent().hide();
			$("input[name='upload4']").parent().parent().parent().parent().hide();
			$("input[name='upload5']").parent().parent().parent().parent().hide();
			$("input[name='upload6']").parent().parent().parent().parent().hide();
			$("input[name='upload7']").parent().parent().parent().parent().hide();
			$("input[name='upload8']").parent().parent().parent().parent().hide();
			 
		}else if($(this).attr("id")=="in_feed_video"){
			
			 $('#videourl').parent().parent().show();
			 $("#article_type").parent().parent().hide();
			 $("#article_img_size").parent().parent().hide();
			 $('input[name="dj_iconimageurl11"]').parent().parent().hide();
			 $('input[name="native_cta"]').parent().parent().hide();
			$('#icon_sizes11').parent().parent().hide();
			
			$('#vid_type').parent().parent().parent().parent().hide();
			
			$('#dj_data_desc1').parent().parent().parent().parent().hide();
			 $('input[name="upload"]').parent().parent().hide(); 
			 $("#dj_data_sponsored1").parent().parent().parent().parent().hide();
			 $("input[name='upload1']").parent().parent().parent().parent().hide();
			 $("input[name='upload2']").parent().parent().parent().parent().hide();
			 $("input[name='upload3']").parent().parent().parent().parent().hide();
			 $("input[name='upload4']").parent().parent().parent().parent().hide();
			 $("input[name='upload5']").parent().parent().parent().parent().hide();
			$("input[name='upload6']").parent().parent().parent().parent().hide();
			$("input[name='upload7']").parent().parent().parent().parent().hide();
			$("input[name='upload8']").parent().parent().parent().parent().hide();
			 $('#dj_data_desc').attr('required',false); 
			 			
		}else if($(this).attr("id")=="recommend_image"){
			//~ alert('hide');			
			$("#url").parent().parent().parent().parent().show();
			 $('input[name="upload"]').parent().parent().show(); 
			 $("#dj_data_desc").parent().parent().parent().parent().show();
			 $("#article_type").parent().parent().hide();
			 $("#article_img_size").parent().parent().hide();
			 $('input[name="dj_iconimageurl11"]').parent().parent().hide();
			 $('input[name="native_cta"]').parent().parent().hide();
			$('#icon_sizes11').parent().parent().hide();
			
			$('#vid_type').parent().parent().parent().parent().hide();
			
			$('#dj_data_desc1').parent().parent().parent().parent().hide();
			 $('#videourl').parent().parent().hide();
			 $("#dj_data_sponsored1").parent().parent().parent().parent().hide();
			$("input[name='upload1']").parent().parent().parent().parent().hide();
			$("input[name='upload2']").parent().parent().parent().parent().hide();
			$("input[name='upload3']").parent().parent().parent().parent().hide();
			$("input[name='upload4']").parent().parent().parent().parent().hide();
			$("input[name='upload5']").parent().parent().parent().parent().hide();
			$("input[name='upload6']").parent().parent().parent().parent().hide();
			$("input[name='upload7']").parent().parent().parent().parent().hide();
			$("input[name='upload8']").parent().parent().parent().parent().hide();
			
		}else if($(this).attr("id")=="recommend_text"){
			$("#url").parent().parent().parent().parent().show();
			 $('input[name="upload"]').parent().parent().hide(); 
			 $("#dj_data_desc").parent().parent().parent().parent().show();
			 $("#article_type").parent().parent().hide();			 
			 $("#article_img_size").parent().parent().hide();	
			 $('input[name="dj_iconimageurl11"]').parent().parent().hide();
			 $('input[name="native_cta"]').parent().parent().hide();
			$('#icon_sizes11').parent().parent().hide();
			
			$('#vid_type').parent().parent().parent().parent().hide();
			
			$('#dj_data_desc1').parent().parent().parent().parent().hide();		 
			 $('#videourl').parent().parent().hide();
			 $("#dj_data_sponsored1").parent().parent().parent().parent().hide();
			$("input[name='upload1']").parent().parent().parent().parent().hide();
			$("input[name='upload2']").parent().parent().parent().parent().hide();
			$("input[name='upload3']").parent().parent().parent().parent().hide();
			$("input[name='upload4']").parent().parent().parent().parent().hide();
			$("input[name='upload5']").parent().parent().parent().parent().hide();
			$("input[name='upload6']").parent().parent().parent().parent().hide();
			$("input[name='upload7']").parent().parent().parent().parent().hide();
			$("input[name='upload8']").parent().parent().parent().parent().hide();
			 
		}else if($(this).attr("id")=="recommend_article"){
			$("#url").parent().parent().parent().parent().show();
			$('#article_img_size').parent().parent().show();
					//~ $("#dj_data_sponsored").val('1');
					//~ $("#title").val('1');
					//~ $("#dj_data_desc").val('1');
					//~ $("#destination_url").val('1');
			 $("#article_type").parent().parent().show();
			 $("#dj_data_sponsored1").parent().parent().parent().parent().show();
			 $("input[name='upload1']").parent().parent().parent().parent().show();
			 $("input[name='upload2']").parent().parent().parent().parent().show();
			 $("input[name='upload3']").parent().parent().parent().parent().show();
			 $("input[name='upload4']").parent().parent().parent().parent().show();
			 //~ $("input[name='upload5']").parent().parent().parent().parent().show();
			 //~ $("input[name='upload6']").parent().parent().parent().parent().show();
			 //~ $("input[name='upload7']").parent().parent().parent().parent().show();
			 //~ $("input[name='upload8']").parent().parent().parent().parent().show();
			 if($('#article_type').val() == "3"){
				 $("input[name='upload5']").parent().parent().parent().parent().show();
				 $("input[name='upload6']").parent().parent().parent().parent().show();
			 }
			 if($('#article_type').val() == "4"){
				 $("input[name='upload5']").parent().parent().parent().parent().show();
				 $("input[name='upload6']").parent().parent().parent().parent().show();
				 $("input[name='upload7']").parent().parent().parent().parent().show();
				 $("input[name='upload8']").parent().parent().parent().parent().show();
			 }
			 $("#dj_data_desc").parent().parent().parent().parent().hide();
			 //~ $('#videourl').attr('required',true);
			 
		}else if($(this).attr("value")=="native_adformat_content"){
			
			$('input[name="upload"]').parent().parent().show(); 
			$('input[name="infeed_type"]').parent().parent().hide();
			$('input[name="recommend_type"]').parent().parent().hide();
			
			 $('input[name="emb_check"]').parent().parent().parent().parent().show()
          $('input[name="dj_video_width"]').parent().parent().parent().parent().show();
          $('input[name="dj_data_sponsored"]').parent().parent().show();
          $('#dj_data_rating').parent().parent().show();
          $('#dj_data_ctatext').parent().parent().show();
           $('#dj_data_desc').parent().parent().hide();
          // $("#Image").prop("checked", true);
            $('input[name="upload"]').parent().parent().parent().parent().show(); 

			 $("#article_type").parent().parent().hide();
			 $("#article_img_size").parent().parent().hide();
			 $('input[name="dj_iconimageurl11"]').parent().parent().hide();
			 $('input[name="native_cta"]').parent().parent().show();
			$('#icon_sizes11').parent().parent().hide();
			
			$('#vid_type').parent().parent().parent().parent().hide();
			
			$('#dj_data_desc1').parent().parent().parent().parent().hide();
			 $('#videourl').parent().parent().hide();
			 $("#dj_data_sponsored1").parent().parent().parent().parent().hide();
			$("input[name='upload1']").parent().parent().parent().parent().hide();
			$("input[name='upload2']").parent().parent().parent().parent().hide();
			$("input[name='upload3']").parent().parent().parent().parent().hide();
			$("input[name='upload4']").parent().parent().parent().parent().hide();
			$("input[name='upload5']").parent().parent().parent().parent().hide();
			$("input[name='upload6']").parent().parent().parent().parent().hide();
			$("input[name='upload7']").parent().parent().parent().parent().hide();
			$("input[name='upload8']").parent().parent().parent().parent().hide();

        }	
        else{
			
			//~ $('input[name="emb_check"]').parent().parent().parent().parent().hide();
			 //~ $('input[name="dj_video_width').parent().parent().parent().parent().hide();
			 //~ $('input[name="upload"]').parent().parent().parent().parent().hide(); 
			 //~ $('input[name="dj_data_sponsored"]').parent().parent().show();
			  //~ $('#dj_data_desc').parent().parent().show();
			   //~ $('#dj_data_rating').parent().parent().hide();
			  //~ $('#dj_data_ctatext').parent().parent().hide();			  
		
		} 
	});
				
				$("#article_type").change(function(){
					//~ alert($("#article_type").val());
					$('#article_img_size').parent().parent().show();
					//~ $("#dj_data_sponsored").val('1');
					//~ $("#title").val('1');
					//~ $("#dj_data_desc").val('1');
					//~ $("#destination_url").val('1');
					
				if($(this).val() == '1' || $(this).val() == '2')
				{					
				$("input[name='upload1']").parent().parent().parent().parent().show();
				$("input[name='upload2']").parent().parent().parent().parent().show();
				$("input[name='upload3']").parent().parent().parent().parent().show();
				$("input[name='upload4']").parent().parent().parent().parent().show();
				$("input[name='upload5']").parent().parent().parent().parent().hide();
				$("input[name='upload6']").parent().parent().parent().parent().hide();
				$("input[name='upload7']").parent().parent().parent().parent().hide();
				$("input[name='upload8']").parent().parent().parent().parent().hide();
				}
				
				if($(this).val() == '3')
				{					
				$("input[name='upload1']").parent().parent().parent().parent().show();
				$("input[name='upload2']").parent().parent().parent().parent().show();
				$("input[name='upload3']").parent().parent().parent().parent().show();
				$("input[name='upload4']").parent().parent().parent().parent().show();
				$("input[name='upload5']").parent().parent().parent().parent().show();
				$("input[name='upload6']").parent().parent().parent().parent().show();
				$("input[name='upload7']").parent().parent().parent().parent().hide();
				$("input[name='upload8']").parent().parent().parent().parent().hide();
				}
				
				if($(this).val() == '4')
				{					
				$("input[name='upload1']").parent().parent().parent().parent().show();
				$("input[name='upload2']").parent().parent().parent().parent().show();
				$("input[name='upload3']").parent().parent().parent().parent().show();
				$("input[name='upload4']").parent().parent().parent().parent().show();
				$("input[name='upload5']").parent().parent().parent().parent().show();
				$("input[name='upload6']").parent().parent().parent().parent().show();
				$("input[name='upload7']").parent().parent().parent().parent().show();
				$("input[name='upload8']").parent().parent().parent().parent().show();
				}
				
				$('input[name="dj_iconimageurl11"]').parent().parent().hide();
				$('input[name="native_cta"]').parent().parent().hide();
				$('#icon_sizes11').parent().parent().hide();
				
				$('#vid_type').parent().parent().parent().parent().hide();
				
				//~ $('#dj_data_desc1').parent().parent().parent().parent().hide();
				});
				
				$("#native_adformat_content").change(function(){
					//~ $("input[name='upload1']").parent().parent().parent().parent().show();
					$('#destination_url').parent().parent().hide(); 
					$('input[name="dj_iconimageurl11"]').parent().parent().show();
					$('input[name="native_cta"]').parent().parent().show();
					$('#icon_sizes11').parent().parent().show();
					
					$('#vid_type').parent().parent().parent().parent().show();
					
					//~ $('#dj_data_desc1').parent().parent().parent().parent().show();
					//~ $('#dj_data_desc1').parent().parent().hide();
				});
			 			
		

        

    

});

</script>
    
<?php
    /*********************************************************/
    /* HTML framework                                        */
    /*********************************************************/
    phpAds_PageFooter();
}


function buildBannerForm($type, $aBanner, &$oComponent=null, $formDisabled=false)
{
	
	
    //-- Build forms
    $form = new OA_Admin_UI_Component_Form("bannerForm", "POST", $_SERVER['SCRIPT_NAME'], null, array("enctype"=>"multipart/form-data"));
    $form->forceClientValidation(true);
    $form->addElement('hidden', 'clientid', $aBanner['clientid']);
    $form->addElement('hidden', 'campaignid', $aBanner['campaignid']);
    $form->addElement('hidden', 'bannerid', $aBanner['bannerid']);
    $form->addElement('hidden', 'type', $type,array('id'=>'test'));
    $form->addElement('hidden', 'status', $aBanner['status']);

	$form->addElement('hidden', 'articlestatus', $type,array('id'=>'articlestatus'));
	//~ die("asd".$articlestatus);
    if ($type == 'sql' || $type == 'web') {
        $form->addElement('custom', 'banner-iab-note', null, null);
    }
    if ($aBanner['contenttype'] == 'swf' && empty($aBanner['alt_contenttype']) && empty($aBanner['alt_imageurl'])) {
        $form->addElement('custom', 'banner-backup-note', null, null);
    }

    $form->addElement('header', 'header_basic', $GLOBALS['strBasicInformation']);
    if (OA_Permission::isAccount(OA_ACCOUNT_ADMIN) || OA_Permission::isAccount(OA_ACCOUNT_MANAGER) || OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
        $form->addElement('text', 'description', $GLOBALS['strName']);
    }
    else {
        $form->addElement('static', 'description', $GLOBALS['strName'], $aBanner['description']);
    }

    //local banners
    if ($type == 'sql' || $type == 'web') {
        if ($type == 'sql') {
            $header = $form->createElement('header', 'header_sql', $GLOBALS['strMySQLBanner']." -  banner creative");
        }
      
        else {
            $header = $form->createElement('header', 'header_sql', $GLOBALS['strWebBanner']." -  banner creative");
        }
        $header->setAttribute('icon', 'icon-banner-stored.gif');
        $form->addElement($header);

        $imageName = _getContentTypeIconImageName($aBanner['contenttype']);
        $size = _getBannerSizeText($type, $aBanner['filename']);

        addUploadGroup($form, $aBanner,
            array(
                'uploadName' => 'upload',
                'radioName' => 'replaceimage',
                'imageName'  => $imageName,
                'fileName'  => $aBanner['filename'],
                'fileSize'  => $size,
                'newLabel'  => $GLOBALS['strNewBannerFile'],
                'updateLabel'  => $GLOBALS['strUploadOrKeep'],
                'handleSWF' => true
              )
        );

        $altImageName = null;
        $altSize = null;
        if ($aBanner['contenttype'] == 'swf') {
            $altImageName = _getContentTypeIconImageName($aBanner['alt_contenttype']);
            $altSize = _getBannerSizeText($type, $aBanner['alt_filename']);
        }

        $aUploadParams = array(
                'uploadName' => 'uploadalt',
                'radioName' => 'replacealtimage',
                'imageName'  => $altImageName,
                'fileSize'  => $altSize,
                'fileName'  => $aBanner['alt_filename'],
                'newLabel'  => $GLOBALS['strNewBannerFileAlt'],
                'updateLabel'  => $GLOBALS['strUploadOrKeep'],
                'handleSWF' => false
              );

        if ($aBanner['contenttype'] != 'swf') {
            $aUploadParams = array_merge($aUploadParams, array('decorateId' => 'swfAlternative'));
        }
        addUploadGroup($form, $aBanner, $aUploadParams);

        $form->addElement('header', 'header_b_links', "Banner link");
        if (count($aBanner['hardcoded_links']) == 0) {
            $form->addElement('text', 'url', $GLOBALS['strURL']);
            $targetElem = $form->createElement('text', 'target', $GLOBALS['strTarget']);
            $targetElem->setAttribute('maxlength', '16');
            $form->addElement($targetElem);
        }
        else {
            foreach ($aBanner['hardcoded_links'] as $key => $val) {
                $link['text'] = $form->createElement('text', "alink[".$key."]", null);
                $link['text']->setAttribute("style", "width:330px");
                $link['radio'] = $form->createElement('radio', "alink_chosen", null, null, $key);
                $form->addGroup($link, 'url_group', $GLOBALS['strURL'], "", false);

                if (isset($aBanner['hardcoded_targets'][$key])) {
                    $targetElem = $form->createElement('text', "atar[".$key."]", $GLOBALS['strTarget']);
                    $targetElem->setAttribute('maxlength', '16');
                    $form->addElement($targetElem);
                }
                if (count($aBanner['hardcoded_links']) > 1) {
                    $form->addElement('text', "asource[".$key."]", $GLOBALS['strOverwriteSource']);
                }
            }
            $form->addElement('hidden', 'url', $aBanner['url']);
        }
        $form->addElement('header', 'header_b_display', 'Banner display');
        $form->addElement('text', 'alt', $GLOBALS['strAlt']);
        $form->addElement('text', 'statustext', $GLOBALS['strStatusText']);
        $form->addElement('text', 'bannertext', $GLOBALS['strTextBelow']);

        if (!empty($aBanner['bannerid'])) {
            $sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
            $sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
            $sizeG['width']->setSize(5);

            $sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
            $sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
            $sizeG['height']->setSize(5);
            $form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);

            //validation rules
            $translation = new OX_Translation();
            $widthRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWidth'])), 'required');
            $widthPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strWidth'])), 'min', 1);
            $heightRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strHeight'])), 'required');
            $heightPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strHeight'])), 'min', 1);
            $numericRule = array($GLOBALS['strNumericField'] , 'numeric');

            $form->addGroupRule('size', array(
                'width' => array($widthRequiredRule, $numericRule, $widthPositiveRule),
                'height' => array($heightRequiredRule, $numericRule, $heightPositiveRule)));
        }
        if (!isset($aBanner['contenttype']) || $aBanner['contenttype'] == 'swf')
        {
            $form->addElement('checkbox', 'transparent', $GLOBALS['strSwfTransparency'], $GLOBALS['strSwfTransparency']);
        }

        //TODO $form->addRule("size", 'Please enter a number', 'numeric'); //this should make all fields in group size are numeric
    }
    
/*Native Ad Format*/    
    
if($type =='native')
{
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
	
	$header = $form->createElement('header', 'header_txt','Native video Ad format');
	$form->addElement($header);
	
	$native_type [] = $form->createElement ( 'radio', 'native_type', null, "<span class='type-name'>In-Feed</span>",native_in_feed, array ('id' => 'native_in_feed' ) );
	
	$native_type [] = $form->createElement ( 'radio', 'native_type', null, "<span class='type-name'>Recommendation Widgets</span>", native_recommend, array ('id' => 'native_recommend' ) );
	
	$native_type [] = $form->createElement ( 'radio', 'native_type', null, "<span class='type-name'> Content Streaming</span>", native_adformat_content, array ('id' => 'native_adformat_content' ) );

	$form->addGroup ( $native_type, 'g_nattype', 'Native Type', "" );
	
		

	
	/** For In-feed - start**/
	$aBanner['infeed_type'] = (empty($aBanner['infeed_type']) && empty($aBanner['bannerid'])) ? 'in_feed_image' : $aBanner['infeed_type'];
	$infeed_type [] = $form->createElement ( 'radio', 'infeed_type', null, "<span class='type-name'>Image</span>", in_feed_image, array ('id' => 'in_feed_image' ) );
   	$infeed_type [] = $form->createElement ( 'radio', 'infeed_type', null, "<span class='type-name'>Text</span>", in_feed_text, array ('id' => 'in_feed_text' ) );
   	//~ $infeed_type [] = $form->createElement ( 'radio', 'infeed_type', null, "<span class='type-name'>Video</span>", in_feed_video, array ('id' => 'in_feed_video' ) );		
	$form->addGroup ( $infeed_type, 'i_nattype', 'In-Feed Type', "" );	

	/** For In-feed - End**/
//~ print_r($aBanner['dj_data_sponsored']);
	/** For Recommended - start**/
	//~ echo"<pre>";print_r($aBanner);exit;
	$Recommend_type [] = $form->createElement ( 'radio', 'recommend_type', null, "<span class='type-name'>Image Widget</span>", recommend_image, array ('id' => 'recommend_image' ) );
	
   	$Recommend_type [] = $form->createElement ( 'radio', 'recommend_type', null, "<span class='type-name'>Text Widget</span>", recommend_text, array ('id' => 'recommend_text' ) );
   	
   	$Recommend_type [] = $form->createElement ( 'radio', 'recommend_type', null, "<span class='type-name'>Article Widget</span>", recommend_article, array ('id' => 'recommend_article' ) );	
   		
	$form->addGroup ( $Recommend_type, 'r_nattype', 'Recommended Type', "" );
	
	$widgetsize = array(1=>'1x4',2=>'2x2',3=>'2x3',4=>'2x4');
	 $form->addElement('select','article_type','Widget size', $widgetsize);
	
	//size
    global $phpAds_IAB;
    switch ($zone['delivery']) {
        case phpAds_ZoneText:
        case OX_ZoneVideoInstream:
        case OX_ZoneVideoOverlay:
            $sizeDisabled = true;
            $zone['width'] = '*';
            $zone['height'] = '*';
        break;
        default:
            $sizeDisabled = false;
        break;

    }

    foreach (array_keys($phpAds_IAB) as $key)
    {
        $iabSizes[$phpAds_IAB[$key]['width']."x".$phpAds_IAB[$key]['height']] =
            $GLOBALS['strIab'][$key];
    }
    $iabSizes['-'] = $GLOBALS['strCustom'];
    //~ $aDefaultSize['select'] = $form->createElement('select', 'article_img_size', null, $iabSizes,
        //~ array('onchange' => 'phpAds_formSelectSize(this); oa_sizeChangeUpdateMessage("warning_change_zone_size");', 'class' => 'medium', 'id' => 'article_img_size'));
	

    //~ $sizeTypes['default'] = $form->createElement('group', 'defaultSizeG', null, $aDefaultSize, null, false);
//~ $size = $aBanner['width']."x".$aBanner['height'];
//~ //$size = "720"."x"."300";
//~ $sizeType = 'default';
//~ $form->setDefaults(array('article_img_size' => $size, 'sizetype' => $sizeType));
    //~ $form->addGroup($sizeTypes, 'size_types', $GLOBALS['strSize'], "<br/>");
	/** For Recommended - End**/
	
	//~ print_r($aBanner);
	
	$banner_sizes["-1x-1"]="accept all banner size";
	$banner_sizes["468x60"]="IAB Full Banner (468 x 60)";
	$banner_sizes["120x600"]="IAB Skyscraper (120 x 600)";
	$banner_sizes["728x90"]="IAB Leaderboard (728 x 90)";
	$banner_sizes["120x90"]="IAB Button 1 (120 x 90)";
	$banner_sizes["120x60"]="IAB Button 2 (120 x 60)";
	$banner_sizes["234x60"]="IAB Half Banner (234 x 60)";
	$banner_sizes["88x31"]="IAB Micro Bar (88 x 31)";
	$banner_sizes["125x125"]="IAB Square Button (125 x 125)";
	$banner_sizes["120x240"]="IAB Vertical Banner (120 x 240)";
	$banner_sizes["180x150"]="IAB Rectangle (180 x 150)";
	$banner_sizes["300x250"]="IAB Medium Rectangle (300 x 250)";
	$banner_sizes["336x280"]="IAB Large Rectangle (336 x 280)";
	$banner_sizes["240x400"]="IAB Vertical Rectangle (240 x 400)";
	$banner_sizes["250x250"]="IAB Square Pop-up (250 x 250)";
	$banner_sizes["160x600"]="IAB Wide Skyscraper (160 x 600)";
	$banner_sizes["720x300"]="IAB Pop-Under (720 x 300)";
	$banner_sizes["300x100"]="IAB 3:1 Rectangle (300 x 100)";
	
$size = $aBanner['width']."x".$aBanner['height'];
//$size = "720"."x"."300";
$sizeType = 'default';
$form->setDefaults(array('article_img_size' => $size, 'sizetype' => $sizeType));

	$form->addElement('select','article_img_size','Size',$banner_sizes);
			$form->addElement('text', 'native_cta', "Call to Action Text",array("value"=>$aBanner['native_cta']));
			
			$form->addElement('text', 'dj_iconimageurl11', "Icon Imageurl",array("value"=>$aBanner['dj_iconimageurl']));
			$icon_sizes[0]="64 x 64";
			$icon_sizes[1]="75 x 75";
			$icon_sizes[2]="80 x 80";

			$form->addElement('select','icon_sizes11','Select icon size',$icon_sizes);


			/**Native Content Stream video*/
/*
			$header = $form->addElement('header', 'videoobject', "Native Video object specifications");
			$embcheck [] = $form->createElement ( 'radio','emb_check', null, "<span class='type-name'> Inline</span>" ,1,array ('id' => 'inline_id'));
			$embcheck [] = $form->createElement ( 'radio', 'emb_check', null, "<span class='type-name'> Third party </span>",2,array ('id' => 'xml_id' ) );
			$form->addGroup ( $embcheck, 'g_emb_check', 'Video', "" );
			$form->addElement('text', 'xml_url', "ThirdParty Url",array('id' => 'xml_url'));
			$form->addElement('text', 'video_url', "Video Url",array('id' => 'videourl'));

			$arrayvideotype=array('video/mp4'=>'MP4','video/x-flv'=>'FLV');	
			$form->addElement('select', 'dj_videotype','Video Type',$arrayvideotype,array('id' => 'vid_type'));		
*/	
			/**Native Content Stream video*/


			/*** Native Ads Parameters***/
/*
			$header = $form->addElement('header', 'native', "Native Data objects specifications");
			$form->addElement('text', 'dj_data_sponsored11', "Brand Name (Sponsored)");

			$form->addElement('text', 'title', "Title");
			$form->addElement('textarea', 'dj_data_desc1', "Descriptive text");
			$star=$form->addElement('text', 'dj_data_rating', "Rating of Product");


			$cta=$form->addElement('text', 'dj_data_ctatext', "CTA description");
			$cta->setAttribute('maxlength', '10');

*/

//~ //Main Image For Content Streaming Native Ad

	$header = $form->createElement('header', 'header_txt','Banner Details');
	$form->addElement($header);
	
	$imageName = _getContentTypeIconImageName($aBanner['contenttype']);
    $size = _getBannerSizeText($type, $aBanner['filename']);

        addUploadGroup($form, $aBanner,
            array(
                'uploadName' => 'upload',
                'radioName' => 'replaceimage',
                'imageName'  => $imageName,
                'fileName'  => $aBanner['filename'],
                'fileSize'  => $size,
                'newLabel'  => $GLOBALS['strNewBannerFile'],
                'updateLabel'  => $GLOBALS['strUploadOrKeep'],
                'handleSWF' => true
              )
        );

       $form->addElement('text', 'dj_data_sponsored', "Brand Name (Sponsored)");
       $form->addElement('text', 'title', "Title");
       $form->addElement('textarea', 'dj_data_desc', "Descriptive text");
       //~ $form->addElement('text', 'destination_url', "Video Url");
        //~ $form->addElement('header', 'header_b_links', "Banner link");
        //~ if (count($aBanner['hardcoded_links']) == 0) {
            //~ $form->addElement('text', 'url', $GLOBALS['strURL']);
            //~ $targetElem = $form->createElement('text', 'target', $GLOBALS['strTarget']);
            //~ $targetElem->setAttribute('maxlength', '16');
            //~ $form->addElement($targetElem);
        //~ }
    
        /** Recommended article type  1x4 & 2x2 - start**/
		//~ $form->addElement('text', 'dj_data_sponsored', "Brand Name (Sponsored)");
		$articledata=OA_Dal_Delivery_query("SELECT * FROM ".$table_prefix."nativead_article  where banner_id='".$aBanner['bannerid']."'");
		 $aVal = array();
while($articledet=OA_Dal_Delivery_fetchAssoc($articledata))
{
	$artdatatitle[] = $articledet['title'];
	$artdatadata_desc[] = $articledet['description'];
	$artdatadata_url[] = $articledet['url'];
	$artdatavideourl[] = $articledet['videourl'];
	$artdataimagename[] = $articledet['imagename'];
	$artdatawidth[] = $articledet['width'];
	$artdataheight[] = $articledet['height'];
	$artdatacontenttype[] = $articledet['contenttype'];
}
//~ print $artdatatitle[0];


		for($i=1;$i<9;$i++){

		//~ header = $form->createElement('subheader', 'header_txt','Banner Details');
		$header = $form->createElement('header', 'header_txt','Banner'.$i.' Details');
		$form->addElement($header);
			
			$imageName = _getContentTypeIconImageName($aBanner['contenttype']);
			$size = _getBannerSizeText($type, $aBanner['filename']);

				addUploadGroup($form, $aBanner,
					array(
						'uploadName' => 'upload'.$i,
						'radioName' => 'replaceimage',
						'imageName'  => $imageName,
						'fileName'  => $artdataimagename[$i-1],
						'fileSize'  => $size,
						'newLabel'  => $GLOBALS['strNewBannerFile'],
						'updateLabel'  => $GLOBALS['strUploadOrKeep'],
						'handleSWF' => true
					  )
				);

		  print_r($artdatadata_desc[$i-1]); 
		  //~ print_r($i-1); 
			$form->addElement('text', 'title'.$i, "Title", array ('value' => $artdatatitle[$i-1]));
			$textarea =& $form->addElement('textarea', 'sample'.$i, "Descriptive text");
			//$textarea->setValue($artdatadata_desc[$i-1]);
			$textarea->setValue("saasdas");
			
			$url =& $form->addElement('text', 'destination_url'.$i, "Destination url");
			$url->setValue($artdatadata_url[$i-1]);
		   //~ $form->addElement('text', 'destination_url'.$i, "Video Url", array ('value' => $artdatavideourl[$i-1])); $artdatadata_desc[$i-1]
		   //~ $avalobj = "filename".$i;
		   //~ $aVal[$avalobj]=$artdataimagename[$i-1];
		   //~ print_r($artdataimagename[$i-1]);die;
		   $form->addElement('hidden', 'artdataimagename'.$i, $artdataimagename[$i-1],  array ('value' => $artdataimagename[$i-1]));
		   $form->addElement('hidden', 'artdatawidth'.$i, $artdatawidth[$i-1],  array ('value' => $artdatawidth[$i-1]));
		   $form->addElement('hidden', 'artdataheight'.$i, $artdataheight[$i-1],  array ('value' => $artdataheight[$i-1]));
		   $form->addElement('hidden', 'artdatacontenttype'.$i, $artdatacontenttype[$i-1],  array ('value' => $artdatacontenttype[$i-1]));

		   //~ print_r($aVal);
		}	
		//~ die;
	   //~ print_r($aVal);die;

		/** Recommended article type  1x4 & 2x2 - start**/
	
}
/*Native Ad Format*/    

/*Native Ad Format*/ 
    //external banners
    if ($type == "url") {
        $header = $form->createElement('header', 'header_txt', $GLOBALS['strURLBanner']);
        $header->setAttribute('icon', 'icon-banner-url.gif');
        $form->addElement($header);

        $form->addElement('text', 'imageurl', $GLOBALS['strNewBannerURL']);

        if ($aBanner['contenttype'] == 'swf') {
            $altImageName = _getContentTypeIconImageName($aBanner['alt_contenttype']);
            $altSize = _getBannerSizeText($type, $aBanner['alt_filename']);

            $form->addElement('text', 'alt_imageurl', $GLOBALS['strNewBannerFileAlt']);
        }

        $form->addElement('header', 'header_b_links', "Banner link");
        $form->addElement('text', 'url', $GLOBALS['strURL']);
        $targetElem = $form->createElement('text', 'target', $GLOBALS['strTarget']);
        $targetElem->setAttribute('maxlength', '16');
        $form->addElement($targetElem);

        $form->addElement('header', 'header_b_display', 'Banner display');
        $form->addElement('text', 'alt', $GLOBALS['strAlt']);

        $form->addElement('text', 'statustext', $GLOBALS['strStatusText']);
        $form->addElement('text', 'bannertext', $GLOBALS['strTextBelow']);

        $sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
        $sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['width']->setSize(5);

        $sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
        $sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['height']->setSize(5);
        $form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);

        if (!isset($aBanner['contenttype']) || $aBanner['contenttype'] == 'swf')
        {
            $form->addElement('checkbox', 'transparent', $GLOBALS['strSwfTransparency'], $GLOBALS['strSwfTransparency']);
        }

        //validation rules
        $translation = new OX_Translation();
        $widthRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWidth'])), 'required');
        $widthPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strWidth'])), 'min', 1);
        $heightRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strHeight'])), 'required');
        $heightPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strHeight'])), 'min', 1);
        $numericRule = array($GLOBALS['strNumericField'] , 'numeric');

        $form->addGroupRule('size', array(
            'width' => array($widthRequiredRule, $numericRule, $widthPositiveRule),
            'height' => array($heightRequiredRule, $numericRule, $heightPositiveRule)));
    }

    //html & text banners
    if ($oComponent) {
        $oComponent->buildForm($form, $aBanner);
    }

    $translation = new OX_Translation();

       //common for all banners-All permission to advertisers
    if (OA_Permission::isAccount(OA_ACCOUNT_ADMIN) || OA_Permission::isAccount(OA_ACCOUNT_MANAGER) || OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
        $form->addElement('header', 'header_additional', "Additional data");
        $form->addElement('text', 'keyword', $GLOBALS['strKeyword']);
        $weightElem = $form->createElement('text', 'weight', $GLOBALS['strWeight']);
        $weightElem->setSize(6);
        $form->addElement($weightElem);
        $form->addElement('textarea', 'comments', $GLOBALS['strComments']);
        $weightPositiveRule = $translation->translate($GLOBALS['strXPositiveWholeNumberField'], array($GLOBALS['strWeight']));
        $form->addRule('weight', $weightPositiveRule, 'regex', '#^\d+$#');
        $form->addRule('weight', $weightPositiveRule, 'nonzero');
    }


    //we want submit to be the last element in its own separate section
    $form->addElement('controls', 'form-controls');
    $form->addElement('submit', 'submit', 'Save changes');
    $imageurlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "	Icon Imageurl");
    $form->addRule('dj_iconimageurl', $imageurlRequiredMsg, 'required');
	 if($_POST['native_type']=="native_in_feed" ){
	    
         $titleRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Title");
        $form->addRule('title', $titleRequiredMsg, 'required');
        $ratingRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Rating of product");
        $form->addRule('dj_data_rating', $ratingRequiredMsg, 'required');
        $ctaRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "CTA Description");
        $form->addRule('dj_data_ctatext', $ctaRequiredMsg, 'required');
	}
	 else if($_POST['native_type']=="native_recommend" )
	 {
		
      //~ echo "<pre>";
      //~ print_r($_POST);die;
        if($_POST['emb_check']==2){
			
        $xmlurlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "ThirdParty Url");
        $form->addRule('xml_url', $xmlurlRequiredMsg, 'required');
        $brandnameRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Brand Name");
        $form->addRule('dj_data_sponsored', $brandnameRequiredMsg, 'required');
        $titleRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Title");
        $form->addRule('title', $titleRequiredMsg, 'required');
         $ratingRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Rating of product");
        $form->addRule('dj_data_rating', $ratingRequiredMsg, 'required');
        $ctaRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "CTA Description");
        $form->addRule('dj_data_ctatext', $ctaRequiredMsg, 'required');
       }
       else{
	    //~ $videourlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "	Video Url");
        //~ $form->addRule('video_url', $videourlRequiredMsg, 'required');
        //~ $brandnameRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Brand Name");
        //~ $form->addRule('dj_data_sponsored', $brandnameRequiredMsg, 'required');
        //~ $titleRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Title");
        //~ $form->addRule('title', $titleRequiredMsg, 'required');
         //~ $ratingRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Rating of product");
        //~ $form->addRule('dj_data_rating', $ratingRequiredMsg, 'required');
        //~ $ctaRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "CTA Description");
        //~ $form->addRule('dj_data_ctatext', $ctaRequiredMsg, 'required'); 
	    }
	 }
	 else if($_POST['native_type']=="native_adformat_content" )
	 {
		//~ echo "<pre>";
				 //~ print_r($_POST);die;
        //$videourlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "	Video Url");
        //$form->addRule('video_url', $videourlRequiredMsg, 'required');
        if($_POST['emb_check']==2){
			
        $xmlurlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "ThirdParty Url");
        $form->addRule('xml_url', $xmlurlRequiredMsg, 'required');
        //~ $brandnameRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Brand Name");
        //~ $form->addRule('dj_data_sponsored', $brandnameRequiredMsg, 'required');
        //~ $titleRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Title");
        //~ $form->addRule('title', $titleRequiredMsg, 'required');
         //~ $ratingRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Rating of product");
        //~ $form->addRule('dj_data_rating', $ratingRequiredMsg, 'required');
        $ctaRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "CTA Description");
        $form->addRule('dj_data_ctatext', $ctaRequiredMsg, 'required');
       }
       else{
	    //~ $videourlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "	Video Url");
        //~ $form->addRule('video_url', $videourlRequiredMsg, 'required');
        //~ $brandnameRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Brand Name");
        //~ $form->addRule('dj_data_sponsored', $brandnameRequiredMsg, 'required');
        //~ $titleRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Title");
        //~ $form->addRule('title', $titleRequiredMsg, 'required');
         //~ $ratingRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "Rating of product");
        $form->addRule('dj_data_rating', $ratingRequiredMsg, 'required');
        $ctaRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], "CTA Description");
        $form->addRule('dj_data_ctatext', $ctaRequiredMsg, 'required'); 
	    }
	 }
	
		
    //validation rules
    if (OA_Permission::isAccount(OA_ACCOUNT_ADMIN) || OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
        $urlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strName']));
        $form->addRule('description', $urlRequiredMsg, 'required');
    }

    //set banner values
    $form->setDefaults($aBanner);
    $form->setDefaults(array("icon_sizes11" => $aBanner['icon_sizes']));
    $form->setDefaults(array("emb_check" => $aBanner['dj_emb_check']));
    $form->setDefaults(array("xml_url" => $aBanner['dj_xml_url']));
    
    foreach ($aBanner['hardcoded_links'] as $key => $val) {
        $swfLinks["alink[".$key."]"] = phpAds_htmlQuotes($val);

        if ($val == $aBanner['url']) {
            $swfLinks['alink_chosen'] = $key;
        }
        if (isset($aBanner['hardcoded_targets'][$key])) {
            $swfLinks["atar[".$key."]"] = phpAds_htmlQuotes($aBanner['hardcoded_targets'][$key]);
        }
        if (count($aBanner['hardcoded_links']) > 1) {
            $swfLinks["asource[".$key."]"] = phpAds_htmlQuotes($aBanner['hardcoded_sources'][$key]);
        }
    }
    $form->setDefaults($swfLinks);
    if ($formDisabled)
    {
        $form->freeze();
    }

    return $form;
}


function addUploadGroup($form, $aBanner, $vars)
{
        $uploadG = array();
        if (isset($vars['fileName']) && $vars['fileName'] != '') {
            $uploadG['radio1'] = $form->createElement('radio', $vars['radioName'], null, (empty($vars['imageName']) ? '' : "<img src='".OX::assetPath()."/images/".$vars['imageName']."' align='absmiddle'> ").$vars['fileName']." <i dir=".$GLOBALS['phpAds_TextDirection'].">(".$vars['fileSize'].")</i>", 'f');
            $uploadG['radio2'] = $form->createElement('radio', $vars['radioName'], null, null, 't');
            $uploadG['upload'] = $form->createElement('file', $vars['uploadName'], null, array("onchange" => "selectFile(this, ".($vars['handleSWF'] ? 'true' : 'false').")", "style" => "width: 250px;","id" => $vars['uploadName']));
            if ($vars['handleSWF']) {
                $uploadG['checkSWF'] = $form->createElement("checkbox", "checkswf", null, $GLOBALS['strCheckSWF']);
                $form->addDecorator('checkswf', 'tag',
                    array('attributes' =>
                        array('id' => 'swflayer', 'style' => 'display:none')));
            }

            $form->addGroup($uploadG, $vars['uploadName'].'_group', $vars['updateLabel'], array("<br>", "", "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"), false);
        }
 else { //add new creative
            $uploadG['hidden'] = $form->createElement("hidden", $vars['radioName'], "t");
            $uploadG['upload'] = $form->createElement('file', $vars['uploadName'], null, array("onchange" => "selectFile(this, ".($vars['handleSWF'] ? 'true' : 'false').")", "size" => 26, "style" => "width: 250px","id" => $vars['uploadName']));
            if ($vars['handleSWF']) {
                $uploadG['checkSWF'] = $form->createElement("checkbox", "checkswf", null, $GLOBALS['strCheckSWF']);
                $form->addDecorator('checkswf', 'tag',
                    array('attributes' =>
                        array('id' => 'swflayer', 'style' => 'display:none')));
            }

            $form->addGroup($uploadG, $vars['uploadName'].'_group', $vars['newLabel'], "<br>", false);

            if (!empty($vars['decorateId'])) {
                $form->addDecorator($vars['uploadName'].'_group', 'process', array('tag' => 'tr',
                    'addAttributes' => array('id' => $vars['decorateId'].'{numCall}',
                    'style' => 'display:none')));
            }

        }
        $form->setDefaults(array(
            $vars['radioName'] => $update ? 'f' : 't',
            'checkswf' => 't'
        ));
}


function processForm($bannerid, $form, &$oComponent, $formDisabled=false)
{
		
    $aFields = $form->exportValues();

//~ echo"<pre>";print_r($aFields);exit;
//~ echo"<pre>";print_r($_FILES);exit;

    $doBanners = OA_Dal::factoryDO('banners');
    
    // Get the existing banner details (if it is not a new banner)
    if (!empty($bannerid)) {
        if ($doBanners->get($bannerid)) {
            $aBanner = $doBanners->toArray();
        }
    }

if (!empty($bannerid)) {
	//~ die("select width, height rv_banners where bannerid='".$bannerid."'");
	$widhei = OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select width, height from rv_banners where bannerid='".$bannerid."'"));
	
	$aFields['height'] = $widhei['height'];
	$aFields['width'] = $widhei['width'];


}
//~ print_r("select width, height ".$table_prefix."banners where bannerid='".$bannerid."'");exit;
    $aVariables = array();
    $aVariables['campaignid']      = $aFields['campaignid'];
    $aVariables['target']          = isset($aFields['target']) ? $aFields['target'] : '';
    $aVariables['height']          = isset($aFields['height']) ? $aFields['height'] : 0;
    $aVariables['width']           = isset($aFields['width'])  ? $aFields['width'] : 0;
    $aVariables['weight']          = !empty($aFields['weight']) ? $aFields['weight'] : 0;
    $aVariables['adserver']        = !empty($aFields['adserver']) ? $aFields['adserver'] : '';
    $aVariables['alt']             = !empty($aFields['alt']) ? $aFields['alt'] : '';
    $aVariables['bannertext']      = !empty($aFields['bannertext']) ? $aFields['bannertext'] : '';
    $aVariables['htmltemplate']    = !empty($aFields['htmltemplate']) ? $aFields['htmltemplate'] : '';
    $aVariables['description']     = !empty($aFields['description']) ? $aFields['description'] : '';
    $aVariables['imageurl']        = (!empty($aFields['imageurl']) && $aFields['imageurl'] != 'http://') ? $aFields['imageurl'] : '';
    $aVariables['url']             = (!empty($aFields['url']) && $aFields['url'] != 'http://') ? $aFields['url'] : '';
    $aVariables['status']          = ($aFields['status'] != '') ? $aFields['status'] : '';
    $aVariables['statustext']      = !empty($aFields['statustext']) ? $aFields['statustext'] : '';
    $aVariables['storagetype']     = $aFields['type'];
    $aVariables['ext_bannertype']  = $aFields['ext_bannertype'];
    $aVariables['comments']        = $aFields['comments'];
    $aVariables['iframe_friendly'] = $aFields['iframe_friendly'] ? 1 : 0;

    $aVariables['filename']        = !empty($aBanner['filename']) ? $aBanner['filename'] : '';
    $aVariables['contenttype']     = !empty($aBanner['contenttype']) ? $aBanner['contenttype'] : '';

    if ($aFields['type'] == 'url') {
        $aVariables['contenttype'] = OA_Creative_File::staticGetContentTypeByExtension($aVariables['imageurl']);
        if (empty($aVariables['contenttype'])) {
            // Assume dynamic urls (i.e. http://www.example.com/foo?bar) are "gif"
            $aVariables['contenttype'] = 'gif';
        }
    } elseif ($aFields['type'] == 'txt') {
        // Text banners should always have a "txt" content type
        $aVariables['contenttype'] = 'txt';
    }

    $aVariables['alt_filename']    = !empty($aBanner['alt_filename']) ? $aBanner['alt_filename'] : '';
    $aVariables['alt_contenttype'] = !empty($aBanner['alt_contenttype']) ? $aBanner['alt_contenttype'] : '';
    $aVariables['alt_imageurl']    = !empty($aFields['alt_imageurl']) ? $aFields['alt_imageurl'] : '';

    if (isset($aFields['keyword']) && $aFields['keyword'] != '') {
        $keywordArray = preg_split('/[ ,]+/D', $aFields['keyword']);
        $aVariables['keyword'] = implode(' ', $keywordArray);
    } else {
        $aVariables['keyword'] = '';
    }

    $editSwf = false;

    // Deal with any files that are uploaded.
    if (!empty($_FILES['upload']["name"]) && $aFields['replaceimage'] == 't' && ($aFields['type'] != 'native' || ($aFields['type'] == 'native' && ($aFields['native_type'] == 'infeed_type' || $aFields['native_type'] ==  'native_in_feed') && $aFields['infeed_type'] == 'in_feed_image')||($aFields['type'] == 'native' && ($aFields['native_type'] == 'native_recommend') && $aFields['recommend_type'] != 'recommend_text') )) { //TODO refactor upload to be a valid quickform elem

        $oFile = OA_Creative_File::factoryUploadedFile('upload');
        checkForErrorFileUploaded($oFile);
        $oFile->store($aFields['type']);
        $aFile = $oFile->getFileDetails();

        if (!empty($aFile)) {
            $aVariables['filename']      = $aFile['filename'];
            $aVariables['contenttype']   = $aFile['contenttype'];
            $aVariables['width']         = $aFile['width'];
            $aVariables['height']        = $aFile['height'];
            $aVariables['pluginversion'] = $aFile['pluginversion'];
            $editSwf                     = $aFile['editswf'];
        }
//~ echo "<pre>";print_r($aVariables);exit;
        // Delete the old file for this banner
        if (!empty($aBanner['filename']) && ($aBanner['filename'] != $aFile['filename']) && ($aBanner['storagetype'] == 'web' || $aBanner['storagetype'] == 'sql')) {
            /*
             * Actually, don't delete it. It might be still being used until the
             * cache expires. See:
             *  - https://github.com/revive-adserver/revive-adserver/issues/341
             *  - https://github.com/revive-adserver/revive-adserver/issues/421
             *
             * DataObjects_Banners::deleteBannerFile($aBanner['storagetype'], $aBanner['filename']);
             *
             */
        }
    }
    if (!empty($_FILES['uploadalt']) && $_FILES['uploadalt']['size'] > 0
        &&  $aFields['replacealtimage'] == 't') {

        //TODO: Check image only? - Wasn't enforced before
        $oFile = OA_Creative_File::factoryUploadedFile('uploadalt');
        checkForErrorFileUploaded($oFile);
        $oFile->store($aFields['type']);
        $aFile = $oFile->getFileDetails();

        if (!empty($aFile)) {
            $aVariables['alt_filename']    = $aFile['filename'];
            $aVariables['alt_contenttype'] = $aFile['contenttype'];
        }
    }

    // Handle SWF transparency
    if ($aVariables['contenttype'] == 'swf') {
        $aVariables['transparent'] = isset($aFields['transparent']) && $aFields['transparent'] ? 1 : 0;
    }

    // Update existing hard-coded links if new file has not been uploaded
    if ($aVariables['contenttype'] == 'swf' && empty($_FILES['upload']['tmp_name'])
        && isset($aFields['alink']) && is_array($aFields['alink']) && count($aFields['alink'])) {
        // Prepare the parameters
        $parameters_complete = array();

        // Prepare targets
        if (!isset($aFields['atar']) || !is_array($aFields['atar'])) {
            $aFields['atar'] = array();
        }

        foreach ($aFields['alink'] as $key => $val) {
            if (substr($val, 0, 7) == 'http://' && strlen($val) > 7) {
                if (!isset($aFields['atar'][$key])) {
                    $aFields['atar'][$key] = '';
                }

                if (isset($aFields['alink_chosen']) && $aFields['alink_chosen'] == $key) {
                    $aVariables['url'] = $val;
                    $aVariables['target'] = $aFields['atar'][$key];
                }

/*
                if (isset($aFields['asource'][$key]) && $aFields['asource'][$key] != '') {
                    $val .= '|source:'.$aFields['asource'][$key];
                }
*/
                $parameters_complete[$key] = array(
                    'link' => $val,
                    'tar'  => $aFields['atar'][$key]
                );
            }
        }

        $parameters = array('swf' => $parameters_complete);
    } else {
        $parameters = null;
    }

    $aVariables['parameters'] = serialize($parameters);

    //TODO: deleting images is not viable because they could still be in use in the delivery cache
    //    // Delete any old banners...
    //    if (!empty($aBanner['filename']) && $aBanner['filename'] != $aVariables['filename']) {
    //        phpAds_ImageDelete($aBanner['storagetype'], $aBanner['filename']);
    //    }
    //    if (!empty($aBanner['alt_filename']) && $aBanner['alt_filename'] != $aVariables['alt_filename']) {
    //        phpAds_ImageDelete($aBanner['storagetype'], $aBanner['alt_filename']);
    //    }

    // Clients are only allowed to modify certain fields, ensure that other fields are unchanged
    /*if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
        $aVariables['weight']       = $aBanner['weight'];
        $aVariables['description']  = $aBanner['name'];
        $aVariables['comments']     = $aBanner['comments'];
    } */

    $insert = (empty($bannerid)) ? true : false;

    if ($oComponent)
    {
        $result = $oComponent->preprocessForm($insert, $bannerid, $aFields, $aVariables);
        if ($result === false)
        {
            // handle error
            return false;
        }
    }
					if (!empty($_FILES['upload1']["name"])) { 
						$oFile = OA_Creative_File::factoryUploadedFile('upload1');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename1']      = $aFile['filename'];
							$aVariables['contenttype1']   = $aFile['contenttype'];
							$aVariables['width1']         = $aFile['width'];
							$aVariables['height1']        = $aFile['height'];
						}
					}
					
				    if (!empty($_FILES['upload2']["name"])) { 
						$oFile = OA_Creative_File::factoryUploadedFile('upload2');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename2']      = $aFile['filename'];
							$aVariables['contenttype2']   = $aFile['contenttype'];
							$aVariables['width2']         = $aFile['width'];
							$aVariables['height2']        = $aFile['height'];
						}
					}
					
				    if (!empty($_FILES['upload3']["name"])) { 
						$oFile = OA_Creative_File::factoryUploadedFile('upload3');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename3']      = $aFile['filename'];
							$aVariables['contenttype3']   = $aFile['contenttype'];
							$aVariables['width3']         = $aFile['width'];
							$aVariables['height3']        = $aFile['height'];
						}
					}
					if (!empty($_FILES['upload4']["name"])) { 
						$oFile = OA_Creative_File::factoryUploadedFile('upload4');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename4']      = $aFile['filename'];
							$aVariables['contenttype4']   = $aFile['contenttype'];
							$aVariables['width4']         = $aFile['width'];
							$aVariables['height4']        = $aFile['height'];
						}
					}
					if (!empty($_FILES['upload5']["name"])) { 
						$oFile = OA_Creative_File::factoryUploadedFile('upload5');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename5']      = $aFile['filename'];
							$aVariables['contenttype5']   = $aFile['contenttype'];
							$aVariables['width5']         = $aFile['width'];
							$aVariables['height5']        = $aFile['height'];
						}
					}
					if (!empty($_FILES['upload6']["name"])) { 
						$oFile = OA_Creative_File::factoryUploadedFile('upload6');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename6']      = $aFile['filename'];
							$aVariables['contenttype6']   = $aFile['contenttype'];
							$aVariables['width6']         = $aFile['width'];
							$aVariables['height6']        = $aFile['height'];
						}
					}
					if (!empty($_FILES['upload7']["name"])) { 
						$oFile = OA_Creative_File::factoryUploadedFile('upload7');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename7']      = $aFile['filename'];
							$aVariables['contenttype7']   = $aFile['contenttype'];
							$aVariables['width7']         = $aFile['width'];
							$aVariables['height7']        = $aFile['height'];
						}
					}
					if (!empty($_FILES['upload8']["name"])) { 
						$oFile = OA_Creative_File::factoryUploadedFile('upload8');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename8']      = $aFile['filename'];
							$aVariables['contenttype8']   = $aFile['contenttype'];
							$aVariables['width8']         = $aFile['width'];
							$aVariables['height8']        = $aFile['height'];
						}
					}
					if (!empty($_FILES['upload']["name"])) {
						$oFile = OA_Creative_File::factoryUploadedFile('upload');
						checkForErrorFileUploaded($oFile);
						$oFile->store($aFields['type']);
						$aFile = $oFile->getFileDetails();

						if (!empty($aFile)) {
							$aVariables['filename']      = $aFile['filename'];
							$aVariables['contenttype']   = $aFile['contenttype'];
							$aVariables['width']         = $aFile['width'];
							$aVariables['height']        = $aFile['height'];
						}
					}
//~ echo"<pre>";print_r($aFields);
//~ echo"<pre>";print_r($aVariables);
//~ 
//~ exit;
    // File the data
    $doBanners->setFrom($aVariables);
    if ($insert) {
        $bannerid = $doBanners->insert();

         $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        
         if($aFields['type']=='native')
         {
			 $dj_data_sponsored=addslashes($_POST['dj_data_sponsored']);
			 $title=addslashes($_POST['title']);
			 $dj_data_desc=addslashes($_POST['dj_data_desc']);
			 $dj_data_rating=addslashes($_POST['dj_data_rating']);
			 $dj_data_ctatext=addslashes($_POST['dj_data_ctatext']);
			 
			 if($_POST['native_type']=="native_in_feed")
			 {

				 $Infeedtype = $_POST['infeed_type'];
			
				 switch($Infeedtype){
					 case 'in_feed_image':
					 
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',filename='".$aVariables['filename']."',width='".$aVariables['width']."',height='".$aVariables['height']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',infeed_type='".$_POST['infeed_type']."',recommend_type='' where bannerid='".$bannerid."'");
						break;
						
					case 'in_feed_video':
					
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',infeed_type='".$_POST['infeed_type']."',video_url='".$_POST['video_url']."',width=-10,height=-10,recommend_type='' where bannerid='".$bannerid."'");						
						break;
					
					case 'in_feed_text':
						
						 OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',bannertext='".$dj_data_desc."',dj_data_desc='".$dj_data_desc."',infeed_type='".$_POST['infeed_type']."',recommend_type='',width=-9,height=-9 where bannerid='".$bannerid."'");
						 break;
				 }
					
				 
			 }elseif($_POST['native_type']== 'native_recommend'){
				  $recommendtype = $aFields['recommend_type'];
				  switch($recommendtype){
					 case 'recommend_image':
					 
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$aFields['native_type']."',filename='".$aVariables['filename']."',width='".$aVariables['width']."',height='".$aVariables['height']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',recommend_type='".$_POST['recommend_type']."',infeed_type='' where bannerid='".$bannerid."'");
						break;
						
					case 'recommend_article':
					/*
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$aFields['native_type']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',recommend_type='".$_POST['recommend_type']."',video_url='".$_POST['video_url']."',width=-10,height=-10 where bannerid='".$bannerid."'");		*/
						//~ print_r($_POST);exit;
						$imgsize = explode("x",$_POST['article_img_size']);
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$aFields['native_type']."',title='".$title."',dj_data_desc='".$dj_data_desc."',recommend_type='".$aFields['recommend_type']."',video_url='".$aFields['video_url']."',article_type='".$_POST['article_type']."',width='".$imgsize[0]."',height='".$imgsize[1]."' where bannerid='".$bannerid."'");
						
						OA_Dal_Delivery_query("DELETE FROM ".$table_prefix."nativead_article WHERE banner_id='".$bannerid."'");
							for($i=1;$i<9;$i++){	
								 if($aVariables["filename".$i]!='')
								{
									$art_imgname=$aVariables["filename".$i];
									$art_width= $aVariables["width".$i];	
									$art_height= $aVariables["height".$i];	
									$art_contenttype= $aVariables["contenttype".$i];
									$art_url= $aVariables["contenttype".$i];
									
								}
								else{
									$art_imgname=$_POST["artdataimagename".$i];
									$art_width= $_POST["artdatawidth".$i];
									$art_height= $_POST["artdataheight".$i];
									$art_contenttype= $_POST["artdatacontenttype".$i];
									$art_url= $_POST["artdatacontenttype".$i];
								}
									
								$art_dj_data_desc= addslashes($_POST["dj_data_desc".$i]);
								$art_title= addslashes($_POST["title".$i]);	
								$art_destinationurl= $_POST["destination_url".$i];		

								OA_Dal_Delivery_query("INSERT into ".$table_prefix."nativead_article (banner_id,imagename,width,height,contenttype,title,description,url) values ('".$bannerid."','".$art_imgname."','".$art_width."','".$art_height."','".$art_contenttype."','".$art_title."','".$art_dj_data_desc."','".$art_destinationurl."')");
								if(($_POST['article_type']=="1" || $_POST['article_type'] == "2") && $i=="4")
								{
									$i=9;
								}
								if($_POST['article_type']=='3' && $i==6)
								{
									$i=9;
								}
							}				
						break;
					
					case 'recommend_text':
						
						 OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$aFields['native_type']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',bannertext='".$dj_data_desc."',dj_data_desc='".$dj_data_desc."',recommend_type='".$_POST['recommend_type']."',width=-11,height=-11 where bannerid='".$bannerid."'");
						 break;
				 }
			 }
			 
			 else if($_POST['native_type']=="native_adformat_content" )
			 {
				 //~ echo "<pre>";
				 //~ print_r($_POST);die;
				 $dj_iconimageurl=$_POST['dj_iconimageurl11'];
				 $icon_sizes=$_POST['icon_sizes11'];
				 if($icon_sizes==0)
				 {
					 $icon_width=64;
					 $icon_height=64;
				 }
				 else if($icon_sizes==1)
				 {
					  $icon_width=75;
					 $icon_height=75;
				 }
				 else if($icon_sizes==2)
				 {
					  $icon_width=80;
					 $icon_height=80;
				 }
				 
				 /*$oFile = OA_Creative_File::factoryUploadedFile('upload');
				checkForErrorFileUploaded($oFile);
				$oFile->store($aFields['type']);
				$aFile = $oFile->getFileDetails();

				if (!empty($aFile)) {
					$aVariables['filename']      = $aFile['filename'];
					$aVariables['contenttype']   = $aFile['contenttype'];
					$aVariables['width']         = $aFile['width'];
					$aVariables['height']        = $aFile['height'];
				}*/
				 $dj_data_sponsored=addslashes($_POST['dj_data_sponsored']);
				 $title=addslashes($_POST['title']);
				 $dj_data_desc=addslashes($_POST['dj_data_desc1']);
				 $dj_data_rating=addslashes($_POST['dj_data_rating']);
				 $dj_data_ctatext=addslashes($_POST['dj_data_ctatext']);
				
					OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',dj_iconimageurl='".$dj_iconimageurl."',dj_width='".$icon_width."',dj_height='".$icon_height."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',dj_data_rating='".$dj_data_rating."',dj_data_ctatext='".$dj_data_ctatext."',video_url='".$_POST['video_url']."', dj_video_width ='".$_POST['dj_video_width']."',dj_video_height='".$_POST['dj_video_height']."',dj_video_skipoffset='".$_POST['dj_video_skipoffset']."',dj_adduration='".$_POST['dj_adduration']."',icon_sizes='".$icon_sizes."',width=-5,height=-5,dj_emb_check='".$_POST['emb_check']."',dj_xml_url='".$_POST['xml_url']."',filename='".$aVariables['filename']."',width='".$aVariables['width']."',height='".$aVariables['height']."',native_cta='".$_POST['native_cta']."' where bannerid='".$bannerid."'");	
				
				 
			 }
         
			//OA_Dal_Delivery_query("update ".$table_prefix."banners set storagetype='".$_POST['type']."',native_type='".$_POST['native_type']."',dj_iconimageurl='".$_POST['dj_iconimageurl']."',dj_width='".$_POST['dj_width']."',dj_height='".$_POST['dj_height']."',video_url='".$_POST['video_url']."', dj_video_width ='".$_POST['dj_video_width']."',dj_video_height='".$_POST['dj_video_height']."',dj_video_skipoffset='".$_POST['dj_video_skipoffset']."',dj_adduration='".$_POST['dj_adduration']."',dj_data_sponsored='".$_POST['dj_data_sponsored']."',title='".$_POST['title']."',dj_data_desc='".$_POST['dj_data_desc']."',dj_data_rating='".$_POST['dj_data_rating']."',dj_data_ctatext='".$_POST['dj_data_ctatext']."' where bannerid='".$bannerid."'"));
         
		 }
        
        // Run the Maintenance Priority Engine process
        OA_Maintenance_Priority::scheduleRun();
    } else {
		//~ echo "<pre>";print_r($doBanners);exit;
        $doBanners->update();
          //print_r($_POST); die("jjjjj");
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
		if($aFields['type']=='native')
         {
			 $dj_data_sponsored=addslashes($_POST['dj_data_sponsored']);
			 $title=addslashes($_POST['title']);
			 $dj_data_desc=addslashes($_POST['dj_data_desc']);
			 $destinationurl=addslashes($_POST['destination_url']);
			 $dj_data_rating=addslashes($_POST['dj_data_rating']);
			 $dj_data_ctatext=addslashes($_POST['dj_data_ctatext']);
			 $article_type=addslashes($_POST['article_type']);
			 
          if($_POST['native_type']=="native_in_feed" )
			 {
				
				 OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type=null,infeed_type=null,recommend_type=null,dj_data_sponsored=null,title=null,filename=null,dj_data_desc=null,video_url=null,width=0,height=0 where bannerid='".$bannerid."'");	
				
				 $Infeedtype = $_POST['infeed_type'];
				 //~ echo "<pre>";print_r($aVariables);exit;
				 switch($Infeedtype){
					 case 'in_feed_image':
					 
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',filename='".$aVariables['filename']."',width='".$aVariables['width']."',height='".$aVariables['height']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',infeed_type='".$_POST['infeed_type']."' where bannerid='".$bannerid."'");
						break;
						
					case 'in_feed_video':
					
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',infeed_type='".$_POST['infeed_type']."',video_url='".$_POST['video_url']."',width=-10,height=-10 where bannerid='".$bannerid."'");						
						break;
					
					case 'in_feed_text':
						
						 OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',bannertext='".$dj_data_desc."',dj_data_desc='".$dj_data_desc."',infeed_type='".$_POST['infeed_type']."',width=-9,height=-9 where bannerid='".$bannerid."'");
						 break;
				 }
		
				 
			 }elseif($_POST['native_type']== 'native_recommend'){
				 
				 		
				   
    
				  OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type=null,infeed_type=null,recommend_type=null,dj_data_sponsored=null,title=null,filename=null,dj_data_desc=null,video_url=null,width=0,height=0 where bannerid='".$bannerid."'");
				  
				  $recommendtype = $aFields['recommend_type'];
				  
				  switch($recommendtype){
					 case 'recommend_image':
					 
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$aFields['native_type']."',filename='".$aVariables['filename']."',width='".$aVariables['width']."',height='".$aVariables['height']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',recommend_type='".$_POST['recommend_type']."' where bannerid='".$bannerid."'");
						break;
						
					case 'recommend_article':
					$imgsize = explode("x",$_POST['article_img_size']);
						OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$aFields['native_type']."',title='".$title."',dj_data_desc='".$dj_data_desc."',recommend_type='".$aFields['recommend_type']."',video_url='".$aFields['video_url']."',article_type='".$_POST['article_type']."',width='".$imgsize[0]."',height='".$imgsize[1]."' where bannerid='".$bannerid."'");
						//~ $i='dj_data_desc1';
						//~ echo "<pre>";
						//~ print_r($_POST[$i]);die("TEST");
						//~ print_r($_POST);die("TEST");
						OA_Dal_Delivery_query("DELETE FROM ".$table_prefix."nativead_article WHERE banner_id='".$bannerid."'");
							for($i=1;$i<9;$i++){	
								//~ 
//~ echo $_POST["artdataimagename".$i];
								//~ die("asd");
								//~ print_r($aVariables["filename".$i]);
								//~ print_r($a["filename".$i]);
 if($aVariables["filename".$i]!='')
{
	$art_imgname=$aVariables["filename".$i];
	$art_width= $aVariables["width".$i];	
	$art_height= $aVariables["height".$i];	
	$art_contenttype= $aVariables["contenttype".$i];
}
else{
	$art_imgname=$_POST["artdataimagename".$i];
	$art_width= $_POST["artdatawidth".$i];
	$art_height= $_POST["artdataheight".$i];
	$art_contenttype= $_POST["artdatacontenttype".$i];
}
	
$art_dj_data_desc= $_POST["dj_data_desc".$i];
$art_title= $_POST["title".$i];	
$art_destinationurl= $_POST["destination_url".$i];	
										
	//~ print("INSERT into ".$table_prefix."nativead_article (banner_id,imagename,width,height,contenttype,title,description,url) values ('".$bannerid."','".$art_imgname."','".$art_width."','".$art_height."','".$art_contenttype."','".$art_title."','".$art_dj_data_desc."','".$art_destinationurl."')");
				
		OA_Dal_Delivery_query("INSERT into ".$table_prefix."nativead_article (banner_id,imagename,width,height,contenttype,title,description,url) values ('".$bannerid."','".$art_imgname."','".$art_width."','".$art_height."','".$art_contenttype."','".$art_title."','".$art_dj_data_desc."','".$art_destinationurl."')");
	
		if(($_POST['article_type']=="1" || $_POST['article_type'] == "2") && $i=="4")
		{
			$i=9;
		}
		if($_POST['article_type']=='3' && $i==6)
		{
			$i=9;
		}
	}	
			//~ exit;		
break;
	
					case 'recommend_text':
						
						 OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$aFields['native_type']."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',recommend_type='".$aFields['recommend_type']."',width=-11,height=-11 where bannerid='".$bannerid."'");
						 break;
				 }
			}
			else if($_POST['native_type']=="native_adformat_content" )
			 {
				 
				 OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type=null,dj_iconimageurl=null,dj_width=null,dj_height=null,dj_data_sponsored=null,title=null,dj_data_desc=null,dj_data_rating=null,dj_data_ctatext=null,video_url=null, dj_video_width =null,dj_video_height=null,dj_video_skipoffset=null,dj_adduration=null,icon_sizes=null,dj_emb_check=null,dj_xml_url=null where bannerid='".$bannerid."'");	
				 $dj_iconimageurl=$_POST['dj_iconimageurl11'];
				 $icon_sizes=$_POST['icon_sizes11'];
				 if($icon_sizes==0)
				 {
					 $icon_width=64;
					 $icon_height=64;
				 }
				 else if($icon_sizes==1)
				 {
					  $icon_width=75;
					 $icon_height=75;
				 }
				 else if($icon_sizes==2)
				 {
					  $icon_width=80;
					 $icon_height=80;
				 }
				 /*$oFile = OA_Creative_File::factoryUploadedFile('upload');
				checkForErrorFileUploaded($oFile);
				$oFile->store($aFields['type']);
				$aFile = $oFile->getFileDetails();

				if (!empty($aFile)) {
					$aVariables['filename']      = $aFile['filename'];
					$aVariables['contenttype']   = $aFile['contenttype'];
					$aVariables['width']         = $aFile['width'];
					$aVariables['height']        = $aFile['height'];
				}*/
				 $dj_data_sponsored=$_POST['dj_data_sponsored'];
				 $title=$_POST['title'];
				 $dj_data_desc=$_POST['dj_data_desc'];
				 $dj_data_rating=$_POST['dj_data_rating'];
				 $dj_data_ctatext=$_POST['dj_data_ctatext'];
				 $emb=$_POST['emb_check'];
				 
				 if($emb==1)
				 {
					OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',dj_iconimageurl='".$dj_iconimageurl."',dj_width='".$icon_width."',dj_height='".$icon_height."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',dj_data_rating='".$dj_data_rating."',dj_data_ctatext='".$dj_data_ctatext."',video_url='".$_POST['video_url']."', dj_video_width ='".$_POST['dj_video_width']."',dj_video_height='".$_POST['dj_video_height']."',dj_video_skipoffset='".$_POST['dj_video_skipoffset']."',dj_adduration='".$_POST['dj_adduration']."',icon_sizes='".$icon_sizes."',width=-5,height=-5,dj_emb_check='".$_POST['emb_check']."',dj_xml_url=null,native_cta='".$_POST['native_cta']."' where bannerid='".$bannerid."'");	
				}
				else{
					OA_Dal_Delivery_query("update ".$table_prefix."banners set native_type='".$_POST['native_type']."',dj_iconimageurl='".$dj_iconimageurl."',dj_width='".$icon_width."',dj_height='".$icon_height."',dj_data_sponsored='".$dj_data_sponsored."',title='".$title."',dj_data_desc='".$dj_data_desc."',dj_data_rating='".$dj_data_rating."',dj_data_ctatext='".$dj_data_ctatext."',video_url=null, dj_video_width ='".$_POST['dj_video_width']."',dj_video_height='".$_POST['dj_video_height']."',dj_video_skipoffset='".$_POST['dj_video_skipoffset']."',dj_adduration='".$_POST['dj_adduration']."',icon_sizes='".$icon_sizes."',width=-5,height=-5,dj_emb_check='".$_POST['emb_check']."',dj_xml_url='".$_POST['xml_url']."',filename='".$aVariables['filename']."',width='".$aVariables['width']."',height='".$aVariables['height']."',native_cta='".$_POST['native_cta']."' where bannerid='".$bannerid."'");
					
				}
				 
			 }
         
         
			//OA_Dal_Delivery_query("update ".$table_prefix."banners set storagetype='".$_POST['type']."',native_type='".$_POST['native_type']."',dj_iconimageurl='".$_POST['dj_iconimageurl']."',dj_width='".$_POST['dj_width']."',dj_height='".$_POST['dj_height']."',video_url='".$_POST['video_url']."', dj_video_width ='".$_POST['dj_video_width']."',dj_video_height='".$_POST['dj_video_height']."',dj_video_skipoffset='".$_POST['dj_video_skipoffset']."',dj_adduration='".$_POST['dj_adduration']."',dj_data_sponsored='".$_POST['dj_data_sponsored']."',title='".$_POST['title']."',dj_data_desc='".$_POST['dj_data_desc']."',dj_data_rating='".$_POST['dj_data_rating']."',dj_data_ctatext='".$_POST['dj_data_ctatext']."' where bannerid='".$bannerid."'"));
         
		 }
        // check if size has changed
        if ($aVariables['width'] != $aBanner['width'] || $aVariables['height'] != $aBanner['height']) {
            MAX_adjustAdZones($bannerid);
            MAX_addDefaultPlacementZones($bannerid, $aVariables['campaignid']);
        }
    }
    if ($oComponent)
    {
        $result = $oComponent->processForm($insert, $bannerid, $aFields, $aVariables);
        if ($result === false)
        {
            // handle error
            // remove rec from banners table?
            return false;
        }
    }

    $translation = new OX_Translation ();
    if ($insert) {
        // Queue confirmation message
        $translated_message = $translation->translate ( $GLOBALS['strBannerHasBeenAdded'], array(
            MAX::constructURL(MAX_URL_ADMIN, 'banner-edit.php?clientid=' .  $aFields['clientid'] . '&campaignid=' . $aFields['campaignid'] . '&bannerid=' . $bannerid),
            htmlspecialchars($aFields['description'])
        ));
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

        // Determine what the next page is
        if ($editSwf) {
            $nextPage = "banner-swf.php?clientid=".$aFields['clientid']."&campaignid=".$aFields['campaignid']."&bannerid=$bannerid&insert=true";
        }
        else {
            $nextPage = "campaign-banners.php?clientid=".$aFields['clientid']."&campaignid=".$aFields['campaignid'];
        }
    }
    else {
        // Determine what the next page is
        if ($editSwf) {
            $nextPage = "banner-swf.php?clientid=".$aFields['clientid']."&campaignid=".$aFields['campaignid']."&bannerid=$bannerid";
        }
        else {
            $translated_message = $translation->translate($GLOBALS['strBannerHasBeenUpdated'],
            array (
                MAX::constructURL ( MAX_URL_ADMIN, 'banner-edit.php?clientid='.$aFields['clientid'].'&campaignid='.$aFields['campaignid'].'&bannerid='.$aFields['bannerid'] ),
                htmlspecialchars ( $aFields ['description'])
            ));
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
            $nextPage = "banner-edit.php?clientid=".$aFields['clientid']."&campaignid=".$aFields['campaignid']."&bannerid=$bannerid";
        }
    }

    // Go to the next page
    Header("Location: $nextPage");
    exit;
}

function checkForErrorFileUploaded($oFile)
{
	if (PEAR::isError($oFile)) {
	    phpAds_PageHeader(1);
	    phpAds_Die($GLOBALS['strErrorOccurred'], htmlspecialchars($oFile->getMessage()). "<br>Please make sure you selected a valid file.");
	}
}

function _getContentTypeIconImageName($contentType)
{
    $imageName = '';
    if (empty($contentType)) {
        return $imageName;
    }

    switch ($contentType) {
        case 'swf':
        case 'dcr':  $imageName = 'icon-filetype-swf.gif'; break;
        case 'jpeg': $imageName = 'icon-filetype-jpg.gif'; break;
        case 'gif':  $imageName = 'icon-filetype-gif.gif'; break;
        case 'png':  $imageName = 'icon-filetype-png.gif'; break;
        case 'rpm':  $imageName = 'icon-filetype-rpm.gif'; break;
        case 'mov':  $imageName = 'icon-filetype-mov.gif'; break;
        default:     $imageName = 'icon-banner-stored.gif'; break;
    }

    return $imageName;
}

function _getPrettySize($size)
{
    $kb = round($size / 1024);

    if ($kb > 0) {
        return "{$kb} KB";
    }

    return "{$size} B";
}

function _getBannerSizeText($type, $filename)
{
    return _getPrettySize(phpAds_ImageSize($type, $filename));
}
?>
<script type="text/javascript">
	/*
	if($('#recommend_article').is(':checked')) {
    function selectFile(val){
//~ alert("#"+val.id);
        //Get reference of FileUpload.
        var fileUpload = $("#"+val.id)[0];
 
        //Check whether the file is valid Image.
        //~ var regex = new RegExp("([a-zA-Z0-9\s_\\.\-:])+(.jpg|.png|.gif)$");
        if (fileUpload.value.toLowerCase()) {
                //Initiate the FileReader object.
                var reader = new FileReader();
                //Read the contents of Image File.
                reader.readAsDataURL(fileUpload.files[0]);
                reader.onload = function (e) {
                    //Initiate the JavaScript Image object.
                    var image = new Image();
                    //Set the Base64 string return from FileReader as source.
                    image.src = e.target.result;
                    image.onload = function () {
                        //Determine the Height and Width.
                        var height = this.height;
                        var width = this.width;
                        //~ alert(height+"534"+width);
                        var valu = $("#article_img_size").val();
                            var res = valu.split("x");
                        if (width == res[0] && height == res[1]) {
                            
                            return true;
                        }
                        else
                        {
							alert("Height and Width must same as "+res[0]+" X "+res[1]);
                            $("#"+val.id).val('');
							return false;
						}
                    };
                }
            
        } 
    }
	function phpAds_formSelectSize(){
		var url_string = location.href; //window.location.href
		var url = new URL(url_string);	
		var bannid = url.searchParams.get("bannerid");
		if(bannid){
		var v= confirm("Are you sure want to change image size?");  
			if(v==true){  
				window.location.href=location.href+'&reload='+$("#article_img_size").val();
			}
		}
	}
}*/
</script>
