<?php
header('Access-Control-Allow-Origin: *');
error_reporting(E_ALL);
ini_set('display_errors', 1);
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * This is autogenerated file which contains all files from the "delivery_dev"
 * folder of Revive Adserver merged into a single output file. On systems
 * without a PHP opcode cache that is configured to not regularly check for
 * file updates, this autogenerated file can dramatically improve the
 * performance of Revive Adserver's delivery engine.
 *
 * !!!Warning!!!
 *
 * Do not edit this file. If you need to do any changes to any delivery file,
 * check out the source code from GitHub; make the necessary changes to the
 * file(s) in the "delivery_dev" folder; and regenerate the delivery files
 * using the script located in the "scripts/delivery" directory.
 */

if (empty($_GET['script'])) {
exit(1);
}
include_once '../../init-delivery.php';
$script = str_replace("\0", '', $_GET['script']);
$aPluginId = explode(':', $script);
$scriptFileName = MAX_PATH . rtrim($conf['pluginPaths']['plugins'], '/') . '/' . implode('/', $aPluginId) . '.delivery.php';
if (stristr($scriptFileName, '../') || stristr($scriptFileName, '..\\') || !is_readable($scriptFileName) || !is_file($scriptFileName)) {
if (empty($conf['debug']['production'])) {
echo "Unable to find delivery script ({$scriptFileName}) for specified plugin-component-identifier: {$script}";
}
exit(1);
}
include $scriptFileName;
