<?php

namespace Rtb_objects;

use Helper\utils;
use Helper\validate;

/**
 * Content_object class
 *
 * This class saves the Content objects set by the user before sending the request.
 *
 */
class Content_object {
    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function save($request_id, $object_id, $flag, $request, $time_stamp) {

        $aConf = $GLOBALS['_MAX']['CONF'];
        //!!!Important not to be changed
        if ($flag == '1')
            $insert_array = array('request_id' => "$request_id", 'site_pk_id' => "$object_id");
        if ($flag == '2')
            $insert_array = array('request_id' => "$request_id", 'app_pk_id' => "$object_id");

        if ($request_id AND $request AND $time_stamp) {
            $object = $this->content_object();
            #Get original name and alias name
            $content_object = $this->format_content_object($object);
            $tmp_prepared_request = array_intersect_key($request, $content_object);

            foreach ($tmp_prepared_request as $key => $data)
                $prepared_request[$content_object[$key]['name']] = $data;

            if (isset($prepared_request)) {
                foreach ($prepared_request as $key => $data) {
                    if (is_array($data)) {
                        $formated = implode(",", array_values($data));
                        $json_converted = json_encode($formated);
                    } else {
                        $json_converted = json_encode($data);
                    }
                    $insert_array[$key] = $json_converted;
                }
            }

            //Create a database connection
            $columns = implode(",", array_keys($insert_array));
            $escaped_values = array_values($insert_array);
            $values = implode(",", $escaped_values);
			$contentid=md5(rand());
            $content_pk_id = $contentid;
            if ($content_pk_id)
            {
                $log_msg = "    [Initandlisten]  Content object intialized";
                debug_rtb($log_msg, PEAR_LOG_INFO);
                return $content_pk_id;
            }
            else
                return false;
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function content_object() {
        $content_object = array(
            'content_id' => array('name' => 'id', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'content_title' => array('name' => 'title', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'content_series' => array('name' => 'series', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'content_season' => array('name' => 'season', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'content_original_url' => array('name' => 'url', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'content_category' => array('name' => 'cat', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'keywords' => array('name' => 'keywords', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'content_rating' => array('name' => 'contentrating', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'user_rating' => array('name' => 'userrating', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'context' => array('name' => 'context', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'is_live_stream' => array('name' => 'livestream', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Content_Object'),
            'source_relationship' => array('name' => 'sourcerelationship', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Content_Object'),
            'length_of_content' => array('name' => 'len', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Content_Object'),
            'qagmediarating' => array('name' => 'qagmediarating', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Content_Object'),
            'is_embeddable' => array('name' => 'embeddable', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Content_Object'),
            'language' => array('name' => 'language', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'episode' => array('name' => 'episode', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'artist' => array('name' => 'artist', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'genre' => array('name' => 'genre', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'album' => array('name' => 'album', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'isrc' => array('name' => 'isrc', 'type' => '_string', 'scope' => 'optional', 'object' => 'Content_Object'),
            'prodq' => array('name' => 'prodq', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Content_Object'),
            
        );

        return $content_object;
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 	
     */

    public function format_content_object($object) {
        if ($object) {
            $site_object = array();
            foreach ($object as $key => $data)
                $site_object[$key] = $data;
            return $site_object;
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function fetch($object) {
        $ob = array();
        if ($object) {
            $content_object = $this->content_object();

            $tmp = array_intersect_key($object, $content_object);
            #Replace with original params
            foreach ($tmp as $key => $data)
                $ob['content'][$content_object[$key]['name']] = $data;#this is default,do not change the key.

            if ($ob)
                return json_encode($ob);
            else
                return false;
        }
    }

}

/* End of file Content_object.php */
