<?php

namespace Helper;

/**
 * Request class
 *
 * All the user provided variable is validated in this class,method defined in this class are static,
 * All methods can be used with out creating the instance of the class.
 *
 */

class Validate
{
	
/*
 * 
 * name: unknown
 * @param
 * @return
 * 
 */
	
	function validate_is_integer($name=null,$value=null)
	{
		if($name AND $value)
		{
			$is_valid=filter_var($value, FILTER_VALIDATE_INT);
			
			if(empty($is_valid))
			{
				$prep['error']='Not a valid '.$name;
				$prep['name'][$name]=$value;//If valid add to params array
			}
			else
			{
				$prep['error']='';
				$prep['data'][$name]=$value;//If valid add to params array
			}
			return $prep;
		}
		else
			return false;
	}
/*
 * 
 * name: unknown
 * @param
 * @return
 * 
 */
	
	function validate_is_string($name=null,$value=null)
	{
		if($name AND $value)
		{
			$is_valid=is_string($value);
			
			if(empty($is_valid))
			{
				$prep['error']='Not a valid '.$name;
				$prep['name'][$name]=$value;//If valid add to params array
			}
			else
			{
				$prep['error']='';
				$prep['data'][$name]=$value;//If valid add to params array
			}
			return $prep;
		}
		else
			return false;
		
	}
/*
 * 
 * name: unknown
 * @param
 * @return
 * 
 */
	
	function validate_is_float($name=null,$value=null)
	{
		if($name AND $value)
		{
			$is_valid=filter_var($value, FILTER_VALIDATE_FLOAT);
			if(empty($is_valid))
			{
				$prep['error']='Not a valid '.$name;
				$prep['data'][$name]=$value;//If valid add to params array
			}
			else
			{
				$prep['error']='';
				$prep['data'][$name]=$value;//If valid add to params array
			}
			return $prep;
		}
		else
			return false;
	}
	
/*
 * 
 * name: validate_is_array_string
 * @param
 * @return
 * 
 */
	function validate_is_array_string($name=null,$value=null)
	{
		if(($name AND $value) AND (is_array($value)))
		{
			foreach($value as $key=>$data)
			{
				$is_valid[$name.'-'.$data]=is_string($data)? 'valid':'notvalid';
			}
			foreach($is_valid as $key=>$data)
			{
				if($data=='notvalid')
				{
					$prep['error'][]='Not a valid '.$key;
					$prep['data'][$name]=$value;//If valid add to params array
				}
				else
				{
					$prep['error'][]='';
					$prep['data'][$name]=$value;//If valid add to params array
				}
			}
		}
		else
			$prep['error'][]='Not a valid '.$name.' type';
		
		return $prep;
	}
/*
 * 
 * name: unknown
 * @param
 * @return
 * 
 */
	
	function validate_is_array_integer($name=null,$value=null)
	{
		if(($name AND $value) AND (is_array($value)))
		{
			foreach($value as $key=>$data)
			{
				$is_valid[$name.'-'.$data]=filter_var($data, FILTER_VALIDATE_INT)? 'valid':'notvalid';
			}
			foreach($is_valid as $key=>$data)
			{
				if($data=='notvalid')
				{
					$prep['error'][]='Not a valid '.$key;
					$prep['data'][$name]=$value;//If valid add to params array
				}
				else
				{
					$prep['error'][]='';
					$prep['data'][$name]=$value;//If valid add to params array
				}
			}
			return $prep;
		}
		else
			$prep['error'][]='Not a valid '.$name.' type';
		
		return $prep;
	}
}

/* End of file Validate.php */
