<?php
require 'mongo_library.php';
class Mongo 
{
	
public $hostname ='134.209.182.131';
public $port ='27017';
public $username = 'mohrevie';
public $password = '^kh(0HrEv!3';
public $database = 'mohrevie';
private $connection = '';
private $timeslot = '';
private $report_timeslot = '';

		function __construct() 
		{
			define('M_HOST', $this->hostname);
			define('M_PORT', $this->port);
			define('M_USERNAME', $this->username);
			define('M_PASSWORD', $this->password);
			define('M_DB', $this->database);
			$this->connection = new Mongo_db();
			$this->timeslot = $this->timeslot();
			$this->report_timeslot = $this->report_timeslot();
		}
  

		
			

			public function demand_request_insert($data)
			{
				
				$connection = $this->connection;
				$timeslot = $this->timeslot;
				$data['created_data'] = date('Y-m-d H:i:s');
				$data['created_timestamp'] = time();
				return $connection->insert('demand_request_'.$timeslot,$data);
	
			}	
			
			public function demand_response_insert($data)
			{
				$connection = $this->connection;
				$timeslot = $this->timeslot;
				$data['created_data'] = date('Y-m-d H:i:s');
				$data['created_timestamp'] = time();

					if(isset($data['win_bid_amt']))
				{
					$data['win_bid_amt']=floatval($data['win_bid_amt']); 
				}
				
				return $connection->insert('demand_response_'.$timeslot,$data).'_RTB_'.$timeslot;
	
			}	 
			
			
			public function demand_win_update($response_full_id, $data)
			{
				
				$res_id = explode('_RTB_',$response_full_id);
				$connection = $this->connection;
				$response_id = $res_id[0];
				if(isset($res_id[1]) && $res_id[1])
				{
					$timeslot = $res_id[1];
				}
				else
				{
					$timeslot = $this->timeslot;
				}
				
				
				$filters['_id'] = $connection->create_document_id($response_id);
				$set = $data;
				$set['updated_data'] = date('Y-m-d H:i:s');
				$set['updated_timestamp'] = time();
				
				if(isset($set['win_bid_amt']))
				{
					$set['win_bid_amt']=floatval($set['win_bid_amt']); 
				}
				
				
				$connection->where($filters)->set($set)->update('demand_response_'.$timeslot);
	
			}	 
			
			
			public function get_demand_requests($query)
			{
				
				$report_timeslot = 	$this->report_timeslot();
				//~ $report_timeslot = 	'2020_07_07__03_45'; 
				$connection = $this->connection;
				$result = $connection->aggregate('demand_request_'.$report_timeslot,$query);
				
				return json_decode(json_encode($result),true)[0]['result'];			
				
			} 
			
			
			public function get_demand_responses($query)
			{
				
				$report_timeslot = 	$this->report_timeslot();
				//~ $report_timeslot = 	'2020_07_07__03_45';
				$connection = $this->connection;
				$result = $connection->aggregate('demand_response_'.$report_timeslot,$query);
				
				return json_decode(json_encode($result),true)[0]['result'];			
				
			} 
			
			
			
			
			
				private function timeslot()
			{
				$time = date('Y_m_d__H_i');
					
				for($i=0;$i<= 59;)
				{
				
					if($i<= date('i'))
					{
						$time = date('Y_m_d__H_i',strtotime(date('Y-m-d H:'.$i)));
					}
					else
					{
						break;
					}
				
					$i = $i + 15;
				}
				
				return $time;
			}
			
				private function report_timeslot()
			{
				$time = date('Y_m_d__H_i');
					
				for($i=0;$i<= 59;)
				{
				
					if($i<= date('i'))
					{
						$time = date('Y_m_d__H_i',strtotime(date('Y-m-d H:'.$i).' - 1 hour'));
					}
					else
					{
						break;
					}
				
					$i = $i + 15;
				}
				
				return $time;
			}
			
			
	
}


