<?php

/*Method Name: OA_Dal_Delivery_getdjaxAppInfo
Description: Fetch the App configuration and store itinto cache
Table Name: djax_app_configurations*/ 
function OA_Dal_Delivery_getdjaxAppInfo()
{
		$conf = $GLOBALS['_MAX']['CONF'];
		$results = array();
		$query = "SELECT * FROM {$conf['table']['prefix']}dj_admin_configuration";
		$_query=OA_Dal_Delivery_query($query);
		if(OA_Dal_Delivery_numRows($_query)>0)
		{
			$results = OA_Dal_Delivery_fetchAssoc($_query);
			return $results;
		} 
		return $results;
}
/*Method Name: djax_getCapabilityvalue
Description: Send Request to TeraWURFL API*/ 
function djax_getCapabilityvalue($url)
{
    $rfd = fopen($url, 'r');
    stream_set_blocking($rfd, true);
    stream_set_timeout($rfd, 20); // 20-second timeout
    $data   = stream_get_contents($rfd);
    $status = stream_get_meta_data($rfd);
    fclose($rfd);
    if ($status['timed_out'])
    {
        $xml = simplexml_load_file($url);
    }
    else
    {
        $xml = simplexml_load_string($data);
    }
    return $xml;
}
/*Method Name: unpackcookie
Description: unpack the TeraWURFL cookie*/ 
function unpackcookie($cookievalue)
{
	$mobileparamters = array();
	$getdata=explode('|',$cookievalue);
	$mobileparamters['is_wireless_device']=$getdata[0];
	$mobileparamters['resolution_height']=$getdata[1];
	$mobileparamters['resolution_width']=$getdata[2];
	$mobileparamters['device_brand']=$getdata[3];
	$mobileparamters['device_os']=$getdata[4];
	$mobileparamters['device_os_version']=$getdata[5];
	$mobileparamters['device_model']=$getdata[6];
	$mobileparamters['device_width']=$getdata[7];
	$mobileparamters['device_height']=$getdata[8];
	$mobileparamters['is_tablet']=$getdata[9];
	return $mobileparamters;
}
/*Method Name: djax_mobileparameter
Description: get the TeraWURFL device info and store in cookie
CookieName : RVDEVICE*/ 
function djax_mobileparameter($appconfigInfo)
{
	$conf = $GLOBALS['_MAX']['CONF'];
	$cookie_name=$conf['var']['deviceinfo'];
	if(isset($_COOKIE[$cookie_name]))
	{
		return unpackcookie($_COOKIE[$cookie_name]);
	}
	else
	{
	$_tera_path=$appconfigInfo['tera_path'];
	$_tera_path .= "webservice.php"; 
    define("M_WURFL", $_tera_path);
    $ua              = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'SonyEricssonK700i/R2AC SEMC-Browser/4.0.2 Profile/MIDP-2.0 Configuration/CLDC-1.1';
    $all_values      = djax_getCapabilityvalue(M_WURFL . "?search=is_wireless_device|device_os|device_os_version|resolution_height|resolution_width|is_tablet|device_os_version|model_name|brand_name|max_image_width|max_image_height&ua=" . urlencode($ua));
    $common          = $all_values->device;
    $all             = $common->capability;
    $json            = json_encode($common);
    $capability      = json_decode($json, TRUE);
    $all_capability  = $capability['capability'];
    $mobileparamters = array();
   
    foreach ($all_capability as $key => $value)
    {
        foreach ($value as $paramname => $paramvalue)
        {
			if ($paramvalue['name'] == 'is_wireless_device')
            {
                $mobileparamters['is_wireless_device'] = $paramvalue['value'];
            }
		    else if ($paramvalue['name'] == 'resolution_height')
            {
                $mobileparamters['resolution_height'] = $paramvalue['value'];
            }
             else  if ($paramvalue['name'] == 'resolution_width')
            {
                $mobileparamters['resolution_width'] = $paramvalue['value'];
            }
			else   if ($paramvalue['name'] == 'brand_name')
            {
                $mobileparamters['device_brand'] = $paramvalue['value'];
            }
            else if ($paramvalue['name'] == 'device_os')
            {
                $mobileparamters['device_os'] = $paramvalue['value'];
            }
            else if ($paramvalue['name'] == 'device_os_version')
            {
                $mobileparamters['device_os_version'] = $paramvalue['value'];
            }
            else if ($paramvalue['name'] == 'model_name')
            {
                $mobileparamters['device_model'] = $paramvalue['value'];
            }
            else if ($paramvalue['name'] == 'max_image_width')
            {
                $mobileparamters['device_width'] = $paramvalue['value'];
            }
			else if ($paramvalue['name'] == 'max_image_height')
            {
                $mobileparamters['device_height'] = $paramvalue['value'];
            }
            else if ($paramvalue['name'] == 'is_tablet')
            {
                $mobileparamters['is_tablet'] = $paramvalue['value'];
            }
            
        }
    } 
	$cookie_value=$mobileparamters['is_wireless_device'].'|'.$mobileparamters['resolution_height'].'|'.$mobileparamters['resolution_width'].'|'.$mobileparamters['device_brand'].'|'.$mobileparamters['device_os'].'|'.$mobileparamters['device_os_version'].'|'.$mobileparamters['device_model'].'|'.$mobileparamters['device_width'].'|'.$mobileparamters['device_height'].'|'.$mobileparamters['is_tablet'];
	//is_wireless_device|resolution_height|resolution_width|device_brand|device_os|device_os_version|device_model|device_width|device_height|is_tablet;
	setcookie($cookie_name,$cookie_value, time() + (86400 * 30));
	return $mobileparamters;
	}
}

/*Method Name: viewer_tracking
Description: Generate viewerid and store it cookie and Database*/ 
function viewer_tracking($zoneId,$aZoneInfo)
{
        if (!isset($_SESSION))
        session_start();
		$conf = $GLOBALS['_MAX']['CONF'];
		$cookie_name=$conf['var']['vieweruniqueid'];
		/*If ViewerNot store in cookie check with table user is exists otherwise insert a new user*/
        if (isset($_COOKIE[$cookie_name]) && $_COOKIE[$cookie_name] != '')
        { 
            $viewer_id = $_COOKIE[$cookie_name];
        }
        else
        {  
            $viewer_id = djax_tracking_viewer();
        }
		$z= djax_tracking_ad_request($viewer_id,$zoneId,$aZoneInfo);
        $_SESSION['request_id'] = $z;
} 
/*Method Name: djax_tracking_viewer
Description: Generate viewerid and store it cookie and Database
Table Name: djax_track_viewers*/		
function djax_tracking_viewer()
{
	$conf = $GLOBALS['_MAX']['CONF'];
    $flashversion = $_GET['version'];
    $cookiePrefix = $GLOBALS['_MAX']['MAX_COOKIELESS_PREFIX'];

			if ($GLOBALS['_MAX']['device']['is_wireless_device'] == 'true')
			{
				$os           = $GLOBALS['_MAX']['device']['device_os'];
				$os_version   = !empty($GLOBALS['_MAX']['device']['deviceos_version']) ? $GLOBALS['_MAX']['device']['deviceos_version'] : 0;
				$device_model = !empty($GLOBALS['_MAX']['device']['device_model']) ? $GLOBALS['_MAX']['device']['device_model'] : 0;
				$device_brand = $GLOBALS['_MAX']['device']['device_brand'];
				$carrier      = !empty($GLOBALS['_MAX']['device']['carrier']) ? $GLOBALS['_MAX']['device']['carrier'] : $_REQUEST['carrier'];
				if ($GLOBALS['_MAX']['device']['is_tablet'] == 'true')
				{
					$device_type = 'Tablet';
				}
				else
				{
					$device_type = 'Mobile';
				}
				if (!empty($GLOBALS['_MAX']['device']['device_width']) && !empty($GLOBALS['_MAX']['device']['device_height']))
				{
					$screen_resolution = $GLOBALS['_MAX']['device']['device_width'] . "X" . $GLOBALS['_MAX']['device']['device_height'];
				}
				$create_unique_user = $screen_resolution . $flashversion . $GLOBALS['_MAX']['device']['device_os'] . $GLOBALS['_MAX']['device']['deviceos_version'] . $GLOBALS['_MAX']['device']['device_model'] . $GLOBALS['_MAX']['device']['device_brand'] . $device_type;
				$viewer_id          = $cookiePrefix . substr(md5($_SERVER['REMOTE_ADDR'] . $create_unique_user), 0, 32);
			}
			else
			{
				$aParams 			= $GLOBALS['_MAX']['CLIENT'];
				$os					= $aParams['wrapper']->getLegacyOs();
				$os                 = !empty($os) ? $os : $_GET['OS'];
				$os_version         = $aParams['wrapper']->getOsVersion();
				$device_type        = 'Display';
				$screen_resolution  = $_GET['screen_resoultion'];
				$create_unique_user = $screen_resolution . $flashversion . $os . $os_version . $device_type;
				$viewer_id          = $cookiePrefix . substr(md5($_SERVER['REMOTE_ADDR'] . $create_unique_user), 0, 32);
			}
			setcookie($conf['var']['vieweruniqueid'],$viewer_id, time() + (86400 * 30));
			if(!empty($GLOBALS['_MAX']['device']['country']))
			{
			$country_code  = $GLOBALS['_MAX']['device']['country'];
			$city          = $GLOBALS['_MAX']['device']['city'];
			$isp           = $GLOBALS['_MAX']['device']['carrier'];
			}
			else
			{
			$country_code  = $GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
			$region        = $GLOBALS['_MAX']['CLIENT_GEO']['region'];
			$city          = $GLOBALS['_MAX']['CLIENT_GEO']['city'];
			$lattitude     = $GLOBALS['_MAX']['CLIENT_GEO']['latitude'];
			$longitude     = $GLOBALS['_MAX']['CLIENT_GEO']['longitude'];
			$isp           = $GLOBALS['_MAX']['CLIENT_GEO']['isp'];	
			}
			$select_query  = "select viewer_id from {$conf['table']['prefix']}dj_track_viewers where viewer_id='$viewer_id'";
			$query         = OA_Dal_Delivery_query($select_query);
			if (OA_Dal_Delivery_numRows($query) > 0)
			{ 
						$result=OA_Dal_Delivery_fetchAssoc($query);
						$viewer_id=$result['viewer_id'];
						return $viewer_id;
			}
			else
			{
						$insert_query = "INSERT INTO {$conf['table']['prefix']}dj_track_viewers(`viewer_id`, `device_type`, `ip_address`,`os`, `os_version`, `screen_resolution`, `device_model_name`,
						device_brand,country,state,city,latitude,longitude,isp) VALUES 
						('$viewer_id','$device_type', '" . $_SERVER['REMOTE_ADDR'] . "', '$os','$os_version', 
						'$screen_resolution','$device_model','$device_brand','$country_code','$region','$city',
						'$lattitude','$longitude','$isp')";
						OA_Dal_Delivery_query($insert_query);
						return $viewer_id;
			}
}
/*Method Name: djax_tracking_ad_request
Description: Store the requestid in database
Table Name: djax_track_ad_requests*/
function djax_tracking_ad_request($viewerid, $zoneid,$aZoneInfo)
{
    $conf            = $GLOBALS['_MAX']['CONF'];
    $date_time       = date('Y-m-d H:00:00', mktime(date('H'), 0, 0, date('m'), date('d'), date('Y')));
	$insert_query     = "INSERT INTO {$conf['table']['prefix']}dj_track_ad_requests(`viewer_id`, `date_time`, `zone_id`, `bidding_price`) 
	VALUES ('$viewerid','$date_time','" . $zoneid . "', '0.0000')";
    OA_Dal_Delivery_query($insert_query);
    $z               = OA_Dal_Delivery_insertId();
    $_SESSION['request_id'] = $z;
    return $z;
}
