<?php 


require_once '../../../../init.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once LIB_PATH . '/Plugin/PluginManager.php';
require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';
require_once MAX_PATH . '/lib/pear/Date.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
 require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
 require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
 require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

$aErrormessage = array();
$oOptions = new OA_Admin_Option('settings');
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel("DSP Portal Settings");
phpAds_PageHeader('dsp-statistics', $oHeaderModel);




// Create a new option object for displaying the setting's page's HTML form
//$oOptions = new OA_Admin_Option('settings');
//$prefSection = "inventory-products";
$aErrormessage = array();

if (isset($_POST['submitok']) && $_POST['submitok'] == 'true') {
    // Prepare an array of the HTML elements to process, and which
    // of the preferences are checkboxes
    $aElements   = array();
    $aCheckboxes = array();
    // Default Banners
    $aElements[] = 'default_banner_image_url';
    $aElements[] = 'default_banner_destination_url';
    // Default Weight
    $aElements[] = 'default_banner_weight';
    $aElements[] = 'default_campaign_weight';
    // Save the preferences
    $result = OA_Preferences::processPreferencesFromForm($aElements, $aCheckboxes);
    if ($result) {

        // Queue confirmation message
        $setPref = $oOptions->getSettingsPreferences($prefSection);
        $title = $setPref[$prefSection]['name'];
        $translation = new OX_Translation ();
        $translated_message = $translation->translate($GLOBALS['strXPreferencesHaveBeenUpdated'],
            array(htmlspecialchars($title)));
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);


        // The preferences were written correctly saved to the database,
        // go to the "next" preferences page from here
        OX_Admin_Redirect::redirect(basename($_SERVER['PHP_SELF']));
    }
    // Could not write the preferences to the database, store this
    // error message and continue
    $aErrormessage[0][] = $strUnableToWritePrefs;
}	
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

$pageName = basename($_SERVER['SCRIPT_NAME']);
if(!empty($_POST))
{
$_POST['period_preset'] = $_POST['period_preset'];
}
else
{
$_POST['period_preset'] = $_GET['period_preset'];
}

$_period = $_POST['period_preset'];

if($_POST['period_preset']!='')
{

	if($_POST['period_preset']=='today')
	{
			$start=date("Y-m-d 00:00:00");//$date=date("Y-m-d H:00:00");
			$end=date("Y-m-d 23:59:59");
			
		//~ $result=time_zone($start,$end);
			
		//~ $startdate=$result[0];
		//~ $endate=$result[1];
		$startdate=$start;
		$endate=$end; 
		// $start=$result[0]; $end=$endate;
		
		
	}
	else if($_POST['period_preset']=='yesterday')
	{
		$start=date('Y-m-d 00:00:00', strtotime('Yesterday'));
		$end=date('Y-m-d 23:59:59', strtotime('Yesterday'));

		//~ $result=time_zone($start,$end);
			
		//~ $startdate=$result[0];
		//~ $endate=$result[1];
		$startdate=$start;
		$endate=$end; 		 
		//$start=$result[0]; $end=$endate;
	
	}

	else if($_POST['period_preset']=='last_7_days')
	{
		$start=date('Y-m-d 00:00:00', strtotime('Today - 7 Day'));
		$end=date('Y-m-d 23:59:59',strtotime('Today - 1 Day'));
		
		//~ $result=time_zone($start,$end);
			
		//~ $startdate=$result[0];
		//~ $endate=$result[1];
		$startdate=$start;
		$endate=$end; 		 
		//$start=$result[0]; $end=$endate;
	}
	else if($_POST['period_preset']=='this_month')
	{
		$start=date('Y-m-d 00:00:00', mktime(0, 0, 0, date('m'), 1, date('Y')));
		$end=date('Y-m-d 23:59:59');
		//~ $result=time_zone($start,$end);
			
		//~ $startdate=$result[0];
		//~ $endate=$result[1]; 
		$startdate=$start;
		$endate=$end; 		
	}
	else if($_POST['period_preset']=='last_month')
	{
		 $start=date('Y-m-d 00:00:00', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
		 $end=date('Y-m-d 23:59:59', mktime(0, 0, 0, date('m'), 0, date('Y')));
		//~ $result=time_zone($start,$end);
		//~ $startdate=$result[0];
		//~ $endate=$result[1]; 
		$startdate=$start;
		$endate=$end; 		
		//$start=$result[0]; $end=$endate;
	}
	else if($_POST['period_preset']=='all_stats')
	{
		$start=date("0000-00-00 00:00:00");
		$end=date("Y-m-d 23:59:59");
		//~ $result=time_zone($start,$end);
		//~ $start='0000-00-00 00:00:00'; $end=$result[1];$startdate=$start;
		//~ $endate=$result[1];
		$startdate=$start;
		$endate=$end; 		
		
	}
	else if($_POST['period_preset']=='specific')
	{
					
		 $start=$_POST['period_start'];
		 $end=$_POST['period_end'];
		//~ $result=time_zone($start,$end);
	    //~ $startdate=$result[0];
		 //~ $endate=$result[1];
		$startdate=$start;
		$endate=$end; 
	}
		

}

else
{
	$start=date("Y-m-d 00:00:00");//$date=date("Y-m-d H:00:00");
	    $end=date("Y-m-d 23:59:59");
	   
		//~ $result=time_zone($start,$end);
			
		 //~ $startdate=$result[0];
		 //~ $endate=$result[1]; 
		
		$startdate=$start;
		$endate=$end; 
}

//////////timezone

function time_zone($start,$end)
{
$end_date =  date('Y-m-d',strtotime($end));	
$end_day=new Date($end_date);
$end_day->setHour(23);
$end_day->setMinute(59);
$end_day->setSecond(59);
$end_day->toUTC();
$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
$start_day=new Date($start);
$start_day->setHour(0);
$start_day->setMinute(0);
$start_day->setSecond(0);
$start_day->toUTC();
$start_date=$start_day->format('%Y-%m-%d %H:%M:%S'); 
$date[]=$start_date;
$date[]=$end_date;
return $date;	
	
}

///////////timezone

$agency_id = OA_Permission::getEntityId();	
if($agency_id==0)
{
	
	
	
if (isset($_POST['page'])) {
    $page = $_POST['page'];
} else {
    $page = 1;
}
 
  
$no_of_records_per_page = 50;

if($page > 1)
{
$offset = ( (($page>1) ? ($page-1) : $page) * $no_of_records_per_page) - 1; 
}
else
{
	$offset = 0;
}
     //~ echo "SELECT re.exchange_id,date(re.datetime) as datetime,sum(re.bidrequest) as bidrequest,sum(re.bidresponse) as bidresponse,sum(re.winnotice) as winnotice,sum(re.advertiserbidprice) as advbid,sum(re.wonbid) as winbid FROM `rq_dj_dsp_reports` as re,rq_campaigns as c,rq_clients as cl,rq_banners as b where datetime between '$startdate' and '$endate' and and b.bannerid=re.ad_id and b.campaignid=c.campaignid and c.clientid=cl.clientid GROUP BY DATE(datetime),exchange_id order by datetime desc LIMIT $offset, $no_of_records_per_page";
     //~ exit;
     
     
	$summarytable=OA_Dal_Delivery_query("SELECT re.exchange_id,date(re.datetime) as datetime,sum(re.bidrequest) as bidrequest,sum(re.bidresponse) as bidresponse,sum(re.winnotice) as winnotice,sum(re.advertiserbidprice) as advbid,sum(re.wonbid) as winbid FROM `rq_dj_dsp_reports` as re,rq_campaigns as c,rq_clients as cl,rq_banners as b where re.datetime between '$startdate' and '$endate'  and b.bannerid=re.ad_id and b.campaignid=c.campaignid and c.clientid=cl.clientid GROUP BY DATE(datetime),exchange_id order by datetime desc LIMIT $offset, $no_of_records_per_page");
		
	$s=OA_Dal_Delivery_query("SELECT exchange_id  FROM `rq_dj_dsp_reports`  where date(datetime) between '$startdate' and '$endate'   GROUP BY date(datetime),exchange_id");
	$total=OA_Dal_Delivery_numRows($s);
				
	$totalstats=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT re.exchange_id,date(re.datetime) as datetime,sum(re.bidrequest) as bidrequest,sum(re.bidresponse) as bidresponse,sum(re.winnotice) as winnotice,sum(re.advertiserbidprice) as advbid,sum(re.wonbid) as winbid FROM `rq_dj_dsp_reports` as re,rq_campaigns as c,rq_clients as cl,rq_banners as b where datetime between '$startdate' and '$endate' and b.bannerid=re.ad_id and b.campaignid=c.campaignid and c.clientid=cl.clientid"));	
}
?>
<form method='post'>
        <select name='period_preset' id='period_preset' onchange='periodFormChange(1)' tabindex='1'>
            <option value='today' selected='selected'>Today</option>
            <option value='yesterday' <?php if($_period == "yesterday") : ?> selected="selected" <?php endif; ?> >Yesterday</option>
            <option value='last_7_days' <?php if($_period == "last_7_days") : ?> selected="selected" <?php endif; ?> >Last 7 days</option>
            <option value='this_month' <?php if($_period == "this_month") : ?> selected="selected" <?php endif; ?> >This month</option>
            <option value='last_month' <?php if($_period == "last_month") : ?> selected="selected" <?php endif; ?> >Last month</option>
            <option value='all_stats' <?php if($_period == "all_stats") : ?> selected="selected" <?php endif; ?> >All statistics</option>
            <option value='specific' <?php if($_period == "specific") : ?> selected="selected" <?php endif; ?> >Specific dates</option>
        </select>


       <input type='hidden' name='offset' value= <?php echo $offset; ?> ></input>
       <input type='hidden' name='no_of_records_per_page' value= <?php echo $no_of_records_per_page; ?> ></input>


       <label for='period_start' style='margin-left: 1em'></label>
        <input class="date" name="period_start" id="period_start" type="text" value="<?php  if(!empty($start)){ echo $start;}else{ echo date('Y-m-d');}?>" tabindex="2"/>
        <input type='image' src='assets/images/icon-calendar-d.gif' id='period_start_button' align='absmiddle' border='0' tabindex='3' />
        <label for='period_end' style='margin-left: 1em'> </label>
	
        <input class="date" name="period_end" id="period_end" type="text" value="<?php if(!empty($end)){ echo $end;}else{ echo date('Y-m-d');} ?>" tabindex="4" /> 
<input type='image' src='assets/images/icon-calendar-d.gif' id='period_end_button' align='absmiddle' border='0' tabindex='3' />
	<a href='' onclick='return periodFormSubmit()'>
    <img src='assets/images/ltr/go_blue.gif' border='0' tabindex='6' /></a>
	<input type="hidden" name="page" id="pg_page" value="<?php echo $page; ?>">


</form>
<style type="text/css">
	
table.gridtable {
	
	font-family: verdana,arial,sans-serif;
	font-size:11px;
	color:#333333;
	border-width: 1px;
	width: 100%;
	border-color: #999999;
	border-collapse: collapse;
}
table.gridtable th {
	
	border-width: 1px;
	padding: 8px;
	border-style: solid;
	border-color: #999999;
}
table.gridtable td {
	
	border-width: 1px;
	padding: 8px;
	border-style: solid;
	border-color: #999999;
}
</style>
<?php
if(OA_Dal_Delivery_numRows($summarytable)>0)
{
?>	
<link rel="stylesheet" type="text/css" href="../../assets/min.php?g=oxp-css-ltr&v=2.8.10">
<table width='100%' border='0' cellspacing='0' cellpadding='0'>
        <tr>
             <td style="padding-bottom:5px; white-space: nowrap;">
				<br />
				<a href="oxm_dspexport.php?startdate=<?php echo $start;?>&enddate=<?php echo $end;?>&period=<?php echo $_period;?>&offset=<?php echo $offset;?>&no_of_records_per_page=<?php echo $no_of_records_per_page;?>" accesskey="e">
				<img src="../../assets/images/excel.gif" border="0" alt="" /> <u>E</u>xport Statistics to CSV</a>
            </td>
            <td width="90%">&nbsp;</td>
         </tr>
</table>
        <table width="100%" class="table">
       <tr>
				<th scope="col" class="aleft" style="color: #0767A8;">Date</th>
                  		<th scope="col" class="aleft" style="color: #0767A8;">DSP Portal</th>    
                		<th scope="col" class="aright" style="color: #0767A8;">Bid Request</th>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
			    	<th scope="col" class="aright" style="color: #0767A8;">Bid Response</th>
			    	<th scope="col" class="aright" style="color: #0767A8;">Won Response</th>
			    	<th scope="col" class="aright" style="color: #0767A8;">Advertiser Bid($)</th>
			  	<th scope="col" class="aright" style="color: #0767A8;">Won Price($)</th>  
				<!--<th scope="col" class="aright" style="color: #0767A8;">Admin Share($)</th> --> 

            
	</tr> 
<?php

	$recordedexchange=array();
		
	while($summarydata=OA_Dal_Delivery_fetchAssoc($summarytable))
	{
		$listedexchanges=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select dsp_portal_name from rq_dj_dsp where id='".$summarydata['exchange_id']."'"));
		$djrequests=$summarydata['bidrequest'];
		$djresponses=$summarydata['bidresponse'];
		$djwinnotice=$summarydata['winnotice'];			
		$djwinprice=$summarydata['winbid'];
		$djbidprice=$summarydata['advbid'];	
		?>
		<tr>
		<td class="aright dark"><?php echo $summarydata['datetime'];?></td>
		<?php if(empty($listedexchanges['dsp_portal_name']))
		{ ?><td class="aright dark" ><?php echo $listedexchanges['dsp_portal_name']; ?></td>
		<?php } else { ?> <td class="aright dark"><a href="oxm_dspdaystat.php?startdate=<?php echo $start;?>&enddate=<?php echo $end;?>&period=<?php echo $_period; ?>&exchangeid=<?php echo $summarydata['exchange_id']; ?>"><?php echo $listedexchanges['dsp_portal_name'];?></td></a></td>
		<?php }?>	
		<?php if($djrequests==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo $djrequests; ?></td>
		<?php }?>

		<?php if($djresponses==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo $djresponses; ?></td>
		<?php }?>


		<?php if($djwinnotice==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo $djwinnotice; ?></td>
		<?php }?>

		<?php if($djbidprice==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo round(($djbidprice/1000),6); ?></td>
		<?php }?>

		<?php if($djwinprice==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo round(($djwinprice/1000),6); ?></td>
		<?php }?>

		</tr>

		<?php 

	}
	
	
	
	
		if(isset($page)){				
			
				$totalPages = ceil($total / $no_of_records_per_page);
				if($totalPages > 1)
				{
					
				echo "<tr><td colspan='7' ><div class='pager'>";
	
				if($page >1 )
				{
					$n = $page - 1;
					echo "<span><a id='page_a_link' href='#' onclick='return change_page($n)'><< Prev</a></span>";
				}
				
				
				for($m=1; $m <= $totalPages; $m++){
					if($m<>$page){
						echo "<span><a id='page_a_link' href='#'onclick='return change_page($m)' >$m</a></span>";
					}
					else{
						echo "<span id='page_links' style='font-weight: bold;'>$m</span>";
					}
				}
				
				
				if($page != $totalPages )
				{
					$n = $page + 1;
					echo "<span><a id='page_a_link' href='#' onclick='return change_page($n)' >Next >> </a></span>";
				}
				
				
					echo "</div></td></tr>";
					
					
					
				}
			
			
			}
		

	
	
	
	
	
	
	if(!empty($totalstats['exchange_id']))
	{
		$listedexchanges=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select dsp_portal_name from {$table_prefix}dj_dsp where id='".$totalstats['exchange_id']."'"));
		$djrequests=$totalstats['bidrequest'];
		$djresponses=$totalstats['bidresponse'];
		$djwinnotice=$totalstats['winnotice'];			
		$djwinprice=$totalstats['winbid'];
		$djbidprice=$totalstats['advbid'];
	?>
		

		<tr class="spl">
		<td class="aright dark"><b>Total</b></td>
		<td class="aright dark">All DSPs</td></td>
		<?php if($djrequests==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo $djrequests; ?></td>
		<?php }?>

		<?php if($djresponses==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo $djresponses; ?></td>
		<?php }?>


		<?php if($djwinnotice==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo $djwinnotice; ?></td>
		<?php }?>

		<?php if($djbidprice==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo round(($djbidprice/1000),6); ?></td>
		<?php }?>

		<?php if($djwinprice==0)
		{ ?><td class="aright dark" ><?php echo '-'; ?></td>
		<?php } else { ?> <td class="aright dark" ><?php echo round(($djwinprice/1000),6); ?></td>
		<?php }?>

		</tr>
		</table>
		
		
<?php

	}
	
	
	
	
	
	
	
	
		
	
	
	
	
	
	
	
	
} 	
else
{
echo '<div style="margin-top: 2em;" class="errormessage"><img border="0" align="absmiddle" width="16" height="16" src="../../assets/images/info.gif" class="errormessage">There are currently no statistics available for the period '.$startdate.' to '.$endate.'</div>';
}


?>






        <script type='text/javascript'>
        <!--
        Calendar.setup({
            inputField : 'period_start',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_start_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });
        Calendar.setup({
            inputField : 'period_end',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_end_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });

       
        //-->


function change_page(e)
{
	document.getElementById('pg_page').value=e;
	periodFormSubmit(1);
	 
	return false;
}

 function periodFormChange(bAutoSubmit)
        {
			
			
 	    var o = document.getElementById('period_preset');
            var periodSelectName = o.options[o.selectedIndex].value;


            var specific = periodSelectName == 'specific';


    	var advertiser = periodSelectName == 'advertiser';

 	    var periodTabIndex = 2;

	    document.getElementById('period_start').readOnly = !specific;
            document.getElementById('period_start_button').disabled = !specific;
            document.getElementById('period_end').readOnly = !specific;
            document.getElementById('period_end_button').disabled = !specific;
       
           

       
                document.getElementById('period_start').style.backgroundColor = '#FFFFFF';
                document.getElementById('period_end').style.backgroundColor = '#FFFFFF';
                document.getElementById('period_start').tabIndex = periodTabIndex;
                document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
                document.getElementById('period_end').tabIndex = periodTabIndex + 2;
                document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
	        document.getElementById('period_start_button').src = 'assets/images/icon-calendar.gif';
           	document.getElementById('period_end_button').src = 'assets/images/icon-calendar.gif' ;
            

           
            document.getElementById('period_start_button').readOnly = !specific;
            document.getElementById('period_end_button').readOnly = !specific;
          
            document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
            document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';

           
}
periodFormChange(0);

    function periodFormSubmit(sb=null) {
		if(sb == null)
		{
				document.getElementById('pg_page').value=1;
	
		}
		
		
            var form = document.getElementById('period_preset').form;
            if (checkDates(form)) {
              form.submit();
            }
            return false;
        }
    function checkDates(form)
        {
          var startField = form.period_start;
          var endField = form.period_end;

          if (!startField.disabled && startField.value != '') {
            var start = Date.parseDate(startField.value, '%Y-%m-%d');
          }
          if (!startField.disabled && endField.value != '') {
            var end = Date.parseDate(endField.value, '%Y-%m-%d');
          }

         
          return true;
        }


        </script>


<style>
	
	.pager
	{
	text-align: center;
    margin-top: 10px;
    margin-bottom: 10px;
	}
	#page_links
	{
		    font-size: 15px;
    color: #848484;
    margin: 5px;
    display: inline-block;
	}
	#page_a_link
	{
	font-size: 15px;
    color: #49b74d;
    margin: 5px;
    display: inline-block;
    font-weight: 600;

	}	
	.table .spl td.dark 
	{
	padding-top: 8px;
    padding-bottom: 8px;
    font-size: 14px
	}
	
	</style>


<?php

//_echoDeliveryCappingJs();

phpAds_PageFooter();

?>

