<?php
require_once '../../init.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once 'lib/Csv.php';
require_once MAX_PATH . '/www/admin/config.php';

$oDbh = &OA_DB::singleton();

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$tab_report = $oDbh->quoteIdentifier('rq_rtb_dsp_tracking',true);

$start_date = $_GET['start_date'];
$end_date = $_GET['end_date'];

 




$tb_select = "SELECT dsp_buyer_id , country , 
					sum(request) as request,
					sum(response) as response,
					sum(win_notice) as win_notice,
					sum(price) as price";
					
					
$tb_from ="FROM ${tab_report} ";

$tb_where = (($start_date == '' && $end_date == "") ?  "" : "WHERE date BETWEEN '${start_date}' and '${end_date}' AND country !='' ");

if(isset($_GET['startAt']) && isset( $_GET['limit']) )
{
	
$startAt  = $_GET['startAt'];
$limit  = $_GET['limit'];
$tb_group ="GROUP BY country,dsp_buyer_id  order by dsp_buyer_id,country limit ${startAt},${limit}";
}
else
{
	$tb_group ="GROUP BY country,dsp_buyer_id  order by dsp_buyer_id,country";
}

 $query = $tb_select." ".$tb_from." ".$tb_where." ".$tb_group;
 
 
 
$rsReport = $oDbh->query($query)->fetchAll();



	$country = array();
	$query="SELECT * FROM `rv_dj_country`";
	$results = $oDbh->query($query)->fetchAll();
	foreach($results as $key => $value)
	{
		$country[$value['country_code']]=$value['name'];
		$country[$value['iso_countycode_alpha3']]=$value['name'];
	}
	
	
	$ad_exchange = array();
	$query="SELECT * FROM `rq_dj_ad_exchange`";
	$results = $oDbh->query($query)->fetchAll();
	foreach($results as $key => $value)
	{
		$ad_exchange[$value['exchange_id']]=$value['exchange_name'];
	}
	
	

foreach($rsReport as $Report)
{	
	$rows[] =  array(0=>$ad_exchange[$Report['dsp_buyer_id']],1=>$country[$Report['country']] ,2=>$Report['request'],3=>$Report['response'], 4=>$Report['win_notice'],5=>$Report['price']);
}



$columns=array(0=>'DSP Buyer Name',1=>'Country',2=>'Request',3=>'Response',4=>'Win Notice',5=>'Amount');

if(count($rows)>0)
{
	$toExport = array_merge(array( $columns ),$rows);
}
else{
	$rows[]= array(0=>'No stats avilable');
	$toExport = array_merge(array( $columns ),$rows);
}





if($start_date =='0000-00-00 00:00:00')
{
	$filename = 'DSP_Country_all_stats.csv';

}
else if(!empty($start_date) && !empty($end_date))
{
	$sdate=explode(' ',$start_date);
	$edate=explode(' ',$end_date);
	$filename = 'DSP_Country Report '.$sdate[0].'_to_'.$edate[0].'.csv';
}
else
{
	$filename = 'DSP_Country Report.csv'; 
}

header('Content-Disposition:attachment;filename='.$filename);
header('Content-Type:application/vnd.ms-excel');

$csv = '';
foreach($toExport as $row) {
	$csv .= OX_Vast_Common_Csv::formatCsvLine($row);
}
 
echo $csv; 
exit;
