<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file

require_once '../../init.php';
// Required files
require_once MAX_PATH . '/www/admin/config.php';
require_once LIB_PATH . '/Plugin/PluginManager.php';
require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once MAX_PATH . '/lib/OA/Dal.php';

OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

	$isSsl = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' : 'http://';
	$image_path = 'assets/images/';
	$css_path = 'assets/css/';
	
$oDbh = &OA_DB::singleton();

$oPluginManager = new OX_PluginManager();
$oComponentGroupManager = new OX_Plugin_ComponentGroupManager();

$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel("Country Reports");
$oHeaderModel->setIconClass('iconTargetingChannelsLarge');
$oHeaderModel->setpageType('list');

phpAds_PageHeader('countrystats', $oHeaderModel);



$tab_report = $oDbh->quoteIdentifier('rq_rtb_dsp_tracking',true);

$pPass = $_GET;
$limit = 25;
$pn = ($_GET['p']) ? $_GET['p'] : 1;

$startAt = $limit * ($pn - 1);


	    
$_period = !empty($pPass['period_preset']) ? $pPass['period_preset'] : '';

if($pPass['period_preset']!='')
{

	if($pPass['period_preset']=='today')
	{
		$start=date('Y-m-d');
		$end=date('Y-m-d');
	}
	else if($pPass['period_preset']=='yesterday')
	{
		$start=date('Y-m-d', strtotime('Yesterday'));
		$end=date('Y-m-d', strtotime('Yesterday'));

	}
	else if($pPass['period_preset']=='this_week')
	{
		$start=date('Y-m-d', strtotime('this week Monday'));
		$end=date('Y-m-d');
	}
	else if($pPass['period_preset']=='last_week')
	{
		$start=date('Y-m-d', strtotime('previous Monday'));
		$end=date('Y-m-d', strtotime('previous Sunday'));
	}
	else if($pPass['period_preset']=='last_7_days')
	{
		$start=date('Y-m-d', strtotime('Today - 7 Day'));
		$end=date('Y-m-d', strtotime('Today - 1 Day'));
	}
	else if($pPass['period_preset']=='this_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
		$end=date('Y-m-d');
	}
	else if($pPass['period_preset']=='last_month')
	{
		$start=date('Y-m-d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
		$end=date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')));
	}
	else if($pPass['period_preset']=='all_stats')
	{
		$start='0000-00-00';
		$end=date('Y-m-d'); $period_preset='all_stats';
	}
	else if($pPass['period_preset']=='specific')
	{
		$start=$pPass['period_start'];
		$end=$pPass['period_end'];
	}

}
else
{
	$start=date('Y-m-d');
	$end=date('Y-m-d');
}


$start_date=$start;
$end_date=$end;



/*Convert start date and end date into timezone format*/
if($period_preset=='all_stats')
{
	$start_date="0000-00-00 00:00:00";
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
}
else if($start_date=='' && $end_date=='')
{ 
	$start_day=new Date(date('Y-m-d H:i:00'));
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
	$end_day=new Date(date('Y-m-d H:i:00'));
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
	
}
else
{
	
	$end_day=new Date($end_date);
	
	$end_day->setHour(23);
	$end_day->setMinute(59);
	$end_day->setSecond(59);
	$end_day->toUTC();
	$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');

	$start_day=new Date($start_date);
	
	$start_day->setHour(0);
	$start_day->setMinute(0);
	$start_day->setSecond(0);
	
	$start_day->toUTC();
	$start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
	
}



$tb_select = "SELECT dsp_buyer_id , country , 
					sum(request) as request,
					sum(response) as response,
					sum(win_notice) as win_notice,
					sum(price) as price";
					
					
$tb_from ="FROM ${tab_report} ";

$tb_where = (($start == '' && $end == "") ?  "" : "WHERE date BETWEEN '${start_date}' and '${end_date}' AND country !='' ");

$tb_group ="GROUP BY country,dsp_buyer_id  order by dsp_buyer_id,country limit ${startAt},${limit}";

$query = $tb_select." ".$tb_from." ".$tb_where." ".$tb_group;
 
$rsReport = $oDbh->query($query)->fetchAll();
 



$tb_select = "SELECT count(dsp_buyer_id) as count";					
$tb_from ="FROM ${tab_report} ";
$tb_where = (($start == '' && $end == "") ?  "" : "WHERE date BETWEEN '${start_date}' and '${end_date}' AND country !='' ");
$tb_group ="GROUP BY country,dsp_buyer_id ";
$query = $tb_select." ".$tb_from." ".$tb_where." ".$tb_group;
$rsTotalReport = $oDbh->query($query)->fetchAll();




	$country = array();
	$query="SELECT * FROM `rv_dj_country`";
	$results = $oDbh->query($query)->fetchAll();
	foreach($results as $key => $value)
	{
		$country[$value['country_code']]=$value['name'];
		$country[$value['iso_countycode_alpha3']]=$value['name'];
	}
	
	
	$ad_exchange = array();
	$query="SELECT * FROM `rq_dj_ad_exchange`";
	$results = $oDbh->query($query)->fetchAll();
	foreach($results as $key => $value)
	{
		$ad_exchange[$value['exchange_id']]=$value['exchange_name'];
	}
	
	

?>


<form method='get' class="oxn_form_at">
        <select name='period_preset' id='period_preset' onchange='periodFormChange(1)' tabindex='1'>
            <option value='today' selected='selected'>Today</option>

            <option value='yesterday' <?php if($_period == "yesterday") : ?> selected="selected" <?php endif; ?> >Yesterday</option>
            <option value='this_week' <?php if($_period == "this_week") : ?> selected="selected" <?php endif; ?> >This week</option>
            <option value='last_week' <?php if($_period == "last_week") : ?> selected="selected" <?php endif; ?> > Last week</option>
            <option value='last_7_days' <?php if($_period == "last_7_days") : ?> selected="selected" <?php endif; ?> >Last 7 days</option>
            <option value='this_month' <?php if($_period == "this_month") : ?> selected="selected" <?php endif; ?> >This month</option>
            <option value='last_month' <?php if($_period == "last_month") : ?> selected="selected" <?php endif; ?> >Last month</option>

            <option value='all_stats' <?php if($_period == "all_stats") : ?> selected="selected" <?php endif; ?> >All statistics</option>
            <option value='specific' <?php if($_period == "specific") : ?> selected="selected" <?php endif; ?> >Specific dates</option>
        </select>

        <label for='period_start' style='margin-left: 1em'></label>
        <input class="date" name="period_start" id="period_start" type="text" value="<?php  if(!empty($start)){ echo $start;}else{ echo date('Y-m-d');}?>" tabindex="2"/>
        <input type='image' src='<?php echo $image_path.'icon-calendar.gif';  ?>' id='period_start_button' align='absmiddle' border='0' tabindex='3' />
        <label for='period_end' style='margin-left: 1em'> </label>

        <input class="date" name="period_end" id="period_end" type="text" value="<?php if(!empty($end)){ echo $end;}else{ echo date('Y-m-d');} ?>" tabindex="4" /> 
<input type='image' src='<?php echo $image_path.'icon-calendar.gif'; ?>' id='period_end_button' align='absmiddle' border='0' tabindex='3' />
	<a href='' onclick='return periodFormSubmit()'>
       &nbsp; <img src='<?php echo $image_path.'go.gif'; ?>' border='0' tabindex='6' /></a>
	


</form>
<?php

if(count($rsReport))
{	
	$start_data = ($pn-1) * $limit;    
	$end_data = $start_data + ($limit - 1);
	$end_data = ($end_data > (count($rsReport)-1) ) ?(count($rsReport)-1) : $end_data;
	
	?>

<link rel="stylesheet" type="text/css" href="<?php echo $css_path.'adr_cs.css'; ?>">

 <table class="ex_pn">
	<tr>
		<td><h3 class="grap">Country Statistics</h3></td>
		<td class="soul"><a  href="djax_dspcountrystats_export.php?start_date=<?php echo $start_date;?>&end_date=<?php echo $end_date;?>&startAt=<?php echo $startAt; ?>&limit=<?php echo $limit; ?>"><img src="<?php echo $image_path.'excel.gif'; ?>">Download All Data</a></td>
		<td class="soul"><a  href="djax_dspcountrystats_export.php?start_date=<?php echo $start_date;?>&end_date=<?php echo $end_date;?>"><img src="<?php echo $image_path.'excel.gif'; ?>">Download Current Page Data </a></td>
	</tr>
	
 </table>


  <table cellspacing="0" cellpadding="0" border="0" width="100%" class="tableAdvanced">
	  <thead>
	<tr>
		<th>DSP Buyer Name</th>
		<th>Country</th>
		<th>Request</th>
		<th>Response</th>
		<th>Win Notice</th> 
		<th>Amount</th>     
             
	</tr>
	  </thead>
	    </tbody>
            
<?php

foreach($rsReport as $Report)
{
	?>
	<tr>
		<td><strong class="bk-tile"><?php echo $ad_exchange[$Report['dsp_buyer_id']];?></strong></td>
		<td><strong class="bk-tile"><?php echo $country[$Report['country']];?></strong></td>
		<td><?php  echo $Report['request'];?></td>
		<td><?php  echo $Report['response']; ?></td>
		<td><?php  echo $Report['win_notice']; ?></td>
		<td><?php  echo $Report['price']; ?></td>
    </tr>
    <?php
}
?>
</tbody>
</table>

<?php

      	$total_records = count($rsTotalReport) ;   
		$data = $pPass;
		if($data['p']){ unset($data['p']); };
		if($data) { $data = '&amp;'.http_build_query($data,'&amp;'); } else { $data=""; }
        $total_pages = ceil($total_records / $limit);
        
        if($total_pages > 1)
        {
		
		echo "<ul class='pgn-oper'> ";

        $k = (($pn+3>$total_pages)?$total_pages-3:(($pn-3<1)?4:$pn));     
        $pagLink = ""; 
        if($pn>=2){ 
            echo "<li><a href='?p=1".$data."'>First</a></li>"; 
            echo "<li><a href='?p=".($pn-1).$data."'> Previous </a></li>"; 
        } 
        else
		{
			 echo "<li class='unRead' ><a >First</a></li>"; 
			 echo "<li  class='unRead' ><a > Previous </a></li>";
		}
		
		
		if($total_pages > 7){  $ic= -3 ; $ic_limit = 3;	}	 else  {$ic = 1; $ic_limit = $total_pages;  $k = 0;   }
		
        for ($i=$ic; $i<=$ic_limit; $i++) {  
          if($k+$i==$pn) 
            $pagLink .= "<li class='active'><a  >".($k+$i)."</a></li>"; 
          else
            $pagLink .= "<li><a href='?p=".($k+$i).$data."'>".($k+$i)."</a></li>";   
        }
		
           
        echo $pagLink; 
        if($pn<$total_pages){ 
            echo "<li><a href='?p=".($pn+1).$data."'> Next </a></li>"; 
            echo "<li><a href='?p=".$total_pages.$data."'> Last </a></li>"; 
        }  
        else
		{
			 echo "<li class='unRead' ><a >Next</a></li>"; 
			 echo "<li  class='unRead' ><a > Last </a></li>";
		}
        
       echo " </ul> ";
       

	}

}else{
	
	echo '<div class="errormessage none-of"><img  src="'.$image_path.'info.gif" >There are currently no statistics available</div>';	
	
}

?>






        <script type='text/javascript'>
     
        Calendar.setup({
            inputField : 'period_start',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_start_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });
        Calendar.setup({
            inputField : 'period_end',
            ifFormat   : '%Y-%m-%d',
            button     : 'period_end_button',
            align      : 'Bl',
            weekNumbers: false,
            firstDay   : 1,
            electric   : false
        });

       
      
 function periodFormChange(bAutoSubmit)
        {
 	    var o = document.getElementById('period_preset');
            var periodSelectName = o.options[o.selectedIndex].value;
            var specific = periodSelectName == 'specific';
 	    var periodTabIndex = 2;

		document.getElementById('period_start').readOnly = !specific;
            document.getElementById('period_start_button').disabled = !specific;
            document.getElementById('period_end').readOnly = !specific;
            document.getElementById('period_end_button').disabled = !specific;
           
		   if (!specific) {
				if(bAutoSubmit)
				{
					document.getElementById('period_start').disabled = true;
					document.getElementById('period_end').disabled =  true;	
				}
				
                document.getElementById('period_start').classList.add("disapp");
                document.getElementById('period_end').classList.add("disapp");
                document.getElementById('period_start').tabIndex = null;
                document.getElementById('period_start_button').tabIndex = null;
                document.getElementById('period_end').tabIndex = null;
                document.getElementById('period_end_button').tabIndex = null;
				document.getElementById('period_start_button').src = '<?php echo $image_path.'icon-calendar-d.gif';  ?>';
				document.getElementById('period_end_button').src = '<?php echo $image_path.'icon-calendar-d.gif';  ?>' ;

            } else {
                document.getElementById('period_start').classList.remove("disapp");
                document.getElementById('period_end').classList.remove("disapp");
                document.getElementById('period_start').tabIndex = periodTabIndex;
                document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
                document.getElementById('period_end').tabIndex = periodTabIndex + 2;
                document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
	        document.getElementById('period_start_button').src = '<?php echo $image_path.'icon-calendar.gif';  ?>';
           	document.getElementById('period_end_button').src = '<?php echo $image_path.'icon-calendar.gif';  ?>' ;
            }

            document.getElementById('period_start_button').readOnly = !specific;
            document.getElementById('period_end_button').readOnly = !specific;
          
            document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
            document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';

            if (!specific && bAutoSubmit) {
                o.form.submit();
            }
}
periodFormChange(0);

    function periodFormSubmit() {
            var form = document.getElementById('period_preset').form;
            if (checkDates(form)) {
		
              form.submit();
            }
            return false;
        }
    function checkDates(form)
        {
          var startField = form.period_start;
          var endField = form.period_end;

          if (!startField.disabled && startField.value != '') {
            var start = Date.parseDate(startField.value, '%Y-%m-%d');
          }
          if (!startField.disabled && endField.value != '') {
            var end = Date.parseDate(endField.value, '%Y-%m-%d');
          }

          if ((start != undefined && end != undefined) && (start.getTime() > end.getTime())) {
            alert('\'From\' date must be earlier then \'To\' date');
            return false;
          }
          return true;
        }
       
</script>
        
       <?php

phpAds_PageFooter();
?>
