<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';
require_once MAX_PATH . '/lib/OX/Util/Utils.php';

// Required files
require_once MAX_PATH . '/www/admin/lib-maintenance-priority.inc.php';
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/OA/Dll.php';
require_once MAX_PATH . '/lib/max/Dal/DataObjects/Campaigns.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/OA/Permission.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/OX/Admin/UI/ViewHooks.php';

require_once RV_PATH . '/lib/RV/Admin/DateTimeFormat.php';

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

phpAds_registerGlobalUnslashed('hideinactive', 'listorder', 'orderdirection');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_ADVERTISER);
if (!empty($clientid) && !OA_Permission::hasAccessToObject('clients', $clientid, OA_Permission::OPERATION_VIEW)) { //check if can see given advertiser
    $page = basename($_SERVER['SCRIPT_NAME']);
    OX_Admin_Redirect::redirect($page);
}


if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}


/*-------------------------------------------------------*/
/* Init data                                             */
/*-------------------------------------------------------*/
//get advertisers and set the current one
$aAdvertisers = getAdvertiserMap();
if (empty($clientid)) { //if it's empty
    if ($session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid']) {
        //try previous one from session
        $sessionClientId = $session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'];
        if (isset($aAdvertisers[$sessionClientId])) { //check if 'id' from session was not removed
            $clientid = $sessionClientId;
        }
    }
    if (empty($clientid)) { //was empty, is still empty - just pick one, no need for redirect
        $ids = array_keys($aAdvertisers);
        $clientid = !empty($ids) ? $ids[0] : -1; //if no advertisers set to non-existent id
    }
}
else {
    if (!isset($aAdvertisers[$clientid])) {
        $page = basename($_SERVER['SCRIPT_NAME']);
        OX_Admin_Redirect::redirect($page);
    }
}


/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

$oHeaderModel = buildHeaderModel($clientid, $aAdvertisers);
phpAds_PageHeader(null, $oHeaderModel);


/*-------------------------------------------------------*/
/* Get preferences                                       */
/*-------------------------------------------------------*/

if (!isset($hideinactive)) {
	if (isset($session['prefs']['advertiser-campaigns.php'][$clientid]['hideinactive'])) {
		$hideinactive = $session['prefs']['advertiser-campaigns.php'][$clientid]['hideinactive'];
	} else {
	   $pref = &$GLOBALS['_MAX']['PREF'];
	   $hideinactive = ($pref['ui_hide_inactive'] == true);
	}
}

if (!isset($listorder)) {
	if (isset($session['prefs']['advertiser-campaigns.php'][$clientid]['listorder'])) {
		$listorder = $session['prefs']['advertiser-campaigns.php'][$clientid]['listorder'];
	} else {
		$listorder = '';
	}
}

if (!isset($orderdirection)) {
	if (isset($session['prefs']['advertiser-campaigns.php'][$clientid]['orderdirection'])) {
		$orderdirection = $session['prefs']['advertiser-campaigns.php'][$clientid]['orderdirection'];
	} else {
		$orderdirection = '';
	}
}


/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

require_once MAX_PATH . '/lib/OA/Admin/Template.php';

$oTpl = new OA_Admin_Template('campaign-index.html');


// Get clients & campaign and build the tree
$dalCampaigns = OA_Dal::factoryDAL('campaigns');
$aCampaigns = $dalCampaigns->getClientCampaigns($clientid, $listorder, $orderdirection, array(DataObjects_Campaigns::CAMPAIGN_TYPE_MARKET_CONTRACT));
foreach ($aCampaigns as $campaignId => $aCampaign) {
    $aCampaign['impressions']  = phpAds_formatNumber($aCampaign['views']);
    $aCampaign['clicks']       = phpAds_formatNumber($aCampaign['clicks']);
    $aCampaign['conversions']  = phpAds_formatNumber($aCampaign['conversions']);

    if (!empty($aCampaign['activate_time'])) {
        $aCampaign['activate'] = RV_Admin_DateTimeFormat::formatUTCDate($aCampaign['activate_time']);
    } else {
        $aCampaign['activate'] = '-';
    }

    if (!empty($aCampaign['expire_time'])) {
        $aCampaign['expire'] = RV_Admin_DateTimeFormat::formatUTCDate($aCampaign['expire_time']);
    } else {
        $aCampaign['expire'] = '-';
    }
    
    if (!empty($aCampaign['updated'])) {
        $aCampaign['updated'] = RV_Admin_DateTimeFormat::formatUTCDateTime($aCampaign['updated']);
    }    

    if ($aCampaign['type'] == DataObjects_Campaigns::CAMPAIGN_TYPE_MARKET_CONTRACT) {
        $aCampaign['system'] = true;
        $aCampaign['type'] = OX_Util_Utils::getCampaignType($aCampaign['priority']);
    }
    else {
        $aCampaign['type'] = OX_Util_Utils::getCampaignType($aCampaign['priority']);
    }

    if ($aCampaign['priority'] == -1) {
        $aCampaign['priority'] = $strOverride;
    }
    elseif ($aCampaign['priority'] == -2) {
        $aCampaign['priority'] = $strCampaignECPM;
    }
    elseif ($aCampaign['priority'] == 0) {
        $aCampaign['priority'] = $strLow;
    }
    else {
        $aCampaign['priority'] = $strHigh . ' (' . $aCampaign['priority'] . ')';
    }

    $aCampaigns[$campaignId] = $aCampaign;

// START INVENTORY REMAINING
    $campaignid=$campaignId;

$camp=OA_Dal_Delivery_query("select * from ".$table_prefix."campaigns where campaignid = $campaignid ");
$res=OA_Dal_Delivery_fetchAssoc($camp);
$booked_views = $res['views'];
$booked_clicks = $res['clicks'];
$booked_conversions = $res['conversions'];

// Impression
if ($booked_views>0) {

$campaign=OA_Dal_Delivery_query("select * from ".$table_prefix."banners where campaignid = $campaignid ");
while($result=OA_Dal_Delivery_fetchAssoc($campaign)){
$bannerid = $result['bannerid'];

$impression=OA_Dal_Delivery_query("select sum(count) as count from ".$table_prefix."data_bkt_m where creative_id = $bannerid ");
$result1=OA_Dal_Delivery_fetchAssoc($impression);
$count = $result1['count'];


$hourly=OA_Dal_Delivery_query("select sum(impressions) as impressions from ".$table_prefix."data_summary_ad_hourly where ad_id = $bannerid ");
$result2=OA_Dal_Delivery_fetchAssoc($hourly);
$impressions = $result2['impressions'];


}

$total_impression = $impressions+$count;
$imp_rem = $booked_views - $total_impression;

if ($imp_rem>=0) {
    $rem_imp = $imp_rem;
} else {
    $rem_imp = '0';
}

} 


// Clicks
if ($booked_clicks>0) {

$campaign_clicks=OA_Dal_Delivery_query("select * from ".$table_prefix."banners where campaignid = $campaignid ");
while($result_clicks=OA_Dal_Delivery_fetchAssoc($campaign_clicks)){
$bannerid = $result_clicks['bannerid'];

$click=OA_Dal_Delivery_query("select sum(count) as count from ".$table_prefix."data_bkt_c where creative_id = $bannerid ");
$result1_click=OA_Dal_Delivery_fetchAssoc($click);
$count = $result1_click['count'];

 
$hourly=OA_Dal_Delivery_query("select sum(clicks) as clicks from ".$table_prefix."data_summary_ad_hourly where ad_id = $bannerid ");
$result2_click=OA_Dal_Delivery_fetchAssoc($hourly);
$clicks = $result2_click['clicks'];

}

$total_clicks = $clicks+$count;
$click_rem = $booked_clicks - $total_clicks;

if ($click_rem>=0) {
    $rem_click = $click_rem;
} else {
    $rem_click = '0';
}

} 


// conversion
if ($booked_conversions>0) {

$campaign_conversion=OA_Dal_Delivery_query("select * from ".$table_prefix."banners where campaignid = $campaignid ");
while($result_conversion=OA_Dal_Delivery_fetchAssoc($campaign_conversion)){
$bannerid = $result_conversion['bannerid'];

$conversion=OA_Dal_Delivery_query("select * from ".$table_prefix."data_bkt_a where creative_id = $bannerid ");
$number=OA_Dal_Delivery_numRows($conversion);

$hourly=OA_Dal_Delivery_query("select sum(conversions) as conversions from ".$table_prefix."data_summary_ad_hourly where ad_id = $bannerid ");
$result2_conversions=OA_Dal_Delivery_fetchAssoc($hourly);
$conversions = $result2_conversions['conversions'];

}

$total_conversion = $number + $conversions;
$con_rem = $booked_conversions - $total_conversion;

if ($con_rem>=0) {
    $rem_con = $con_rem;
} else {
    $rem_con = '0';
}

} 

$aCampaigns[$campaignId]["rem_imp"] = $rem_imp;
$aCampaigns[$campaignId]["rem_click"] = $rem_click;
$aCampaigns[$campaignId]["rem_con"] = $rem_con;



// END INVENTORY REMAINING



}

$aCount = array(
    'campaigns'        => 0,
    'campaigns_hidden' => 0,
);

$campaignshidden = 0;
if (isset($aCampaigns) && is_array($aCampaigns) && count($aCampaigns) > 0) {
    reset ($aCampaigns);
    while (list ($key, $campaign) = each ($aCampaigns)) {
        $aCount['campaigns']++;
        if ($hideinactive == true && ($campaign['status'] != OA_ENTITY_STATUS_RUNNING || $campaign['status'] == OA_ENTITY_STATUS_RUNNING &&
            count($campaign['banners']) == 0 && count($campaign['banners']) < $campaign['count'])) {
            $aCount['campaigns_hidden']++;
            unset($aCampaigns[$key]);
        }
    }
}
//DAC - custom start
if($GLOBALS['_MAX']['CONF']['plugins']['DeliveryOptions']==1)
{
$is_delivery_options_enabled=1;
}
else
{
$is_delivery_options_enabled=0;
}
//DAC custom end

$oTpl->assign('clientId', $clientid);
$oTpl->assign('aCampaigns', $aCampaigns);
$oTpl->assign('is_delivery_options_enabled',$is_delivery_options_enabled);
//DAC - custom work - start
if($GLOBALS['_MAX']['CONF']['plugins']['RTB']==1)
{
$oTpl->assign('is_rtb_enabled',1);
}
//DAc-custom work -end
$oTpl->assign('aCount', $aCount);
$oTpl->assign('hideinactive', $hideinactive);
$oTpl->assign('listorder', $listorder);
$oTpl->assign('orderdirection', $orderdirection);
$oTpl->assign('showconversions', $conf['logging']['trackerImpressions']);
$oTpl->assign('isAdvertiser', OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER));
$oTpl->assign('canEdit', OA_Permission::hasPermission(OA_PERM_BANNER_ACTIVATE) || OA_Permission::hasPermission(OA_PERM_BANNER_EDIT));
$oTpl->assign('canAddBan', OA_Permission::hasPermission(OA_ACCOUNT_ADVERTISER) || OA_Permission::hasPermission(OA_PERM_BAN_ADD));
$oTpl->assign('canAddCamp', OA_Permission::hasPermission(OA_PERM_CAMP_ADD));
$oTpl->assign('canEditCamp', OA_Permission::hasPermission(OA_PERM_CAMP_EDIT));
$oTpl->assign('canDelCamp', OA_Permission::hasPermission(OA_PERM_CAMP_DEL));
$oTpl->assign('isManager', OA_Permission::isAccount(OA_ACCOUNT_MANAGER));

///////////////////*DAC015-DJAX*///////////////////// 
// $oTpl->assign('isAdvertiser', 0); 

// $oTpl->assign('isManager', 1);
///////////////////*DAC015-DJAX*///////////////////// 

/*-------------------------------------------------------*/
/* Store preferences                                     */
/*-------------------------------------------------------*/

$session['prefs']['advertiser-campaigns.php'][$clientid]['hideinactive'] = $hideinactive;
$session['prefs']['advertiser-campaigns.php'][$clientid]['listorder'] = $listorder;
$session['prefs']['advertiser-campaigns.php'][$clientid]['orderdirection'] = $orderdirection;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
phpAds_SessionDataStore();


/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/
/** add view hooks **/
OX_Admin_UI_ViewHooks::registerPageView($oTpl, 'advertiser-campaigns',
    array('advertiserId' => $clientid));

$oTpl->display();
phpAds_PageFooter();



function buildHeaderModel($advertiserId, $aAllAdvertisers)
{
    if ($advertiserId) {
        $advertiser = phpAds_getClientDetails ($advertiserId);

        $advertiserName = $advertiser ['clientname'];
 
        if ($advertiser['type'] != DataObjects_Clients::ADVERTISER_TYPE_MARKET) {
            $advertiserEditUrl = "advertiser-edit.php?clientid=$advertiserId";
        }
    }
    $builder = new OA_Admin_UI_Model_InventoryPageHeaderModelBuilder();
    $oHeaderModel = $builder->buildEntityHeader(array(
        array ('name' => $advertiserName, 'url' => $advertiserEditUrl,
               'id' => $advertiserId, 'entities' => $aAllAdvertisers,
               'htmlName' => 'clientid'
              ),
        array('name' => '')
    ), 'campaigns', 'list');

    return $oHeaderModel;
}


function getAdvertiserMap()
{
    $aAdvertisers = array();
    $dalClients = OA_Dal::factoryDAL('clients');
    if (OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
        $agency_id = OA_Permission::getEntityId();
        $aAdvertisers = $dalClients->getAllAdvertisersForAgency($agency_id);
    }
    else if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
        $advertiserId = OA_Permission::getEntityId();
        $aAdvertiser = $dalClients->getAdvertiserDetails($advertiserId);
        $aAdvertisers[$advertiserId] = $aAdvertiser;
    }
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
    // DAC185 START
    $query_new=OA_Dal_Delivery_query("SELECT clientid,exchange_id from ".$table_prefix."campaigns  where exchange_id != ''");
	while($row_new = OA_Dal_Delivery_fetchAssoc($query_new)){
		unset($aAdvertisers[$row_new['clientid']]);
	}
	// DAC185 END
    $aAdvertiserMap = array();
	
    foreach ($aAdvertisers as $clientid => $aClient) {
        $aAdvertiserMap[$clientid] = array('name' => $aClient['clientname'],
            'url' => "advertiser-campaigns.php?clientid=".$clientid);
    }

    return $aAdvertiserMap;
}


?>

