<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Preferences.php';

require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';

require_once MAX_PATH . '/lib/OA/Admin/Statistics/Fields/Delivery/Affiliates.php';
require_once MAX_PATH . '/lib/OA/Admin/Statistics/Fields/Delivery/Default.php';
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
	{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
	{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
	{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN, OA_ACCOUNT_MANAGER, OA_ACCOUNT_ADVERTISER, OA_ACCOUNT_TRAFFICKER);

// Load the account's preferences, with additional information, into a specially named array
$GLOBALS['_MAX']['PREF_EXTRA'] = OA_Preferences::loadPreferences(true, true);

// Create a new option object for displaying the setting's page's HTML form
$oOptions = new OA_Admin_Option('preferences');
$prefSection = "user-interface";

$aStatisticsFieldsDelivery['affiliates'] = new OA_StatisticsFieldsDelivery_Affiliates();
$aStatisticsFieldsDelivery['default'] = new OA_StatisticsFieldsDelivery_Default();

// Prepare an array for storing error messages
$aErrormessage = array();
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
// If the settings page is a submission, deal with the form data
if (isset($_POST['submitok']) && $_POST['submitok'] == 'true') {
    // Prepare an array of the HTML elements to process, and which
    // of the preferences are checkboxes
    $aElements   = array();
	$aCheckboxes = array(
		'ui_show_campaign_info' 				=> $_POST['ui_show_campaign_info'],
		'ui_show_banner_info'					=> $_POST['ui_show_banner_info'],
		'ui_show_campaign_preview'				=> $_POST['ui_show_campaign_preview'],
		'ui_show_banner_html'					=> $_POST['ui_show_banner_html'],
		'ui_show_banner_preview'				=> $_POST['ui_show_banner_preview'],
		'ui_html_wyswyg_enabled'				=> $_POST['ui_html_wyswyg_enabled'],
		'ui_hide_inactive'						=> $_POST['ui_hide_inactive'],
		'ui_show_matching_banners'				=> $_POST['ui_show_matching_banners'],
		'ui_show_matching_banners_parents'		=> $_POST['ui_show_matching_banners_parents'],
		'ui_show_entity_id'						=> $_POST['ui_show_entity_id'],
		'ui_novice_user'						=> $_POST['ui_novice_user'],
		'ui_week_start_day'						=> $_POST['ui_week_start_day'],
		'ui_percentage_decimals'				=> $_POST['ui_percentage_decimals'],
		'ui_column_revenue'						=> $_POST['ui_column_revenue'],
		'ui_column_bv'							=> $_POST['ui_column_bv'],
		'ui_column_num_items'					=> $_POST['ui_column_num_items'],
		//~ 'ui_column_adid'						=> $_POST['ui_column_adid'],
		//'ui_column_ratingvalue'					=> $_POST['ui_column_ratingvalue'],
		'ui_column_pubrev'						=> $_POST['ui_column_pubrev'],
		'ui_column_revcpc'						=> $_POST['ui_column_revcpc'],
		'ui_column_erpm'						=> $_POST['ui_column_erpm'],
		'ui_column_erpc'						=> $_POST['ui_column_erpc'],
		'ui_column_erps'						=> $_POST['ui_column_erps'],
		'ui_column_eipm'						=> $_POST['ui_column_eipm'],
		'ui_column_eipc'						=> $_POST['ui_column_eipc'],
		'ui_column_eips'						=> $_POST['ui_column_eips'],
		'ui_column_ecpm'						=> $_POST['ui_column_ecpm'],
		'ui_column_ecpc'						=> $_POST['ui_column_ecpc'],
		'ui_column_ecps'						=> $_POST['ui_column_ecps'],
		'ui_column_id'							=> $_POST['ui_column_id'],
		'ui_column_requests'					=> $_POST['ui_column_requests'],
		'ui_column_impressions'					=> $_POST['ui_column_impressions'],
		'ui_column_clicks'						=> $_POST['ui_column_clicks'],
		'ui_column_ctr'							=> $_POST['ui_column_ctr'],
		'ui_column_conversions'					=> $_POST['ui_column_conversions'],
		'ui_column_conversions_pending'			=> $_POST['ui_column_conversions_pending'],
		'ui_column_sr_views'					=> $_POST['ui_column_sr_views'],
		'ui_column_sr_clicks'					=> $_POST['ui_column_sr_clicks'],		
		
		'ui_column_revenue_label'				=> $_POST['ui_column_revenue_label'],
		'ui_column_bv_label'					=> $_POST['ui_column_bv_label'],
		'ui_column_num_items_label'				=> $_POST['ui_column_num_items_label'],
		//~ 'ui_column_adid_label'					=> $_POST['ui_column_adid_label'],
		//'ui_column_ratingvalue_label'			=> $_POST['ui_column_ratingvalue_label'],
		'ui_column_pubrev_label'				=> $_POST['ui_column_pubrev_label'],
		'ui_column_revcpc_label'				=> $_POST['ui_column_revcpc_label'],
		'ui_column_erpm_label'					=> $_POST['ui_column_erpm_label'],
		'ui_column_erpc_label'					=> $_POST['ui_column_erpc_label'],
		'ui_column_erps_label'					=> $_POST['ui_column_erps_label'],
		'ui_column_eipm_label'					=> $_POST['ui_column_eipm_label'],
		'ui_column_eipc_label'					=> $_POST['ui_column_eipc_label'],
		'ui_column_eips_label'					=> $_POST['ui_column_eips_label'],
		'ui_column_ecpm_label'					=> $_POST['ui_column_ecpm_label'],
		'ui_column_ecpc_label'					=> $_POST['ui_column_ecpc_label'],
		'ui_column_ecps_label'					=> $_POST['ui_column_ecps_label'],
		'ui_column_id_label'					=> $_POST['ui_column_id_label'],
		'ui_column_requests_label'				=> $_POST['ui_column_requests_label'],
		'ui_column_impressions_label'			=> $_POST['ui_column_impressions_label'],
		'ui_column_clicks_label'				=> $_POST['ui_column_clicks_label'],
		'ui_column_ctr_label'					=> $_POST['ui_column_ctr_label'],
		'ui_column_conversions_label'			=> $_POST['ui_column_conversions_label'],
		'ui_column_conversions_pending_label'	=> $_POST['ui_column_conversions_pending_label'],
		'ui_column_sr_views_label'				=> $_POST['ui_column_sr_views_label'],
		'ui_column_sr_clicks_label'				=> $_POST['ui_column_sr_clicks_label'],		
		
		'ui_column_revenue_rank'				=> $_POST['ui_column_revenue_rank'],
		'ui_column_bv_rank'						=> $_POST['ui_column_bv_rank'],
		'ui_column_num_items_rank'				=> $_POST['ui_column_num_items_rank'],
		//~ 'ui_column_adid_rank'				=> $_POST['ui_column_adid_rank'],
		//'ui_column_ratingvalue_rank'			=> $_POST['ui_column_ratingvalue_rank'],
		'ui_column_pubrev_rank'					=> $_POST['ui_column_pubrev_rank'],
		'ui_column_revcpc_rank'					=> $_POST['ui_column_revcpc_rank'],
		'ui_column_erpm_rank'					=> $_POST['ui_column_erpm_rank'],
		'ui_column_erpc_rank'					=> $_POST['ui_column_erpc_rank'],
		'ui_column_erps_rank'					=> $_POST['ui_column_erps_rank'],
		'ui_column_eipm_rank'					=> $_POST['ui_column_eipm_rank'],
		'ui_column_eipc_rank'					=> $_POST['ui_column_eipc_rank'],
		'ui_column_eips_rank'					=> $_POST['ui_column_eips_rank'],
		'ui_column_ecpm_rank'					=> $_POST['ui_column_ecpm_rank'],
		'ui_column_ecpc_rank'					=> $_POST['ui_column_ecpc_rank'],
		'ui_column_ecps_rank'					=> $_POST['ui_column_ecps_rank'],
		'ui_column_id_rank'						=> $_POST['ui_column_id_rank'],
		'ui_column_requests_rank'				=> $_POST['ui_column_requests_rank'],
		'ui_column_impressions_rank'			=> $_POST['ui_column_impressions_rank'],
		'ui_column_clicks_rank'					=> $_POST['ui_column_clicks_rank'],
		'ui_column_ctr_rank'					=> $_POST['ui_column_ctr_rank'],
		'ui_column_conversions_rank'			=> $_POST['ui_column_conversions_rank'],
		'ui_column_conversions_pending_rank'	=> $_POST['ui_column_conversions_pending_rank'],
		'ui_column_sr_views_rank'				=> $_POST['ui_column_sr_views_rank'],
		'ui_column_sr_clicks_rank'				=> $_POST['ui_column_sr_clicks_rank'],
	);
 	
    /*foreach ($aStatisticsFieldsDelivery as $obj) {
        $aVars = $obj->getVisibilitySettings();
        $aSuffixes = array('_label', '_rank');
        foreach (array_keys($aVars) as $name) {
            $aElements[] = $name;
            $aCheckboxes[$name] = true;
            foreach ($aSuffixes as $suffix) {
                $aElements[] = $name.$suffix;
            }
        }
    }*/
 
    //~ Custom code
	$j=0;    
    $currentAccountId = OA_Permission::getAccountId(); 
    $query = OA_Dal_Delivery_query("SELECT a.preference_id,a.preference_name,b.preference_id FROM `{$table_prefix}preferences` as a inner join {$table_prefix}account_preference_assoc as b on b.preference_id=a.preference_id");
    $query1 = OA_Dal_Delivery_query("SELECT a.preference_name FROM `{$table_prefix}preferences` as a inner join {$table_prefix}account_preference_assoc as b on b.preference_id=a.preference_id where b.account_id={$currentAccountId}");
    $arr = $arr1 = array();
    while($row = OA_Dal_Delivery_fetchAssoc($query)){	
		$arr[]=$row;	
	}
    while($row1 = OA_Dal_Delivery_fetchAssoc($query1)){	
		$arr1[]=$row1['preference_name'];	
	}
	foreach($aCheckboxes as $key => $value){
		foreach($arr as $key1 => $value1){		
			if($value1['preference_name']==$key){
				if($value == true){			
					OA_Dal_Delivery_query("update {$table_prefix}account_preference_assoc set value = '{$value}' where preference_id={$value1['preference_id']} and account_id = {$currentAccountId}");
				}
				else{	
					OA_Dal_Delivery_query("update {$table_prefix}account_preference_assoc set value = '' where preference_id={$value1['preference_id']} and account_id = {$currentAccountId}");	
				}					
			}			
		}
		if(!in_array($key, $arr1)){
			$q[$j]=OA_Dal_Delivery_query("select preference_id from  {$table_prefix}preferences where preference_name = '{$key}'");
			$r[$j]=OA_Dal_Delivery_fetchAssoc($q[$j]);			
			if($value == true){				
				OA_Dal_Delivery_query("insert into {$table_prefix}account_preference_assoc(account_id,preference_id,value) values({$currentAccountId},{$r[$j]['preference_id']},'{$value}')");	
			}
			else{					
				OA_Dal_Delivery_query("insert into {$table_prefix}account_preference_assoc(account_id,preference_id,value) values({$currentAccountId},{$r[$j]['preference_id']},'')");					
			}				
		}
		$j++;		
	}
	$result=true;
	//~ End Custom code
	
	
	
    // Save the preferences
    //~ $result = OA_Preferences::processPreferencesFromForm($aElements, $aCheckboxes);
    if ($result) {
        // Queue confirmation message
        $setPref = $oOptions->getSettingsPreferences($prefSection);
        $title = $setPref[$prefSection]['name'];
        $translation = new OX_Translation ();
        $translated_message = $translation->translate($GLOBALS['strXPreferencesHaveBeenUpdated'],
            array(htmlspecialchars($title)));
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
        OX_Admin_Redirect::redirect(basename($_SERVER['SCRIPT_NAME']));
    }
    // Could not write the preferences to the database, store this
    // error message and continue
    $aErrormessage[0][] = $strUnableToWritePrefs;
}

// Set the correct section of the preference pages and display the drop-down menu
$setPref = $oOptions->getSettingsPreferences($prefSection);
$title = $setPref[$prefSection]['name'];

// Display the settings page's header and sections
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('account-preferences-index', $oHeaderModel);

// Prepare an array of columns to be used shortly
$aStatistics = array();
foreach ($aStatisticsFieldsDelivery as $obj) {
    $aVars = $obj->getVisibilitySettings();
    foreach ($aVars as $name => $text) {
        $aStatistics[] = array(
            'text' => $text,
            'name' => $name
        );
    }
}

// Prepare an array of HTML elements to display for the form, and
// output using the $oOption object
$aSettings = array (
    array (
        'text'  => $strInventory,
        'items' => array (
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_show_campaign_info',
                'text'  => $strShowCampaignInfo
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_show_banner_info',
                'text'  => $strShowBannerInfo
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_show_campaign_preview',
                'text'  => $strShowCampaignPreview
            ),
            array (
                'type'  => 'break'
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_show_banner_html',
                'text'  => $strShowBannerHTML
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_show_banner_preview',
                'text'  => $strShowBannerPreview
            ),
            array (
                'type'  => 'break'
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_html_wyswyg_enabled',
                'text'  => $strUseWyswygHtmlEditorByDefault,
            ),
            array (
                'type'  => 'break'
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_hide_inactive',
                'text'  => $strHideInactive
            ),
            array (
                'type'  => 'break'
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_show_matching_banners',
                'text'  => $strGUIShowMatchingBanners
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_show_matching_banners_parents',
                'text'  => $strGUIShowParentCampaigns
            ),
            array (
                'type'  => 'break'
            ),
            array (
                'type'  => 'checkbox',
                'name'  => 'ui_show_entity_id',
                'text'  => $strShowEntityId
            )
        )
    ),
    array (
        'text'  => $strConfirmationUI,
        'items' => array (
             array (
                'type'    => 'checkbox',
                'name'    => 'ui_novice_user',
                'text'    => $strNovice
            ),
        )
    ),
    array (
        'text'  => $strStatisticsDefaults,
        'items' => array (
            array (
                'type'  => 'select',
                'name'  => 'ui_week_start_day',
                'text'  => $strBeginOfWeek,
                'items' => array($strDayFullNames[0], $strDayFullNames[1])
            ),
            array (
                'type'  => 'break'
            ),
            array (
                'type'  => 'select',
                'name'  => 'ui_percentage_decimals',
                'text'  => $strPercentageDecimals,
                'items' => array(0, 1, 2, 3)
            ),
            array (
                'type'  => 'break'
            ),
            array(
                'type'  => 'statscolumns',
                'name'  => '',
                'rows'  => $aStatistics
            )
        )
    )
);
$oOptions->show($aSettings, $aErrormessage);

// Display the page footer
phpAds_PageFooter();

?>
