<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    Plugin
 * @subpackage openxDeliveryLog
 */

	
MAX_Dal_Delivery_Include();

/**
 * A function to log conversions.
 *
 * @param integer $trackerId The ID of the tracker for which the conversion is to be logged.
 * @param array $serverRawIp The "raw IP address" value to use for the conversion.
 * @param array $aConversion An array of the conversion details, as returned from the
 *                           MAX_trackerCheckForValidAction() function.
 * @return array An array...
 */

function Plugin_deliveryLog_oxLogConversion_logConversion_Delivery_logConversion($trackerId, $serverRawIp, $aConversion, $okToLog = true)
{
	if (!$okToLog) { return false; }

        $aConf = $GLOBALS['_MAX']['CONF'];
	
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
	
	$results=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select c.clientid,c.revenue_type,c.revenue,cl.is_house_ads as housead from ".$table_prefix."campaigns as c,".$table_prefix."banners as b,".$table_prefix."clients as cl where b.campaignid=c.campaignid and cl.clientid=c.clientid and b.bannerid='".$aConversion['cid']."'"));
	if($results['housead']!=1)
	{
	$method = $results['dj_payment_method'];
	$id = $results['clientid'];
	$type = $results['revenue_type'];
	$amt = $results['revenue'];
	$damt = $results['deposit_amount'];
	$win_bid = $amt;
	$tracker_parameter=$aConversion['cid'].'_'. $aConversion['zid'];
	$request_id=(!empty($_REQUEST['request_id']))?$_REQUEST['request_id']:$_COOKIE['OXLCR'][$tracker_parameter];

	
     if(!empty($win_bid))
    {
    	 $getpubshare=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select pubshare from ".$table_prefix."dj_admin_configuration"));
			$publishershare = $getpubshare['pubshare'];
				
//$pub_share=$win_bid*($publishershare/100);			
	     $pub_share=0;
    }
     else 
     {
     	     $pub_share=0;
     }
	if(empty($request_id))
	{
	$djaxdate=gmdate('Y-m-d H:i:s', $time);
	$results=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select dj_win_bid,cost from {$aConf['table']['prefix']}data_bkt_a where date_time='".$djaxdate."' and creative_id='".(int)$aConversion['cid']."' and zone_id='".(int)$aConversion['zid']."'"));
	$win_bid=$results['dj_win_bid']+$win_bid;
	$pub_share=$results['cost']+$pub_share;
	OA_Dal_Delivery_query("update {$aConf['table']['prefix']}data_bkt_a set dj_win_bid='$win_bid',cost='$pub_share' where date_time='".$djaxdate."' and creative_id='".(int)$aConversion['cid']."' and zone_id='".(int)$aConversion['zid']."'");
	}
    }
    // Initiate the connection to the database (before using mysql_real_escape_string)
 	OA_Dal_Delivery_connect('rawDatabase');

    $table = $GLOBALS['_MAX']['CONF']['table']['prefix'] . 'data_bkt_a';

    if (empty($GLOBALS['_MAX']['NOW'])) {
        $GLOBALS['_MAX']['NOW'] = time();
    }
    $time = $GLOBALS['_MAX']['NOW'];

	

    $aValues = array(
        'server_ip'        => $serverRawIp,
        'tracker_id'       => (int)$trackerId,
        'date_time'        => gmdate('Y-m-d H:i:s', $time),
        'action_date_time' => gmdate('Y-m-d H:i:s', $aConversion['dt']),
        'creative_id'      => (int)$aConversion['cid'],
        'zone_id'          => (int)$aConversion['zid'],
        'ip_address'       => $_SERVER['REMOTE_ADDR'],
        'dj_request_id'	   => $request_id,
	'dj_win_bid'	   => $win_bid,
        'cost'             => $pub_share,
        'action'           => $aConversion['action_type'],
        'window'           => $aConversion['window'],
        'status'           => $aConversion['status']
    );
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

	$campaig_Qry=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT c.campaignid AS camp_id,c.revenue_type as revenue_type FROM ".$table_prefix."campaigns as c,".$table_prefix."banners as b WHERE b.bannerid='".$aConversion['cid']."' AND b.campaignid=c.campaignid "));
						
			
	
	$cookie_name = "djaxretarget_".$campaig_Qry['camp_id'];
	
	
	if(!empty($_COOKIE[$cookie_name]))
		{
			 setcookie($cookie_name, null, -1, '/');
		}
    // Need to also escape identifier as "window" is reserved since PgSQL 8.4
    $aFields = array_map('OX_escapeIdentifier', array_keys($aValues));
    $aValues = array_map('OX_escapeString', $aValues);

    $query = "
        INSERT INTO
            {$table}
            (" . implode(', ', $aFields) . ")
        VALUES
            ('" . implode("', '", $aValues) . "')
    ";
    $result = OA_Dal_Delivery_query($query, 'rawDatabase');
    if (!$result) {
        return false;
    }
    $aResult = array(
        'server_conv_id' => OA_Dal_Delivery_insertId('rawDatabase', $table, 'server_conv_id'),
        'server_raw_ip' => $serverRawIp
    );
    return $aResult;
}

?>
