<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once RV_PATH . '/lib/RV.php';

require_once MAX_PATH . '/lib/OA.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * @package    OpenXPlugin
 * @subpackage Plugins_BannerTypes
 * @abstract
 */
class Plugins_BannerTypeHTML_oxHtml_360banner extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
    function getOptionDescription()
    {
        return $this->translate("360 Deg Banner");
    }




 function validateForm(&$form)
    {
        return true;
    }


	function processForm($insert, $bannerid, $aFields ,$aVariables)
    {
		
	
		if($aFields['parameters'] && unserialize($aFields['parameters']))
		{
				$details =  unserialize($aFields['parameters']);
		}
		else
		{
				$details = array();
		}
		$aFields['type'] = 'web';
		$details['banner_type'] = $aFields['banner_type'];
		$details['cly_speed'] = $aFields['cly_speed'];
		$details['clu_speed'] = $aFields['clu_speed'];
	
		
		if (!empty($_FILES['cly_upload']) && $_FILES['cly_upload']['size'] > 0) 
		{		 //TODO refactor upload to be a valid quickform elem
				$oFile = OA_Creative_File::factoryUploadedFile('cly_upload');
				checkForErrorFileUploaded($oFile);
				$oFile->store($aFields['type']);
				$aFile = $oFile->getFileDetails();

				if (!empty($aFile)) {
					$details['banner_details']['cly']['filename']      = $aFile['filename'];
					$details['banner_details']['cly']['contenttype']   = 'png';
				}

				$details['banner_details']['cly']['width']         = $aFile['width'];
				$details['banner_details']['cly']['height']        = $aFile['height'];
				
			
				//~ // Delete old file for this banner
				//~ if (!empty($aBanner['cly_filename']) && ($aBanner['cly_filename'] != $aFile['cly_filename'])) {
					//~ DataObjects_Banners::deleteBannerFile($aBanner['storagetype'], $aBanner['cly_filename']);
				//~ }
				
		}
		
		
		for($i=0;$i<6;$i++)
		{
     
     
			if (!empty($_FILES['clu_'.$i.'_upload']) && $_FILES['clu_'.$i.'_upload']['size'] > 0) 
			{		 //TODO refactor upload to be a valid quickform elem
				$oFile = OA_Creative_File::factoryUploadedFile('clu_'.$i.'_upload');
				checkForErrorFileUploaded($oFile);
				$oFile->store($aFields['type']);
				$aFile = $oFile->getFileDetails();

				if (!empty($aFile)) {
					$details['banner_details']['clu'][$i]['filename']      = $aFile['filename'];
					$details['banner_details']['clu'][$i]['contenttype']   = 'png';
				}

				$details['banner_details']['clu'][$i]['width']         = $aFile['width'];
				$details['banner_details']['clu'][$i]['height']        = $aFile['height'];
				
			
				//~ // Delete old file for this banner
				//~ if (!empty($aBanner['cly_filename']) && ($aBanner['cly_filename'] != $aFile['cly_filename'])) {
					//~ DataObjects_Banners::deleteBannerFile($aBanner['storagetype'], $aBanner['cly_filename']);
				//~ }
				
			}
     
     
     
     
		}
 
		
		
		$aVariables['parameters'] = serialize($details);
		

		$doBanners = OA_Dal::factoryDO('banners');
			// Get existing banner details
		if (!empty($bannerid)) 
		{
			if ($doBanners->get($bannerid)) 
			{
				$aBanner = $doBanners->toArray();
			}
		}
		
		$doBanners->setFrom($aVariables);			
		$doBanners->update();
		return true;
    }
    
    
    function buildForm(&$form, &$row)
    {
      
      if($row['parameters'] && unserialize($row['parameters']))
      {
		  $params = unserialize($row['parameters']);
		  
		  $row['banner_type'] = $params['banner_type'];
		  $row['cly_speed'] = $params['cly_speed'];
		  $row['clu_speed'] = $params['clu_speed'];
		  
		  if($params['banner_details']['cly'])
		  {
			  foreach($params['banner_details']['cly'] as $k=>$v)
			  {
				   $row['cly_'.$k] = $v;
			  }
		  }
		  
		   if($params['banner_details']['clu'])
		  {
			  foreach($params['banner_details']['clu'] as $i=>$ii)
			  {
					foreach($ii as $k=>$v)
					{
						$row['clu_'.$i.'_'.$k] = $v;
					}
			  }
		  }
	  }
	  
	 
    $form->addElement ( 'header', 'banner_heading', 'Banner Details' );
    $banner_type =  $row['banner_type'] = ($row['banner_type']) ? $row['banner_type'] : 0;
        
    $expDateGroup ['banner_type_cy'] = $form->createElement ( 'radio', 'banner_type', null, 'Cylinder', '0', array ('id' => 'banner_type_cy' ,'onclick' => 'return bannertypechange(\'cy\')') );
    $expDateGroup ['banner_type_cu'] = $form->createElement ( 'radio', 'banner_type', null, 'Cube', '1', array ('id' => 'banner_type_cu'  ,'onclick' => 'return bannertypechange(\'cu\')') );
	$form->addGroup ( $expDateGroup, 'banner_type', 'Banner Type', array ("<br>", '', '' ) );
	
	
	
    $form->addElement ( 'header', 'banner_dum');
    //section decorator to allow hiding of the section
    $form->addDecorator ( 'banner_dum', 'tag', array ('attributes' => array ('id' => 'cy_ban_details' , 'class' => $banner_type ? 'hide' : ''   ) ) );

    //overr
		$type = 'web';
		
        $imageName = _getContentTypeIconImageName($row['cly_contenttype']);
        $size = _getBannerSizeText($type, $row['cly_filename']);
        
        addUploadGroup($form, $row,
            array(
                'uploadName' => 'cly_upload',
                'radioName' => 'cly_replaceimage',
                'imageName'  => $imageName,
                'fileName'  => $row['cly_filename'],
                'fileSize'  => $size,
                'newLabel'  => "Select the <b>Cylinder</b> Image ",
                'updateLabel'  => "Do you wish to keep your existing <b>Cylinder Image</b>, or do you want to upload another? ",
                'handleSWF' => true
              )
        ); 
        
        
        	        $form->addElement('html','html0', '<b style="    padding: 0px 30px;
        padding-bottom: 20px;    display: block;">Recomented Banner Sizes : 792 X 320 , 792 X 160<b>');



    $cly_speed['text'] = $form->createElement('text', 'cly_speed', null ,  array('size' => 2));
        
    $cly_speed['note'] = $form->createElement('html', null, ' Second');
    $form->addGroup($cly_speed, 'cly_speeds','Cyclinder Rotation Speed');

        
        
    $form->addElement ( 'header', 'banner_dum2');
    //section decorator to allow hiding of the section
    $form->addDecorator ( 'banner_dum2', 'tag', array ('attributes' => array ('id' => 'cu_ban_details' ,'class' => $banner_type ? '' : 'hide'   ) ) );

 
	for($i=0;$i<6;$i++)
	{
        $imageName = _getContentTypeIconImageName($row['clu_'.$i.'_contenttype']);
        $size = _getBannerSizeText($type, $row['clu_'.$i.'_filename']);
        
        addUploadGroup($form, $row,
            array(
                'uploadName' => 'clu_'.$i.'_upload',
                'radioName' => 'clu_'.$i.'_replaceimage',
                'imageName'  => $imageName,
                'fileName'  => $row['clu_'.$i.'_filename'],
                'fileSize'  => $size,
                'newLabel'  => "Select the <b>Cube ".($i+1)."</b> Image",
                'updateLabel'  => "Do you wish to keep your existing <b>Cube ".($i+1)." Image</b>, or do you want to upload another? ",
                'handleSWF' => true
              )
        ); 

	} 
	
	
	
        	        $form->addElement('html','html0', '<b style="    padding: 0px 30px;
        padding-bottom: 20px;    display: block;">Recomented square Banner Sizes : 100 X 100, 200 X 200 , 300 X 300 <b>');



    $cly_speed['text'] = $form->createElement('text', 'clu_speed', null ,  array('size' => 2));
        
    $cly_speed['note'] = $form->createElement('html', null, ' Second');
    $form->addGroup($cly_speed, 'clu_speeds','Cube Rotation Speed');
	
	
	
			$form->addElement('header', 'header_b_display', 'Banner display');
			$sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
			$sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
			$sizeG['width']->setSize(5);

			$sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
			$sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
			$sizeG['height']->setSize(5);
			$form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);
			
			$translation = new OX_Translation();
            $widthRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWidth'])), 'required');
            $widthPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strWidth'])), 'min', 1);
            $heightRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strHeight'])), 'required');
            $heightPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strHeight'])), 'min', 1);
            $numericRule = array($GLOBALS['strNumericField'] , 'numeric');

            $form->addGroupRule('size', array(
                'width' => array($widthRequiredRule, $numericRule, $widthPositiveRule),
                'height' => array($heightRequiredRule, $numericRule, $heightPositiveRule)));
			$form->addElement('text', 'url', "Destination URL"); 
			
	        $form->addElement('hidden', 'parameters', $row['parameters']);
	        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());


			$scrStyle  = <<<EOD
			
						 <style>
							#cy_ban_details table tr:nth-child(1) , #cu_ban_details table tr:nth-child(1) ,
							#cy_ban_details table tr:nth-child(3) , #cu_ban_details table tr:nth-child(3) 
							{
							    display: none;

							}
							
							#cy_ban_details table tr:nth-child(2) , #cu_ban_details table tr:nth-child(2) 
							{
							opacity:0;
							}
							
						 </style>
						 
						 <script>
							
							function bannertypechange(t)
							{
								if(t=='cu')
								{
									$('#cy_ban_details').addClass('hide');
									$('#cu_ban_details').removeClass('hide');
								}
								else
								{
									$('#cu_ban_details').addClass('hide');
									$('#cy_ban_details').removeClass('hide');
								}
							}
							
						 </script>
			
EOD;
	        $form->addElement('html','html1', $scrStyle);


  
    }
    

}

?>
