<?php
require_once MAX_PATH . '/lib/max/Delivery/limitations.php';
require_once MAX_PATH . '/lib/max/Delivery/adRender.php';
require_once MAX_PATH . '/lib/max/Delivery/cache.php';
require_once MAX_PATH . '/www/admin/plugins/rtb/djax_tracking.php';
require_once MAX_PATH . '/www/admin/plugins/rtb/ssp_rtbprocess.php';


define ("PRI_ECPM_FROM", 6);
define ("PRI_ECPM_TO", 9);

$GLOBALS['OX_adSelect_SkipOtherPriorityLevels'] = -1;
function MAX_adSelect($what, $campaignid = '', $target = '', $source = '', $withtext = 0, $charset = '', $context = array(), $richmedia = true, $ct0 = '', $loc = '', $referer = '')
{
	
	
    $conf = $GLOBALS['_MAX']['CONF'];

    // For local mode and XML-RPC calls the some parameters are not set in the global scope
    // So we need to override the empty globals with the values passed into this function.
    if (empty($GLOBALS['source'])) {
        $GLOBALS['source'] = $source;
    }
    if (empty($GLOBALS['loc'])) {
        $GLOBALS['loc'] = $loc;
    }

    // Store the original zone, campaign or banner IDs for later use
    $originalZoneId = null;
    if (strpos($what,'zone:') === 0) {
        $originalZoneId = intval(substr($what,5));
    } elseif (strpos($what,'campaignid:') === 0) {
        $originalCampaignId = intval(substr($what,11));
    } elseif (strpos($what, 'bannerid:') === 0) {
        $originalBannerId = intval(substr($what,9));
    }
    $userid = MAX_cookieGetUniqueViewerId();
    MAX_cookieAdd($conf['var']['viewerId'], $userid, _getTimeYearFromNow());
    $outputbuffer = '';
    // Set flag
    $found = false;
    // Reset followed zone chain
    $GLOBALS['_MAX']['followedChain'] = array();
    $GLOBALS['_MAX']['adChain'] = array();

    // Reset considered ads set
    $GLOBALS['_MAX']['considered_ads'] = array();

    $first = true;
    global $g_append, $g_prepend;
    $g_append = '';
    $g_prepend = '';
    if(!empty($what)) {
	    while ($first || ($what != '' && $found == false)) {
	        $first = false;
	        // Get first part, store second part
	        $ix = strpos($what, '|');
	        if ($ix === false) {
	            $remaining = '';
	        } else {
	            $remaining = substr($what, $ix+1);
	            $what = substr($what, 0, $ix);
	        }
	        if (strpos($what, 'zone:') === 0) {
	            $zoneId  = intval(substr($what,5));
	            $row = _adSelectZone($zoneId, $context, $source, $richmedia);
	        } else {
	            // Expand paths to regular statements
	            if (strpos($what, '/') > 0) {
	                if (strpos($what, '@') > 0) {
	                    list ($what, $append) = explode ('@', $what);
	                } else {
	                    $append = '';
	                }

	                $separate  = explode ('/', $what);
	                $expanded  = '';
	                $collected = array();

	                reset($separate);
	                while (list(,$v) = each($separate)) {
	                    $expanded .= ($expanded != '' ? ',+' : '') . $v;
	                    $collected[] = $expanded . ($append != '' ? ',+'.$append : '');
	                }

	                $what = strtok(implode('|', array_reverse ($collected)), '|');
	                $remaining = strtok('').($remaining != '' ? '|'.$remaining : '');
	            }

	            $row = _adSelectDirect($what, $campaignid, $context, $source, $richmedia, $remaining == '');
	        }
	        if (is_array($row) && empty($row['default'])) {
	            // Log the ad request
	            MAX_Delivery_log_logAdRequest($row['bannerid'], $row['zoneid'], $row);
	            if (($row['adserver'] == 'max' || $row['adserver'] == '3rdPartyServers:ox3rdPartyServers:max')
	                && preg_match("#{$conf['webpath']['delivery']}.*zoneid=([0-9]+)#", $row['htmltemplate'], $matches) && !stristr($row['htmltemplate'], $conf['file']['popup'])) {
	                // The ad selected was an OpenX HTML ad on the same server... do internal redirecty stuff
	                $GLOBALS['_MAX']['adChain'][] = $row;
	                $found = false;
	                $what = "zone:{$matches[1]}";
	            } else {
	                $found = true;
	            }
	        } else {
                    // Log the ad request
                    MAX_Delivery_log_logAdRequest(null, $originalZoneId, null);
                    $what  = $remaining;
	        }
	    }
    }

    // Return the banner information
    if ($found) {
        $zoneId = empty($row['zoneid']) ? 0 : $row['zoneid'];
        // For internal redirected creatives, make sure that any appended code in the adChain is appended
        if (!empty($GLOBALS['_MAX']['adChain'])) {
            foreach ($GLOBALS['_MAX']['adChain'] as $index => $ad) {
                if (($ad['ad_id'] != $row['ad_id']) && !empty($ad['append'])) {
                    $row['append'] .= $ad['append'];
                }
            }
        }
        $outputbuffer = MAX_adRender($row, $zoneId, $source, $target, $ct0, $withtext, $charset, true, true, $richmedia, $loc, $referer, $context);
 
        $output = array(
            'html'          => $outputbuffer,
            'bannerid'      => $row['bannerid'],
            'contenttype'   => $row['contenttype'],
            'alt'           => $row['alt'],
            'width'         => $row['width'],
            'height'        => $row['height'],
            'url'           => $row['url'],
            'campaignid'    => $row['campaignid'],
            'clickUrl'      => $row['clickUrl'],
            'logUrl'        => $row['logUrl'],
            'aSearch'       => $row['aSearch'],
            'aReplace'      => $row['aReplace'],
            'bannerContent' => $row['bannerContent'],
            'clickwindow'   => $row['clickwindow'],
            'aRow'          => $row,
            'context'       => _adSelectBuildContext($row, $context),
            'iframeFriendly' => (bool)$row['iframe_friendly'],
        );
        // Init block/capping fields to avoid notices below
        $row += array(
            'block_ad'             => 0,
            'cap_ad'               => 0,
            'session_cap_ad'       => 0,
            'block_campaign'       => 0,
            'cap_campaign'         => 0,
            'session_cap_campaign' => 0,
            'block_zone'           => 0,
            'cap_zone'             => 0,
            'session_cap_zone'     => 0,
        );
        // If ad-logging is disabled, the log beacon won't be sent, so set the capping at request
        if (MAX_Delivery_cookie_cappingOnRequest()) {
            if ($row['block_ad'] > 0 || $row['cap_ad'] > 0 || $row['session_cap_ad'] > 0) {
                MAX_Delivery_cookie_setCapping('Ad', $row['bannerid'], $row['block_ad'], $row['cap_ad'], $row['session_cap_ad']);
            }
            if ($row['block_campaign'] > 0 || $row['cap_campaign'] > 0 || $row['session_cap_campaign'] > 0) {
                MAX_Delivery_cookie_setCapping('Campaign', $row['campaign_id'], $row['block_campaign'], $row['cap_campaign'], $row['session_cap_campaign']);
            }
            if ($row['block_zone'] > 0 || $row['cap_zone'] > 0 || $row['session_cap_zone'] > 0) {
                MAX_Delivery_cookie_setCapping('Zone', $row['zoneid'], $row['block_zone'], $row['cap_zone'], $row['session_cap_zone']);
            }
            // Store the last view action event om the cookie as well (if required)
            MAX_Delivery_log_setLastAction(0, array($row['bannerid']), array($zoneId), array($row['viewwindow']));
        }
    } else {

        if (!empty($zoneId)) {
            // Blank impression beacon as global append
            $g_append = MAX_adRenderBlankBeacon($zoneId, $source, $loc, $referer).$g_append;

            // Try to fill the impression with a fallback from plugins
            $outputbuffer = join("\n", OX_Delivery_Common_hook('blankAdSelect', array($zoneId, $context, $source, $richmedia)) ?: []);
        }

        if (!empty($outputbuffer)) {
            // A fallback was provided by some plugin(s)
            $outputbuffer = $g_prepend . $outputbuffer . $g_append;
            $output = array('html' => $outputbuffer, 'bannerid' => '' );
        } elseif (!empty($row['default'])) {
            // Return the default banner
            if (empty($target)) {
                $target = '_blank';  // Default
            }
            $outputbuffer = $g_prepend . '<a href=\'' . $row['default_banner_destination_url'] . '\' target=\'' .
                            $target . '\'><img src=\'' . $row['default_banner_image_url'] .
                            '\' border=\'0\' alt=\'\'></a>' . $g_append;
            $output = array('html' => $outputbuffer, 'bannerid' => '', 'default_banner_image_url' => $row['default_banner_image_url'] );
        } elseif (!empty($conf['defaultBanner']['imageUrl'])) {
            // Return the default banner
            if (empty($target)) {
                $target = '_blank';  // Default
            }
            $outputbuffer = "{$g_prepend}<img src='{$conf['defaultBanner']['imageUrl']}' border='0' alt=''>{$g_append}";
            $output = array('html' => $outputbuffer, 'bannerid' => '', 'default_banner_image_url' => $conf['defaultBanner']['imageUrl']);
        } else {
            // No default banner was returned, return no banner
            $outputbuffer = $g_prepend . $g_append;
            $output = array('html' => $outputbuffer, 'bannerid' => '' );
        }
    }

	// post adSelect hook
    OX_Delivery_Common_hook('postAdSelect', array(&$output));
    return $output;
}

/**
 * This function selects an ad selected by direct selection
 *
 * @param string  $what         The search term being used to select the ad
 * @param string  $campaignid   The campaign ID to fecth banners from, added in 2.3.32 to allow BC with 2.0
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param string  $source       The "source" parameter passed into the adcall
 * @param boolean $richMedia    Does this invocation method allow for serving 3rd party/html ads
 * @param boolean $lastpart     Are there any other search strings left
 *
 * @return array|false          Returns an ad-array (see page DocBlock) or false if no ad found
 */
function _adSelectDirect($what, $campaignid = '', $context = array(), $source = '', $richMedia = true, $lastpart = true)
{
    $aDirectLinkedAdInfos = MAX_cacheGetLinkedAdInfos($what, $campaignid, $lastpart);

    // Set a flag to let the selection algorithm know that this is a direct request
    $GLOBALS['_MAX']['DIRECT_SELECTION'] = true;

    $aLinkedAd = _adSelectCommon($aDirectLinkedAdInfos, $context, $source, $richMedia);

    if (is_array($aLinkedAd)) {
        $aLinkedAd['zoneid'] = 0;
        $aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
        $aLinkedAd['storagetype'] = $aLinkedAd['type'];
        $aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];

        return $aLinkedAd;
    }
    // this looks broken...
    if (!empty($aDirectLinkedAdInfos['default_banner_image_url'])) {
        return array(
           'default'                        => true,
           'default_banner_image_url'       => $aDirectLinkedAdInfos['default_banner_image_url'],
           'default_banner_destination_url' => $aDirectLinkedAdInfos['default_banner_destination_url']
        );
    }

    return false;
}


/**
 * Returns an id of the next's zone in the chain specified in $arrZone
 * or $zoneId if there is no chained zone.
 *
 * @param int $zoneId Zone id to be returned if the chain was not found.
 * @param array $arrZone An associative array with an attribute 'chain' which
 *              contains zone's chain specification.
 * @return int Id of the next zone in the chain or $zoneId if there is no chain.
 */
function _getNextZone($zoneId, $arrZone)
{
    if (!empty($arrZone['chain']) && (substr($arrZone['chain'],0,5) == 'zone:')) {
        return intval(substr($arrZone['chain'],5));
    }
    else {
        return $zoneId;
    }
}

function _adSelectZone($zoneId, $context = array(), $source = '', $richMedia = true)
{
		if ($zoneId === 0) { return false; }
		/*DAC015-Advanced SSP:App Confguration details get and store in cache*/
		$appconfigInfo = MAX_cacheGetdjaxAppInfo('appconfig');
		/*DAC015-Advanced SSP:App Configuration details get and store in cache*/
		/*DAC015-Enterprise:Tera WURFL fetch*/
		$GLOBALS['_MAX']['device']=djax_mobileparameter($appconfigInfo);
		/*DAC015-Enterprise:Tera WURFL fetch*/
		global $g_append, $g_prepend;
		while (!in_array($zoneId, $GLOBALS['_MAX']['followedChain'])) {
		$GLOBALS['_MAX']['followedChain'][] = $zoneId;
		$appendedThisZone = false;
		$aZoneInfo = MAX_cacheGetZoneInfo($zoneId);
		/*DAC015-Enterprise:Unique ViewerIDs store*/
		//viewer_tracking($zoneId,$aZoneInfo);
		/*DAC015-Enterprise:Unique ViewerIDs store*/
		if (empty($aZoneInfo)) {
		return false;
		}
		if ($zoneId != 0 && MAX_limitationsIsZoneForbidden($zoneId, $aZoneInfo)) {
		$zoneId = _getNextZone($zoneId, $aZoneInfo);
		continue;
		}
        $aZoneLinkedAdInfos = MAX_cacheGetZoneLinkedAdInfos ($zoneId);
		$aZoneLinkedAdInfos['zoneid']=$zoneId;
	    if (is_array($aZoneInfo)) {
            if (isset($aZoneInfo['forceappend']) && $aZoneInfo['forceappend'] == 't') {
                $g_prepend .= $aZoneInfo['prepend'];
                $g_append = $aZoneInfo['append'] . $g_append;
                $appendedThisZone = true;
            }
            // merge zone info and banner info
            $aZoneLinkedAdInfos += $aZoneInfo; 
            $aLinkedAd = _adSelectCommon($aZoneLinkedAdInfos, $context, $source, $richMedia);    
            if (is_array($aLinkedAd)) {
                $aLinkedAd['zoneid'] = $zoneId;
                $aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
                $aLinkedAd['storagetype'] = $aLinkedAd['type'];
                $aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
                $aLinkedAd['zone_companion'] = $aZoneLinkedAdInfos['zone_companion'];
                $aLinkedAd['block_zone'] = $aZoneInfo['block_zone'];
                $aLinkedAd['cap_zone'] = $aZoneInfo['cap_zone'];
                $aLinkedAd['session_cap_zone'] = $aZoneInfo['session_cap_zone'];
                $aLinkedAd['affiliate_id'] = $aZoneInfo['publisher_id'];

		if($_REQUEST['format']!='vast_pod' && $_REQUEST['format']!='vast_pod_wrapper')
		{
		        $aLinkedAd['zoneid'] = $zoneId;
		        $aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
		        $aLinkedAd['storagetype'] = $aLinkedAd['type'];
		        $aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
		        $aLinkedAd['zone_companion'] = $aZoneLinkedAdInfos['zone_companion'];
		        $aLinkedAd['block_zone'] = $aZoneInfo['block_zone'];
		        $aLinkedAd['cap_zone'] = $aZoneInfo['cap_zone'];
		        $aLinkedAd['session_cap_zone'] = $aZoneInfo['session_cap_zone'];
		        $aLinkedAd['affiliate_id'] = $aZoneInfo['publisher_id'];

		        if (!$appendedThisZone) {
		            $aLinkedAd['append'] .= $aZoneInfo['append'] . $g_append;
		            $aLinkedAd['prepend'] = $g_prepend . $aZoneInfo['prepend'] . $aLinkedAd['prepend'];
		        } else {
		            $aLinkedAd['append'] .= $g_append;
		            $aLinkedAd['prepend'] = $g_prepend . $aLinkedAd['prepend'];
		        }
		        return ($aLinkedAd);
		}
		else
		{
			$djax_vastpod=array();

			foreach($aLinkedAd as $key => $djaxads)
			{
				$djax_vastpod[$key]=$djaxads;
			}
		        return ($djax_vastpod);

		}
            }

            $zoneId = _getNextZone($zoneId, $aZoneInfo);
        }
    }
    if (!empty($aZoneInfo['default_banner_image_url'])) {
        return array(
           'default'                        => true,
           'default_banner_image_url'       => $aZoneInfo['default_banner_image_url'],
           'default_banner_destination_url' => $aZoneInfo['default_banner_destination_url']
        );
    }

    return false;
}


/**
 * This function selects an ad cyclying through override, contract, renmant, etc.
 *
 * @param string  $aAds         The array of ads to pick from
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param string  $source       The "source" parameter passed into the adcall
 * @param boolean $richMedia    Does this invocation method allow for serving 3rd party/html ads
 *
 * @return array|false          Returns an ad-array (see page DocBlock) or false if no ad found
 */
function _adSelectCommon($aAds, $context, $source, $richMedia)
{
	$adSelectFunction = '_adSelect';
    OX_Delivery_Common_hook('preAdSelect', array(&$aAds, &$context, &$source, &$richMedia));

    if (!empty($aAds['ext_adselection'])) {
        $adSelectFunction = OX_Delivery_Common_getFunctionFromComponentIdentifier($aAds['ext_adselection'], 'adSelect');
    }
    if (empty($adSelectFunction) || !function_exists($adSelectFunction)) {
        $adSelectFunction = '_adSelect';
    }

    // Are there any ads linked?
    if (!empty($aAds['count_active'])) {
        // Is this a companion request and can it be fullfilled?
        if (isset($aAds['zone_companion']) && isset($context)) {
            foreach ($context as $contextEntry) {
                if (isset($contextEntry['==']) && preg_match('/^companionid:/', $contextEntry['=='])) {
                    if ($aLinkedAd = _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia, true)) {
                        return $aLinkedAd;
                    }
                }
            }
        }
        $aLinkedAd = _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia);
        if (is_array($aLinkedAd)) {
            return $aLinkedAd;
        }
    }
    return false;
}

/**
 * This internal function selects an ad cyclying through override, contract, remnant, etc.
 * taking into account companion positioning as requested
 *
 * @param callback $adSelectFunction The plugin callback function
 * @param string  $aAds         The array of ads to pick from
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param string  $source       The "source" parameter passed into the adcall
 * @param boolean $richMedia    Does this invocation method allow for serving 3rd party/html ads
 * @param boolean $companion    Should ad selection only return companion ads?
 *
 * @return array|false          Returns an ad-array (see page DocBlock) or false if no ad found
 */
function _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia, $companion = false)
{
            $aLinkedAd = OX_Delivery_Common_hook('adSelect', array(&$aAds, &$context, &$source, &$richMedia, $companion, $type), $adSelectFunction);
            // Did we pick an ad from this campaign type?
    		if (is_array($aLinkedAd)) {
      			return $aLinkedAd;
    		}
    return false;
}

/*DAC015-Advanced SSP*/

/*DAC015:Advanced SSP: Store the djax App configuration details in cache*/
function MAX_cacheGetdjaxAppInfo($appconfig, $cached = true)
{
$sName = OA_Delivery_Cache_getName(__FUNCTION__,$appconfig);
if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$aRows = OA_Dal_Delivery_getdjaxAppInfo();
$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
}

return $aRows;
}
/*DAC015:Advanced SSP: Store the djax App configuration details in cache*/
function _adSelect(&$aLinkedAdInfos, $context, $source, $richMedia, $companion, $adArrayVar = 'ads', $cp = null)
{
	$djax_zoneinfo=MAX_cacheGetZoneInfo($aLinkedAdInfos['zoneid']);
	$zoneInventoryType = $djax_zoneinfo['inventory_type'];
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
	switch($zoneInventoryType){
		case 1: //for private
				if(count($aLinkedAdInfos['normal_ads'])>0){
					$aAds=array();
					$aAds=$aLinkedAdInfos['normal_ads'];
					_adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
					if(empty($aAds)){
						if(count($aLinkedAdInfos['houseads'])>0){
							$aAds=$aLinkedAdInfos['houseads'];
							_adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
						}
					}
				}elseif(count($aLinkedAdInfos['houseads'])>0){
					$aAds=array();
					$aAds=$aLinkedAdInfos['houseads'];
					  _adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
					  
				}else{
					
					$aAds = array();
				}
				break;
		case 2: //for public
				if($_REQUEST['format']!='vast_pod' || $_REQUEST['format']!='vast_pod_wrapper')
				{
					if(count($aLinkedAdInfos['rtb_ads'])>0){
						$aAds=array();
						$aAds=$aLinkedAdInfos['rtb_ads'];
						$djax_final_data=djax_checklimit($aAds,$djax_zoneinfo,'Video');
						if($djax_final_data['djax_externalads']['djax_campaignid'])
						{
							$GLOBALS['_MAX']['RTB']=$djax_final_data;
							foreach($aAds as $key => $djvalue){
								if($djvalue['placement_id']==$djax_final_data['djax_externalads']['djax_campaignid'])
								{
								}
								else
								{ 
									unset($aAds[$djvalue['ad_id']]);
								}
							}
						}
						elseif(count($aLinkedAdInfos['houseads'])>0){
								$aAds=array();
								$aAds=$aLinkedAdInfos['houseads'];
								_adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
							}else{
							$aAds = array();
						}
					}else{
						$aAds = array();
					}
				}
				else
				{
					
					$aAds=array();
					$aAds=$aLinkedAdInfos['houseads'];
					_adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
				}
				break;
		case 3: //for both
		
				if(count($aLinkedAdInfos['normal_ads'])>0){
					
					$aAds=$aLinkedAdInfos['normal_ads'];				
					  _adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
					  if(empty($aAds)){
						if(count($aLinkedAdInfos['houseads'])>0){
							
							$aAds=$aLinkedAdInfos['houseads'];
							
							_adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
						}
					}
				}
				else if(count($aLinkedAdInfos['rtb_ads'])>0 && ($_REQUEST['format']!='vast_pod'  || $_REQUEST['format']!='vast_pod_wrapper'))
				{	
					$aAds=array();
					$aAds=$aLinkedAdInfos['rtb_ads'];
					$djax_final_data=djax_checklimit($aAds,$djax_zoneinfo,'Video');					
					if($djax_final_data['djax_externalads']['djax_campaignid'])
					{
						$GLOBALS['_MAX']['RTB']=$djax_final_data;
						foreach($aAds as $key => $djvalue){
							if($djvalue['placement_id']==$djax_final_data['djax_externalads']['djax_campaignid'])
							{
							}
							else
							{ 
								unset($aAds[$djvalue['ad_id']]);
							}
						}
					}
					else 
					{
							 $aAds=array();
								if(count($aLinkedAdInfos['houseads'])>0){
									
									$aAds=$aLinkedAdInfos['houseads'];
									
									_adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
								}
							
					}
				}elseif(count($aLinkedAdInfos['houseads'])>0){					
					$aAds=$aLinkedAdInfos['houseads'];
					  _adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
				}else{
					$aAds = array();
				}
				break;
	}
	/** Advanced ssp adselect - end **/
	if (count($aAds) == 0)
	{
	return;
	}
global $n;
mt_srand
(floor
((isset ($n) && strlen ($n) > 5
? hexdec ($n[0].$n[2].$n[3].$n[4].$n[5])
: 1000000) * (double) microtime ()));
$conf = $GLOBALS['_MAX']['CONF'];


$total_priority = _setPriorityFromWeights($aAds);

global $n;
mt_srand
(floor
((isset ($n) && strlen ($n) > 5
? hexdec ($n[0].$n[2].$n[3].$n[4].$n[5])
: 1000000) * (double) microtime ()));
$conf = $GLOBALS['_MAX']['CONF'];
$random_num =
mt_rand (0, $GLOBALS['_MAX']['MAX_RAND'])
/ $GLOBALS['_MAX']['MAX_RAND'];
  if ($random_num > $total_priority) {
return;
}
$low = 0;
$high = 0;
if(!empty($GLOBALS['_MAX']['RTB']['djax_externalads']['djax_campaignid']))
{
	foreach($aAds as $aLinkedAd) 
	{
			$ad = MAX_cacheGetAd($aLinkedAd['ad_id']);
			return $ad;
	}
}
else
{
	foreach($aAds as $aLinkedAd) 
	{
		if (!empty($aLinkedAd['priority'])) {
		$low = $high;
		$high += $aLinkedAd['priority'];
		if ($high > $random_num && $low <= $random_num) {
		 $ad = MAX_cacheGetAd($aLinkedAd['ad_id']);
		$ad['tracker_status'] = (!empty($aLinkedAd['tracker_status'])) ? $aLinkedAd['tracker_status'] : null;
		if($ad['width'] == $ad['height'] && $ad['width'] == -1) {
		$ad['width'] = $aLinkedAd['width'];
		$ad['height'] = $aLinkedAd['height'];
		}
		return $ad;
		}
		}
	}
}
}

/**
 * Return boolean indicating if this request is eligible for selection into a
 * control group for ecpm optimization.  Having only CPM ads as being eligible
 * may be a disqualifying criteria, given a configuration setting.
 *
 * @param unknown_type $aAds
 */
function _controlTrafficEnabled (&$aAds)
{
    $control_enabled = true;

    // if enableControlOnPureCPM is not enabled, we will check to see if
    // the ads are all only CPM, and disable control selection if they are
    if (empty ($GLOBALS['_MAX']['CONF']['delivery']['enableControlOnPureCPM']))
    {
        // check for any non-CPM campaign in eligible set
        $control_enabled = false;
        foreach ($aAds as $ad) {
            if ($ad['revenue_type'] != MAX_FINANCE_CPM)
            {
                $control_enabled = true;
                break;
            }
        }

    }

    return $control_enabled;
}


/**
 * Enter description here...
 *
 * @param unknown_type $aAd
 * @param unknown_type $context
 * @param unknown_type $source
 * @param unknown_type $richMedia
 */
function _adSelectCheckCriteria($aAd, $aContext, $source, $richMedia)
{
    	$conf = $GLOBALS['_MAX']['CONF'];
    	if($aAd['is_house_ads']==0)
    	{
    		$revenue = $aAd['revenue_type'];
			 $revenue_amt = $aAd['revenue'];
			 $method = $aAd['method'];
			 //$damt = $aAd['damt'];
			 $results=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select deposit_amount from dj_payment_details where client_id='".$aAd['client_id']."'"));
			 $postcheck=OA_Dal_Delivery_query("select * from dj_postpaid_pending where clientid='".$aAd['client_id']."'");
			 $damt = $results['deposit_amount'];
			 if($revenue == 1)
			 {
				 $amt = $revenue_amt/1000;
			 }
			 else
			 {
				 $amt = $revenue_amt;
			 }

			 if($method == 1)
			 {
				if(!empty($damt))
				{
				if($damt < $amt)
				{  die("false");
					return false;
				}
				}
			else
			{ die("false2");
			return false;	
			}
			}
			elseif($method == 2)
			{
				
				if(OA_Dal_Delivery_numRows($postcheck) > 0)
				{    die("false3");
					return false;
				}
				
			}
		}
	$getad=MAX_cacheGetAd($aAd['ad_id']);
	$check_video=unserialize($getad['parameters']);
if($_REQUEST['format']!='daast1_wrapper' && $_REQUEST['format']!='daast1')
{
	$vast_version=array('vast1','vast2','vast3');

	$vast_wrapper_version=array('vast1_wrapper','vast2_wrapper','vast3_wrapper');

				if($_REQUEST['format']=='vast1_wrapper')
				{
						$versionno=1;
				}
				else if($_REQUEST['format']=='vast2_wrapper')
				{
						$versionno=2;
				}
				else if($_REQUEST['format']=='vast3_wrapper')
				{
						$versionno=3;
				}
		if(in_array($_REQUEST['format'],$vast_version))
		{
			
			if($check_video['vast_video_delivery']=='vast' || $check_video['vast_overlay_format']=='wrapper_overlay')
			{
				return false;
			}
		}
		
		if(in_array($_REQUEST['format'],$vast_wrapper_version))
		{ 
			if($check_video['vast_video_delivery']!='vast' && $aAd['ext_bannertype']=='bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml')
			{
				return false;
			}
			else if(($check_video['vast_overlay_format']!='wrapper_overlay' && $aAd['ext_bannertype']=='bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml'))
			{
				return false;
			}
			else
			{
				if($check_video['vast_video_delivery']=='vast')
				{
					if($aAd['ext_bannertype']=="bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml")
					{
						if($check_video['vast_overlay_version']!=$versionno)
						{
							return false;
					    }
					}
					else
					{
						
						if($check_video['vast_version']!=$versionno)
						{ 
							return false;
					    }
					    
					}
				}
				else if($check_video['vast_overlay_format']=='wrapper_overlay')
				{
					if($check_video['vast_overlay_version']!=$versionno)
					{  
					return false;
					}
				}
			}
		}
	
		if($_REQUEST['format']=='vast_pod')
		{
			if($check_video['vast_video_delivery']=='vast')
			{
				return false;
			}
		}	
		else if($_REQUEST['format']=='vast_pod_wrapper')
		{
			if($check_video['vast_video_delivery']!='vast')
			{ 
				return false;
			}
			if($check_video['vast_version']!=3)
			{ 
				return false;
			}
		}

}
else
{
if($_REQUEST['format']=='daast1_wrapper')
{
	if($check_video['vast_wrapper_url']!='' )
	{
	}
	else
	{  
		return false;
	}
}
if($_REQUEST['format']=='daast1')
{
	if($check_video['vast_wrapper_url']!='' )
	{
		return false;
	}
}

}
    // Enforce campaign expirations
    if (!empty ($aAd['expire_time'])) {
        $expire = strtotime ($aAd['expire_time']);
        $now = MAX_commonGetTimeNow ();
        if ($expire > 0 && $now > $expire) {
            OX_Delivery_logMessage('Campaign has expired for bannerid '.$aAd['ad_id'], 7);
            return false;
        }
    }

    // Excludelist banners
    if (isset($aContext['banner']['exclude'][$aAd['ad_id']])) {
        OX_Delivery_logMessage('List of excluded banners list contains bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if (isset($aContext['campaign']['exclude'][$aAd['placement_id']])) {
        // Excludelist campaigns
        OX_Delivery_logMessage('List of excluded campaigns contains bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if (isset($aContext['client']['exclude'][$aAd['client_id']])) {
        // Excludelist clients
        OX_Delivery_logMessage('List of excluded clients contains bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if (!empty($aContext['banner']['include']) && !isset($aContext['banner']['include'][$aAd['ad_id']])) {
        // Includelist banners
        OX_Delivery_logMessage('List of included banners does not contain bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if (!empty($aContext['campaign']['include']) && !isset($aContext['campaign']['include'][$aAd['placement_id']])) {
        // Includelist campaigns
        OX_Delivery_logMessage('List of included campaigns does not contain bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if (   // Exclude richmedia banners if no alt image is specified
        $richMedia == false &&
        $aAd['alt_filename'] == '' &&
        !($aAd['contenttype'] == 'jpeg' || $aAd['contenttype'] == 'gif' || $aAd['contenttype'] == 'png') &&
        !($aAd['type'] == 'url' && $aAd['contenttype'] == '')
       ) {
        OX_Delivery_logMessage('No alt image specified for richmedia bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if (MAX_limitationsIsAdForbidden($aAd)) {
        // Capping & blocking
        OX_Delivery_logMessage('MAX_limitationsIsAdForbidden = true for bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if ($GLOBALS['_MAX']['SSL_REQUEST'] && $aAd['type'] == 'html' && $aAd['html_ssl_unsafe']) {
        // HTML Banners that contain 'http:' on SSL
        OX_Delivery_logMessage('"http:" on SSL found for html bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if ($GLOBALS['_MAX']['SSL_REQUEST'] && $aAd['type'] == 'url' && $aAd['url_ssl_unsafe']) {
        // It only matters if the initial call is to non-SSL (it can/could contain http:)
        OX_Delivery_logMessage('"http:" on SSL found in imagurl for url bannerid '.$aAd['ad_id'], 7);
        return false;
    }

    if ($conf['delivery']['acls'] && !MAX_limitationsCheckAcl($aAd, $source)) {
        // Delivery limitations
        OX_Delivery_logMessage('MAX_limitationsCheckAcl = false for bannerid '.$aAd['ad_id'], 7);
        return false;
    }
    // If any of the above failed, this function will have already returned false
    // So to get this far means that the ad was valid
    return true;
}

function _adSelectBuildContextArray(&$aLinkedAds, $adArrayVar, $context, $companion = false)
{
    $aContext = array(
        'campaign' => array('exclude' => array(), 'include' => array()),
        'banner'   => array('exclude' => array(), 'include' => array()),
        'client'   => array('exclude' => array(), 'include' => array()),
    );

    if (is_array($context) && !empty($context)) {
        $cContext = count($context);
        for ($i=0; $i < $cContext; $i++) {
            reset($context[$i]);
            list ($key, $value) = each($context[$i]);

            $valueArray = explode(':', $value);

            if (count($valueArray) == 1) {
                list($value) = $valueArray;
                $type = "";
            } else {
                list($type, $value) = $valueArray;
            }

            // Skip if value is empty
            if (empty($value)) {
                continue;
            }

            switch($type) {
                case 'campaignid':
                    switch ($key) {
                        case '!=': $aContext['campaign']['exclude'][$value] = true; break;
                        case '==': $aContext['campaign']['include'][$value] = true; break;
                    }
                break;
                case 'clientid':
                    switch ($key) {
                        case '!=': $aContext['client']['exclude'][$value] = true; break;
                        case '==': $aContext['client']['include'][$value] = true; break;
                    }
                break;
                case 'companionid':
                    switch ($key) {
                        case '!=':
                            // Exclusion list prevents competing companion ads from being displayed
                            // even when a previous try to fatch a companion failed
                            $aContext['campaign']['exclude'][$value] = true;
                            break;
                        case '==':
                            // Inclusion list should be ignored if a previous try already failed
                            // to return an ad
                            if ($companion) {
                                $aContext['campaign']['include'][$value] = true;
                            }
                       break;
                    }
                break;
                default:
                    switch ($key) {
                        case '!=': $aContext['banner']['exclude'][$value] = true; break;
                        case '==': $aContext['banner']['include'][$value] = true; break;
                    }
            }
        }
    }

    return $aContext;
}

/**
 * This function builds the context array to track which ads/campaigns have been shown on the current page
 *
 * @param array $aBanner      The ad-array for the ad to render code for
 * @param array $context      The context of this ad selection
 *                            - used for companion positioning
 *                            - and excluding banner/campaigns from this ad-call
 * @return array              The updated context array
 */
function _adSelectBuildContext($aBanner, $context = array()) {
    if (!empty($aBanner['zone_companion'])) {
        // This zone call has companion banners linked to it.
        // So pass into the next call that we would like a banner from this campaign
        // and not from the other companion linked campaigns
        foreach ($aBanner['zone_companion'] AS $companionCampaign) {
            $value = 'companionid:'.$companionCampaign;
            if ($aBanner['placement_id'] == $companionCampaign) {
                $context[] = array('==' => $value);
            } else {
                // Did we previously deliver an ad from this campaign?
                $key = array_search(array('==', $value), $context);
                if ($key === false) {
                    // Nope, we must exclude the campaign then!
                    $context[] = array('!=' => $value);
                }
            }
        }
    }
    if (isset($aBanner['advertiser_limitation']) && $aBanner['advertiser_limitation'] == '1') {
        $context[] = array('!=' => 'clientid:' . $aBanner['client_id']);
    }
    return $context;
}

/**
 * This function removes any ads which cannot be shown for the current impression
 *
 * @param array $aAds - The array of ads to be evaluated
 * @param  $aContext
 * @param unknown_type $source
 * @param unknown_type $richMedia
 * @return none
 */
function _adSelectDiscardNonMatchingAds(&$aAds, $aContext, $source, $richMedia)
{
    // Don't filter ads on direct selection requests (if that setting is disabled)
    if (empty($GLOBALS['_MAX']['CONF']['delivery']['aclsDirectSelection']) && !empty($GLOBALS['_MAX']['DIRECT_SELECTION'])) {
        return;
    }
    foreach ($aAds as $adId => $aAd) {
        OX_Delivery_logMessage('_adSelectDiscardNonMatchingAds: checking bannerid '.$aAd['ad_id'], 7);
        if (!_adSelectCheckCriteria($aAd, $aContext, $source, $richMedia)) {
            OX_Delivery_logMessage('failed _adSelectCheckCriteria: bannerid '.$aAd['ad_id'], 7);
            unset($aAds[$adId]);
        } else {
            OX_Delivery_logMessage('passed _adSelectCheckCriteria: bannerid '.$aAd['ad_id'], 7);
        }
    }
    return;
}

?>
