<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once(MAX_PATH . '/lib/OA/Permission.php');

// Setup navigation
function _buildNavigation($accountType)
{
    $oMenu = new OA_Admin_Menu;

    $aConf = $GLOBALS['_MAX']['CONF'];

    switch ($accountType) {
        case OA_ACCOUNT_ADMIN:
            if ($GLOBALS['_MAX']['CONF']['ui']['dashboardEnabled']) {
                $oMenu->add(new OA_Admin_Menu_Section("dashboard", 'Home', "dashboard.php", false, ""));
            }
	//DAC029
		$oMenu->add(new OA_Admin_Menu_Section("overview", 'Dashboard', "overview-index.php", false, "email"));
				 $oMenu->addTo("overview", new OA_Admin_Menu_Section("overview-index", 'Overview', "overview-index.php", false, ""));  
				 $oMenu->addTo("overview", new OA_Admin_Menu_Section("campaign-overview", 'CampaignOverview', "campaign-overview.php", false, ""));    
	//DAC029
            // Note: The stats screens haven't been updated to use the new menuing names...
            $oMenu->add(new OA_Admin_Menu_Section("2", 'Stats', "stats.php", false, "statistics"));
                $oMenu->addTo("2", new OA_Admin_Menu_Section("2.1", 'ClientsAndCampaigns', "stats.php?1=1", false, "statistics/advertisersAndCampaigns"));
                $oMenu->addTo("2.1", new OA_Admin_Menu_Section("2.1.1", 'ClientHistory', "stats.php?entity=advertiser&breakdown=history&clientid={clientid}", false, "statistics/advertiserHistory"));
                $oMenu->addTo("2.1.1", new OA_Admin_Menu_Section("2.1.1.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&day={day}", false, "statistics/advertiserHistory/daily"));
                $oMenu->addTo("2.1", new OA_Admin_Menu_Section("2.1.2", 'Campaigns', "stats.php?entity=advertiser&breakdown=campaigns&clientid={clientid}", false, "statistics/campaignOverview"));
                $oMenu->addTo("2.1.2", new OA_Admin_Menu_Section("2.1.2.1", 'CampaignHistory', "stats.php?entity=campaign&breakdown=history&clientid={clientid}&campaignid={campaignid}", false, "statistics/campaignHistory"));
                $oMenu->addTo("2.1.2.1", new OA_Admin_Menu_Section("2.1.2.1.1", 'DailyStats', "stats.php?entity=campaign&breakdown=daily&clientid={clientid}&campaignid={campaignid}&day={day}", false, "statistics/campaignHistory/daily"));
                $oMenu->addTo("2.1.2", new OA_Admin_Menu_Section("2.1.2.2", 'Banners', "stats.php?entity=campaign&breakdown=banners&clientid={clientid}&campaignid={campaignid}", false, "statistics/bannerOverview"));
                $oMenu->addTo("2.1.2.2", new OA_Admin_Menu_Section("2.1.2.2.1", 'BannerHistory', "stats.php?entity=banner&breakdown=history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "statistics/bannerHistory"));
                $oMenu->addTo("2.1.2.2.1", new OA_Admin_Menu_Section("2.1.2.2.1.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&day={day}", false, "statistics/bannerHistory/daily"));
                $oMenu->addTo("2.1.2.2", new OA_Admin_Menu_Section("2.1.2.2.2", 'PublisherDistribution', "stats.php?entity=banner&breakdown=affiliates&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "statistics/publisherDistribution"));
                $oMenu->addTo("2.1.2.2.2", new OA_Admin_Menu_Section("2.1.2.2.2.1", 'DistributionHistoryWebsite', "stats.php?entity=banner&breakdown=affiliate-history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/history"));
                $oMenu->addTo("2.1.2.2.2.1", new OA_Admin_Menu_Section("2.1.2.2.2.1.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
                $oMenu->addTo("2.1.2.2.2", new OA_Admin_Menu_Section("2.1.2.2.2.2", 'DistributionHistoryZone', "stats.php?entity=banner&breakdown=zone-history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
                $oMenu->addTo("2.1.2.2.2.2", new OA_Admin_Menu_Section("2.1.2.2.2.2.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
                $oMenu->addTo("2.1.2", new OA_Admin_Menu_Section("2.1.2.3", 'PublisherDistribution', "stats.php?entity=campaign&breakdown=affiliates&clientid={clientid}&campaignid={campaignid}", false, "statistics/publisherDistribution"));
                $oMenu->addTo("2.1.2.3", new OA_Admin_Menu_Section("2.1.2.3.1", 'DistributionHistoryWebsite', "stats.php?entity=campaign&breakdown=affiliate-history&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/history"));
                $oMenu->addTo("2.1.2.3.1", new OA_Admin_Menu_Section("2.1.2.3.1.1", 'DailyStats', "stats.php?entity=campaign&breakdown=daily&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
                $oMenu->addTo("2.1.2.3", new OA_Admin_Menu_Section("2.1.2.3.2", 'DistributionHistoryZone', "stats.php?entity=campaign&breakdown=zone-history&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
                $oMenu->addTo("2.1.2.3.2", new OA_Admin_Menu_Section("2.1.2.3.2.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
                $oMenu->addTo("2.1", new OA_Admin_Menu_Section("2.1.3", 'PublisherDistribution', "stats.php?entity=advertiser&breakdown=affiliates&clientid={clientid}", false, "statistics/publisherDistribution"));
                $oMenu->addTo("2.1.3", new OA_Admin_Menu_Section("2.1.3.1", 'DistributionHistoryWebsite', "stats.php?entity=advertiser&breakdown=affiliate-history&clientid={clientid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/history"));
                $oMenu->addTo("2.1.3.1", new OA_Admin_Menu_Section("2.1.3.1.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
                $oMenu->addTo("2.1.3", new OA_Admin_Menu_Section("2.1.3.2", 'DistributionHistoryZone', "stats.php?entity=advertiser&breakdown=zone-history&clientid={clientid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
                $oMenu->addTo("2.1.3.2", new OA_Admin_Menu_Section("2.1.3.2.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
                $oMenu->addTo("2", new OA_Admin_Menu_Section("2.4", 'AffiliatesAndZones', "stats.php?entity=global&breakdown=affiliates", false, "statistics/publishersAndZones"));
                $oMenu->addTo("2.4", new OA_Admin_Menu_Section("2.4.1", 'AffiliateHistory', "stats.php?entity=affiliate&breakdown=history&affiliateid={affiliateid}", false, "statistics/publisherHistory"));
                $oMenu->addTo("2.4.1", new OA_Admin_Menu_Section("2.4.1.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&day={day}", false, "statistics/publisherHistory/daily"));
                $oMenu->addTo("2.4", new OA_Admin_Menu_Section("2.4.2", 'Zones', "stats.php?entity=affiliate&breakdown=zones&affiliateid={affiliateid}", false, "statistics/zoneOverview"));
                $oMenu->addTo("2.4.2", new OA_Admin_Menu_Section("2.4.2.1", 'ZoneHistory', "stats.php?entity=zone&breakdown=history&affiliateid={affiliateid}&zoneid={zoneid}", false, "statistics/zoneHistory"));
                $oMenu->addTo("2.4.2.1", new OA_Admin_Menu_Section("2.4.2.1.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&day={day}", false, "statistics/zoneHistory/daily"));
                $oMenu->addTo("2.4.2", new OA_Admin_Menu_Section("2.4.2.2", 'CampaignDistribution', "stats.php?entity=zone&breakdown=campaigns&affiliateid={affiliateid}&zoneid={zoneid}", false, "statistics/campaignDistribution"));
                $oMenu->addTo("2.4.2.2", new OA_Admin_Menu_Section("2.4.2.2.1", 'DistributionHistoryCampaign', "stats.php?entity=zone&breakdown=campaign-history&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}", true, "statistics/campaignDistribution/history"));
                $oMenu->addTo("2.4.2.2.1", new OA_Admin_Menu_Section("2.4.2.2.1.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&day={day}", false, "statistics/campaignDistribution/history/daily"));
                $oMenu->addTo("2.4.2.2", new OA_Admin_Menu_Section("2.4.2.2.2", 'DistributionHistoryBanner', "stats.php?entity=zone&breakdown=banner-history&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&bannerid={bannerid}", true));
                $oMenu->addTo("2.4.2.2.2", new OA_Admin_Menu_Section("2.4.2.2.2.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&bannerid={bannerid}&day={day}"));
                $oMenu->addTo("2.4", new OA_Admin_Menu_Section("2.4.3", 'CampaignDistribution', "stats.php?entity=affiliate&breakdown=campaigns&affiliateid={affiliateid}", false, "statistics/campaignDistribution"));
                $oMenu->addTo("2.4.3", new OA_Admin_Menu_Section("2.4.3.1", 'DistributionHistoryCampaign', "stats.php?entity=affiliate&breakdown=campaign-history&affiliateid={affiliateid}&campaignid={campaignid}", true, "statistics/campaignDistribution/history"));
                $oMenu->addTo("2.4.3.1", new OA_Admin_Menu_Section("2.4.3.1.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&campaignid={campaignid}&day={day}", false, "statistics/campaignDistribution/history/daily"));
                $oMenu->addTo("2.4.3", new OA_Admin_Menu_Section("2.4.3.2", 'DistributionHistoryBanner', "stats.php?entity=affiliate&breakdown=banner-history&affiliateid={affiliateid}&campaignid={campaignid}&bannerid={bannerid}", true));
                $oMenu->addTo("2.4.3.2", new OA_Admin_Menu_Section("2.4.3.2.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&campaignid={campaignid}&bannerid={bannerid}&day={day}"));
                $oMenu->addTo("2", new OA_Admin_Menu_Section("2.2", 'GlobalHistory', "stats.php?entity=global&breakdown=history", false, "statistics/global"));
                $oMenu->addTo("2.2", new OA_Admin_Menu_Section("2.2.1", 'DailyStats', "stats.php?entity=global&breakdown=daily&day={day}", false, "statistics/global/daily"));
                $oMenu->addTo("2", new OA_Admin_Menu_Section("report-index", 'AdvancedReports', "report-index.php", false, "statistics"));
			
			////// Mediation Stats Starts////
			    
			//~ $oMenu->addTo("2", new OA_Admin_Menu_Section("apps_stats", 'App Reports', "apps_stats.php", false, ""));
			    //~ 
			//~ $oMenu->addTo("2", new OA_Admin_Menu_Section("adunit_stats", 'Adunit Reports', "adunit_stats.php", false, ""));
			    //~ 
			//~ $oMenu->addTo("2", new OA_Admin_Menu_Section("network_stats", 'Network Reports', "network_stats.php", false, ""));

////// Mediation Stats Starts////
            $oMenu->add(new OA_Admin_Menu_Section("inventory", 'Adminstration', "agency-index.php", false, "inventory"));
                $oMenu->addTo("inventory", new OA_Admin_Menu_Section("agency-index", 'AgencyManagement', "agency-index.php", false, "settings/agencyManagement"));
                $oMenu->addTo("agency-index", new OA_Admin_Menu_Section("agency-edit_new", 'AddAgency', "agency-edit.php", true, "settings/agencyManagement/addagency"));
                $oMenu->addTo("agency-index", new OA_Admin_Menu_Section("agency-edit", 'AgencyProperties', "agency-edit.php?agencyid={agencyid}", false, "settings/agencyManagement/editagency"));
                $oMenu->addTo("agency-index", new OA_Admin_Menu_Section("agency-access", 'UserAccess', "agency-access.php?agencyid={agencyid}", false, "inventory/directSelection"));
                if (empty($aConf['ui']['disableDirectSelection'])) {
                    $oMenu->addTo("inventory", new OA_Admin_Menu_Section("admin-generate", 'GenerateBannercode', "admin-generate.php"));
                }
                $oMenu->addTo("inventory", new OA_Admin_Menu_Section("admin-access", 'AdminAccess', "admin-access.php"));
                $oMenu->addTo("admin-access", new OA_Admin_Menu_Section("admin-user", 'AdminAccess', "admin-user.php?userid={userid}"));

            $oMenu->add(new OA_Admin_Menu_Section("account-index", 'Preferences', "account-index.php", false, "settings/preferences"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("account-user-index", 'UserPreferences', "account-user-index.php", false, ""));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("account-preferences-index", 'AccountPreferences', "account-preferences-index.php", false, "settings/preferences"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("userlog-index", 'UserLog', "userlog-index.php", false, "settings/userLog"));
                $oMenu->addTo("userlog-index", new OA_Admin_Menu_Section("userlog-details", 'UserLogDetails', "userlog-audit-detailed.php", false, "settings/userLog/details"));

            $oMenu->add(new OA_Admin_Menu_Section("configuration", 'Configuration', "account-settings-index.php", false, "settings"));
                $oMenu->addTo("configuration", new OA_Admin_Menu_Section("account-settings-index", 'GlobalSettings', "account-settings-index.php", false, ""));
                $oMenu->addTo("configuration", new OA_Admin_Menu_Section("maintenance-index", 'Maintenance', "maintenance-index.php", false, "settings/maintenance"));
                $oMenu->addTo("configuration", new OA_Admin_Menu_Section("updates-index", 'ProductUpdates', "updates-product.php", false, "settings/productUpdates"));
                  /*$oMenu->addTo("configuration", new OA_Admin_Menu_Section("mobilesdk-index", 'Admin Configuration', "djax-mobilesdk.php", false, "settings/mobilesdk"));*/
            $oMenu->add(new OA_Admin_Menu_Section("plugin-index", 'Plugins', "plugin-index.php"));
			$oMenu->add(new OA_Admin_Menu_Section("dspbuyers", 'SSP Buyers', "manage_dsp.php", false, "settings"));
			$oMenu->addTo("dspbuyers", new OA_Admin_Menu_Section("listing-dsp-buyers", 'Listing DSP Buyers', "manage_dsp.php", false, "settings/maintenance"));
            $oMenu->addTo("dspbuyers", new OA_Admin_Menu_Section("add-dsp-buyers", 'Add DSP Buyers', "add_dsp.php", false, ""));
            
            $oMenu->addTo("dspbuyers", new OA_Admin_Menu_Section("stats", 'Dsp Reports', "djax-dspstats.php", false, ""));
            $oMenu->addTo("dspbuyers", new OA_Admin_Menu_Section("countrystats", 'Dsp Country Reports', "djax-dspcountrystats.php", false, ""));
            $oMenu->addTo("dspbuyers", new OA_Admin_Menu_Section("devicestats", 'Dsp Device Reports', "djax-dspdevicestats.php", false, ""));
            $oMenu->addTo("dspbuyers", new OA_Admin_Menu_Section("sitestats", 'Dsp Site Reports', "djax-dspsitestats.php", false, ""));
			
			/*$oMenu->add(new OA_Admin_Menu_Section("dspstats", 'DSP Statistics', "djax-dspstats.php", false, "settings"));*/
			    $oMenu->addTo("dspstats", new OA_Admin_Menu_Section("stats", 'Dsp Reports', "djax-dspstats.php", false, ""));
			    $oMenu->addTo("dspstats", new OA_Admin_Menu_Section("countrystats", 'Dsp Country Reports', "djax-dspcountrystats.php", false, ""));
			    $oMenu->addTo("dspstats", new OA_Admin_Menu_Section("devicestats", 'Dsp Device Reports', "djax-dspdevicestats.php", false, ""));
			    $oMenu->addTo("dspstats", new OA_Admin_Menu_Section("sitestats", 'Dsp Site Reports', "djax-dspsitestats.php", false, ""));
			//$oMenu->addTo("dspstats", new OA_Admin_Menu_Section("", 'Dsp Reports', "djax-dspstats.php", false, ""));
			

	////////////////////////////* Begin OpenXmods - DAC024 *////////////////////////////

                $oMenu->add(new OA_Admin_Menu_Section("email", 'Email System', "oxm_publisher_email.php", false, "email"));
                $oMenu->addTo("email", new OA_Admin_Menu_Section("publisher_email", 'Publisher Email System', "oxm_publisher_email.php", false, ""));                
                                
    ////////////////////////////* End OpenXmods - DAC024 *//////////////////////////////



	////////////////////////////* Begin OpenXmods *////////////////////////////
		
		//~ $oMenu->add(new OA_Admin_Menu_Section("mediation_networks", 'Mediation', "admin_networks.php", false, "products"));
     	//~ 
     		//~ $oMenu->addTo("mediation_networks", new OA_Admin_Menu_Section("manage_networks", 'Admin Networks', "admin_networks.php", false, ""));
        //~ 
            //~ $oMenu->addTo("mediation_networks", new OA_Admin_Menu_Section("mediation_publisher_networks", 'Publisher Networks', "publisher_networks.php", false, ""));		 
        				  
	////////////////////////////* End OpenXmods *//////////////////////////////

 /////////////////DAC015-Passback module//////////////	
			// $oMenu->add(new OA_Admin_Menu_Section("passback-statistics", 'Passback Statistics', "oxm_passbackads.php", false, "settings"));
			// $oMenu->addTo("passback-statistics", new OA_Admin_Menu_Section("passback-statistics-index", 'Passback Statistics', "oxm_passbackads.php", false, ""));
			 
	        /////////////////DAC015-Passback module//////////////	     
////////////////////////////* Begin OpenXmods *////////////////////////////
		 $oMenu->add(new OA_Admin_Menu_Section("products", 'Inventory Products', "oxm_inventory_products.php", false, "products"));
				 $oMenu->addTo("products", new OA_Admin_Menu_Section("inventory_products", 'Inventory Products List', "oxm_inventory_products.php", false, ""));
                 $oMenu->addTo("products", new OA_Admin_Menu_Section("inventory_add_products", 'Add Products', "oxm_inventory_add_products.php?mode=add", false, "")); 		 
                 $oMenu->addTo("products", new OA_Admin_Menu_Section("inventory_products_history", 'Booking History', "oxm_inventory_products_history.php", false, "")); 		 
		      
				////////////////////////////* Begin OpenXmods *////////////////////////////


			       //~ $oMenu->add(new OA_Admin_Menu_Section("orders", 'Order approval', "oxm_order_approval.php", false, "orders"));
                        //~ $oMenu->addTo("orders", new OA_Admin_Menu_Section("order_approval", 'Order Approval List', "oxm_order_approval.php", false, "")); 
		      
				////////////////////////////* End OpenXmods *//////////////////////////////



   break;
        case OA_ACCOUNT_MANAGER:
            if ($GLOBALS['_MAX']['CONF']['ui']['dashboardEnabled'] && $aConf['sync']['checkForUpdates']) {
                $oMenu->add(new OA_Admin_Menu_Section("dashboard", 'Home', "dashboard.php", false, "dashboard"));
            }
			//DAC029
		$oMenu->add(new OA_Admin_Menu_Section("overview", 'Dashboard', "overview-index.php", false, "email"));
				 $oMenu->addTo("overview", new OA_Admin_Menu_Section("overview-index", 'Overview', "overview-index.php", false, ""));  
				 $oMenu->addTo("overview", new OA_Admin_Menu_Section("campaign-overview", 'CampaignOverview', "campaign-overview.php", false, ""));    
		   //DAC029
            // Note: The stats screens haven't been updated to use the new menuing names...
            $oMenu->add(new OA_Admin_Menu_Section("2", 'Stats', "stats.php", false, "statistics"));
                $oMenu->addTo("2", new OA_Admin_Menu_Section("2.1", 'ClientsAndCampaigns', "stats.php?1=1", false, "statistics/advertisersAndCampaigns"));
                $oMenu->addTo("2.1", new OA_Admin_Menu_Section("2.1.1", 'ClientHistory', "stats.php?entity=advertiser&breakdown=history&clientid={clientid}", false, "statistics/advertiserHistory"));
                $oMenu->addTo("2.1.1", new OA_Admin_Menu_Section("2.1.1.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&day={day}", false, "statistics/advertiserHistory/daily"));
                $oMenu->addTo("2.1", new OA_Admin_Menu_Section("2.1.2", 'Campaigns', "stats.php?entity=advertiser&breakdown=campaigns&clientid={clientid}", false, "statistics/campaignOverview"));
                $oMenu->addTo("2.1.2", new OA_Admin_Menu_Section("2.1.2.1", 'CampaignHistory', "stats.php?entity=campaign&breakdown=history&clientid={clientid}&campaignid={campaignid}", false, "statistics/campaignHistory"));
                $oMenu->addTo("2.1.2.1", new OA_Admin_Menu_Section("2.1.2.1.1", 'DailyStats', "stats.php?entity=campaign&breakdown=daily&clientid={clientid}&campaignid={campaignid}&day={day}", false, "statistics/campaignHistory/daily"));
                $oMenu->addTo("2.1.2", new OA_Admin_Menu_Section("2.1.2.2", 'Banners', "stats.php?entity=campaign&breakdown=banners&clientid={clientid}&campaignid={campaignid}", false, "statistics/bannerOverview"));
                $oMenu->addTo("2.1.2.2", new OA_Admin_Menu_Section("2.1.2.2.1", 'BannerHistory', "stats.php?entity=banner&breakdown=history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "statistics/bannerHistory"));
                $oMenu->addTo("2.1.2.2.1", new OA_Admin_Menu_Section("2.1.2.2.1.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&day={day}", false, "statistics/bannerHistory/daily"));
                $oMenu->addTo("2.1.2.2", new OA_Admin_Menu_Section("2.1.2.2.2", 'PublisherDistribution', "stats.php?entity=banner&breakdown=affiliates&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "statistics/publisherDistribution"));
                $oMenu->addTo("2.1.2.2.2", new OA_Admin_Menu_Section("2.1.2.2.2.1", 'DistributionHistoryWebsite', "stats.php?entity=banner&breakdown=affiliate-history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/history"));
                $oMenu->addTo("2.1.2.2.2.1", new OA_Admin_Menu_Section("2.1.2.2.2.1.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
                $oMenu->addTo("2.1.2.2.2", new OA_Admin_Menu_Section("2.1.2.2.2.2", 'DistributionHistoryZone', "stats.php?entity=banner&breakdown=zone-history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
                $oMenu->addTo("2.1.2.2.2.2", new OA_Admin_Menu_Section("2.1.2.2.2.2.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
                $oMenu->addTo("2.1.2", new OA_Admin_Menu_Section("2.1.2.3", 'PublisherDistribution', "stats.php?entity=campaign&breakdown=affiliates&clientid={clientid}&campaignid={campaignid}", false, "statistics/publisherDistribution"));
                $oMenu->addTo("2.1.2.3", new OA_Admin_Menu_Section("2.1.2.3.1", 'DistributionHistoryWebsite', "stats.php?entity=campaign&breakdown=affiliate-history&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/history"));
                $oMenu->addTo("2.1.2.3.1", new OA_Admin_Menu_Section("2.1.2.3.1.1", 'DailyStats', "stats.php?entity=campaign&breakdown=daily&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
                $oMenu->addTo("2.1.2.3", new OA_Admin_Menu_Section("2.1.2.3.2", 'DistributionHistoryZone', "stats.php?entity=campaign&breakdown=zone-history&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
                $oMenu->addTo("2.1.2.3.2", new OA_Admin_Menu_Section("2.1.2.3.2.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
                $oMenu->addTo("2.1", new OA_Admin_Menu_Section("2.1.3", 'PublisherDistribution', "stats.php?entity=advertiser&breakdown=affiliates&clientid={clientid}", false, "statistics/publisherDistribution"));
                $oMenu->addTo("2.1.3", new OA_Admin_Menu_Section("2.1.3.1", 'DistributionHistoryWebsite', "stats.php?entity=advertiser&breakdown=affiliate-history&clientid={clientid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/history"));
                $oMenu->addTo("2.1.3.1", new OA_Admin_Menu_Section("2.1.3.1.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
                $oMenu->addTo("2.1.3", new OA_Admin_Menu_Section("2.1.3.2", 'DistributionHistoryZone', "stats.php?entity=advertiser&breakdown=zone-history&clientid={clientid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
                $oMenu->addTo("2.1.3.2", new OA_Admin_Menu_Section("2.1.3.2.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
                $oMenu->addTo("2", new OA_Admin_Menu_Section("2.2", 'GlobalHistory', "stats.php?entity=global&breakdown=history", false, "statistics/global"));
                $oMenu->addTo("2.2", new OA_Admin_Menu_Section("2.2.1", 'DailyStats', "stats.php?entity=global&breakdown=daily&day={day}", false, "statistics/global/daily"));
                $oMenu->addTo("2", new OA_Admin_Menu_Section("2.4", 'AffiliatesAndZones', "stats.php?entity=global&breakdown=affiliates", false, "statistics/publishersAndZones"));
                $oMenu->addTo("2.4", new OA_Admin_Menu_Section("2.4.1", 'AffiliateHistory', "stats.php?entity=affiliate&breakdown=history&affiliateid={affiliateid}", false, "statistics/publisherHistory"));
                $oMenu->addTo("2.4.1", new OA_Admin_Menu_Section("2.4.1.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&day={day}", false, "statistics/publisherHistory/daily"));
                $oMenu->addTo("2.4", new OA_Admin_Menu_Section("2.4.2", 'Zones', "stats.php?entity=affiliate&breakdown=zones&affiliateid={affiliateid}", false, "statistics/zoneOverview"));
                $oMenu->addTo("2.4.2", new OA_Admin_Menu_Section("2.4.2.1", 'ZoneHistory', "stats.php?entity=zone&breakdown=history&affiliateid={affiliateid}&zoneid={zoneid}", false, "statistics/zoneHistory"));
                $oMenu->addTo("2.4.2.1", new OA_Admin_Menu_Section("2.4.2.1.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&day={day}", false, "statistics/zoneHistory/daily"));
                $oMenu->addTo("2.4.2", new OA_Admin_Menu_Section("2.4.2.2", 'CampaignDistribution', "stats.php?entity=zone&breakdown=campaigns&affiliateid={affiliateid}&zoneid={zoneid}", false, "statistics/campaignDistribution"));
                $oMenu->addTo("2.4.2.2", new OA_Admin_Menu_Section("2.4.2.2.1", 'DistributionHistoryCampaign', "stats.php?entity=zone&breakdown=campaign-history&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}", true, "statistics/campaignDistribution/history"));
                $oMenu->addTo("2.4.2.2.1", new OA_Admin_Menu_Section("2.4.2.2.1.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&day={day}", false, "statistics/campaignDistribution/history/daily"));
                $oMenu->addTo("2.4.2.2", new OA_Admin_Menu_Section("2.4.2.2.2", 'DistributionHistoryBanner', "stats.php?entity=zone&breakdown=banner-history&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&bannerid={bannerid}", true));
                $oMenu->addTo("2.4.2.2.2", new OA_Admin_Menu_Section("2.4.2.2.2.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&bannerid={bannerid}&day={day}"));
                $oMenu->addTo("2.4", new OA_Admin_Menu_Section("2.4.3", 'CampaignDistribution', "stats.php?entity=affiliate&breakdown=campaigns&affiliateid={affiliateid}", false, "statistics/campaignDistribution"));
                $oMenu->addTo("2.4.3", new OA_Admin_Menu_Section("2.4.3.1", 'DistributionHistoryCampaign', "stats.php?entity=affiliate&breakdown=campaign-history&affiliateid={affiliateid}&campaignid={campaignid}", true, "statistics/campaignDistribution/history"));
                $oMenu->addTo("2.4.3.1", new OA_Admin_Menu_Section("2.4.3.1.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&campaignid={campaignid}&day={day}", false, "statistics/campaignDistribution/history/daily"));
                $oMenu->addTo("2.4.3", new OA_Admin_Menu_Section("2.4.3.2", 'DistributionHistoryBanner', "stats.php?entity=affiliate&breakdown=banner-history&affiliateid={affiliateid}&campaignid={campaignid}&bannerid={bannerid}", true));
                $oMenu->addTo("2.4.3.2", new OA_Admin_Menu_Section("2.4.3.2.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&campaignid={campaignid}&bannerid={bannerid}&day={day}"));
                $oMenu->addTo("2", new OA_Admin_Menu_Section("report-index", 'AdvancedReports', "report-index.php", false, "statistics"));
			
			///////// Mediation Stats Starts/////////
			//~ $oMenu->addTo("2", new OA_Admin_Menu_Section("apps_stats", 'App Reports', "apps_stats.php", false, ""));
			    //~ 
			//~ $oMenu->addTo("2", new OA_Admin_Menu_Section("adunit_stats", 'Adunit Reports', "adunit_stats.php", false, ""));
			    //~ 
			//~ $oMenu->addTo("2", new OA_Admin_Menu_Section("network_stats", 'Network Reports', "network_stats.php", false, ""));
			///////// Mediation Stats Ends/////////
			
            $oMenu->add(new OA_Admin_Menu_Section("inventory", 'Adminstration', "advertiser-index.php", false, ""));

            $oMenu->addTo("inventory", new OA_Admin_Menu_Section("advertiser-index", 'Clients', "advertiser-index.php", false, "inventory", null, 1, false, 'g_adv'));
                $oMenu->addTo("advertiser-index", new OA_Admin_Menu_Section("advertiser-edit_new", 'AddClient', "advertiser-edit.php", true, "inventory/advertiserAndCampaings/addAdvertiser"));
                $oMenu->addTo("advertiser-index", new OA_Admin_Menu_Section("advertiser-edit", 'ClientProperties', "advertiser-edit.php?clientid={clientid}", false, "inventory/advertiserAndCampaings/editAdvertiser"));
                if ($aConf['logging']['trackerImpressions']) {
                    $oMenu->addTo("advertiser-index", new OA_Admin_Menu_Section("advertiser-trackers", 'Trackers', "advertiser-trackers.php?clientid={clientid}", false, "inventory/advertisersAndCampaigns/trackers"));
                        $oMenu->addTo("advertiser-trackers", new OA_Admin_Menu_Section("tracker-edit_new", 'AddTracker', "tracker-edit.php?clientid={clientid}", true, "inventory/advertisersAndCampaigns/trackers/addTracker"));
                        $oMenu->addTo("advertiser-trackers", new OA_Admin_Menu_Section("tracker-edit", 'TrackerProperties', "tracker-edit.php?clientid={clientid}&trackerid={trackerid}", false, "inventory/advertisersAndCampaigns/trackers/editTracker"));
                        $oMenu->addTo("advertiser-trackers", new OA_Admin_Menu_Section("tracker-campaigns", 'LinkedCampaigns', "tracker-campaigns.php?clientid={clientid}&trackerid={trackerid}", false, "inventory/advertisersAndCampaigns/trackers/editTracker/linkedCampaigns"));
                        $oMenu->addTo("advertiser-trackers", new OA_Admin_Menu_Section("tracker-variables", 'Variables', "tracker-variables.php?clientid={clientid}&trackerid={trackerid}", false, "inventory/advertisersAndCampaigns/trackers/editTracker/variables"));
                        $oMenu->addTo("advertiser-trackers", new OA_Admin_Menu_Section("tracker-append", 'AppendTrackerCode', "tracker-append.php?clientid={clientid}&trackerid={trackerid}", false, "inventory/advertisersAndCampaigns/trackers/editTracker/appendCode"));
                        $oMenu->addTo("advertiser-trackers", new OA_Admin_Menu_Section("tracker-invocation", 'Invocationcode', "tracker-invocation.php?clientid={clientid}&trackerid={trackerid}", false, "inventory/advertisersAndCampaigns/trackers/editTracker/invocationCode"));
                }
                $oMenu->addTo("advertiser-index", new OA_Admin_Menu_Section("advertiser-access", 'UserAccess', "advertiser-access.php?clientid={clientid}", false, ""));

            $oMenu->addTo("inventory", new OA_Admin_Menu_Section("advertiser-campaigns", 'Campaigns', "advertiser-campaigns.php", false, "inventory/advertiserAndCampaings/campaigns", null, 1, false, 'g_adv'));
                $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-edit_new", 'AddCampaign', "campaign-edit.php?clientid={clientid}", true, "inventory/advertiserAndCampaings/campaigns/addCampaign"));
                $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-edit", 'CampaignProperties', "campaign-edit.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/editCampaign"));
                $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-zone", 'LinkedZones', "campaign-zone.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/linkedZones"));
                if ($aConf['logging']['trackerImpressions']) {
                    $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-trackers", 'LinkedTrackers', "campaign-trackers.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/linkedTrackers"));
                }

            $oMenu->addTo("inventory", new OA_Admin_Menu_Section("campaign-banners", 'Banners', "campaign-banners.php", false, "inventory/advertisersAndCampaigns/campaigns/banners", null, 1, false, 'g_adv'));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-edit_new", 'AddBanner', "banner-edit.php?clientid={clientid}&campaignid={campaignid}", true, "inventory/advertisersAndCampaigns/campaigns/banners/addBanner"));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-edit", 'BannerProperties', "banner-edit.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/banners/editBanner"));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-swf", 'ConvertSWFLinks', "banner-swf.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, null, array(), 1, true));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-acl", 'ModifyBannerAcl', "banner-acl.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/banners/editBanner/deliveryOptions"));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-zone", 'LinkedZones', "banner-zone.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/banners/editBanner/linkedZones"));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-advanced", 'Advanced', "banner-advanced.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/banners/editBanner/convertFlashLinks"));

            $oMenu->addTo("inventory", new OA_Admin_Menu_Section("website-index", 'Affiliates', "website-index.php", false, "inventory/publishersAndZones", null, 1, false, 'g_website'));
                $oMenu->addTo("website-index", new OA_Admin_Menu_Section("affiliate-edit_new", 'AddNewAffiliate', "affiliate-edit.php", true, "inventory/publishersAndZones/addPublisher"));
                $oMenu->addTo("website-index", new OA_Admin_Menu_Section("affiliate-edit", 'AffiliateProperties', "affiliate-edit.php?affiliateid={affiliateid}", false, "inventory/publishersAndZones/editPublisher"));
                $oMenu->addTo('website-index', new OA_Admin_Menu_Section('affiliate-invocation', 'Invocationcode', 'affiliate-invocation.php?affiliateid={affiliateid}', false, "inventory/affiliateInvocation"));
                    $oMenu->addTo('affiliate-invocation', new OA_Admin_Menu_Section('affiliate-preview', 'InvocationcodePreview', 'affiliate-preview.php'));
                $oMenu->addTo('website-index', new OA_Admin_Menu_Section('affiliate-access', 'UserAccess', 'affiliate-access.php?affiliateid={affiliateid}'));
 /* DAC009 - openxmods */
 $oMenu->addTo("website-index", new OA_Admin_Menu_Section("affiliate-dsp", "Affiliate DSP Assoc", "affiliate-dsp.php?affiliateid={affiliateid}", false, "inventory/editDSPPublisher"));
 $oMenu->addTo("website-index", new OA_Admin_Menu_Section("affiliate-dsp-app-objects", "DSP App Object", "affiliate-dsp-app-objects.php?affiliateid={affiliateid}", false, "inventory/editDSPPublisher"));
  
/* DAC009 - openxmods */

         
          ////////////////////////////* Begin OpenXmods G *////////////////////////////      
                //~ $oMenu->addTo('website-index', new OA_Admin_Menu_Section('manage_apps', 'Organize Apps', 'manage_apps.php?affiliateid={affiliateid}'));
                //~ 
                //~ $oMenu->addTo('website-index', new OA_Admin_Menu_Section('manage_adunits', 'Organize Ad Units', 'manage_adunits.php?affiliateid={affiliateid}'));
                //~ 
                //~ $oMenu->addTo('website-index', new OA_Admin_Menu_Section('manage_networks', 'Organize Networks', 'manage_networks.php?affiliateid={affiliateid}'));
                //~ 
                //~ $oMenu->addTo('website-index', new OA_Admin_Menu_Section('manage_segments', 'Organize Segments', 'manage_segments.php?affiliateid={affiliateid}'));   	    
          
      
	////////////////////////////* End OpenXmods G *//////////////////////////////

            $oMenu->addTo('inventory', new OA_Admin_Menu_Section('affiliate-zones', 'Zones', 'affiliate-zones.php', false, "inventory/publishersAndZones/zones", null, 1, false, 'g_website'));
                $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-edit_new', 'AddNewZone', 'zone-edit.php?affiliateid={affiliateid}', true, "inventory/publishersAndZones/zones/addZone"));
                $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-edit', 'ZoneProperties', 'zone-edit.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone"));
                $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-advanced', 'Advanced', 'zone-advanced.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/advanced"));
	
		 $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('djax-parameters', 'Advanced Open RTB Parameters', 'djax-parameters.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/parameter"));
	
                $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-include', 'IncludedBanners', 'zone-include.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/linkedBanners"));
                $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-probability', 'Probability', 'zone-probability.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/probability"));
                $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-invocation', 'Invocationcode', 'zone-invocation.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/invocationCode"));
 
//===========================Modified By DAC157 G Starts =============================//
 //~ $oMenu->addTo("inventory", new OA_Admin_Menu_Section('affiliate-apps', 'App Publisher', 'affiliate-apps.php', false, 'inventory/publishersAndZonesAndapps/apps', null, 1, false, 'g_website')); //g_mobizone

//===========================Modified By DAC157 G Ends=============================//


            $oMenu->addTo('inventory', new OA_Admin_Menu_Section('affiliate-channels', 'Channels', 'affiliate-channels.php', false, "inventory/publishersAndZones/channels", null, 1, false, 'g_website'));
                $oMenu->addTo('affiliate-channels', new OA_Admin_Menu_Section('channel-edit-affiliate_new', 'AddNewChannel', 'channel-edit.php?affiliateid={affiliateid}', true, "inventory/publishersAndZones/channels/addChannel"));
                $oMenu->addTo('affiliate-channels', new OA_Admin_Menu_Section('channel-edit-affiliate', 'ChannelProperties', 'channel-edit.php?affiliateid={affiliateid}&channelid={channelid}', false, "inventory/publishersAndZones/channels/editChannel"));
                $oMenu->addTo('affiliate-channels', new OA_Admin_Menu_Section('channel-affiliate-acl', 'ChannelLimitations', 'channel-acl.php?affiliateid={affiliateid}&channelid={channelid}', false, "inventory/publishersAndZones/channels/editChannel/deliveryOptions"));
				// DAC185 START Post back or Server-To-Server URL Tracking
				$oMenu->addTo('inventory', new OA_Admin_Menu_Section('s2s-tracker', 'Advertiser Post Back Tracker Pixel', 's2s-tracker.php', false, "inventory/S2S Tracker", null, 1, false, 'g_website'));
                $oMenu->addTo('s2s-tracker', new OA_Admin_Menu_Section('s2s-tracker_new', 'Post Back Tracker Code', 's2s-tracker.php', true, "inventory/inventory/S2S Tracker"));
				//  DAC185 END Post back or Server-To-Server URL Tracking
			if (empty($aConf['ui']['disableDirectSelection'])) {
                $oMenu->addTo("inventory", new OA_Admin_Menu_Section("admin-generate", 'GenerateBannercode', "admin-generate.php", false, ""));
			}
            if (empty($aConf['ui']['disableDirectSelection'])) {
                $oMenu->addTo("inventory", new OA_Admin_Menu_Section("admin-generate", 'GenerateBannercode', "admin-generate.php", false, ""));
            }
            $oMenu->addTo("inventory", new OA_Admin_Menu_Section("agency-access", 'UserAccess', "agency-access.php?agencyid={agencyid}", false, "", array(array(OA_ACCOUNT_MANAGER => OA_PERM_SUPER_ACCOUNT))));
                $oMenu->addTo("agency-access", new OA_Admin_Menu_Section("agency-user", 'UserProperties', "agency-user.php?userid={userid}&agencyid={agencyid}", false, ""));

            $oMenu->add(new OA_Admin_Menu_Section("account-index", 'Preferences', "account-index.php", false, "settings"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("account-user-index", 'UserPreferences', "account-user-index.php", false, ""));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("account-preferences-index", 'AccountPreferences', "account-preferences-index.php", false, "settings/preferences"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("userlog-index", 'UserLog', "userlog-index.php", false, "settings/userLog"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("channel-index", 'ChannelManagement', "channel-index.php", false, "settings/channelManagement"));
                    $oMenu->addTo("channel-index", new OA_Admin_Menu_Section("channel-edit_new", 'AddNewChannel', "channel-edit.php?agencyid={agencyid}", true, "settings/channelManagement/addChannel"));
                    $oMenu->addTo("channel-index", new OA_Admin_Menu_Section("channel-edit", 'ChannelProperties', "channel-edit.php?agencyid={agencyid}&channelid={channelid}", false, "settings/channelManagement/editChannel"));
                    $oMenu->addTo("channel-index", new OA_Admin_Menu_Section("channel-acl", 'ChannelLimitations', "channel-acl.php?agencyid={agencyid}&channelid={channelid}", false, "settings/channelManagement/editChannel/deliveryOptions"));
            break;
        case OA_ACCOUNT_TRAFFICKER:
            // Note: The stats screens haven't been updated to use the new menuing names...
            $oMenu->add(new OA_Admin_Menu_Section("1", 'Stats', "stats.php?entity=affiliate&breakdown=history&affiliateid={affiliateid}", false, "statistics/publisherHistory"));
                $oMenu->addTo("1", new OA_Admin_Menu_Section("1.1", 'AffiliateHistory', "stats.php?entity=affiliate&breakdown=history&affiliateid={affiliateid}", false, "statistics/publisherHistory"));
                $oMenu->addTo("1.1", new OA_Admin_Menu_Section("1.1.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&day={day}", false, "statistics/publisherHistory/daily"));
                $oMenu->addTo("1", new OA_Admin_Menu_Section("1.2", 'Zones', "stats.php?entity=affiliate&breakdown=zones&affiliateid={affiliateid}", false, "statistics/zoneOverview"));
                $oMenu->addTo("1.2", new OA_Admin_Menu_Section("1.2.1", 'ZoneHistory', "stats.php?entity=zone&breakdown=history&affiliateid={affiliateid}&zoneid={zoneid}", false, "statistics/zoneHistory"));
                $oMenu->addTo("1.2.1", new OA_Admin_Menu_Section("1.2.1.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&day={day}", false, "statistics/zoneHistory"));
                $oMenu->addTo("1.2", new OA_Admin_Menu_Section("1.2.2", 'CampaignDistribution', "stats.php?entity=zone&breakdown=campaigns&affiliateid={affiliateid}&zoneid={zoneid}", false, "statistics/zoneHistory/daily"));
                $oMenu->addTo("1.2.2", new OA_Admin_Menu_Section("1.2.2.1", 'DistributionHistoryCampaign', "stats.php?entity=zone&breakdown=campaign-history&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}", true, "statistics/campaignDistribution"));
                $oMenu->addTo("1.2.2.1", new OA_Admin_Menu_Section("1.2.2.1.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&day={day}", false, "statistics/campaignDistribution/history"));
                $oMenu->addTo("1.2.2", new OA_Admin_Menu_Section("1.2.2.2", 'DistributionHistoryBanner', "stats.php?entity=zone&breakdown=banner-history&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&bannerid={bannerid}", true, "statistics/campaignDistribution/history/daily"));
                $oMenu->addTo("1.2.2.2", new OA_Admin_Menu_Section("1.2.2.2.1", 'DailyStats', "stats.php?entity=zone&breakdown=daily&affiliateid={affiliateid}&zoneid={zoneid}&campaignid={campaignid}&bannerid={bannerid}&day={day}"));
                $oMenu->addTo("1", new OA_Admin_Menu_Section("1.3", 'CampaignDistribution', "stats.php?entity=affiliate&breakdown=campaigns&affiliateid={affiliateid}", false, "statistics/campaignDistribution"));
                $oMenu->addTo("1.3", new OA_Admin_Menu_Section("1.3.1", 'DistributionHistoryCampaign', "stats.php?entity=affiliate&breakdown=campaign-history&affiliateid={affiliateid}&campaignid={campaignid}", true, "statistics/campaignDistribution/history"));
                $oMenu->addTo("1.3.1", new OA_Admin_Menu_Section("1.3.1.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&campaignid={campaignid}&day={day}", false, "statistics/campaignDistribution/history/daily"));
                $oMenu->addTo("1.3", new OA_Admin_Menu_Section("1.3.2", 'DistributionHistoryBanner', "stats.php?entity=affiliate&breakdown=banner-history&affiliateid={affiliateid}&campaignid={campaignid}&bannerid={bannerid}", true));
                $oMenu->addTo("1.3.2", new OA_Admin_Menu_Section("1.3.2.1", 'DailyStats', "stats.php?entity=affiliate&breakdown=daily&affiliateid={affiliateid}&campaignid={campaignid}&bannerid={bannerid}&day={day}", true));
                $oMenu->addTo("1", new OA_Admin_Menu_Section("report-index", 'AdvancedReports', "report-index.php?affiliateid={affiliateid}", false, "reports"));
                
                ///////// Mediation Stats G Starts /////////
			//~ $oMenu->addTo("1", new OA_Admin_Menu_Section("apps_stats", 'App Reports', "apps_stats.php?affiliateid={affiliateid}", false, "reports"));
			    //~ 
			//~ $oMenu->addTo("1", new OA_Admin_Menu_Section("adunit_stats", 'Adunit Reports', "adunit_stats.php?affiliateid={affiliateid}", false, "reports"));
			    //~ 
			//~ $oMenu->addTo("1", new OA_Admin_Menu_Section("network_stats", 'Network Reports', "network_stats.php?affiliateid={affiliateid}", false, "reports"));
			///////// Mediation G Stats Ends/////////

            $oMenu->add(new OA_Admin_Menu_Section("inventory", 'Adminstration', "affiliate-zones.php?affiliateid={affiliateid}", false, "inventory/publishersAndZones/zones"));
                $oMenu->addTo("inventory", new OA_Admin_Menu_Section("affiliate-zones", 'Zones', "affiliate-zones.php?affiliateid={affiliateid}", false, "inventory/publishersAndZones/zones"));
                    $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-edit_new', 'AddNewZone', 'zone-edit.php?affiliateid={affiliateid}', true, "inventory/publishersAndZones/zones/addZone", array(array(OA_ACCOUNT_TRAFFICKER => OA_PERM_ZONE_ADD))));
                    $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-edit', 'ZoneProperties', 'zone-edit.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone", array(array(OA_ACCOUNT_TRAFFICKER => OA_PERM_ZONE_EDIT))));
                    $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('djax-parameters', 'Advanced Open RTB Parameters', 'djax-parameters.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/parameter"));
                    $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-include', 'IncludedBanners', 'zone-include.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/linkedBanners", array(array(OA_ACCOUNT_TRAFFICKER => OA_PERM_ZONE_LINK))));
                    $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-probability', 'Probability', 'zone-probability.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/linkedBanners/probability"));
                    $oMenu->addTo('affiliate-zones', new OA_Admin_Menu_Section('zone-invocation', 'Invocationcode', 'zone-invocation.php?affiliateid={affiliateid}&zoneid={zoneid}', false, "inventory/publishersAndZones/zones/editZone/linkedBanners/invocationCode", array(array(OA_ACCOUNT_TRAFFICKER => OA_PERM_ZONE_INVOCATION))));
                $oMenu->addTo('inventory', new OA_Admin_Menu_Section('affiliate-invocation', 'Invocationcode', 'affiliate-invocation.php?affiliateid={affiliateid}', false, "inventory/affiliateInvocation", array(array(OA_ACCOUNT_TRAFFICKER => OA_PERM_ZONE_INVOCATION))));
                    $oMenu->addTo('affiliate-invocation', new OA_Admin_Menu_Section('affiliate-preview', 'InvocationcodePreview', 'affiliate-preview.php', false, "", array(array(OA_ACCOUNT_TRAFFICKER => OA_PERM_ZONE_INVOCATION))));
                $oMenu->addTo('inventory', new OA_Admin_Menu_Section('affiliate-access', 'UserAccess', 'affiliate-access.php?affiliateid={affiliateid}', false, "", array(array(OA_ACCOUNT_TRAFFICKER => OA_PERM_SUPER_ACCOUNT))));
            $oMenu->add(new OA_Admin_Menu_Section("account-index", 'Preferences', "account-index.php", false, "settings"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("account-user-index", 'UserPreferences', "account-user-index.php", false, "settings/preferences"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("account-preferences-index", 'AccountPreferences', "account-preferences-index.php", false, "settings/preferences"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("userlog-index", 'UserLog', "userlog-index.php", false, "settings/userLog", array(array(OA_ACCOUNT_TRAFFICKER => OA_PERM_USER_LOG_ACCESS))));
           
           
            $oMenu->add(new OA_Admin_Menu_Section("pubstats", 'DSP Statistics', "djax-dsp-pubstats.php?affiliateid={affiliateid}", false, "dspstats/pubhistory"));
                 $oMenu->addTo("pubstats", new OA_Admin_Menu_Section("dsp-pubstats", 'DSP Reports', "djax-dsp-pubstats.php?affiliateid={affiliateid}", false, ""));
                 $oMenu->addTo("pubstats", new OA_Admin_Menu_Section("dsp-pubcountrystats", 'Dsp Country Reports', "djax-dsp-pubcountrystats.php?affiliateid={affiliateid}", false, ""));
                 $oMenu->addTo("pubstats", new OA_Admin_Menu_Section("dsp-pubdevicestats", 'Dsp Device Reports', "djax-dsp-pubdevicestats.php?affiliateid={affiliateid}", false, ""));
                 $oMenu->addTo("pubstats", new OA_Admin_Menu_Section("dsp-pubsitestats", 'Dsp Site Reports', "djax-dsp-pubsitestats.php?affiliateid={affiliateid}", false, ""));


                
    ////////////////////////////* Begin OpenXmods *////////////////////////////
	//	$oMenu->add(new OA_Admin_Menu_Section("mediation", 'Mediation', "manage_apps.php?affiliateid={affiliateid}", false, "mediation_apps"));
     	//~ 
     		//~ $oMenu->addTo("mediation", new OA_Admin_Menu_Section("manage_apps", 'Organize Apps', "manage_apps.php?affiliateid={affiliateid}", false, "mediation_apps"));
        //~ 
           	//~ $oMenu->addTo("mediation", new OA_Admin_Menu_Section("manage_adunits", 'Organize Ad Units', "manage_adunits.php?affiliateid={affiliateid}", false, "mediation_apps"));
        //~ 
        	//~ $oMenu->addTo("mediation", new OA_Admin_Menu_Section("manage_networks", 'Organize Networks', "manage_networks.php?affiliateid={affiliateid}", false, "mediation_networks"));
        //~ 
       		//~ $oMenu->addTo("mediation", new OA_Admin_Menu_Section("manage_segments", 'Organize Segments', "manage_segments.php?affiliateid={affiliateid}", false, "mediation_segments"));
       
	////////////////////////////* End OpenXmods *//////////////////////////////
        break;
        case OA_ACCOUNT_ADVERTISER:
			//DAC029
		$oMenu->add(new OA_Admin_Menu_Section("overview", 'Dashboard', "overview-index.php", false, "email"));
				 $oMenu->addTo("overview", new OA_Admin_Menu_Section("overview-index", 'Overview', "overview-index.php", false, ""));  
				 $oMenu->addTo("overview", new OA_Admin_Menu_Section("campaign-overview", 'CampaignOverview', "campaign-overview.php", false, ""));    
			//DAC029        
            // Note: The stats screens haven't been updated to use the new menuing names...
            $oMenu->add(new OA_Admin_Menu_Section("1", 'Stats', "stats.php?entity=advertiser&breakdown=history&clientid={clientid}", false, "statistics/advertiserHistory"));
            $oMenu->addTo("1", new OA_Admin_Menu_Section("1.1", 'ClientHistory', "stats.php?entity=advertiser&breakdown=history&clientid={clientid}", false, "statistics/advertiserHistory"));
            $oMenu->addTo("1.1", new OA_Admin_Menu_Section("1.1.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&day={day}", false, "statistics/advertiserHistory/daily"));
            $oMenu->addTo("1", new OA_Admin_Menu_Section("1.2", 'Campaigns', "stats.php?entity=advertiser&breakdown=campaigns&clientid={clientid}", false, "statistics/campaignOverview"));
            $oMenu->addTo("1.2", new OA_Admin_Menu_Section("1.2.1", 'CampaignHistory', "stats.php?entity=campaign&breakdown=history&clientid={clientid}&campaignid={campaignid}", false, "statistics/campaignHistory"));
            $oMenu->addTo("1.2.1", new OA_Admin_Menu_Section("1.2.1.1", 'DailyStats', "stats.php?entity=campaign&breakdown=daily&clientid={clientid}&campaignid={campaignid}&day={day}", false, "statistics/campaignHistory/daily"));
            $oMenu->addTo("1.2", new OA_Admin_Menu_Section("1.2.2", 'Banners', "stats.php?entity=campaign&breakdown=banners&clientid={clientid}&campaignid={campaignid}", false, "statistics/bannerOverview"));
            $oMenu->addTo("1.2.2", new OA_Admin_Menu_Section("1.2.2.1", 'BannerHistory', "stats.php?entity=banner&breakdown=history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "statistics/bannerHistory"));
            $oMenu->addTo("1.2.2.1", new OA_Admin_Menu_Section("1.2.2.1.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&day={day}", false, "statistics/bannerHistory/daily"));
            $oMenu->addTo("1.2.2", new OA_Admin_Menu_Section("1.2.2.4", 'PublisherDistribution', "stats.php?entity=banner&breakdown=affiliates&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "statistics/publisherDistribution"));
            $oMenu->addTo("1.2.2.4", new OA_Admin_Menu_Section("1.2.2.4.1", 'DistributionHistoryWebsite', "stats.php?entity=banner&breakdown=affiliate-history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/history"));
            $oMenu->addTo("1.2.2.4.1", new OA_Admin_Menu_Section("1.2.2.4.1.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
            $oMenu->addTo("1.2.2.4", new OA_Admin_Menu_Section("1.2.2.4.2", 'DistributionHistoryZone', "stats.php?entity=banner&breakdown=zone-history&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
            $oMenu->addTo("1.2.2.4.2", new OA_Admin_Menu_Section("1.2.2.4.2.1", 'DailyStats', "stats.php?entity=banner&breakdown=daily&clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
            $oMenu->addTo("1.2", new OA_Admin_Menu_Section("1.2.3", 'PublisherDistribution', "stats.php?entity=campaign&breakdown=affiliates&clientid={clientid}&campaignid={campaignid}", false, "statistics/publisherDistribution"));
            $oMenu->addTo("1.2.3", new OA_Admin_Menu_Section("1.2.3.1", 'DistributionHistoryWebsite', "stats.php?entity=campaign&breakdown=affiliate-history&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/history"));
            $oMenu->addTo("1.2.3.1", new OA_Admin_Menu_Section("1.2.3.1.1", 'DailyStats', "stats.php?entity=campaign&breakdown=daily&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
            $oMenu->addTo("1.2.3", new OA_Admin_Menu_Section("1.2.3.2", 'DistributionHistoryZone', "stats.php?entity=campaign&breakdown=zone-history&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
            $oMenu->addTo("1.2.3.2", new OA_Admin_Menu_Section("1.2.3.2.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&campaignid={campaignid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
            $oMenu->addTo("1", new OA_Admin_Menu_Section("1.3", 'PublisherDistribution', "stats.php?entity=advertiser&breakdown=affiliates&clientid={clientid}", false, "statistics/publisherDistribution"));
            $oMenu->addTo("1.3", new OA_Admin_Menu_Section("1.3.1", 'DistributionHistoryWebsite', "stats.php?entity=advertiser&breakdown=affiliate-history&clientid={clientid}&affiliateid={affiliateid}", true, "statistics/publisherDistribution/hisotry"));
            $oMenu->addTo("1.3.1", new OA_Admin_Menu_Section("1.3.1.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&affiliateid={affiliateid}&day={day}", false, "statistics/publisherDistribution/history/daily"));
            $oMenu->addTo("1.3", new OA_Admin_Menu_Section("1.3.2", 'DistributionHistoryZone', "stats.php?entity=advertiser&breakdown=zone-history&clientid={clientid}&affiliateid={affiliateid}&zoneid={zoneid}", true));
            $oMenu->addTo("1.3.2", new OA_Admin_Menu_Section("1.3.2.1", 'DailyStats', "stats.php?entity=advertiser&breakdown=daily&clientid={clientid}&affiliateid={affiliateid}&zoneid={zoneid}&day={day}"));
            $oMenu->addTo("1", new OA_Admin_Menu_Section("report-index", 'AdvancedReports', "report-index.php?clientid={clientid}", false, "reports"));

            $oMenu->add(new OA_Admin_Menu_Section("inventory", 'Adminstration', "advertiser-campaigns.php?clientid={clientid}", false, "inventory/advertisersAndCampaigns/campaigns"));
                $oMenu->addTo("inventory", new OA_Admin_Menu_Section("advertiser-campaigns", 'Campaigns', "advertiser-campaigns.php?clientid={clientid}", false, "inventory/advertisersAndCampaigns/campaigns"));
				$oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-banners", 'Banners', "campaign-banners.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/banners"));
					
					//**************  Modified By DAC176 *********************//
					
					$oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-edit_new", 'AddCampaign', "campaign-edit.php?clientid={clientid}", true, "inventory/advertiserAndCampaings/campaigns/addCampaign",array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_CAMP_ADD))));                
                 $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-edit", 'CampaignProperties', "campaign-edit.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/editCampaign",array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_CAMP_EDIT))));
                $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-zone", 'LinkedZones', "campaign-zone.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/linkedZones",array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_CAMP_EDIT))));
					
					//**************  Modified By DAC176 *********************//
					
					//**************  Modified By OpenXmods *********************//

                  $oMenu->addTo("inventory", new OA_Admin_Menu_Section("advertiser-campaigns", 'Campaigns', "advertiser-campaigns.php", false, "inventory/advertiserAndCampaings/campaigns", null, 1, false, 'g_adv'));
                $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-edit_new", 'AddCampaign', "campaign-edit.php?clientid={clientid}", true, "inventory/advertiserAndCampaings/campaigns/addCampaign"));
                $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-edit", 'CampaignProperties', "campaign-edit.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/editCampaign"));
                $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-zone", 'LinkedZones', "campaign-zone.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/linkedZones"));
                
                //**************  Modified By OpenXmods *********************//
                
                
              //**************  Modified By DAC176 *********************//        
                
                if ($aConf['logging']['trackerImpressions']) {
                    
                    $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-trackers", 'LinkedTrackers', "campaign-trackers.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/linkedTrackers",array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_CAMP_EDIT))));
                    
                }
                
                $oMenu->addTo("advertiser-campaigns", new OA_Admin_Menu_Section("campaign-banners", 'Banners', "campaign-banners.php?clientid={clientid}&campaignid={campaignid}", false, "inventory/advertisersAndCampaigns/campaigns/banners"));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-edit_new", 'AddBanner', "banner-edit.php?clientid={clientid}&campaignid={campaignid}", true, "inventory/advertisersAndCampaigns/campaigns/banners/addBanner", array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_BAN_ADD))));                    
                        $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-edit", 'BannerProperties', "banner-edit.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/editBanner", array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_BANNER_EDIT))));
                
				//**************  Modified By DAC176 G *********************//
				
				
				//**************  Modified By OpenXmods G*********************//
				
            $oMenu->addTo("inventory", new OA_Admin_Menu_Section("campaign-banners", 'Banners', "campaign-banners.php", false, "inventory/advertisersAndCampaigns/campaigns/banners", null, 1, false, 'g_adv'));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-edit_new", 'AddBanner', "banner-edit.php?clientid={clientid}&campaignid={campaignid}", true, "inventory/advertisersAndCampaigns/campaigns/banners/addBanner"));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-edit", 'BannerProperties', "banner-edit.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/banners/editBanner"));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-swf", 'ConvertSWFLinks', "banner-swf.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, null, array(), 1, true));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-acl", 'ModifyBannerAcl', "banner-acl.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/banners/editBanner/deliveryOptions",array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_DELIVERY))));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-zone", 'LinkedZones', "banner-zone.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/banners/editBanner/linkedZones"));
                $oMenu->addTo("campaign-banners", new OA_Admin_Menu_Section("banner-advanced", 'Advanced', "banner-advanced.php?clientid={clientid}&campaignid={campaignid}&bannerid={bannerid}", false, "inventory/advertisersAndCampaigns/campaigns/banners/editBanner/convertFlashLinks"));
				
           
					//**************  Modified By OpenXmods G*********************//




                   
                $oMenu->addTo("inventory", new OA_Admin_Menu_Section("advertiser-access", 'UserAccess', "advertiser-access.php?clientid={clientid}", false, "", array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_SUPER_ACCOUNT))));
                    $oMenu->addTo("advertiser-access", new OA_Admin_Menu_Section("advertiser-user", 'UserProperties', "advertiser-user.php?userid={userid}&clientid={clientid}", false, "", array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_SUPER_ACCOUNT))));

            $oMenu->add(new OA_Admin_Menu_Section("account-index", 'Preferences', "account-index.php", false, "settings"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("account-user-index", 'UserPreferences', "account-user-index.php", false, ""));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("account-preferences-index", 'AccountPreferences', "account-preferences-index.php", false, "settings/prefrences"));
                $oMenu->addTo("account-index", new OA_Admin_Menu_Section("userlog-index", 'UserLog', "userlog-index.php", false, "settings/userLog", array(array(OA_ACCOUNT_ADVERTISER => OA_PERM_USER_LOG_ACCESS))));

		    ///////////////////////// begin OpenX mods ////////////////////////////
			$oMenu->add(new OA_Admin_Menu_Section("add_inventory", 'Buy Inventory', "oxm_add_inventory.php", false, "add_inventory"));
		    	$oMenu->addTo("add_inventory", new OA_Admin_Menu_Section("oxm_add_inventory", 'Buy Inventory', "oxm_add_inventory.php", false, "")); 
		    	$oMenu->addTo("add_inventory", new OA_Admin_Menu_Section("oxm_add_inventory_booking", 'Booking History', "oxm_add_inventory_booking.php", false, "")); 
			
		    ////////////////////////// end OpenX mods /////////////////////////////


        break;
        default:
            // If the user is not logged in then $accountType will be null
    }

    $GLOBALS['_MAX']['MENU_OBJECT'][$accountType] = &$oMenu;
    return $oMenu;
}

?>
