/*
 * File:        jquery.dataTables.columnFilter.js
 * Version:     1.5.0.
 * Author:      Jovan Popovic 
 * http://jquery-datatables-column-filter.googlecode.com/svn/trunk/index.htmls
 * http://code.google.com/p/jquery-datatables-column-filter/
 * 
 * Copyright 2011-2012 Jovan Popovic, all rights reserved.
 *
 * This source file is free software, under either the GPL v2 license or a
 * BSD style license, as supplied with this software.
 * 
 * This source file is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. 
 * 
 * Parameters:"
 * @sPlaceHolder                 String      Place where inline filtering function should be placed ("tfoot", "thead:before", "thead:after"). Default is "tfoot"
 * @sRangeSeparator              String      Separator that will be used when range values are sent to the server-side. Default value is "~".
 * @sRangeFormat                 string      Default format of the From ... to ... range inputs. Default is From {from} to {to}
 * @aoColumns                    Array       Array of the filter settings that will be applied on the columns
 */
(function(e) {
    e.fn.columnFilter = function(t) {
        function c(e, t, n, r, i) {
            if (typeof t == "undefined") return new Array;
            typeof n == "undefined" && (n = !0);
            typeof r == "undefined" && (r = !0);
            typeof i == "undefined" && (i = !0);
            var s;
            r == 1 ? s = e.aiDisplay : s = e.aiDisplayMaster;
            var o = new Array;
            for (var u = 0, a = s.length; u < a; u++) {
                var f = s[u],
                    l = w.fnGetData(f),
                    c = l[t];
                if (i == 1 && c.length == 0) continue;
                if (n == 1 && jQuery.inArray(c, o) > -1) continue;
                o.push(c)
            }
            return o.sort()
        }

        function h(e) {
            return S.bUseColVis ? e : w.fnSettings().oApi._fnVisibleToColumnIndex(w.fnSettings(), e)
        }

        function p(t, o, u, a, f, c) {
            var p = "text_filter";
            a && (p = "number_filter");
            i = i.replace(/(^\s*)|(\s*$)/g, "");
            var d = t.fnSettings().aoPreSearchCols[r].sSearch,
                v = "search_init ",
                m = i;
            if (d != "" && d != "^") {
                a && d.charAt(0) == "^" ? m = d.substr(1) : m = d;
                v = ""
            }
            var g = e('<input type="text" class="' + v + p + '" value="' + m + '"/>');
            c != undefined && c != -1 && g.attr("maxlength", c);
            s.html(g);
            a ? s.wrapInner('<span class="filter_column filter_number" />') : s.wrapInner('<span class="filter_column filter_text" />');
            n[r] = i;
            var y = r;
            a && !t.fnSettings().oFeatures.bServerSide ? g.keyup(function() {
                t.fnFilter("^" + this.value, h(y), !0, !1);
                l()
            }) : g.keyup(function() {
                if (t.fnSettings().oFeatures.bServerSide && f != 0) {
                    var n = t.fnSettings().aoPreSearchCols[y].sSearch,
                        r = e(this).data("dt-iLastFilterLength");
                    typeof r == "undefined" && (r = 0);
                    var i = this.value.length;
                    if (Math.abs(i - r) < f) return;
                    e(this).data("dt-iLastFilterLength", i)
                }
                t.fnFilter(this.value, h(y), o, u);
                l()
            });
            g.focus(function() {
                if (e(this).hasClass("search_init")) {
                    e(this).removeClass("search_init");
                    this.value = ""
                }
            });
            g.blur(function() {
                if (this.value == "") {
                    e(this).addClass("search_init");
                    this.value = n[y]
                }
            })
        }

        function d(t) {
            s.html(b(0));
            var n = t.attr("id") + "_range_from_" + r,
                i = e('<input type="text" class="number_range_filter" id="' + n + '" rel="' + r + '"/>');
            s.append(i);
            s.append(b(1));
            var o = t.attr("id") + "_range_to_" + r,
                u = e('<input type="text" class="number_range_filter" id="' + o + '" rel="' + r + '"/>');
            s.append(u);
            s.append(b(2));
            s.wrapInner('<span class="filter_column filter_number_range" />');
            var f = r;
            a.push(r);
            t.dataTableExt.afnFiltering.push(function(e, r, i) {
                if (t.attr("id") != e.sTableId) return !0;
                if (document.getElementById(n) == null) return !0;
                var s = document.getElementById(n).value * 1,
                    u = document.getElementById(o).value * 1,
                    a = r[h(f)] == "-" ? 0 : r[h(f)] * 1;
                return s == "" && u == "" ? !0 : s == "" && a <= u ? !0 : s <= a && "" == u ? !0 : s <= a && a <= u ? !0 : !1
            });
            e("#" + n + ",#" + o, s).keyup(function() {
                var e = document.getElementById(n).value * 1,
                    r = document.getElementById(o).value * 1;
                if (e != 0 && r != 0 && e > r) return;
                t.fnDraw();
                l()
            })
        }

        function v(t) {
            var n = o.split(/[}{]/);
            s.html("");
            var i = t.attr("id") + "_range_from_" + r,
                u = e('<input type="text" class="date_range_filter" id="' + i + '" rel="' + r + '"/>');
            u.datepicker();
            var f = t.attr("id") + "_range_to_" + r,
                c = e('<input type="text" class="date_range_filter" id="' + f + '" rel="' + r + '"/>');
            for (ti = 0; ti < n.length; ti++) n[ti] == S.sDateFromToken ? s.append(u) : n[ti] == S.sDateToToken ? s.append(c) : s.append(n[ti]);
            s.wrapInner('<span class="filter_column filter_date_range" />');
            c.datepicker();
            var p = r;
            a.push(r);
            t.dataTableExt.afnFiltering.push(function(n, r, i) {
                if (t.attr("id") != n.sTableId) return !0;
                var s = u.datepicker("getDate"),
                    o = c.datepicker("getDate");
                if (s == null && o == null) return !0;
                var a = null;
                try {
                    if (r[h(p)] == null || r[h(p)] == "") return !1;
                    a = e.datepicker.parseDate(e.datepicker.regional[""].dateFormat, r[h(p)])
                } catch (f) {
                    return !1
                }
                return a == null ? !1 : s == null && a <= o ? !0 : s <= a && o == null ? !0 : s <= a && a <= o ? !0 : !1
            });
            e("#" + i + ",#" + f, s).change(function() {
                t.fnDraw();
                l()
            })
        }

        function m(t, n, i, s, o, u, a) {
            n == null && (n = c(t.fnSettings(), i, !0, !1, !0));
            var f = i,
                h = t.fnSettings().aoPreSearchCols[r].sSearch;
            if (h == null || h == "") h = a;
            var p = '<select class="search_init select_filter"><option value="" class="search_init">' + o + "</option>",
                d = 0,
                v = n.length;
            for (d = 0; d < v; d++)
                if (typeof n[d] != "object") {
                    var m = "";
                    if (escape(n[d]) == h || escape(n[d]) == escape(h)) m = "selected ";
                    p += "<option " + m + ' value="' + escape(n[d]) + '">' + n[d] + "</option>"
                } else {
                    var m = "";
                    if (u) {
                        n[d].value == h && (m = "selected ");
                        p += "<option " + m + 'value="' + n[d].value + '">' + n[d].label + "</option>"
                    } else {
                        escape(n[d].value) == h && (m = "selected ");
                        p += "<option " + m + 'value="' + escape(n[d].value) + '">' + n[d].label + "</option>"
                    }
                }
            var g = e(p + "</select>");
            s.html(g);
            s.wrapInner('<span class="filter_column filter_select" />');
            g.change(function() {
                e(this).val() != "" ? e(this).removeClass("search_init") : e(this).addClass("search_init");
                u ? t.fnFilter(e(this).val(), i, u) : t.fnFilter(unescape(e(this).val()), i);
                l()
            });
            h != null && h != "" && t.fnFilter(unescape(h), i)
        }

        function g(e, t, n, o) {
            var u = e.fnSettings();
            t == null && u.sAjaxSource != "" && !u.oFeatures.bServerSide && u.aoDrawCallback.push({
                fn: function(t, r, i) {
                    return function() {
                        if (u.iDraw == 2 && u.sAjaxSource != null && u.sAjaxSource != "" && !u.oFeatures.bServerSide) return m(e, null, h(t), r, i, n, o)
                    }
                }(r, s, i),
                sName: "column_filter_" + r
            });
            m(e, t, h(r), s, i, n, o)
        }

        function y(t, n) {
            n == null && (n = c(t.fnSettings(), r, !0, !0, !0));
            var o = r,
                u = "",
                a, f = n.length,
                h = i.replace("%", "Perc").replace("&", "AND").replace("$", "DOL").replace("£", "STERL").replace("@", "AT").replace(/\s/g, "_");
            h = h.replace(/[^a-zA-Z 0-9]+/g, "");
            var p = i;
            if (S.sFilterButtonText != null || S.sFilterButtonText != undefined) p = S.sFilterButtonText;
            var d = 10,
                v = 12,
                m = Math.floor(f / v);
            f % v > 0 && (m += 1);
            var g = 100 / m - 2,
                y = d * m;
            m == 1 && (g = 20);
            var b = '<div style="float:left; min-width: ' + g + '%; " >',
                w = "</div>",
                E = t.attr("id") + h,
                x = "chkBtnOpen" + E,
                T = E + "-flt-toggle";
            u += '<button id="' + x + '" class="checkbox_filter" > ' + p + "</button>";
            u += '<div id="' + T + '" ' + 'title="' + i + '" ' + 'class="toggle-check ui-widget-content ui-corner-all"  style="width: ' + y + '%; " >';
            u += b;
            for (a = 0; a < f; a++) {
                a % v == 0 && a != 0 && (u += w + b);
                u += '<input class="search_init checkbox_filter" type="checkbox" id= "' + n[a] + '" name= "' + h + '" value="' + n[a] + '" >' + n[a] + "<br/>";
                var N = e(u);
                s.html(N);
                s.wrapInner('<span class="filter_column filter_checkbox" />');
                N.change(function() {
                    var r = "",
                        i = "|",
                        s = e('input:checkbox[name="' + h + '"]:checked').size();
                    e('input:checkbox[name="' + h + '"]:checked').each(function(t) {
                        if (t == 0 && s == 1 || t != 0 && t == s - 1) i = "";
                        r = r.replace(/^\s+|\s+$/g, "");
                        r = r + e(this).val() + i;
                        i = "|"
                    });
                    for (var u = 0; u < f; u++) r != "" ? e("#" + n[u]).removeClass("search_init") : e("#" + n[u]).addClass("search_init");
                    t.fnFilter(r, o, !0, !1);
                    l()
                })
            }
            e("#" + x).button();
            e("#" + T).dialog({
                autoOpen: !1,
                hide: "blind",
                buttons: [{
                    text: "Reset",
                    click: function() {
                        e('input:checkbox[name="' + h + '"]:checked').each(function(t) {
                            e(this).attr("checked", !1);
                            e(this).addClass("search_init")
                        });
                        t.fnFilter("", o, !0, !1);
                        l();
                        return !1
                    }
                }, {
                    text: "Close",
                    click: function() {
                        e(this).dialog("close")
                    }
                }]
            });
            e("#" + x).click(function() {
                e("#" + T).dialog("open");
                var t = e(this);
                e("#" + T).dialog("widget").position({
                    my: "top",
                    at: "bottom",
                    of: t
                });
                return !1
            });
            var C = l;
            l = function() {
                var t = e("#" + x);
                e("#" + T).dialog("widget").position({
                    my: "top",
                    at: "bottom",
                    of: t
                });
                C()
            }
        }

        function b(e) {
            switch (e) {
                case 0:
                    return o.substring(0, o.indexOf("{from}"));
                case 1:
                    return o.substring(o.indexOf("{from}") + 6, o.indexOf("{to}"));
                default:
                    return o.substring(o.indexOf("{to}") + 4)
            }
        }
        var n, r, i, s, o = "From {from} to {to}",
            u = new Array,
            a = new Array,
            f = null,
            l = function() {},
            w = this,
            E = {
                sPlaceHolder: "foot",
                sRangeSeparator: "~",
                iFilteringDelay: 500,
                aoColumns: null,
                sRangeFormat: "From {from} to {to}",
                sDateFromToken: "from",
                sDateToToken: "to"
            },
            S = e.extend(E, t);
        return this.each(function() {
            if (!w.fnSettings().oFeatures.bFilter) return;
            n = new Array;
            var t = w.fnSettings().aoFooter[0],
                f = w.fnSettings().nTFoot,
                l = "tr";
            if (S.sPlaceHolder == "head:after") {
                var c = e("tr:first", w.fnSettings().nTHead).detach();
                if (w.fnSettings().bSortCellsTop) {
                    c.prependTo(e(w.fnSettings().nTHead));
                    t = w.fnSettings().aoHeader[1]
                } else {
                    c.appendTo(e(w.fnSettings().nTHead));
                    t = w.fnSettings().aoHeader[0]
                }
                l = "tr:last";
                f = w.fnSettings().nTHead
            } else if (S.sPlaceHolder == "head:before") {
                if (w.fnSettings().bSortCellsTop) {
                    var c = e("tr:first", w.fnSettings().nTHead).detach();
                    c.appendTo(e(w.fnSettings().nTHead));
                    t = w.fnSettings().aoHeader[1]
                } else t = w.fnSettings().aoHeader[0];
                l = "tr:first";
                f = w.fnSettings().nTHead
            }
            e(t).each(function(t) {
                r = t;
                var n = {
                    type: "text",
                    bRegex: !1,
                    bSmart: !0,
                    iMaxLenght: -1,
                    iFilterLength: 0
                };
                if (S.aoColumns != null) {
                    if (S.aoColumns.length < r || S.aoColumns[r] == null) return;
                    n = S.aoColumns[r]
                }
                i = e(e(this)[0].cell).text();
                if (n.sSelector == null) s = e(e(this)[0].cell);
                else {
                    s = e(n.sSelector);
                    s.length == 0 && (s = e(e(this)[0].cell))
                }
                if (n != null) {
                    n.sRangeFormat != null ? o = n.sRangeFormat : o = S.sRangeFormat;
                    switch (n.type) {
                        case "null":
                            break;
                        case "number":
                            p(w, !0, !1, !0, n.iFilterLength, n.iMaxLenght);
                            break;
                        case "select":
                            n.bRegex != 1 && (n.bRegex = !1);
                            g(w, n.values, n.bRegex, n.selected);
                            break;
                        case "number-range":
                            d(w);
                            break;
                        case "date-range":
                            v(w);
                            break;
                        case "checkbox":
                            y(w, n.values);
                            break;
                        case "text":
                        default:
                            bRegex = n.bRegex == null ? !1 : n.bRegex;
                            bSmart = n.bSmart == null ? !1 : n.bSmart;
                            p(w, bRegex, bSmart, !1, n.iFilterLength, n.iMaxLenght)
                    }
                }
            });
            for (j = 0; j < a.length; j++) {
                var h = function() {
                    var t = w.attr("id");
                    return e("#" + t + "_range_from_" + a[j]).val() + S.sRangeSeparator + e("#" + t + "_range_to_" + a[j]).val()
                };
                u.push(h)
            }
            if (w.fnSettings().oFeatures.bServerSide) {
                var m = w.fnSettings().fnServerData;
                w.fnSettings().fnServerData = function(t, n, r) {
                    for (j = 0; j < a.length; j++) {
                        var i = a[j];
                        for (k = 0; k < n.length; k++) n[k].name == "sSearch_" + i && (n[k].value = u[j]())
                    }
                    n.push({
                        name: "sRangeSeparator",
                        value: S.sRangeSeparator
                    });
                    if (m != null) try {
                        m(t, n, r, w.fnSettings())
                    } catch (s) {
                        m(t, n, r)
                    } else e.getJSON(t, n, function(e) {
                        r(e)
                    })
                }
            }
        })
    }
})(jQuery);
