	
//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size='256000';
	var iab_file_type=['image/png','image/jpeg','image/gif'];

//Define default

	var input = document.getElementById("web_creative_edit"),formdata = false;
	//Bind the event to onchange of the url file
	if(creative_type=='web' || creative_type=='sql')
	{
		input.addEventListener("change",handleFileSelect , false);
	}
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#web_creative_edit_form" );


	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFileSelect(evt)
 	{
		var selcted_creative_size=jQuery('#web_creative_size').val();
		var creative_size_split = selcted_creative_size.split('x');
		var iab_max_width= parseInt(creative_size_split[0], 10); 
		var iab_max_height= parseInt(creative_size_split[1], 10);

		var form = jQuery( "#web_creative_edit_form" );

		var isvalid_creative=true;		//form check list

		jQuery('#tmp_web_creative').val('');//empty temporary feild value
		
		var i = 0, len = this.files.length, img, reader, file;

			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();
					freader.onload = function (evt) {
				//To fetch wight and heigh of the selected image using File API.
				img = new Image();
						img.src = evt.target.result;
				img.onload = function() //After programatically loding selcted image get inside the method
				{

						//Fetch creative attribute
						var creative_size=file.size;
						var creative_type=file.type;
						var creative_width=parseInt(this.width,10);
						var creative_height=parseInt(this.height,10);

						//VALIDATE THE SELECTED IMAGE
							//IAB type check
							var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
							if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
							{
								jQuery( "#web_creative_edit_form" ).validate().showErrors({"web_creative_edit": lbl_creative.creatve_file_format});
								isvalid_creative=false;
								jQuery('#creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#web_creative_edit').val('');
								jQuery('#tmp_web_creative').val('');
							}
							//IAB size check
							else if (creative_size > iab_max_size )
							{
								jQuery( "#web_creative_edit_form" ).validate().showErrors({"web_creative_edit": lbl_creative.file_not_exceed+iab_size_kb});
								isvalid_creative=false;
								jQuery('#creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#web_creative_edit').val('');
								jQuery('#tmp_web_creative').val('');
							}

							//IAB width check
							else if (creative_width != iab_max_width || creative_height != iab_max_height)
							{
								jQuery( "#web_creative_edit_form" ).validate().showErrors({"web_creative_edit":  creative_upld_msg +" ("+iab_max_width+"x"+iab_max_height+") "+lbl_creative.creative_dimensn});
								isvalid_creative=false;
								jQuery('#creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#web_creative_edit').val('');
								jQuery('#tmp_web_creative').val('');
							}

							//IAB height check
							/*if (creative_height != iab_max_height )
							{
								jQuery( "#web_creative_edit_form" ).validate().showErrors({"web_creative_edit": "creative height is not upto Iab standard."});
								isvalid_creative=false;
								jQuery('#creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#web_creative_edit').val('');
								jQuery('#tmp_web_creative').val('');
							}*/

							
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("api_key", api_key);
							formdata.append("creative", file);
						}
						
						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#web_creative_edit'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response.file_name);
										if(data.response != 'error')
										{
											jQuery('#tmp_web_creative').val(data.response.file_name);
											jQuery('#tmp_web_creative_content_type').val(data.response.image_type);
											jQuery('#tmp_web_creative_url').val(data.response.full_path);
										}
										else
										{
											window.location.replace(data.redirect);
											jQuery('#tmp_web_creative').val('');
										}
									}
								});
							}
						}
					}
						//img.src = _URL.createObjectURL(file);
					}
					freader.readAsDataURL(file);
				}
				else
				{
					jQuery('#web_creative_edit').val('');
					jQuery('#creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
					jQuery( "#web_creative_edit_form" ).validate().showErrors({"web_creative_edit": lbl_creative.creatve_must_img});
				}	
			}	
	}
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){
		
		jQuery( "#edit_creative" ).unbind().bind('click',function(evt){

			if(jQuery("#web_creative_edit_form").valid()==true)
			{
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					async:false,
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							jQuery('#edit_creative').unbind('click');
							jQuery("#web_creative_edit_form").validate().resetForm();
							jQuery("#web_creative_edit_form").get(0).reset();

							//RELOAD DATATABLES			
							jQuery('.dataTable').dataTable(custom_opt).fnDraw();
							jQuery('.dataTables_filter input').attr("placeholder", "Search here...");
							jQuery(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
								});
							jQuery("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if(jQuery(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if(jQuery(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();
							//RELOAD DATATABLES			
							
							//Reset hidden feilds
							jQuery('#tmp_web_creative').val('');
							jQuery('#tmp_web_creative_content_type').val('');
							jQuery('#tmp_web_creative_url').val('');
							jQuery('#web_creative_id').val('');
							
							jQuery('#storage_type').val('');
							
							//Switch modal box
							jQuery('#modal_web_creative_edit').modal('hide');
							jQuery('#modal_web_creative_edit_success').modal('show');
						}
						else
						{
							jQuery("#web_creative_edit_form").validate().showErrors(data.msg);
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});


	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){

		evt.preventDefault();
		jQuery('#web_creative_edit').attr('src','');
		
		jQuery( "#web_creative_edit_form" ).validate().element(jQuery('#web_creative_edit'));
		
		if(jQuery('#tmp_web_creative').val() !='')
		{
			
			var tmp_web_creative_name=jQuery('#tmp_web_creative').val();
			jQuery.ajax({
			type:'POST',
			async:false,
			url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
			data: {creative_name:tmp_web_creative_name,api_key:api_key},
			success: function(data, textStatus, jqXHR){
			console.log(jqXHR);

				if(data.response == 'ok')
				{
					console.log(data.msg);
				}
				else
				{
					console.log(data.msg);
				}
			//Validate the particular feild
			
			jQuery( "#web_creative_edit_form" ).validate().element(jQuery('#web_creative_edit'));
			}, 
			// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Error ! A problem with the request try again!');
			}
			}); 
		}
			
		});
	});
	
	/* name: 		
	 * @param:		null
	 * 
	 * Retorr to old creative
	 * */

	jQuery(function(){
		jQuery( "#restore" ).click(function(evt){

//		evt.preventDefault();
		if(jQuery('#old_creative_url').val() !='')
		{
			console.log("restored");
			jQuery( "#web_creative_edit_form" ).validate().element(jQuery('#web_creative_edit'));
				
			var old_creative=jQuery('#old_creative').val();
			var old_creative_content_type=jQuery('#old_creative_content_type').val();
			var old_creative_url=jQuery('#old_creative_url').val();

			jQuery( "#localdbban" ).removeClass( "error" ).addClass( "success" );
			jQuery( "#creative_edit_element" ).removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
			
			jQuery('#tmp_web_creative').val(old_creative);
			jQuery('#tmp_web_creative_content_type').val(old_creative_content_type);
			jQuery('#tmp_web_creative_url').val(old_creative_url);
			
			jQuery('#preview_image').html("<img src='"+old_creative_url+"'/>");
	
			//jQuery('#web_creative_edit').bind('click');
//			var input = document.getElementById("web_creative_edit"),formdata = false;
//			input.addEventListener("change",handleFileSelect , false);
		}
			
		});
	});
	

// Added for edit submit enable if user make changes in form.
// 29-06-2017
$(document).ready(function() {
     $('#edit_creative').prop('disabled', true);
     
     $('input[type="text"],file').keyup(function() {
        if($(this).val() != '') {
           $('#edit_creative').prop('disabled', false);
        }
     });
     
     $('#restore').click(function(){
		if($(this).val() != '') {
           $('#edit_creative').prop('disabled', false);
        } 
	 });

     $('#web_creative_edit').change(function(){
		if($(this).val() != '') {
           $('#edit_creative').prop('disabled', false);
        } 
	 });
     
 });
