//When form ready
jQuery(document).ready(function ()
{
	
	var campaign_id = jQuery('#web_creative_anchor').attr('data-campaign-id');
	jQuery('#wrapper_overlay_block').hide();
	jQuery('#vmap_count').hide();
	jQuery('#vmap_adbreak').hide();
	jQuery('#adbreak1').hide();
	jQuery('#adbreak2').hide();
	jQuery('#adbreak3').hide();
	jQuery('#adbreak4').hide();
	jQuery('#adbreak5').hide();
	//vpaid jayashree
	jQuery('#vpaid_enable_option').hide('');
	//Store it to a hidden feild
	jQuery('#_vol_campaign_id').val(campaign_id);
	if(campaign_id)
	{
		jQuery('#vol_campaign_group').hide();
		jQuery('#overlay_campaign').val(campaign_id);
	}
	 //REINITIATE VALIDATE CLASS FOR MODAL BOX
	if($('.form-validate').length > 0)
	{
		$('.form-validate').each(function(){
		var id = $(this).attr('id');
			$("#"+id).validate({
				errorElement:'span',
				errorClass: 'help-block error',
				errorPlacement:function(error, element){
				element.parents('.controls').append(error);
				},
				highlight: function(label) {
				$(label).closest('.control-group').removeClass('error success').addClass('error');
				},
				success: function(label) {
				label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
				}
			});
		});
	}
	//REINITIATE CHECKBOX CLASS FOR MODAL BOX
	if($(".icheck-me").length > 0)
	{
		$(".icheck-me").each(function(){
			var $el = $(this);
			var skin = ($el.attr('data-skin') !== undefined) ? "_"+$el.attr('data-skin') : "",
			color = ($el.attr('data-color') !== undefined) ? "-"+$el.attr('data-color') : "";

			var opt = {
				checkboxClass: 'icheckbox' + skin + color,
				radioClass: 'iradio' + skin + color,
				increaseArea: "10%"
			}

			$el.iCheck(opt);
		});
	}

	//Hide external web creative feild
	//Overlay
	jQuery('#swf_block').hide();
	jQuery('#txt_block').hide();
	jQuery('#img_block').show();
	jQuery('#ohttp_block').show();
	jQuery('#ortmp_block').hide();
	jQuery('#page_block').show();
	jQuery('#video_block').hide();
	jQuery('#select_companion_overlay').hide();
	jQuery('#upload_companion_overlay').hide();
	jQuery('#companion_properties_overlay').hide();
	
	
	
});
	
	//Set IAB creative standard
	var isvalid_companion=false;
	
	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size	='256000';
	var iab_file_type=['image/png','image/jpeg','image/gif'];


	//Define default for Overlay Image

	var overlay_img = document.getElementById("overlay_image"),formdata = false;
	//Bind the event to onchange of the url file
	overlay_img.addEventListener("change",handleImageFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_overlay_creative_form" );

	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select for companion banner, validate and process through ajax.
	 * */

	function handleImageFileSelect(evt)
 	{	
		var form = jQuery( "#video_overlay_creative_form" );

		var isvalid_creative=true;		//form check list

		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_overlay_image_creative').val()!='')
		{
			var tmp_overlay_image_creative_name=jQuery('#tmp_overlay_image_creative').val();
			jQuery.ajax({
			type:'POST',
			async:false,
			url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
			data: {creative_name:tmp_overlay_image_creative_name, api_key:api_key},
			success: function(data, textStatus, jqXHR){
			console.log(jqXHR);
			console.log(data.response);

				if(data.response == 'ok')
				{
					console.log(data.msg);
				}
				else
				{
					console.log(data.msg);
				}
			//Validate the particular feild
			form.validate().element(jQuery('#overlay_image'));
			}, 
			// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Error ! A problem with the request try again!');
			}
			}); 
		}
		jQuery('#tmp_overlay_image_creative').val('');//empty temporary feild value
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				if (!!file.type.match(/image.*/))
				{

					var freader = new FileReader();
					freader.onload = function (evt) {
					//To fetch wight and heigh of the selected image using File API.
					img = new Image();
						img.src = evt.target.result;
					img.onload = function() //After programatically loding selcted image get inside the method
					{
						//Fetch creative attribute
						var creative_size=file.size;
						var creative_type=file.type;
						
						//VALIDATE THE SELECTED IMAGE
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"overlay_image": lbl_creative.creatve_file_format});
							isvalid_creative=false;
							jQuery('#overlay_image_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_image').val('');
							jQuery('#tmp_overlay_image_creative').val('');
						}
						//IAB size check
						else if (creative_size > iab_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"overlay_image": lbl_creative.file_not_exceed+iab_size_kb});
							isvalid_creative=false;
							jQuery('#overlay_image_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_image').val('');
							jQuery('#tmp_overlay_image_creative').val('');
						}
						else
						{}
						
						
							
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#overlay_image'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#tmp_overlay_image_creative').val(data.response.file_name);
											jQuery('#tmp_overlay_image_creative_content_type').val(data.response.image_type);
											jQuery('#tmp_overlay_image_creative_url').val(data.response.full_path);
										}
										else
										{
											
											window.location.replace(data.redirect);
											jQuery('#tmp_overlay_image_creative').val('');
										}
									}
								});
							}
						}
					}

						//img.src = _URL.createObjectURL(file);
				}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = form.validate();
					jQuery('#overlay_image').val('');
					jQuery('#overlay_image_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"overlay_image": lbl_creative.creatve_must_img});
				}
			}	
		}
	}
	
	/* name:reset_img_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_img_upload()
	{
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#overlay_image').val('');
		jQuery('#preview_overlay_image').html('');
		//Validate the particular field
		var form = jQuery( "#video_overlay_creative_form" );
		//form.validate().element(jQuery('#overlay_image'));
		
		if(jQuery('#tmp_overlay_image_creative').val() !='')
		{
			var tmp_overlay_image_creative_name=jQuery('#tmp_overlay_image_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_image_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_overlay_image_creative').val('');
		jQuery('#overlay_image').val('');
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_image" ).click(function(evt){
		var form = jQuery("#video_overlay_creative_form");
		evt.preventDefault();
		form.validate().element(jQuery('#overlay_image'));
		if(jQuery('#tmp_overlay_image_creative').val() !='')
		{
			var tmp_overlay_image_creative_name=jQuery('#tmp_overlay_image_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_image_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#overlay_image'));
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
			
		});
	});
	
	//Define default for Overlay Image
	var iab_swf_file_type=['application/x-shockwave-flash'];
	
	var overlay_swf = document.getElementById("overlay_swf"),formdata = false;
	//Bind the event to onchange of the url file
	overlay_swf.addEventListener("change",handleSwfFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_overlay_creative_form" );

	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select for companion banner, validate and process through ajax.
	 * */

	function handleSwfFileSelect(evt)
 	{	
		var form = jQuery( "#video_overlay_creative_form" );

		var isvalid_creative=true;		//form check list

		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_overlay_swf_creative').val()!='')
		{
			var tmp_overlay_swf_creative_name=jQuery('#tmp_overlay_swf_creative').val();
			jQuery.ajax({
			type:'POST',
			async:false,
			url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
			data: {creative_name:tmp_overlay_swf_creative_name, api_key:api_key},
			success: function(data, textStatus, jqXHR){
			console.log(jqXHR);
			console.log(data.response);

				if(data.response == 'ok')
				{
					console.log(data.msg);
				}
				else
				{
					console.log(data.msg);
				}
			//Validate the particular feild
			form.validate().element(jQuery('#overlay_swf'));
			}, 
			// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Error ! A problem with the request try again!');
			}
			}); 
		}
		jQuery('#tmp_overlay_swf_creative').val('');//empty temporary feild value
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				
				//To fetch wight and heigh of the selected image using File API.
				/*img = new Image();
				img.onload = function() //After programatically loding selcted image get inside the method
				{*/
					if (!!file.type.match(/application.*/))
					{
						//Fetch creative attribute
						var creative_size=file.size;
						var creative_type=file.type;
						
						//VALIDATE THE SELECTED IMAGE
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_swf_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"overlay_swf": lbl_creative.file_should_swf});
							isvalid_creative=false;
							jQuery('#overlay_swf_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_swf').val('');
							jQuery('#tmp_overlay_swf_creative').val('');
						}
						
						//IAB size check
						else if (creative_size > iab_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"overlay_swf": lbl_creative.file_not_exceed+iab_size_kb});
							isvalid_creative=false;
							jQuery('#overlay_swf_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_swf').val('');
							jQuery('#tmp_overlay_swf_creative').val('');
						}
						
						
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#overlay_swf'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_swf_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#tmp_overlay_swf_creative').val(data.response.file_name);
											if(data.response.image_type!='')
											{
												jQuery('#tmp_overlay_swf_creative_content_type').val("swf");
											}
											else if(data.response.file_ext==".swf")
											{
												jQuery('#tmp_overlay_swf_creative_content_type').val("swf");
											}
											else if(data.response.file_ext==".flv")
											{
												jQuery('#tmp_overlay_swf_creative_content_type').val("flv");
											}
											else if(data.response.file_ext==".mp4")
											{
												jQuery('#tmp_overlay_swf_creative_content_type').val("mp4");
											}
											jQuery('#tmp_overlay_swf_creative_url').val(data.response.full_path);
										}
										else
										{
											
											window.location.replace(data.redirect);
											jQuery('#tmp_overlay_swf_creative').val('');
										}
									}
								});
							}
						}
					}
					else
					{
						var validator = form.validate();
						jQuery('#overlay_swf').val('');
						jQuery('#overlay_swf_element').removeClass('fileupload-exists').addClass('fileupload-new');
						validator.showErrors({"overlay_swf": lbl_creative.creatve_must_swf});
					}
				/*}
				img.src = _URL.createObjectURL(file);*/
			}	
		}
	}
	
	/* name:reset_swf_upload
	 * @param:
	 * 
	 * Make swf upload refresh when creative size is changed
	 * */
	 
	function reset_swf_upload()
	{
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#overlay_swf').val('');
		jQuery('#preview_overlay_swf').html('');
		//Validate the particular field
		var form = jQuery( "#video_overlay_creative_form" );
		//form.validate().element(jQuery('#overlay_swf'));
		
		if(jQuery('#tmp_overlay_swf_creative').val() !='')
		{
			var tmp_overlay_swf_creative_name=jQuery('#tmp_overlay_swf_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_swf_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				
				}
			}); 
				
		}
		jQuery('#tmp_overlay_swf_creative').val('');
		jQuery('#overlay_swf').val('');
	}
		
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_swf" ).click(function(evt){
		var form = jQuery("#video_overlay_creative_form");
		evt.preventDefault();
		form.validate().element(jQuery('#overlay_swf'));
		if(jQuery('#tmp_overlay_swf_creative').val() !='')
		{
			var tmp_overlay_swf_creative_name=jQuery('#tmp_overlay_swf_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_swf_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#overlay_swf'));
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
			
		});
	});


	//Specify in bytes to avoid code complexity
	//~ var iab_video_size_mb = '2MB';
	//~ var iab_video_max_size	='2097152';
	var iab_video_size_mb = '30MB';
	var iab_video_max_size	='31457280';
	var iab_video_file_type	=['video/x-flv','video/mp4'];

	//Define default

	var input = document.getElementById("video_overlay_creative"),formdata = false;
	//Bind the event to onchange of the url file
	input.addEventListener("change",handleVideoFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_overlay_creative_form" );
	
	
	/* name: overlay_type
	 * @param:null
	 * 
	 * switch between image or swf or text overlay.
	 * */
	
	function video_overlay_type(val)
	{ 
		if(val=='image_overlay')
		{  
			jQuery('#page_block').show();
			jQuery('#img_block').show();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').hide();
			jQuery('#wrapper_overlay_block').hide();
			jQuery('#desturl').show();
			jQuery('#overlay_url').show();
			jQuery('#wdth_ht_div').show();
			jQuery('#3rdpart_div').show();
			jQuery('#compa_main').show();
			jQuery('#vmap_count').hide();
			jQuery('#vmap_adbreak').hide();
			//vpaid jayashree
			jQuery('#vpaid_enable').show();
			jQuery('#vpaid_enable_option').hide();
			clean_vmap();
			if(jQuery('#tmp_overlay_swf_creative').val()!='')
			{
				reset_swf_upload();
			}
	
		}
		else if(val=='swf_overlay')
		{
			jQuery('#img_block').hide();
			jQuery('#swf_block').show();
			jQuery('#txt_block').hide();
			jQuery('#wrapper_overlay_block').hide();
			jQuery('#desturl').show();
			jQuery('#wdth_ht_div').show();
			jQuery('#3rdpart_div').show();
			jQuery('#compa_main').show();
			jQuery('#vmap_count').hide();
			jQuery('#vmap_adbreak').hide();
			//vpaid jayashree
			jQuery('#vpaid_enable').show();
			jQuery('#vpaid_enable_option').hide();
			clean_vmap();
			if(jQuery('#tmp_overlay_image_creative').val()!='')
			{
				reset_img_upload();
			}
		}
		else if(val=='text_overlay')
		{
			jQuery('#img_block').hide();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').show();
			jQuery('#wrapper_overlay_block').hide();
			jQuery('#desturl').show();
			jQuery('#wdth_ht_div').show();
			jQuery('#3rdpart_div').show();
			jQuery('#compa_main').show();
			jQuery('#vmap_count').hide();
			jQuery('#vmap_adbreak').hide();
			//vpaid jayashree
			jQuery('#vpaid_enable').show();
			jQuery('#vpaid_enable_option').hide();
			clean_vmap();
			if(jQuery('#tmp_overlay_image_creative').val()!='')
			{
				reset_img_upload();
			}
			if(jQuery('#tmp_overlay_swf_creative').val()!='')
			{
				reset_swf_upload();
			}
		}
		else if(val=='wrapper_overlay')
		{
			jQuery('#img_block').hide();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').hide();
			jQuery('#wdth_ht_div').hide();
			jQuery('#3rdpart_div').hide();
			jQuery('#overlay_action').hide();
			jQuery('#wrapper_overlay_block').show();
			jQuery('#desturl').hide();
			jQuery('#page_block').hide();
			jQuery('#compa_main').hide();
			jQuery('#vmap_count').hide();
			jQuery('#vmap_adbreak').hide();
			//vpaid jayashree
			jQuery('#vpaid_enable').hide();
			jQuery('#vpaid_enable_option').hide();
			clean_vmap();
			jQuery('#vast_overlay_version').val('1');
		}
		else if(val=='vmap')
		{
			jQuery('#img_block').hide();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').hide();
			jQuery('#wdth_ht_div').hide();
			jQuery('#3rdpart_div').hide();
			jQuery('#overlay_action').hide();
			jQuery('#wrapper_overlay_block').hide();
			jQuery('#desturl').hide();
			jQuery('#page_block').hide();
			jQuery('#compa_main').hide();
			jQuery('#vmap_count').show();
			jQuery('#vmap_adbreak').show();
			//vpaid jayashree
			jQuery('#vpaid_enable').hide();
			jQuery('#vpaid_enable_option').hide();
			jQuery('#vast_overlay_version').val('1');
			jQuery('#adbreak1').show();
			jQuery('#adbreak2').show();
		}
		else
		{
			jQuery('#img_block').show();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').hide();
			jQuery('#wdth_ht_div').show();
			jQuery('#3rdpart_div').show();
			jQuery('#vmap_count').hide();
			jQuery('#compa_main').show();
			jQuery('#vmap_adbreak').hide();
			clean_vmap();
		}
	}
	
	function overlay_vmap_adbreak_count(val)
	{
		console.log(val);
		if(val==2)
		{
			jQuery('#adbreak1').show();
			jQuery('#adbreak2').show();
			jQuery('#adbreak3').hide();
			jQuery('#adbreak4').hide();
			jQuery('#adbreak5').hide();
		}
		else if(val==3)
		{
			jQuery('#adbreak1').show();
			jQuery('#adbreak2').show();
			jQuery('#adbreak3').show();
			jQuery('#adbreak4').hide();
			jQuery('#adbreak5').hide();
		}
		else if(val==4)
		{
			jQuery('#adbreak1').show();
			jQuery('#adbreak2').show();
			jQuery('#adbreak3').show();
			jQuery('#adbreak4').show();
			jQuery('#adbreak5').hide();
		}
		else if(val==5)
		{
			jQuery('#adbreak1').show();
			jQuery('#adbreak2').show();
			jQuery('#adbreak3').show();
			jQuery('#adbreak4').show();
			jQuery('#adbreak5').show();
		}
	}
	
	function clean_vmap()
	{
			jQuery('#adbreak1_tag').val('');
			jQuery('#adbreak2_tag').val('');
			jQuery('#adbreak3_tag').val('');
			jQuery('#adbreak4_tag').val('');
			jQuery('#adbreak5_tag').val('');
			jQuery('#vmap_adbreak1_offset').val('');
			jQuery('#vmap_adbreak2_offset').val('');
			jQuery('#vmap_adbreak3_offset').val('');
			jQuery('#vmap_adbreak4_offset').val('');
			jQuery('#vmap_adbreak5_offset').val('');
			
	}
	
	
	
	if($(".title_no").is(":checked")==true)
	{	
		$('div #vpaid_enable_option').hide();
		$('div #vpaid_resizes').hide();
	
	}
	
	
	
	//vpaid jayashree
	function vapid_enable_type(val)
	{
		
		if(val==1)
		{
			$('#vpaid_enable_option').show('');
			$('#vpaid_resizes').hide('');
		}
		else
		{
			$('#vpaid_enable_option').hide('');
		}
	}
	function vapid_expand_type(val)
	{
		
		if(val==1)
		{
			$('#vpaid_resizes').show('');
		}
		else
		{
			$('#vpaid_resizes').hide('');
		}
	}
	function overlay_vast_type(val)
	{
		if(val)
		{
			jQuery('#wdth_ht_div').hide();
			jQuery('#3rdpart_div').hide();
		}
		
	}
	/* name: overlay_delivery_type
	 * @param:null
	 * 
	 * switch between click to Page or Click to Video.
	 * */
	
	function overlay_action(val)
	{
		if(val=='click_to_page')
		{
			jQuery('#page_block').show();
			jQuery('#video_block').hide();
			reset_video_upload();
		}
		else if(val=='click_to_video')
		{
			jQuery('#page_block').hide();
			jQuery('#video_block').show();
		}
		else
		{
			jQuery('#page_block').show();
			jQuery('#video_block').hide();
		}
	}
	
	/* name: overlay_delivery_type
	 * @param:null
	 * 
	 * switch between HTTP and RTMP
	 * */
	
	function overlay_delivery_type(val)
	{
		if(val=='progressive')
		{
			jQuery('#ohttp_block').show();
			jQuery('#ortmp_block').hide();
		}
		else if(val=='streaming')
		{
			jQuery('#ohttp_block').hide();
			jQuery('#ortmp_block').show();
			reset_video_upload();
		}
		else
		{
			jQuery('#ohttp_block').show();
			jQuery('#ortmp_block').hide();
		}
	}
	
	
	
	/* name: empty_overlay_companion
	 * @param:null
	 * 
	 * if we change campaign empty companion information
	 * */
	function empty_overlay_companion()
	{
		jQuery('#overlay_companion_size').val('');
		jQuery('#overlay_companion_width').val('');
		jQuery('#overlay_companion_height').val('');
		jQuery('#select_companion_overlay').hide();
		jQuery('#upload_companion_overlay').hide();
		jQuery('#companion_properties_overlay').hide();
		
		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_overlay_companion_creative').val()!='')
		{
			var tmp_overlay_companion_creative_name=jQuery('#tmp_overlay_companion_creative').val();
			jQuery.ajax({
			type:'POST',
			async:false,
			url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
			data: {creative_name:tmp_overlay_companion_creative_name, api_key:api_key},
			success: function(data, textStatus, jqXHR){
			console.log(jqXHR);
			console.log(data.response);

				if(data.response == 'ok')
				{
					console.log(data.msg);
				}
				else
				{
					console.log(data.msg);
				}
			//Validate the particular feild
			form.validate().element(jQuery('#overlay_companion_file'));
			}, 
			// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Error ! A problem with the request try again!');
			}
			}); 
		}
		jQuery('#tmp_overlay_companion_creative').val('');//empty temporary feild value
		
	}
	
	/* name: check_companion
	 * @param:null
	 * 
	 * Description:Check companion size with web creatives,if match size then choose companion banner from web creatives and process through ajax.
	 * */
	
	function check_overlay_companion_size(csize)
	{	
		
		//var width = jQuery('#overlay_companion_width').val();
		//var height = jQuery('#overlay_companion_height').val();
		//var overlay_size = width+'x'+height;
	
		var campaign=	jQuery('#overlay_campaign').val();
		var size 	= 	csize.split("x");
		var width 	= 	size[0];
		var height	=	size[1];
		if(campaign!='')
		{
			if(width!='' && height!='')
			{
				jQuery.ajax({
						type: "POST",
						url: site_url+'/api/v1/video_creative/check_companion_size/format/json',
						data: {campaign_id:campaign,companion_width:width,companion_height:height,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								isvalid_companion=false;
								jQuery('#select_companion_overlay').show();
								jQuery('#companion_properties_overlay').hide();
								jQuery('#upload_companion_overlay').hide();
								jQuery("#companion_properties_overlay").show();
								filter_overlay_companions(campaign,width,height);
							}
							else
							{
								isvalid_companion=true;
								jQuery('#select_companion_overlay').hide();
								jQuery('#upload_companion_overlay').show();
								jQuery('#companion_properties_overlay').show();
							}
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
							//alert('Error ! A problem with the request try again!');
						}
				}); 
			}
			else
			{
				isvalid_companion=false;
				jQuery('#select_companion_overlay').hide();
				jQuery('#upload_companion_overlay').hide();
				jQuery('#companion_properties_overlay').hide();
			}
		}
		else
		{
			var form 		= jQuery( "#video_overlay_creative_form" );
			var validator 	= form.validate();
			validator.showErrors({"overlay_campaign": lbl_creative.choose_cmpgn});
			jQuery('#overlay_companion_size').val('');
			jQuery('#overlay_companion_height').val('');
			jQuery('#overlay_companion_width').val('');
			jQuery('#select_companion_overlay').hide();
			jQuery('#upload_companion_overlay').hide();
			jQuery('#companion_properties_overlay').hide();
			jQuery('#overlay_campaign').focus();
		}
	}
	
	/* name: filter_companions
	 * @param:null
	 * 
	 * Description:Filter web creatives for companion banner, match size and process through ajax.
	 * */
	
	function filter_overlay_companions(campaign,width,height)
	{
		if(campaign!='')
		{
			if(width!='' && height!='')
			{	
				jQuery.ajax({
					type: "POST",
					async:false,
					url: site_url+'/advertiser/creatives/filter_companions/'+campaign+'/'+width+'/'+height,
					success: function(data){
						
						jQuery("#overlay_companion_list").html(data);					
					}
				}); 
								
			}
			else
			{
				return false;	
			}
		}
		else
		{
			return false;	
		}		
	}

	/* name: handleVideoFileSelect
	 * @param:null
	 * 
	 * Description:Handle video creative select, validate and process through ajax.
	 * */

	function handleVideoFileSelect(evt)
 	{		
		var form 			= 	jQuery( "#video_overlay_creative_form" );

		var isvalid_creative=	true;		//form check list

		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_video_overlay_creative').val()!='')
		{
			var tmp_video_overlay_creative_name	=	jQuery('#tmp_video_overlay_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_video_overlay_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
					console.log(data.response);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#video_overlay_creative'));
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
					
				}
			}); 
		}
		jQuery('#tmp_video_overlay_creative').val('');//empty temporary feild value
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;
			
			//Check weather it's image
			if ((file = this.files[0]))
			{		
				if (!!file.type.match(/video.*/))
				{
					//Fetch creative attribute
					var creative_size=file.size;
					var creative_type=file.type;						
					
					//VALIDATE THE SELECTED IMAGE
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_video_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"video_overlay_creative": lbl_creative.file_should_mp4});
							isvalid_creative=false;
							jQuery('#video_overlay_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_overlay_creative').val('');
							jQuery('#tmp_video_overlay_creative').val('');
						}
						//IAB size check
						else if (creative_size > iab_video_max_size )
						 {
							var validator = form.validate();
							validator.showErrors({"video_overlay_creative": lbl_creative.file_not_exceed+iab_video_size_mb});
							isvalid_creative=false;
							jQuery('#video_overlay_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_overlay_creative').val('');
							jQuery('#tmp_video_overlay_creative').val('');
						}

						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#video_overlay_creative'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_video_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#tmp_video_overlay_creative').val(data.response.file_name);
											if(data.response.file_ext==".flv")
											{
												
												jQuery('#tmp_video_overlay_creative_content_type').val('flv');
											}
											else if(data.response.file_ext==".mp4")
											{
												jQuery('#tmp_video_overlay_creative_content_type').val("mp4");	
											}
											jQuery('#tmp_video_overlay_creative_url').val(data.response.full_path);
											jQuery('#tmp_video_overlay_creative_raw_name').val(data.response.raw_name);
											jQuery('#tmp_video_overlay_creative_file_ext').val(data.response.file_ext);
										}
										else
										{
											jQuery('#modal_video_overlay_creative_add .close').click();
											jQuery('#timeout_modal_box').modal('show');	
										}
									}
								});
							}
						}
				}
				else
				{
					var validator = form.validate();
					jQuery('#video_overlay_creative').val('');
					jQuery('#video_overlay_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"video_overlay_creative": lbl_creative.creatve_must_video});
				}
			}	
		}
	}	
	
	/* name:reset_video_upload
	 * @param:
	 * 
	 * Make video upload refresh when change delivery type is changed
	 * */
	 
	function reset_video_upload()
	{
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#video_overlay_creative').val('');
		//jQuery('#preview_image').html('');
		//Validate the particular field
		var form = jQuery( "#video_overlay_creative_form" );
	//	form.validate().element(jQuery('#video_overlay_creative'));
		
		if(jQuery('#tmp_video_overlay_creative').val() !='')
		{
			var tmp_video_overlay_creative_name=jQuery('#tmp_video_overlay_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_video_overlay_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_video_overlay_creative').val('');
		jQuery('#video_overlay_creative').val('');
	}
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){
		var form = jQuery("#video_overlay_creative_form");
		var validator = form.validate();
			jQuery('.close').bind('click',function(evt){		
			jQuery("#add_video_overlay_creative").unbind('click');			
	     	});
		jQuery( "#add_video_overlay_creative" ).unbind().bind('click',function(evt){
			//jQuery( "#add_video_overlay_creative" ).click(function(evt){
			var overlay_format=$('input[name=overlay_type]:checked').val();
			if(form.valid()==true)
			{
					if((overlay_format=='image_overlay' && jQuery('#tmp_overlay_image_creative').val()!='') || (overlay_format=='swf_overlay' && jQuery('#tmp_overlay_swf_creative').val()!='') || (overlay_format=='text_overlay') || (overlay_format=='wrapper_overlay') || (overlay_format=='vmap'))
				{
					if(jQuery('#overlay_companion_size').val!='' && isvalid_companion==true)
					//if(jQuery('#overlay_companion_width').val!='' && jQuery('#overlay_companion_height').val!='' && isvalid_companion==true)
					//~ {
						if(jQuery('#tmp_overlay_companion_creative').val()!='')
						{
							jQuery("#add_video_overlay_creative" ).bind().unbind('click');
							evt.preventDefault();
							
							jQuery.ajax({
								type:'POST',
								async:false,
								url: form.attr("action"),
								data:form.serialize(),
								success: function(data, textStatus, jqXHR){
									console.log(jqXHR);
									if(data.response == 'ok')
									{
										if(jQuery('#_vol_campaign_id').val() !='')
										{
											refresh_existing_creative(jQuery('#_vol_campaign_id').val());
										//	$('#add_creative_msg').attr("data-notify-message","Overlay Video creative added sucessfully");
										//	$('#add_creative_msg').trigger('click');	
										$('.alert-success').show();	
										$('#success_msg').html(lbl_advertiser.msg_overlay_added);
										$('html, body').animate({ scrollTop: $('#successalert').offset().top -45 }, 'slow');										
										}

										validator.resetForm();
										form.get(0).reset();
										//Reset hidden feilds
										jQuery('#tmp_video_overlay_creative').val('');
										jQuery('#tmp_video_overlay_creative_content_type').val('');
										jQuery('#tmp_video_overlay_creative_url').val('');
										jQuery("#add_video_overlay_creative" ).unbind().bind('click');
										//Switch modal box
										jQuery('#modal_video_overlay_creative_add .close').click();
										if(jQuery('#_vol_campaign_id').val() =='')
										{
											jQuery('#modal_video_overlay_creative_success').modal('show');
										}
									}
									else
									{
										validator.showErrors(data.msg);
									}
								}, 
								// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
								error: function(jqXHR, textStatus, errorThrown){
								
								}
							}); 
						}
						else
						{
							validator.showErrors({"overlay_companion_file": lbl_creative.not_upload_cmpanion});
						}
					//~ }
					else
					{
						jQuery("#add_video_overlay_creative" ).bind().unbind('click');
						evt.preventDefault();
							
						jQuery.ajax({
							type:'POST',
							async:false,
							url: form.attr("action"),
							data:form.serialize(),
							success: function(data, textStatus, jqXHR){
								console.log(jqXHR);
								if(data.response == 'ok')
								{
									if(jQuery('#_vol_campaign_id').val() !='')
									{
										refresh_existing_creative(jQuery('#_vol_campaign_id').val());
										//$('#add_creative_msg').attr("data-notify-message","Overlay Video creative added successfully");
										//	$('#add_creative_msg').trigger('click');
										$('.alert-success').show();	
										$('#success_msg').html(lbl_advertiser.msg_overlay_added);
										$('html, body').animate({ scrollTop: $('#successalert').offset().top -45 }, 'slow');										
									}

									
									validator.resetForm();
									form.get(0).reset();
									//Reset hidden feilds
									jQuery('#tmp_video_overlay_creative').val('');
									jQuery('#tmp_video_overlay_creative_content_type').val('');
									jQuery('#tmp_video_overlay_creative_url').val('');
									jQuery("#add_video_overlay_creative" ).unbind().bind('click');
									//Switch modal box
									jQuery('#modal_video_overlay_creative_add .close').click();
									if(jQuery('#_vol_campaign_id').val() =='')
									{
										jQuery('#modal_video_overlay_creative_success').modal('show');
									}
								}
								else
								{
									validator.showErrors(data.msg);
								}
							}, 
							// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
							error: function(jqXHR, textStatus, errorThrown){
							
							}
						}); 
					}
				}
				else
				{
					validator.showErrors({"video_overlay_creative": lbl_creative.not_upload_video});
				}
			}
		});
	});


	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){
		var form = jQuery("#video_overlay_creative_form");
		evt.preventDefault();
		form.validate().element(jQuery('#video_overlay_creative'));
		if(jQuery('#tmp_video_overlay_creative').val() !='')
		{
			var tmp_video_overlay_creative_name=jQuery('#tmp_video_overlay_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_video_overlay_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#video_overlay_creative'));
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
			
		});
	});
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when creative is uplaoded and changed as a Streaming creative(RTMP Banner)
	 * */

	jQuery( "#overlay_delivery_method" ).click(function(evt){
		if (jQuery('#overlay_delivery_method').val()=='streaming' || jQuery('#overlay_delivery_method').val()=='wrapper_overlay')
		{
			//Trigger the remove creative event
			jQuery( "#remove" ).click();
		}
	});
	
	
	//Define default for Companion Banner

	var companion = document.getElementById("overlay_companion_file"),formdata = false;
	//Bind the event to onchange of the url file
	companion.addEventListener("change",handleFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_overlay_creative_form" );

	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select for companion banner, validate and process through ajax.
	 * */


	function handleFileSelect(evt)
 	{
			
		var selcted_creative_size=jQuery('#overlay_companion_size').val();
		var creative_size_split = selcted_creative_size.split('x');
		var iab_max_width= parseInt(creative_size_split[0], 10); 
		var iab_max_height= parseInt(creative_size_split[1], 10);
		

		//var iab_max_width= jQuery('#overlay_companion_width').val();
		//var iab_max_height= jQuery('#overlay_companion_height').val();
		
		var form = jQuery( "#video_overlay_creative_form" );

		var isvalid_creative=true;		//form check list

		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_overlay_companion_creative').val()!='')
		{
			var tmp_overlay_companion_creative_name=jQuery('#tmp_overlay_companion_creative').val();
			jQuery.ajax({
			type:'POST',
			async:false,
			url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
			data: {creative_name:tmp_overlay_companion_creative_name, api_key:api_key},
			success: function(data, textStatus, jqXHR){
			console.log(jqXHR);
			console.log(data.response);

				if(data.response == 'ok')
				{
					console.log(data.msg);
				}
				else
				{
					console.log(data.msg);
				}
			//Validate the particular feild
			form.validate().element(jQuery('#overlay_companion_file'));
			}, 
			// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Error ! A problem with the request try again!');
			}
			}); 
		}
		jQuery('#tmp_overlay_companion_creative').val('');//empty temporary feild value
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{	
				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();
					freader.onload = function (evt) {
					//To fetch wight and heigh of the selected image using File API.
					img = new Image();
						img.src = evt.target.result;
					img.onload = function() //After programatically loding selcted image get inside the method
					{
						//Fetch creative attribute
						var creative_size=file.size;
						var creative_type=file.type;
						var creative_width=parseInt(this.width,10);
						var creative_height=parseInt(this.height,10);

						//VALIDATE THE SELECTED IMAGE
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"overlay_companion_file": lbl_creative.creatve_file_format});
							isvalid_creative=false;
							jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_companion_file').val('');
							jQuery('#tmp_overlay_companion_creative').val('');
						}
						//IAB size check
						else if (creative_size > iab_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"overlay_companion_file": lbl_creative.file_not_exceed +iab_size_kb});
							isvalid_creative=false;
							jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_companion_file').val('');
							jQuery('#tmp_overlay_companion_creative').val('');
						}

						//IAB width check
						else if (creative_width != iab_max_width || creative_height != iab_max_height)
						{
							var validator = form.validate();
							validator.showErrors({"overlay_companion_file": lbl_creative.creative_upld_msg+"("+iab_max_width+"x"+iab_max_height+") "+lbl_creative.creative_dimensn});
							isvalid_creative=false;
							jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_companion_file').val('');
							jQuery('#tmp_overlay_companion_creative').val('');
						}

						//IAB height check
						/*if (creative_height != iab_max_height )
						{
							var validator = form.validate();
							validator.showErrors({"overlay_companion_file": "creative height is not match to IAB standard."});
							isvalid_creative=false;
							jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_companion_file').val('');
							jQuery('#tmp_overlay_companion_creative').val('');
						}*/

						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#overlay_companion_file'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#tmp_overlay_companion_creative').val(data.response.file_name);
											jQuery('#tmp_overlay_companion_creative_content_type').val(data.response.image_type);
											jQuery('#tmp_overlay_companion_creative_url').val(data.response.full_path);
										}
										else
										{
											
											window.location.replace(data.redirect);
											jQuery('#tmp_overlay_companion_creative').val('');
										}
									}
								});
							}
						}
					}
						//img.src = _URL.createObjectURL(file);
					}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = form.validate();
					jQuery('#overlay_companion_file').val('');
					jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"overlay_companion_file": lbl_creative.creatve_must_img});
				}
			}	
		}
	}
	
	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload()
	{
		jQuery('#overlay_companion.fileupload').removeClass('fileupload-exists');
		jQuery('#overlay_companion.fileupload').addClass('fileupload-new');
		jQuery('#overlay_companion_file').val('');
		jQuery('#preview_image').html('');
		//Validate the particular field
		var form = jQuery( "#video_overlay_creative_form" );
		//form.validate().element(jQuery('#overlay_companion_file'));
		
		if(jQuery('#tmp_overlay_companion_creative').val() !='')
		{
			var tmp_overlay_companion_creative_name=jQuery('#tmp_overlay_companion_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_companion_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_overlay_companion_creative').val('');
		jQuery('#overlay_companion_file').val('');
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_companion" ).click(function(evt){
		var form = jQuery("#video_overlay_creative_form");
		evt.preventDefault();
		form.validate().element(jQuery('#overlay_companion_file'));
		if(jQuery('#tmp_overlay_companion_creative').val() !='')
		{
			var tmp_overlay_companion_creative_name=jQuery('#tmp_overlay_companion_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_companion_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#overlay_companion_file'));
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
			
		});
	});


	
	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
			jQuery.ajax({
			type:'POST',
			async:false,
			url : site_url+"/advertiser/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id},
			
			success : function(data){

							if(data!='')
							{
								jQuery("#_existing_creative").html(data);
							}
							return true;
							//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
						}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}

/** 
	 * 
	 * url_content_checking
	 * */
	function url_content_checking(url){
		
		var url1 = jQuery('#thirdparty_vast_tag').val();
		var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
		
		if(regex.test(url1)) {
		jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/url_xml_validation/format/json',
									type: "POST",
									async:false,
									data: {url:url1, api_key:api_key},
									//processData: false,
									//contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										//console.log(data);
										if(data.response != 'ok'){
											jQuery('#over_thirdparty_tag_error').html(data.msg);
											jQuery('#wrapper_overlay_block #over_third_party_div').removeClass('success');
											jQuery('#wrapper_overlay_block #over_third_party_div').addClass('error');
											jQuery('#add_video_overlay_creative').addClass('disabled');
										}
										else{
											jQuery('#over_thirdparty_tag_error').html('');
											jQuery('#wrapper_overlay_block #over_third_party_div').addClass('success');
											jQuery('#wrapper_overlay_block #over_third_party_div').removeClass('error');
											jQuery('#add_video_overlay_creative').removeClass('disabled');
										}
									}
								});
		}
		else{
			jQuery('#over_thirdparty_tag_error').html('');
		}
	}
function url_content_checking_vamp1(url){
		
		var url1 = jQuery('#adbreak1_tag').val();
		var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
		
		if(regex.test(url1)) {
		jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/url_xml_validation/format/json',
									type: "POST",
									async:false,
									data: {url:url1, api_key:api_key},
									//processData: false,
									//contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										//alert(data);
										console.log(data);
										if(data.response != 'ok'){
											jQuery('#over_vmap_adbreak1_error').html(data.msg);
											jQuery('#vmap_adbreak #adbreak1 div.control-group').removeClass('success');
											jQuery('#vmap_adbreak #adbreak1 div.control-group').addClass('error');
											jQuery('#add_video_overlay_creative').addClass('disabled');
										}
										else{
											jQuery('#over_vmap_adbreak1_error').html('');
											jQuery('#add_video_overlay_creative').removeClass('disabled');
											jQuery('#vmap_adbreak #adbreak1 div.control-group').addClass('success');
											jQuery('#vmap_adbreak #adbreak1 div.control-group').removeClass('error');
										}
									}
								});
		}
		else{
			jQuery('#over_vmap_adbreak1_error').html('');
		}
	}
function url_content_checking_vamp2(url){
		
		var url1 = jQuery('#adbreak2_tag').val();
		var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
		
		if(regex.test(url1)) {
		jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/url_xml_validation/format/json',
									type: "POST",
									async:false,
									data: {url:url1, api_key:api_key},
									//processData: false,
									//contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										//alert(data);
										//console.log(data);
										if(data.response != 'ok'){
											jQuery('#over_vmap_adbreak2_error').html(data.msg);
											jQuery('#vmap_adbreak #adbreak2 div.control-group').removeClass('success');
											jQuery('#vmap_adbreak #adbreak2 div.control-group').addClass('error');
											jQuery('#add_video_overlay_creative').addClass('disabled');
										}
										else{
											jQuery('#over_vmap_adbreak2_error').html('');
											jQuery('#add_video_overlay_creative').removeClass('disabled');
											jQuery('#vmap_adbreak #adbreak2 div.control-group').addClass('success');
											jQuery('#vmap_adbreak #adbreak2 div.control-group').removeClass('error');
										}
									}
								});
		}
		else{
			jQuery('#over_vmap_adbreak2_error').html('');
		}
	}
	function url_content_checking_vamp3(url){
		
		var url1 = jQuery('#adbreak3_tag').val();
		var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
		
		if(regex.test(url1)) {
		jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/url_xml_validation/format/json',
									type: "POST",
									async:false,
									data: {url:url1, api_key:api_key},
									//processData: false,
									//contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										//alert(data);
										//console.log(data);
										if(data.response != 'ok'){
											jQuery('#over_vmap_adbreak3_error').html(data.msg);
											jQuery('#vmap_adbreak #adbreak3 div.control-group').removeClass('success');
											jQuery('#vmap_adbreak #adbreak3 div.control-group').addClass('error');
											jQuery('#add_video_overlay_creative').addClass('disabled');
										}
										else{
											jQuery('#over_vmap_adbreak3_error').html('');
											jQuery('#add_video_overlay_creative').removeClass('disabled');
											jQuery('#vmap_adbreak #adbreak3 div.control-group').addClass('success');
											jQuery('#vmap_adbreak #adbreak3 div.control-group').removeClass('error');
										}
									}
								});
		}
		else{
			jQuery('#over_vmap_adbreak3_error').html('');
		}
	}
	function url_content_checking_vamp4(url){
		
		var url1 = jQuery('#adbreak4_tag').val();
		var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
		
		if(regex.test(url1)) {
		jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/url_xml_validation/format/json',
									type: "POST",
									async:false,
									data: {url:url1, api_key:api_key},
									//processData: false,
									//contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										//alert(data);
										//console.log(data);
										if(data.response != 'ok'){
											jQuery('#over_vmap_adbreak4_error').html(data.msg);
											jQuery('#vmap_adbreak #adbreak4 div.control-group').removeClass('success');
											jQuery('#vmap_adbreak #adbreak4 div.control-group').addClass('error');
											jQuery('#add_video_overlay_creative').addClass('disabled');
										}
										else{
											jQuery('#over_vmap_adbreak4_error').html('');
											jQuery('#add_video_overlay_creative').removeClass('disabled');
											jQuery('#vmap_adbreak #adbreak4 div.control-group').addClass('success');
											jQuery('#vmap_adbreak #adbreak4 div.control-group').removeClass('error');
										}
									}
								});
		}
		else{
			jQuery('#over_vmap_adbreak4_error').html('');
		}
	}
	function url_content_checking_vamp5(url){
		
		var url1 = jQuery('#adbreak5_tag').val();
		var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
		
		if(regex.test(url1)) {
		jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/url_xml_validation/format/json',
									type: "POST",
									async:false,
									data: {url:url1, api_key:api_key},
									//processData: false,
									//contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										//alert(data);
										//console.log(data);
										if(data.response != 'ok'){
											jQuery('#over_vmap_adbreak5_error').html(data.msg);
										    jQuery('#vmap_adbreak #adbreak5 div.control-group').removeClass('success');
											jQuery('#vmap_adbreak #adbreak5 div.control-group').addClass('error');
											jQuery('#add_video_overlay_creative').addClass('disabled');
										}
										else{
											jQuery('#over_vmap_adbreak5_error').html('');
											jQuery('#add_video_overlay_creative').removeClass('disabled');
											jQuery('#vmap_adbreak #adbreak5 div.control-group').addClass('success');
											jQuery('#vmap_adbreak #adbreak5 div.control-group').removeClass('error');
										}
									}
								});
		}
		else{
			jQuery('#over_vmap_adbreak5_error').html('');
		}
	}
