$(function(){
 

	//Modified for dynamic select2 fetch by Suganiya.R on 17th feb,2016

	$('.editable').each(function(index) {
		var edit_id=this.id;
		var pars=$(this).attr('data-sel-options');
		if(pars!='')
		{
			src_data = $.parseJSON(pars);	
		}
		else
		{
			src_data ='';
		}
		var rules=$(this).attr('data-rule-options');		
		
		function get_source(data,edit_id)
		{	
			if(data)
			{
				var src= data[edit_id];			
				if(src!=undefined)
				{
					var sel_src=JSON.stringify(src);
					str=sel_src.replace(/^"/, "");
					str=sel_src.replace(/"$/, "");
					return str;
				}
			}

		}
		
		$("#"+edit_id).editable({
		
		  source: get_source(src_data,edit_id),
        validate: function(value) {
				
			if(rules!='')
			{
				rules_data = $.parseJSON(rules);
			}
			else
			{
				rules_data='';
			}
			var src= rules_data[edit_id];
			
				if(src || src!=undefined)
				{
					if(src[0]['value']!="")
					{					
							for (i = 0; i < src.length; i++) {
								var rule=src[i]['value'];
								
								if(rule=="required")
								{
								   if($.trim(value) == '') return lbl_editable.field_reqd;
							    }
							    
								if(rule=="number")
								{
								   if(IsNumeric(value)== false) return lal_valid.invalid_value;
								}
								if(rule=="positive")
								{
								   if($.trim(value)<0 ) return lal_valid.pos_num;
								}
								if(rule=="decimal")
								{
								   //Decimal validation
								   if(!(/^\$?[0-9]+(,[0-9]{7})*(\.[0-9]{1,2})?$/.test(value))) return lbl_charts.max_all;
								}
								if(rule=="valid_floor")
								{
								   if($.trim(value)<0.000001 ) return lbl_editable.valid_amount;
								}
								if(rule=="valid_url")
								{
								  if(checkURL(value)==false) return lbl_charts.vali_url;
								}
							}
					
						 
					}
				 
			   }		
			
			},
		url: site_url+'/api/v1/app_settings/set_value/format/json', 
      	ajaxOptions: {
           dataType: 'json' //assuming json response
      	},           
       success: function(data, config) {
          	   
		   if(data.response=='ok' && data.id) {  //record created, response like {"id": 2}
               //set pk
               $(this).editable('option', 'pk', data.id);
           } else if(data && data.response=='error'){ 
               //server-side validation error, response like {"errors": {"username": "username already exist"} }
        	   return data.msg;
		   }               
       },
	    display: function(value) {
			//console.log(value);
        var html = [];
		if(value) {
			
		$("#"+edit_id+"_").html(value);
		} else {
			$("#"+edit_id+"_").empty();
		}
	   },
       error: function(errors) {
        	 return errors.msg;
       }
		
    });
    });
	
	
	$('.controller').click(function(e){
		e.stopPropagation();
		$('#'+$(e.target).attr('data-value')).editable('toggle');
	
	});
	
	function checkURL(value) { 
   	 	var urlregex = new RegExp("^(http:\/\/|https:\/\/|ftp:\/\/){1}([0-9A-Za-z]+\.)");
	
		if (urlregex.test(value)) {
       		 return (true);
   		 	}
    	return (false);
	}

	function IsNumeric(input){
    	var RE = /^-{0,1}\d*\.{0,1}\d+$/;
    	return (RE.test(input));
	}
	   
});
