//When form ready
jQuery(document).ready(function ()
{   
	jQuery('#html_upload').hide();
	var campaign_id = jQuery('#mobile_creative_anchor').attr('data-campaign-id');

	//Store it to a hidden feild
	jQuery('#_html_campaign_id').val(campaign_id);
	if(campaign_id)
	{
		jQuery('#html_campaign_group').hide();
	}
	
});
	
	
	
var iab_file_type=['application/zip', 'application/x-zip-compressed', 'multipart/x-zip', 'application/x-compressed'];
	//Set IAB creative standard
//Define default
	var input = document.getElementById("html_creative"),formdata = false;			

/* name: html_type
	 * @param:null
	 * 
	 * switch between url banner and normal banner.
	 * */
	
	function html_type()
	{
		if(jQuery('#is_html5').is(':checked'))
		{
			jQuery('#_html_banner').val(1);
			jQuery('#html_ctnt').hide();
			jQuery('#html_upload').show();
			file_input();			
		}
		else
		{
			jQuery('#html_ctnt').show();
			jQuery('#html_upload').hide();
		}
	}
	
function file_input()
{
		
				//Bind the event to onchange of the url file
				input.addEventListener("change",handleFileSelect , false);	
				console.log(window.FormData);
				if (window.FormData)
				{
					formdata = new FormData();
				
				}
				jQuery.validator.setDefaults({
					debug: true,
					success: "valid"
				});
				var form = jQuery( "#html_creative_form" );
	
}

	
	function handleFileSelect(evt)
 	{
		//~ var selcted_creative_size=jQuery('#html_creative_size').val();
		//~ var creative_size_split = selcted_creative_size.split('x');
		//~ var iab_max_width= parseInt(creative_size_split[0], 10); 
		//~ var iab_max_height= parseInt(creative_size_split[1], 10);
		
		var iab_max_width= jQuery('#html_creative_width').val();
		var iab_max_height= jQuery('#html_creative_height').val();
		
		var form = jQuery( "#html_creative_form" );

		var isvalid_creative=true;		//form check list


		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_html_creative').val()!='')
		{
			var tmp_html_creative_name=jQuery('#tmp_html_creative').val();
			jQuery.ajax({
			type:'POST',
			async:false,
			url: site_url+'/api/v1/web_creative/delete_a_tmp_html_creative/format/json',
			data: {creative_name:tmp_html_creative_name,api_key:api_key,html_creative:1},
			success: function(data, textStatus, jqXHR){
			console.log(jqXHR);
			console.log(data.response);

				if(data.response == 'ok')
				{
					console.log(data.msg);
				}
				else
				{
					console.log(data.msg);
				}
			//Validate the particular feild
			form.validate().element(jQuery('#html_creative'));
			}, 
			// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Error ! A problem with the request try again!');
			}
			}); 
		}
		
		jQuery('#tmp_web_creative').val('');//empty temporary feild value
		
		var i = 0, len = this.files.length, img, reader, file;
		//for ( ; i < len; i++ )
		//{
			file = this.files[i];		
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				var extension = file.name.substr( (file.name.lastIndexOf('.') +1) );
				if (!!file.type.match(/application.*/) || !!file.type.match(/multipart.*/) || extension == "zip")
				{
					
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type=file.type;
							var creative_width=parseInt(this.width,10);
							var creative_height=parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
								//IAB type check
								var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
								if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
								{
									var validator = form.validate();
									validator.showErrors({"web_creative": "Creative file format should be zip"});
									isvalid_creative=false;
									jQuery('#creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#html_creative').val('');
									jQuery('#tmp_html_creative').val('');
								}
								
								

							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("html_creative", "1");
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{ 
								//Validate the particular feild
								jQuery( "#html_creative_form" ).validate().element(jQuery('#html_creative'));
								
								if (formdata)
								{ 
									jQuery.ajax({
										
										url: site_url+'/api/v1/web_creative/creative_to_tmp_html_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
										
											if(data.response != 'error')
											{
												jQuery('#tmp_html_creative').val(data.response.file_name);
												
												
												jQuery('#tmp_html_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_html_creative_url').val(data.response.full_path);
												if(data.response.file_ext==".zip")
												{
													jQuery('#tmp_html_creative_ext').val("zip");
												}
											}
											else
											{
												
												window.location.replace(data.redirect);
												jQuery('#tmp_html_creative').val('');
											}
										}
									});
								}
							}
					
					
					
				}
				else
				{
					var validator = jQuery( "#html_creative_form" ).validate();
					jQuery('#html_creative').val('');
					jQuery('#creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"html_creative": "Creative must be an image "});
				}
			}	
		//}
		
	}
	
	
	
	
/* name: 		
	 * @param:		null
	 *
	 * Submit the HTML creative form
	 * */
	jQuery(function(){
		var form = jQuery("#html_creative_form");
		var validator = form.validate();
		jQuery( "#add_html5_creative_btn" ).unbind().bind('click',function(evt){
	//	if ( CKEDITOR.instances.html_content.getData() == '' ){
			//alert("HTML content field is required");
		//}
		//alert(check_editor_empty());
		
		  if(form.valid()==true)
		  {
				jQuery('#add_html5_creative_btn').unbind('click.html_add');							
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					url: form.attr("action"),
					async:false,
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

						if(data.response == 'ok')
						{
							if(jQuery('#_html_campaign_id').val() !='')
							{
								refresh_existing_creative(jQuery('#_html_campaign_id').val());
								$('.alert-success').show();	
								$('#success_msg').html(data.msg);
								$('html, body').animate({ scrollTop: $('#successalert').offset().top -45 }, 'slow');								
							}
							//Switch modal box					
$('#modal_mobile_html5_creative_add').modal('hide');
$('#modal_mobile_html5_creative_add, .modal-backdrop').css('display','none');


							if(jQuery('#_html_campaign_id').val() =='')
							{
								//jQuery('#modal_html_creative_success').modal('show');
								swal({   title: "Good Job!",   text: "New HTML creative added successfully!",   type: "success",   showCancelButton: true,   confirmButtonColor: "#399bff",   confirmButtonText: "Go to creatives!",   cancelButtonText: "Close",   closeOnConfirm: false,   closeOnCancel: true }, function(isConfirm){   if (isConfirm) {     window.location.href = "/index.php/advertiser/creatives";   } });
								
							}
							
							validator.resetForm();
							form.get(0).reset();
							jQuery( "#add_html5_creative_btn" ).bind('click.html_add');
							
						}
						else
						{
							jQuery( "#add_html5_creative_btn" ).bind('click.html_add');
							validator.showErrors(data.msg);
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}else{
				
				/* if(check_editor_empty())
				 { 
					validator.showErrors({"html_content": "Please enter some html content"});	
				} */
			}	
		  
		});
	});

	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
			jQuery.ajax({
			type:'POST',
			url : site_url+"/advertiser/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id},
			
			success : function(data){

							if(data!='')
							{
								jQuery("#_existing_creative").html(data);
							}
							return true;
							//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
						}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	
	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * Check Empty Text at the Editor.
	 * */
function check_editor_empty() {
	var form = jQuery("#html_creative_form");
	var validator = form.validate();
	var editor_val = CKEDITOR.instances.html_content.document.getBody().getChild(0).getText() ;
    
	if (editor_val == '') {
		
		validator.showErrors({"html_content": "Please enter some html content"});
		$('span[for="html_content"]').css('display','block');
		return false ;
	}
    
	return true ;
}
