// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
        "oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/targeting/fetch_keyword",
	
	  "aoColumnDefs": [
        {
			"aTargets": [0],
			"mData":"keyword",
		},
        {
			"aTargets": [1],
			"mData":null,
			"mRender": function (data, type, full) {
			  var keyword_id=full.id;
			  var status=full.is_blocked;//Get blocked status
			  return action_button(keyword_id,status);
			}
		},
		
    	]
    };

 
function action_button(keyword_id,status)
{
	 if(check_manager_permission('189') || check_manager_permission('190') || check_manager_permission('191'))
	 {
	 if(check_manager_permission('189'))
	{
	var rev_url = site_url+'/admin/targeting/edit_keyword'; 
	
	var rev_btn = '<a data-toggle="modal" role="button"  class="btn btn-small" data-target="#modal-edit-keyword" href="'+rev_url+'/'+keyword_id+'"><i class="icon-edit"></i>&nbsp;&nbsp;Review</a>';
	}else
	{
		var rev_btn ='';
	}

 	if(check_manager_permission('190'))
	{
	var del_btn = '<button class="btn btn-small site" data-id="'+keyword_id+'" data-toggle="modal" onclick="delete_keyword('+keyword_id+')"><i class="icon-trash"></i>&nbsp;&nbsp;Delete</button>';
	}else
	{
		var del_btn ='';
	}

	if(check_manager_permission('191'))
	{
	if(status==0)
	{
	   var block_btn = '&nbsp;<button class="btn btn-small btn-danger confirm"  data="'+keyword_id+'" data-bb="confirm"><i class="icon-lock"></i>&nbsp;&nbsp;Block</i></button>';
	}
	else 
	{
		var block_btn = '&nbsp;<button class="btn btn-small btn-success confirm_unblock"  data="'+keyword_id+'" data-bb="confirm"><i class="icon-key"></i>&nbsp;&nbsp;Unblock</i></button>';
	}
}else
{
	var block_btn='';
}
	
	return rev_btn+del_btn+block_btn;
}
else
{
	return 'you have limited privileges';
}
}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});


function delete_keyword(keyword_id)
{   
	$("#id").val(keyword_id);
    $('#modal_delete_keyword').modal('show');	
}


// Block  Functionality with Confirm Box

	$(document).on("click", ".confirm", function(e) {
	 
	 	bootbox.confirm("Are you sure  want to block this keyword ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/block_keyword/format/json',
					data:{'keyword_id':$(e.target).attr('data'),'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							 
							$('select').select2("val", "");
							
							$('.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
								});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('.alert-success').show();	
					        $('#success_msg').html(data.msg);
					        	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 });


// UnBlock  Functionality with Confirm Box

	$(document).on("click", ".confirm_unblock", function(e) {
	 
	 	bootbox.confirm("Are you sure  want to unblock this keyword ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/unblock_keyword/format/json',
					data:{'keyword_id':$(e.target).attr('data'),'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							 
							$('select').select2("val", "");
							
							$('.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
								});
							$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('.alert-success').show();	
					       $('#success_msg').html(data.msg);
					      $('html, body').animate({ scrollTop: $('#successalert').offset().top -45 }, 'slow');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 });
