// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
        "oLanguage":{
						"sSearch": "<span>"+lbl_datatable.lbl_search+":</span> ",
						"sInfo":  lbl_datatable.lbl_showing+"<span>_START_</span>"+lbl_datatable.lbl_to+"<span>_END_</span>"+lbl_datatable.lbl_of+"<span>_TOTAL_</span>"+lbl_datatable.lbl_entries,
						"sLengthMenu": "_MENU_ <span>"+lbl_datatable.lbl_entries_page+"</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/geo_settings/fetch_geo_list",
	
	  "aoColumnDefs": [
        {
			"aTargets": [0],
			"mData":"cpm_value",
		},
        {
			"aTargets": [1],
			"mData": "country_name",
		},
		{
			"aTargets": [2],
			"mData":null,
			"mRender": function (data, type, full) {
				var geo_id=full.id;
				var status=full.status;//Get blocked status
			  return action_button(geo_id,status);
			}
		},
		
    	]
    };

 
function action_button(geo_id,status)
{
	var rev_url = site_url+'/admin/geo_settings/edit_geo'; 
	var rev_btn = '<a data-toggle="modal" role="button"  class="btn btn-small" data-target="#modal-edit-geo" href="'+rev_url+'/'+geo_id+'"><i class="icon-edit"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_review+'</a>';
	
	var del_url = '';
	var del_btn = '<button class="btn btn-small site" data-id="'+geo_id+'" data-toggle="modal" onclick="delete_geo('+geo_id+')"><i class="icon-trash"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_delete+'</button>';
	
    if(status==0)
	{
	   var block_btn = '&nbsp;<button class="btn btn-small btn-danger confirm"  data="'+geo_id+'" data-bb="confirm"><i class="icon-lock"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_block+'</i></button>';
	}
	else 
	{
		var block_btn = '&nbsp;<button class="btn btn-small btn-success confirm_unblock"  data="'+geo_id+'" data-bb="confirm"><i class="icon-key"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_unblock+'</i></button>';
	}
	//var block_btn = '<button class="btn btn-small btn-success" data-id="'+geo_id+'" data-toggle="modal" onclick="block_manager('+geo_id+')"><i class="icon-lock"></i>&nbsp;&nbsp;Block</button>';
	 
	return rev_btn+' '+del_btn+' '+block_btn;
}

$('.modal').on('hidden', function () {
$(this).removeData('modal');
});

function delete_geo(geo_id)
{
	console.log('cat_id'+geo_id);
	$("#geo_id").val(geo_id);
    $('#modal_delete_geo').modal('show');	
}


// Block  Functionality with Confirm Box

	$(document).on("click", ".confirm", function(e) {
	 
	 	bootbox.confirm("Are you sure you want to block this geo setting ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
				// URL from the link that was clicked on
				type:'GET',
				url: site_url+'/api/v1/geo_settings/block_geo/format/json',
				data:{'geo_id':$(e.target).attr('data'),'api_key':api_key},
				// Success function. the 'data' parameter is an array of objects that can be looped over
				success: function(data, textStatus, jqXHR){
				console.log(jqXHR);
				if(data.response == 'ok'){
					 
					$('select').select2("val", "");
					
					$('.dataTable').dataTable(custom_opt).fnDraw();
					$('.dataTables_filter input').attr("placeholder",lbl_datatable.search_place_holder);
					$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
						disable_search_threshold: 9999999
						});
					if($(this).hasClass("dataTable-fixedcolumn")){
						new FixedColumns( oTable );
					}
					if($(this).hasClass("dataTable-columnfilter")){
						oTable.columnFilter({
							"sPlaceHolder" : "head:after"
						});
					}
					resize_chosen();	
					
					//$('#save_site').unbind('click');
					$('#del_cat_msg').attr("data-notify-message",data.msg);
					
					$('#del_cat_msg').trigger('click');	
				}
				else
				{
					//validator.showErrors(data.msg);
				}
			
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Oh no! A problem with the AJAX request!');
				}
				}); 
				
			}
		}); 
	 
	 });


// UnBlock  Functionality with Confirm Box

	$(document).on("click", ".confirm_unblock", function(e) {
	 
	 	bootbox.confirm(lal_valid.unblock_geo_setting, function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
				// URL from the link that was clicked on
				type:'GET',
				url: site_url+'/api/v1/geo_settings/unblock_geo/format/json',
				data:{'geo_id':$(e.target).attr('data'),'api_key':api_key},
				// Success function. the 'data' parameter is an array of objects that can be looped over
				success: function(data, textStatus, jqXHR){
				//console.log(jqXHR);
				if(data.response == 'ok'){
					 
					$('select').select2("val", "");
					
					$('.dataTable').dataTable(custom_opt).fnDraw();
					$('.dataTables_filter input').attr("placeholder",lbl_datatable.search_place_holder);
					$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
						disable_search_threshold: 9999999
						});
					$("#check_all").click(function(e){
									$('input', oTable.fnGetNodes()).prop('checked',this.checked);
					});
					if($(this).hasClass("dataTable-fixedcolumn")){
						new FixedColumns( oTable );
					}
					if($(this).hasClass("dataTable-columnfilter")){
						oTable.columnFilter({
							"sPlaceHolder" : "head:after"
						});
					}
					resize_chosen();	
					
					//$('#save_site').unbind('click');
					$('#del_cat_msg').attr("data-notify-message",data.msg);
					
					$('#del_cat_msg').trigger('click');	
				}
				else
				{
					//validator.showErrors(data.msg);
				}
			
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Oh no! A problem with the AJAX request!');
				}
				}); 
				
			}
		}); 
	 
	 });
