//Preload with the first column since you know it will always be there
var includedColumns = [{ "mData": "adnetwork_name","sClass": "span1"}];
//Add additional columns
includedColumns.push({ "mData": "vast_mediation_url","sClass": "span3" });

includedColumns.push({ "mData" : null, "sClass": "span4",
				"mRender": function (data, type, full) {
				return '<span class="change_'+full.id+'"><a href="javascript:void(0)" onclick="toBox('+full.id+','+full.ecpm+')">'+full.ecpm+'</a></span>';
				} });

includedColumns.push({"mData" : null,"sClass":"no-print", "bSortable": false,
			  "mRender": function (data, type, full){
				var account_id	=	full.id;
				var status		=	full.status;
				return action_button(account_id,status);
			  }
		  });
$.each(includedColumns, function (i, column) {
column.aTargets = [i];
});

// dataTables
//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
         "oLanguage":{
				        "sSearch": "<span>"+lbl_datatable.lbl_search+":</span> ",
						"sInfo": lbl_datatable.lbl_showing+" <span>_START_</span> "+lbl_datatable.lbl_to+" <span>_END_</span> "+lbl_datatable.lbl_of+"  <span>_TOTAL_</span>" +lbl_datatable.lbl_entries,
						"sLengthMenu": "_MENU_ <span>"+lbl_datatable.lbl_entries_page+"</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/vast_mediation/fetch_adnetwork",
	"aaSorting": [],
	  "aoColumnDefs":includedColumns, 
	  
	  		"oTableTools": {
        "aButtons": [
            {
                "sExtends": "copy",
                 "sButtonText": lbl_datatable.lbl_copy,
                 "mColumns": [0,1,2,3]
            },
            {
                "sExtends": "csv",
                "sButtonText": lbl_datatable.lbl_csv,
                "mColumns": [0,1,2,3]
            },
            {
                "sExtends": "xls",
                "sButtonText": lbl_datatable.lbl_xls,
                "mColumns": [0,1,2,3]
            },
            {
                "sExtends": "pdf",
                "sButtonText": lbl_datatable.lbl_pdf,
                "mColumns": [0,1,2,3]
            },
            {
                "sExtends": "print",
                "sButtonText": lbl_datatable.lbl_print,
                "bSelectedOnly": true
            },
        ]
    },
    "fnRowCallback": function(nRow, aData, iDisplayIndex){
			if(aData.is_deleted =='1')
			{
				$(nRow).addClass('inactive');	
			}	
			return nRow;
		}
    };

$(document).ready(function() {

	if($(".dataTable").length > 0){
		//TRIGGER THE DATATBLE EVENT
		jQuery('.dataTable').dataTable(custom_opt).fnDraw();
		//TRIGGER THE DATATBLE EVENT

			jQuery('.dataTables_filter input').attr("placeholder", lbl_datatable.search_place_holder);
		jQuery(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
			disable_search_threshold: 9999999
		});
		jQuery("#check_all").click(function(e){
			$('input', oTable.fnGetNodes()).prop('checked',this.checked);
		});
		if(jQuery(this).hasClass("dataTable-fixedcolumn")){
			new FixedColumns( oTable );
		}
		if(jQuery(this).hasClass("dataTable-columnfilter")){
			oTable.columnFilter({
			"sPlaceHolder" : "head:after"
			});
		}
		resize_chosen();
	}

});

function toBox(id, ecpm){
	var btn = '<input type="text" name="change_ecpm" value="'+ecpm+'" class="dytext span3 input-medium positiveNumber" maxlength="5"></input><button type="button" class="btn btn-primary editable-submit" min="0.1" onclick="update_ecpm('+id+','+ecpm+')"><i class="icon-ok icon-white"></i></button><button type="button" class="btn editable-cancel" onclick="close_ecpm('+id+','+ecpm+')"><i class="icon-remove"></i></button>';
	$('.change_'+id).html(btn);
}

function close_ecpm(id, ecpm){
	var old = '<a href="javascript:void(0)" onclick="toBox('+id+','+ecpm+')">'+ecpm+'</a>';
	$('.change_'+id).html(old);
}

function update_ecpm(id){
	var ecpm = $('.change_'+id+' .dytext').val();
	
	if(!parseFloat(ecpm))
	{
		alert('Please enter postive values');
		return false;
	}	
	
	if(parseFloat(ecpm) < 0.1)
{
alert('Enter values greater than or equal to 0.1');	
return false;	
}	
	jQuery.ajax({
		type:'POST',
		url: site_url+'/api/v1/vast_mediation/update_ecpm/format/json',
		data: {api_key: api_key,dsp_id : id,dsp_ecpm:ecpm},
		success: function(data, textStatus, jqXHR){
			if(data.response == 'ok')
			{
				$('.change_'+id).html('<a href="javascript:void(0)" onclick="toBox('+id+','+data.msg+')">'+data.msg+'</a>');
			}
			else
			{
				alert('Unable to process your request');
			}
		}, 
		error: function(jqXHR, textStatus, errorThrown){
		}
	}); 
}

// Action 
function action_button(account_id,status)
{

	if(check_manager_permission('222') || check_manager_permission('223') || check_manager_permission('224') || check_manager_permission('225'))
	 {	
		 
		 if(check_manager_permission('222'))
		 {			 
			var rev_url = site_url+'/admin/vast_mediation/edit_dsp'; 
			//var rev_btn = '<a data-toggle="modal" role="button"  class="btn btn-small" data-target="#modal_edit_dsp" data_backdrop="static" href="'+rev_url+'/'+account_id+'"><i class="icon-edit"></i>&nbsp;&nbsp;Review</a>&nbsp;&nbsp;';
			var rev_btn = '<a role="button"  class="btn btn-small" href="'+rev_url+'/'+account_id+'"><i class="icon-edit"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_review+'</a>&nbsp;&nbsp;';
		 }
		 else
		 {
		   var rev_btn='';	
		 }
		 
		 if(check_manager_permission('223'))
		 {
			var del_btn = '<button class="btn btn-small" data-id="'+account_id+'" data-toggle="modal" onclick="delete_dsp('+account_id+')"><i class="icon-trash"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_delete+'</button>&nbsp;&nbsp;';
		 }
		 else
		 {
		   var del_btn='';	
		 }			
			
		 if(check_manager_permission('224'))
		 {					
	
	if(status==1)
	{
		var block_btn = '<button class="btn btn-small btn-danger" data-id="'+account_id+'" data-toggle="modal" onclick="block_dsp('+account_id+')"><i class="icon-lock"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_block+'</button>'; 
	}
	else
	{
		var block_btn = '<button class="btn btn-small btn-success" data-id="'+account_id+'" data-toggle="modal" onclick="unblock_dsp('+account_id+')"><i class="icon-key"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_unblock+'</button>';
	}
	
		 }
		 else
		 {
		   var block_btn='';	
		 }		
		 	
		 if(check_manager_permission('225'))
		 {	
	
			var csv_upload_url = site_url+'/admin/vast_mediation/upload_csv_country_dsp';
			var csv_upload_btn = '<a data-toggle="modal" role="button"  class="btn btn-small" data-target="#modal_csv_upload" data_backdrop="static" href="'+csv_upload_url+'/'+account_id+'"><i class="icon-globe"></i>&nbsp;&nbsp;'+lal_valid.country_csv+'</a>&nbsp;&nbsp;';
	
   		 }
		 else
		 {
		   var csv_upload_btn='';	
		 }
			
		   return rev_btn+csv_upload_btn+del_btn+block_btn;
     }
	 else
	{
		return lal_valid.priv;
	}		
}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function delete_dsp(account_id)
{
	$("#del_account_id").val(account_id);
    $('#modal_delete_dsp').modal('show');	
}

function block_dsp(account_id)
{
	$("#block_account_id").val(account_id);
    $('#modal_block_dsp').modal('show');	
}


function unblock_dsp(account_id)
{
	$("#unblock_account_id").val(account_id);
    $('#modal_unblock_dsp').modal('show');	
}
