//Preload with the first column since you know it will always be there
var includedColumns = [{ "mData": "name" ,
						 "mRender"	: function (data, type, full){
						  return full.name.charAt(0).toUpperCase()+full.name.slice(1);
						  }
					   }];
//Add additional columns
includedColumns.push({ "mData": "email" });
includedColumns.push({ "mData": "camp_count" , "sClass": "alignRight",
						"mRender": function (data, type, full) {
						return (full.camp_count)?full.camp_count:0;
					  }
					 });
if (check_manager_permission('135'))
{
	includedColumns.push({ "mData" : null, "sClass": "alignRight","sType":"currency",
				"mRender": function (data, type, full) {
				return full.spend_amount;
				} });
}

if (check_manager_permission('156') || check_manager_permission('135'))
{
	includedColumns.push({ "mData" : null, "sClass": "alignRight","sType":"currency",
				"mRender": function (data, type, full) {
				return full.balance;
				} });
}



includedColumns.push({"mData" : null,"sClass":"no-print","bSortable": false,
			  "mRender": function (data, type, full){
				var account_id	=	full.account_id;
				var status		=	full.status;
				return action_button(account_id,status,full);
			  }
		  });
$.each(includedColumns, function (i, column) {
column.aTargets = [i];
});

var man_account_id = $('#manager_account_id').val();

// dataTables
//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
        "oLanguage":{
					"sSearch": "<span>"+lbl_datatable.lbl_search+":</span> ",
						"sInfo":  lbl_datatable.lbl_showing+"<span>_START_</span>"+lbl_datatable.lbl_to+"<span>_END_</span>"+lbl_datatable.lbl_of+"<span>_TOTAL_</span>"+lbl_datatable.lbl_entries,
						"sLengthMenu": "_MENU_ <span>"+lbl_datatable.lbl_entries_page+"</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/users/fetch_advertiser/"+man_account_id,
	  "aoColumnDefs":includedColumns,/*[
        {
			"aTargets"	: [0],
			"mData"		:"name",
			"mRender"	: function (data, type, full)
			{
				return full.name.charAt(0).toUpperCase()+full.name.slice(1);
			}
		},
        {
			"aTargets"	: [1],
			"mData"		: "email",
			"mRender"	: function (data, type, full)
			{
				return full.email;
			}
		},
		{
			"aTargets"	: [2],
			"mData"		: "camp_count",
			"mRender"	: function (data, type, full)
			{
				return (full.camp_count)?full.camp_count:0;
			}
		},
		{
			"aTargets"	: [3],
			"mData"		: "account_id",
			"mRender"	: function (data, type, full)
			{
				return (full.spend_amount)?Math.round(full.spend_amount * 100) / 100:0;
			}
		},
		{
			"aTargets"	: [4],
			"mData"		:null,
			"sClass":"no-print",
			"mRender"	: function (data, type, full) {
				var account_id	=	full.account_id;
				var status		=	full.status;
				return action_button(account_id,status,full);
			}
		}
		
    	],*/
	  
	  "oTableTools": {
			//"sSwfPath": base_url+"template/flat/js/plugins/datatable/swf456/copy_csv_xls_pdf.swf",
        "aButtons": [
            {
                "sExtends": "copy",
                 "sButtonText": lbl_datatable.lbl_copy,
                 "mColumns": [0,1,2,3,4]
            },
            {
                "sExtends": "csv",
                "sButtonText":lbl_datatable.lbl_csv,
                "mColumns": [0,1,2,3,4]
            },
            {
                "sExtends": "xls",
                "sButtonText": lbl_datatable.lbl_xls,
                "mColumns": [0,1,2,3,4]
            },
           
            {
                "sExtends": "print",
                "sButtonText": lbl_datatable.lbl_print,
               // "bShowAll" :true,
                "bSelectedOnly": true,
               /* "sInfo": 'Click print or cancel <button>Print</button>',
                "fnClick": function (nButton, oConfig, oFlash) {
                  
                  $('td.no-print').hide(); 
                  
                } */
            },
        ]
    }
    };

$(document).ready(function() {

	if($(".dataTable").length > 0){
		//TRIGGER THE DATATBLE EVENT
		jQuery('.dataTable').dataTable(custom_opt).fnDraw();
		//TRIGGER THE DATATBLE EVENT

		jQuery('.dataTables_filter input').attr("placeholder", lbl_datatable.search_place_holder);
		jQuery(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
			disable_search_threshold: 9999999
		});
		jQuery("#check_all").click(function(e){
			$('input', oTable.fnGetNodes()).prop('checked',this.checked);
		});
		if(jQuery(this).hasClass("dataTable-fixedcolumn")){
			new FixedColumns( oTable );
		}
		if(jQuery(this).hasClass("dataTable-columnfilter")){
			oTable.columnFilter({
			"sPlaceHolder" : "head:after"
			});
		}
		resize_chosen();
	}

});

// Action 
function action_button(account_id,status,full)
{
	if(check_manager_permission('119') || check_manager_permission('120') || check_manager_permission('121'))
	 {	
		if(check_manager_permission('119'))
		{
			var rev_url = site_url+'/admin/users/edit_advertiser'; 
			var rev_btn = '<a data-toggle="modal" role="button"  class="btn btn-small" data-target="#modal_edit_advertiser" data_backdrop="static" href="'+rev_url+'/'+account_id+'"><i class="icon-edit"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_review+'</a>&nbsp;&nbsp;';
		}
		else
		{
			var rev_btn='';	
		}
		
		if(check_manager_permission('120'))
		{
		var del_url = '';
		var del_btn = '<button class="btn btn-small" data-id="'+account_id+'" data-toggle="modal" onclick="delete_advertiser('+account_id+')"><i class="icon-trash"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_delete+'</button>&nbsp;&nbsp;';
		}
		else
		{
			var del_btn='';	
		}
		
	 if(check_manager_permission('121')){
		if(status==0)
		{
			var block_btn = '<button class="btn btn-small btn-danger" data-id="'+account_id+'" data-toggle="modal" onclick="block_advertiser('+account_id+')"><i class="icon-lock"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_block+'</button>&nbsp;&nbsp;'; 
		}
		else
		{
			var block_btn = '<button class="btn btn-small btn-success" data-id="'+account_id+'" data-toggle="modal" onclick="unblock_advertiser('+account_id+')"><i class="icon-key"></i>&nbsp;&nbsp;'+lbl_datatable.lbl_unblock+'</button>&nbsp;&nbsp;';
		}



		
		// Campaign Link
		//var camp_url = site_url+'/admin/users_inventory/campaigns/'+account_id; 
		//var cam_btn = '<a  role="button"  class="btn btn-small"  data_backdrop="static" href="'+camp_url+'"><i class="icon-file"></i>&nbsp;&nbsp;Campaigns</a>&nbsp;&nbsp;';
		//var cam_btn = '<a role="button"  class="btn btn-small" href="'+camp_url+'/'+account_id+'"><i class="icon-file"></i>&nbsp;&nbsp;Campaign</a>&nbsp;&nbsp;';
		
	 }
	 else
	  {
		 var block_btn='';  
	  }
		
		if(full.house_adv=='1'){
			//<b>Not Applicable</b> 
			return '(<small>'+lbl_datatable.default_advser+'</small>)';
		}
		else
		{	return rev_btn + del_btn + block_btn;
		//return rev_btn + del_btn + block_btn + cam_btn;
		//return rev_btn+del_btn+cam_btn+block_btn;
	}
	}
	else
	{
		return lal_valid.priv;
	}

}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function delete_advertiser(account_id)
{
	$("#del_account_id").val(account_id);
    $('#modal_delete_advertiser').modal('show');	
}

function block_advertiser(account_id)
{
	$("#block_account_id").val(account_id);
    $('#modal_block_advertiser').modal('show');	
}

function unblock_advertiser(account_id)
{
	$("#unblock_account_id").val(account_id);
    $('#modal_unblock_advertiser').modal('show');	
}

