// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
        "oLanguage":{
						"sSearch": "<span>"+lbl_datatable.lbl_search+":</span> ",
						"sInfo": lbl_datatable.lbl_showing+" <span>_START_</span> "+lbl_datatable.lbl_to+" <span>_END_</span> "+lbl_datatable.lbl_of+" <span>_TOTAL_</span> "+lbl_datatable.lbl_entries+"",
						"sLengthMenu": "_MENU_ <span>"+lbl_datatable.lbl_entries_page+"</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/approvals/fetch_payment_list",
	
	  "aoColumnDefs": [
        {
			"aTargets": [0],
			"mData":"date",
			"sType":"date",
			"mRender":function (data,type,full) {
			  
			   return data;
			}
		},
		{
			"aTargets": [1],
			"mData":"name",
		},
        {
			"aTargets": [2],
			"mData": "email",
		},
		{
			"aTargets": [3],
			"mData":"amount",
			"sType":"currency",
			"sClass": "alignRight",
			"mRender":function(data,type,full){
				
			   return data;
			}
		},
		{
			"aTargets": [4],
			"mData": "payment_type",
			"mRender":function(data,type,full){
				var pay;
				if(data == 'wire'){
					pay = lbl_datatable.wire;
				}else if(data == 'paypal'){
					pay = lbl_datatable.paypal;
				}
				
			   return pay;
			}
			
		},
		{
			"aTargets": [5],
			"mData":null,
			"bSortable": false,
			"mRender": function (data, type, full) {
			  return action_button(full);
			}
		},
		
    	]
    };

//date seperator
function getFormattedDate(dString)
 {
  var d = new Date(dString.split(".")[0].replace(/-/g,"/")); 
  var mm = d.getMonth()+1;
  var dd = d.getDate();
  if (mm<10)mm="0"+mm;
  if (dd<10)dd="0"+dd;
  return d.getFullYear()+"/"+mm+"/"+dd;
}

function action_button(full)
{
	if(check_manager_permission(133) || check_manager_permission('231'))
	{
		if(check_manager_permission(133))
		{
			var view_url = site_url+'/admin/approvals/payment_details_viewmore';
			var view_btn = '<a data-toggle="modal" role="button"  class="btn btn-small" data-target="#modal_payment_details_view" href="'+view_url+'/'+full.id+'"><i class="glyphicon-more_windows"></i>&nbsp;&nbsp;'+lbl_publisher.lbl_view+'</a>';
		}
		else
		{
			var view_btn = '';
		}
		if(check_manager_permission('231'))
		{	
		var app_url = '';
		/*var app_btn = '<a data-toggle="modal" role="button"  class="btn btn-small" onclick="approve('+full.id+','+full.amount+','+full.account_id+')"><i class="icon-thumbs-up"></i>&nbsp;&nbsp;Approve</a>';*/
		 var app_btn = '<a button class="btn btn-small site confirm" id="approve" data-accountid="'+full.account_id+'" data-amount="'+full.amount+'" data-id="'+full.id+'" data-bb="confirm"><i class="icon-thumbs-up"></i>&nbsp;&nbsp;'+lal_valid.approve+'</button></a>';
		 
		var rej_url = '';
		//var rej_btn = '<a data-toggle="modal" role="button"  class="btn btn-small" onclick="reject('+full.id+')"><i class="icon-thumbs-down"></i>&nbsp;&nbsp;Reject</a>';
		var rej_btn ='<a button class="btn btn-small site confirm_reject" id="reject" data-id="'+full.id+'" data-bb="confirm"><i class="icon-thumbs-down"></i>&nbsp;&nbsp;'+lbl_datatable.reject+'</button></a>';
		return view_btn+app_btn+rej_btn;
		
		}else
		{
			var view_btn = '';
		}
		
	}else
	{
		return lal_valid.priv;
	}
		 	
}

// approve Functionality with Confirm Box
		$(document).on("click", ".confirm", function(e) {
		//assign values to the variables
		 var pay_id=($(this).data('id'));
		 var account_id=($(this).data('accountid'));
		 var amount=($(this).data('amount'));
		 var msg1		="<div class='modal-header'><button aria-hidden='true' data-dismiss='modal' class='close' type='button'>X</button><h3 id='myModalLabel'><i class='icon-ok'></i>"+lbl_charts.appr_adv_pay+"</h3></div><div class=''><br><p>&nbsp;&nbsp;&nbsp;&nbsp;"+lbl_charts.app_pay+"</p>";
	     bootbox.confirm(msg1,lbl_publisher.lbl_cancel,lbl_datatable.lbl_ok, function(result) {
  			
			if(result===true){
				// AJAX request to get the data
				$.ajax({
				// URL from the link that was clicked on
				type:'POST',
				url: site_url+'/api/v1/approval/payment_approve/format/json',
				data:{'pay_id':pay_id,'account_id':account_id,'amount':amount,'api_key':api_key},
				// Success function. the 'data' parameter is an array of objects that can be looped over
				success: function(data, textStatus, jqXHR){
				
				if(data.response=='ok'){
					$('select').select2("val", "");
					$('.dataTable').dataTable(custom_opt).fnDraw();
					$('.dataTables_filter input').attr("placeholder", lbl_datatable.search_place_holder);
					$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
						disable_search_threshold: 9999999
						});
					$("#check_all").click(function(e){
									$('input', oTable.fnGetNodes()).prop('checked',this.checked);
					});
					if($(this).hasClass("dataTable-fixedcolumn")){
						new FixedColumns( oTable );
					}
					if($(this).hasClass("dataTable-columnfilter")){
						oTable.columnFilter({
							"sPlaceHolder" : "head:after"
						});
					}
					resize_chosen();
					  $('.alert-success').show();	
					  $('#success_msg').html(data.msg);
					  $('html, body').animate({ scrollTop: $('#successalert').offset().top -45 }, 'slow');
					
					
					notification();
					if(parseInt(data.tot_count.TOTAL_COUNT) > 0){
						
						
						$('#unread_approval_count').html(data.tot_count.TOTAL_COUNT);
					
						
					}	
					
					

					//Refresh notification @ top right
						//empty previous notification
						jQuery('#approval_notify').html('');	
					notification();	
				}
				else
				{
					//validator.showErrors(data.msg);
				}
			
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				
				}
				}); 
				
			}
		}); 
	 
	 });
		
	  // reject Functionality with Confirm Box
		$(document).on("click", ".confirm_reject", function(e) {
	 	//assign values to the variables
		 var pay_id=($(this).data('id'));
		  // var msg2		="<div class='modal-header'><button aria-hidden='true' data-dismiss='modal' class='close' type='button'>X</button><h3 id='myModalLabel'><i class='icon-ok'></i>Reject Advertiser Payment</h3></div><div class=''><br><p>&nbsp;&nbsp;&nbsp;&nbsp;Are you sure you want to reject this payment?</p>";
		   
			var msg2		="<div class='modal-header'><button aria-hidden='true' data-dismiss='modal' class='close' type='button'>X</button><h3 id='myModalLabel'><i class='icon-ok'></i>"+lbl_charts.rej_adv_pay+"</h3></div><div class=''><br><p>&nbsp;&nbsp;&nbsp;&nbsp;"+lbl_charts.rej_pay+"</p>";		   
		   
		  // bootbox.confirm("Are you sure you want to reject this payment?", function(result) {
			  bootbox.confirm(msg2,lbl_publisher.lbl_cancel,lbl_datatable.lbl_ok, function(result) {
  			if(result===true){
				// AJAX request to get the data
				$.ajax({
				// URL from the link that was clicked on
				type:'POST',
				url: site_url+'/api/v1/approval/payment_reject/format/json',
				data:{'rej_pay_id':pay_id,'api_key':api_key},
				// Success function. the 'data' parameter is an array of objects that can be looped over
				success: function(data, textStatus, jqXHR){
				
				if(data.response=='ok'){
					$('select').select2("val", "");
					
					$('.dataTable').dataTable(custom_opt).fnDraw();
					$('.dataTables_filter input').attr("placeholder", lbl_datatable.search_place_holder);
					$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
						disable_search_threshold: 9999999
						});
					$("#check_all").click(function(e){
									$('input', oTable.fnGetNodes()).prop('checked',this.checked);
					});
					if($(this).hasClass("dataTable-fixedcolumn")){
						new FixedColumns( oTable );
					}
					if($(this).hasClass("dataTable-columnfilter")){
						oTable.columnFilter({
							"sPlaceHolder" : "head:after"
						});
					}
					resize_chosen();	
					
					$('.alert-success').show();	
					  $('#success_msg').html(data.msg);
					  $('html, body').animate({ scrollTop: $('#successalert').offset().top -45 }, 'slow');
					//Refresh notification @ top right
						//empty previous notification
						jQuery('#approval_notify').html('');	
					notification();	
				}
				else
				{
					//validator.showErrors(data.msg);
				}
			
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				
				}
				}); 
				
			}
		}); 
	 
	 });
