<div class="span12">
	<div class="box ">
		<div class="box-title">
			<h3><i class="icon-bar-chart"></i><?php echo $this->lang->line('creative_performance');?></h3>
			<div class="actions"> <a href="#" class="btn btn-mini content-refresh"><i class="icon-refresh"></i></a> <a href="#" class="btn btn-mini content-remove"><i class="icon-remove"></i></a> <a href="#" class="btn btn-mini content-slideUp"><i class="icon-angle-down"></i></a> </div>
		</div>
		<div class="box-content">
			<div class="statistic-big">
				<div class="top">
						<div class="highlight-toolbar">
							<div class="pull-left">
								<form id='frm_search' name="frm_search">
								<div class="btn-toolbar">
									<div class="btn-group">
										<?php if($this->config->item('prod_code')=='MOB'){?>
										<select id='environment' name="environment" class='chosen-select' data-nosearch="true" data-placeholder="Sort by">
											<option value="Mobile">Mobile</option>
										</select>
									  <?php }else if($this->config->item('prod_code')=='VID'){?>
										<select id='environment' name="environment" class='chosen-select' data-nosearch="true" data-placeholder="Sort by">
											<option value="Display">Website</option>
										</select>
										<?php }else{?>
										<select id='environment' name="environment" class='chosen-select' data-nosearch="true" data-placeholder="Sort by">
											<option value="all">All Environment</option>
											<option value="Display">Website</option>
											<option value="Mobile">Mobile</option>
										</select>
										<?php }?>
									</div>
									<div class="btn-group">
									<select name="campaign" id="campaign" class='chosen-select' >
										<option value="all">All Campaigns</option>
										<?php 
											if(!empty($campaign_data)):
												foreach($campaign_data as $camp):
										?>
											<option value="<?php echo $camp['campaignid']; ?>"><?php echo $camp['campaignname']; ?></option>
										<?php endforeach; 
											else: ?>
												<option value="">No Campaigns Available</option>
										<?php endif; ?>
									</select>
										
									</div>
									<div class="btn-group">
										<a href="#" name="reservation" id="reservation" class="btn margin_correction"><span>
										<span id="default_start_date"><?php echo ($search_date != FALSE)?date('M d, Y',strtotime($search_date['from_date'])):''; ?></span> - 
										<span id="default_end_date"><?php echo ($search_date != FALSE)?date('M d, Y',strtotime($search_date['to_date'])):''; ?></span></span>&nbsp;&nbsp;<i class="icon-caret-down"></i></a>				</div>
									<div class="btn-group">
										<a id='submit_search' href="#" class="btn margin_correction" rel="tooltip" title="Apply filter"><i class="icon-search"></i></a>
									</div>
									
									<div class="btn-group">
										<a id='refresh_search'  class="btn margin_correction" rel="tooltip" title="Refresh Results"><i class="icon-refresh"></i></a>
									</div>
										
								</div>
								<input type='hidden' value="<?php echo ($search_date != FALSE)?date('Y-m-d',strtotime($search_date['from_date'])):''; ?>"  id='date_from' name='date_from'/>
								<input type='hidden' value="<?php echo ($search_date != FALSE)?date('Y-m-d',strtotime($search_date['to_date'])):''; ?>" id='date_to' name="date_to" />
							</form>

							</div>
						</div>
					</div>
						<div class="bottom">
							<div id="creative_performance_chart" style="min-width: 310px; margin: 0 auto"></div>
						</div>
						<div class="bottom">
							<ul class="stats-overview">
								<li >
									<span class="name" ><?php echo $this->lang->line('impression');?></span>
									<span id='total_imp' class="value"> 0 </span>
								</li>
								<li>
									<span class="name"><?php echo $this->lang->line('clicks');?></span>
									<span id='total_clk' class="value"> 0 </span>
								</li>
								<li >
									<span class="name"><?php echo $this->lang->line('unique_impression');?></span>
									<span id='total_uimp' class="value">0 </span>
								</li>
								<li >
									<span class="name" ><?php echo $this->lang->line('unique_clicks');?></span>
									<span id='total_uclk' class="value"> 0 </span>
								</li>
								<li>
									<span class="name"><?php echo $this->lang->line('converstion');?></span>
									<span id="total_con" class="value"> 0 </span>
								</li>
							</ul>
						</div>
			</div>
		</div>
	</div>
</div>
 <script>



	$('#submit_search').click(function (){
	
		var env = $('#environment').val();
		var cam = $('#campaign').val();
		var df = $('#date_from').val();
		var dt = $('#date_to').val();
		custom_opt.sAjaxSource = site_url+"/admin/reports/fetch_creative_stats/"+env+"/"+cam+"/"+df+"/"+dt;
		
		// Load Chart
		load_chart();	
			
	});
	
	$('#refresh_search').click(function (){
	
		$('#environment').val('all').trigger('liszt:updated');
		$('#campaign').val('all').trigger('liszt:updated');
		$('#date_from').val(start_default_date);
		$('#date_to').val(end_default_date);
		$('#reservation span').text(default_start_date_txt+' - '+default_end_date_txt);
		custom_opt.sAjaxSource = site_url+"/admin/reports/fetch_creative_stats";
		// Load Chart
		load_chart();
		
	});

    function dataTableRedraw()
    {
   		$('.dataTable').dataTable(custom_opt).fnDraw();
			$('.dataTables_filter input').attr("placeholder", "Search here...");
			$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
				disable_search_threshold: 9999999
				});
			$("#check_all").click(function(e){
							$('input', oTable.fnGetNodes()).prop('checked',this.checked);
			});
			if($(this).hasClass("dataTable-fixedcolumn")){
				new FixedColumns( oTable );
			}
			if($(this).hasClass("dataTable-columnfilter")){
				oTable.columnFilter({
					"sPlaceHolder" : "head:after"
				});
			}
			resize_chosen();	
   }

$(document).ready(function() {
	
	start_default_date = jQuery('#date_from').val();
	end_default_date =  jQuery('#date_to').val();
	
	default_start_date_txt = jQuery('#default_start_date').text();
	default_end_date_txt = jQuery('#default_end_date').text();
	
	
  	$('#reservation').daterangepicker({
  	  ranges: {
  		 'Today': [moment(), moment()],
  		 'Yesterday': [moment().subtract('days', 1), moment().subtract('days', 1)],
  		 'Last 7 Days': [moment().subtract('days', 6), moment()],
  		 'Last 30 Days': [moment().subtract('days', 29), moment()],
  		 'This Month': [moment().startOf('month'), moment().endOf('month')],
  		 'Last Month': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')]
  	  },
	  startDate: moment().subtract('days', 29),
      endDate: moment()
  	},
  	function(start, end) {
		$('#date_from').val(start.format('YYYY-MM-DD'));
		$('#date_to').val(end.format('YYYY-MM-DD'));
		$('#reservation span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
  	});
  });
  

	load_chart();
	var chart;	
	
	function load_chart(){

			$(function(){
			
			var options = {
			chart: {
					renderTo: 'creative_performance_chart',
					type: 'column'
				},
            title: {
                text: ''
            },
            xAxis: {
                categories: [] 
            },
            yAxis: {
                min: 0,
                title: {
                    text: 'Values'
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                }
            },
            legend: {
                align: 'right',
                x: -70,
                verticalAlign: 'top',
                y: -10,
                floating: true,
                backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColorSolid) || 'white',
                borderColor: '#CCC',
                borderWidth: 1,
                shadow: true
            },
            tooltip: {
                formatter: function() {
					if(this.series.name=='SPEND')
					{
						return '<b>'+ this.x +'</b><br/>'+
							this.series.name +': $'+ this.y;
					} else if(this.series.name=='CTR') {
						return '<b>'+ this.x +'</b><br/>'+
							this.series.name +':'+ this.y+'%';
					}else {
						return '<b>'+ this.x +'</b><br/>'+
							this.series.name +':'+ this.y;
					}
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: true,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'
                    }
                }
            },
				series: []
			};

			 chart = new Highcharts.Chart(options);
			 chart.showLoading();
			
			// AJAX request to get the data
			$.ajax({
			// URL from the link that was clicked on
			type:'POST',
			url: site_url+'/api/v1/report/fetch/format/json',
			data:{
						'page':'MANAGE_HS_CREATIVE',
						'display_type':'CHART',
						'date_from':$('#date_from').val(),
						'date_to':$('#date_to').val(),
						'account_id':'<?php echo get_session('account_id'); ?>',
						'account_type':'<?php echo get_session('account_type'); ?>',
						'environment':$('#environment').val(),
						'campaign_id':$('#campaign').val(),
						'adv_account_id':'<?php echo get_session('default_advertiser_account_id'); ?>',
					},
			// Success function. the 'data' parameter is an array of objects that can be looped over
			success: function(data, textStatus, jqXHR){
			if(data.response == 'ok'){
				if (data.data!=false)
				{
					options.series = data.chart_data;
					options.xAxis.categories = data.chart_x_axis;
					chart = new Highcharts.Chart(options);
					chart.hideLoading();
				}
				else
				{
					chart.hideNoData();
					chart.showNoData('No data found. Refine your search filters.');
					chart.hideLoading();
				}
				
				var total = data.total;
				for (key in total) {
					var rec = total[key];
					
							if(rec.key == 'ECPM'){
							
								$('#total_'+rec.key.toString().toLowerCase()).html(currency+rec.value)
							}
							else if(rec.key == 'SPEND'){
							
								$('#total_'+rec.key.toString().toLowerCase()).html(currency+rec.value)
							}
							else if(rec.key == 'CTR'){
							
								$('#total_'+rec.key.toString().toLowerCase()).html(rec.value+'%')
							}
							else
							{
						
								$('#total_'+rec.key.toString().toLowerCase()).html(''+rec.value)
							}
				}
				if(!data.chart_data)
				{
					$('#total_imp').html('0');
					$('#total_clk').html('0');
					$('#total_uimp').html('0');
					$('#total_uclk').html('0');
					$('#total_con').html('0');

				}
			}
			}, 
			// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
			}); 
			});	
	}



	
</script>
