<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Do_ads extends CI_Model
{
	function validate_zone($zone_id)
	{	
		$SQL = "SELECT oz.vd, oz.zoneid, oz.dj_zone_type, oz.dj_floor_price, oz.dj_passback_tag, dps.account_id FROM ".TAB_ZONES." as oz JOIN ".TAB_SITE_ZONE_ASSOC." as sza ON oz.zoneid = sza.zone_id JOIN ".TAB_PUB_SITES." as dps ON sza.site_id = dps.site_id JOIN ".TAB_AFFILIATE." as oa ON oz.affiliateid=oa.affiliateid WHERE oz.dj_is_deleted = 0 AND oz.status = 1 AND dps.is_deleted = 0 AND dps.status = 1 AND oa.dj_is_deleted = 0 AND oa.dj_is_denied = 0 AND oz.zoneid=".$zone_id;
		$query = $this->db->query($SQL);
		$result = $query->result_array();
		return $result;
	}

	function track_request($viewer, $request)
	{
		if(!empty($viewer)) $this->db->insert(TAB_TRACK_VIEWERS, $viewer);
		$this->db->insert(TAB_TRACK_AD_REQ, $request);
		return $this->db->insert_id();
	}

	function get_dsp($account_id,$format)
	{
		if($format)
		{	
		$this->db->select(array('dva.id', 'dva.adnetwork_name', 'dva.vast_mediation_url', 'dva.video_length', 'dva.publisher', 'dva.country', 'dva.vast_version','dva.ad_type'));
		$this->db->from(TAB_DSP_PUB_ASSOC.' AS ddpa');
		$this->db->join(TAB_VIDEO_ADNETWORK.' AS dva', 'dva.id = ddpa.dsp_id', 'LEFT');
		$this->db->where(array('dva.vast_version' => $format,'dva.is_deleted' => 0, 'dva.status' => 1, 'ddpa.publisher_id' => $account_id));
		$result = $this->db->get();
		return $result->result_array();
		}
		else
		{
		return false;	
		}
	}

	function publisher_filter($account_id, $dsp)
	{
		$result = $this->db->select('GROUP_CONCAT(dsp_id) as dsp')->from(TAB_DSP_TAR_PUBLISHER)->where(array('account_id' => (INT)$account_id))->get();
		$target = $result->result_array();
		$target_array = array_filter(explode(',', $target[0]['dsp']));
		foreach($dsp as $key => $data)
		{
			if($data['publisher'] == 1 && !in_array($data['id'], $target_array))
			{
				unset($dsp[$key]);
			}
			if($data['publisher'] == 2 && in_array($data['id'], $target_array))
			{
				unset($dsp[$key]);
			}
		}
		return array_values($dsp);
	}

	function country_filter($country, $dsp)
	{
		$result = $this->db->select('GROUP_CONCAT(dsp_id) as dsp')->from(TAB_DSP_TAR_COUNTRY)->where(array('country_code' => $country))->get();
		$target = $result->result_array();
		$target_array = array_filter(explode(',', $target[0]['dsp']));
		foreach($dsp as $key => $data)
		{
			if($data['country'] == 1 && !in_array($data['id'], $target_array))
			{
				unset($dsp[$key]);
			}
			if($data['country'] == 2 && in_array($data['id'], $target_array))
			{
				unset($dsp[$key]);
			}
		}
		return array_values($dsp);
	}

	function get_ecpm($dsp, $country)
	{
		$sql = "SELECT id,ecpm FROM ".TAB_VIDEO_ADNETWORK." where id IN(".implode(',', $dsp).")";	// ECPM filter
		$ecpm_query = $this->db->query($sql);
		$ecpm_q_result= 	$ecpm_query->result_array();


		foreach($ecpm_q_result as $k=>$v)
		{
			$ecpm_array[] = $ecpm_q_result[$k]['ecpm'];
			$dsp_array[] = $ecpm_q_result[$k]['id'];
		}
						
		if(in_array(0, $ecpm_array))
		{
		
		$app_conf_query  ="SELECT  `config_value` FROM `djax_app_configurations` where 		  config_key='default_ecpm'";
		$app_config_query = $this->db->query($app_conf_query);
		$app_config_ecpm = 	$app_config_query->result_array();
		$app_config_ecpm_val = $app_config_ecpm[0]['config_value'];
		

			foreach($ecpm_array as $key => $ecpm)							// Country weight filter if ECPM is not exist
			{											
				if($ecpm == 0)
				{
					$result = $this->db->select('country_weight')->get_where(TAB_DSP_COUNTRY_WEIGHT, array('dsp_id' => $dsp_array[$key], 'country_code' => $country))->result_array();
					if(!empty($result))
					{
						$ecpm_array[$key] = $result[0]['country_weight'];
					}
					else
					{
						$ecpm_array[$key] = $app_config_ecpm_val;
					}
				}
			}
		}
		
		$array_zeros = array();
		$array_zeros = array_count_values($ecpm_array);

		if(isset($array_zeros[0]) && $array_zeros[0] == count($ecpm_array))			// All ECPM values are Zero
		{
			$array_key = array_rand($ecpm_array);
		}
		else if(array_count_values($ecpm_array)[max($ecpm_array)] > 1) 				//   
		{
			$high_array = array_keys($ecpm_array,max($ecpm_array),false);
			$random = array_rand($high_array);
			$array_key = $high_array[$random];
		}
		else
		{
			$array_key = array_search(max($ecpm_array), $ecpm_array);
		}
		return $dsp_array[$array_key].'-'.$ecpm_array[$array_key];
	}

	function get_dsp_data($dsp, $video_type)
	{
		$result = $this->db->select(array('va.vast_version', 'c.campaignid', 'b.bannerid'))->from(TAB_VIDEO_ADNETWORK.' AS va')->join(TAB_CAMPAIGNS.' AS c', 'c.exchange_id = va.id')->join(TAB_BANNERS.' AS b', 'b.exchange_id = va.id')->where(array('va.id' => $dsp, 'b.dj_banner_type' => $video_type))->get();
		//echo $this->db->last_query();exit;
		return $result->result_array();
		
	}
	
	function get_category($zone_id)
	{
		$SQL = "SELECT IFNULL(GROUP_CONCAT(sc.category_id),'All') as category_id FROM ".TAB_SITE_CAT_ASSOC." as sc JOIN ".TAB_SITE_ZONE_ASSOC." as sza ON sza.zone_id = ".$zone_id." AND sza.site_id = sc.site_id";
		$query = $this->db->query($SQL);
		if($query->num_rows()>0)
		{
		$result = $query->row_array();
		return $result;		
		}
		else
		{
	    return "All";	
		}	
			
		
	}	

	
}

