<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for publisher related activities
 * 
 * @package		Video
 * @subpackage	Vast Mediation
 * @category	Controller
 * @author		Hari
 * @link		http://www.djaxadserver.com
*/
// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Ads extends REST_Controller
{
	function __construct()
	{
		header('Access-Control-Allow-Origin: *');
		parent::__construct();
		$this->load->model('Do_ads');
	}

	function index_get()
	{
		
		$this->load->library('maxmind_geoip');   // Location info Library
		
		$zone_id = (int)$this->get('zone_id');
		$format = $this->get('format');
		
		if(isset($zone_id) && is_int($zone_id) && $zone_id > 0)		// check integer zone ID
		{
			$zone = $this->Do_ads->validate_zone($zone_id);	
			
			$zone_type = $zone[0]['dj_zone_type'];
			if(count($zone) === 1 && ($zone_type == 'V_A_OL' || $zone_type == 'V_A_IN' || $zone_type == 'M_A_OL' || $zone_type == 'M_A_IN'))	// Check valid zone ID
			{
				
				$ip  = @$_SERVER['REMOTE_ADDR'];
				//$ip  = '182.72.85.3';
				$location = $this->maxmind_geoip->getIP($ip);
				
				$request_id = $this->track_request($location, $zone);			// Track request
				
				$input['zone_id']= $zone_id;
				$input['width']  = (null !==$this->get('width') && $this->get('width') != '') ? $this->get('width') : 640;
				$input['height']  = (null !==$this->get('height') && $this->get('height') != '') ? $this->get('height') : 480;
				$input['yob']  = (null !==$this->get('yob') && $this->get('yob') != '') ? $this->get('yob') : 1960;
				$input['gender']  = (null !==$this->get('gender') && $this->get('gender') != '') ? $this->get('gender') : 'MALE';
				$input['vpi']  = (null !==$this->get('vpi') && $this->get('vpi') != '') ? $this->get('vpi') : '.MP4';

				$account_id = $zone[0]['account_id'];
				
				$get_cat = $this->Do_ads->get_category($zone_id); // Get Site Category Id
				
				$input['category_id'] = $get_cat['category_id']; // Site Category Id
				
				if(!empty($zone[0]['vd']))
				{
				$min_max_vid = explode("|",$zone[0]['vd']);
				$input['min_dur'] = $min_max_vid[0];
				$input['max_dur'] = $min_max_vid[1];	
				}
				else
				{
				$input['min_dur'] = "";
				$input['max_dur'] = "";	
				}		
				
							
		if($format=='vast2')
		{
			$version = 2;
			$vs = 2;
		}
		
		elseif($format=='vast3')
		{
			$version = 3;
			$vs = 3;
		}
		
		elseif($format=='vpaid2')
		{
			$version = 4;
			$vs = 2;
		}
		
		elseif($format=='vpaid3')
		{
			$version = 5;
			$vs = 3;
		}
		
		elseif($format=='vmap')
		{
			$version = 6;
			$vs = 1;
		}
		
				$dsp = $this->Do_ads->get_dsp($account_id,$version);		// linked DSPs
				//print_r($dsp);exit;
				$dsp = $this->Do_ads->publisher_filter($account_id, $dsp);	// Apply publisher filter
				
				$country = isset($location['country_code']) ? $location['country_code'] : '';
				$dsp = $this->Do_ads->country_filter($country, $dsp);		// Apply country filter
				// make request to all dsps
				$this->load->library('mcurl');								// mcurl library for parallel request
				
				$vars = array();
				$options = array(CURLOPT_SSL_VERIFYPEER => FALSE, CURLOPT_TIMEOUT_MS => 10000);	// set curl response time and other parameters here
				foreach($dsp as $network)
				{
					if($network['vast_version'] > 0)
					{
						$network['vast_version'] = $vs;
					}
					$vast_url = $this->dynamic_url($network, $location, $input);	// Macro replace
					$this->mcurl->add_call($network['id'], "get", $vast_url, $vars, $options);
				}
				$responses = $this->mcurl->execute();
				
				$flitered_dsp = array();
				foreach($responses as $dsp_id => $response)			// eliminate no ad and invalid responses
				{
					$res_low = strtolower($response['response']);
					/*if(!empty($response['response']))
					{
					$xml_data=new SimpleXMLElement($response['response'])or die("Error: Cannot create object");
					


    print_r($xml_data);

}
exit;	*/					//echo $dsp_id;exit;
//print_r($response);exit; 
//echo strpos(htmlentities($response['response']), 'Linear&gt;');die("entities");

					if($format=='vmap')
					{
						$search_val = '&lt;vmap:vmap';
					}
					else
					{
						$search_val = 'impression';
					}	
				//	echo htmlentities($res_low);exit;
					//echo "io";exit;
				
					if($response['error'] == '' && $response['response'] != '' && strpos(htmlentities($res_low),$search_val) !== false)	// Validate response and store dsp ID into filtered_dsp
					{
						if($format!='vmap')
						{
						if(($zone_type == 'V_A_IN' || $zone_type == 'M_A_IN') && strpos(htmlentities($response['response']), '&lt;Linear') !== false)  // Inline Filter
						{
							$flitered_dsp[] = $dsp_id;
	
						}
						else if(($zone_type == 'V_A_OL' || $zone_type == 'M_A_OL') && strpos(htmlentities($response['response']), '&lt;NonLinearAds') !== false) // Overlay Filter
						{
							$flitered_dsp[] = $dsp_id;
						}
						}
						else
						{
							
					$dom_t = new DOMDocument;
					$dom_t->preserveWhiteSpace = FALSE;
					$dom_t->loadXML($response['response']);
					$vmap_t = $dom_t->getElementsByTagName('VMAP');
					$j=1;
					foreach($vmap_t as $param_t)
					{
					$AdTagURI_t = $param_t->getElementsByTagName('AdTagURI');
					if($AdTagURI_t)
					{
					foreach($AdTagURI_t as $uri_t)
					{
					if(!empty($uri_t->textContent))
					{											
					if($j==1)
					{
					
					$vmap_first = file_get_contents($uri_t->textContent);

					if(($zone_type == 'V_A_IN' || $zone_type == 'M_A_IN'))
					{
						if(strpos(htmlentities($vmap_first), '&lt;Linear') !== false)
						{
						$flitered_dsp[] = $dsp_id;
						}					
							//	Inline wrapper ad
					}
					else
					{
						if(strpos(htmlentities($vmap_first), '&lt;NonLinearAds') !== false)
						{
						$flitered_dsp[] = $dsp_id;
						}
					
					}
				}
			}
		$j++;
		}
	}
}
							//echo "vpaid2";exit;
							
						}	
									
					}
				//	echo "ELSE";exit;
				}
				//print_r($flitered_dsp);die("---");
				if(is_array($flitered_dsp) && !empty($flitered_dsp))
				{
					
					$this->load->config('vast');
					$vast_path = $this->config->item('internal_xml_path');
					$final = $this->Do_ads->get_ecpm($flitered_dsp, $country);	// Apply ECPM and Country weight 
					//print_r($final); 
					$final_dsp = explode('-', $final)[0]; 
					$final_ecpm = explode('-', $final)[1]; 
					$xml = str_replace('UTF-8?', 'UTF-8', $responses[$final_dsp]['response']);      // For our ad tag
					if($format!='vmap')
					{
					if (strpos(htmlentities($xml), '&lt;Linear') !== false) 
					{
						$video_type = 'V_IN';
					}
					else
					{
						$video_type = 'V_OL';
					}
					} 
				
					if($format=='vmap')
					{
					if($zone_type == 'V_A_IN' || $zone_type == 'M_A_IN')
					{
						$video_type = 'V_IN';
					}
					else if($zone_type == 'V_A_OL' || $zone_type == 'M_A_OL')
					{
						$video_type = 'V_OL';
					}
											
					$dsp_data = $this->Do_ads->get_dsp_data($final_dsp, $video_type);
													
					$vast_wrapper = $xml;	
					$dom = new DOMDocument;
					$dom->preserveWhiteSpace = FALSE;
					$dom->loadXML($xml);
					$vmap = $dom->getElementsByTagName('VMAP');
					$i=1;
					foreach($vmap as $param)
					{
					$AdTagURI = $param->getElementsByTagName('AdTagURI');
					if($AdTagURI)
					{
					foreach($AdTagURI as $uri)
					{
					if(!empty($uri->textContent))
					{
					//$get_contents = file_get_contents($uri->textContent);
											
					if($i==1)
					{
					if($dsp_data[0]['vast_version'] > 0)
					{
						$dsp_data[0]['vast_version'] = 3;
					}				
				
					$vmap_1st = file_get_contents($uri->textContent);

					if($video_type == 'V_IN')
					{
						if(strpos(htmlentities($vmap_1st), '&lt;Linear') !== false)
						{
						$vast_wrapper_temp = $this->vast_wrapper_inline($zone, $uri->textContent, $dsp_data, $request_id, $final_ecpm);	
						}					
							//	Inline wrapper ad
					}
					else
					{
						if(strpos(htmlentities($vmap_1st), '&lt;NonLinearAds') !== false)
						{
						$vast_wrapper_temp = $this->vast_wrapper_overlay($zone, $uri->textContent, $dsp_data, $request_id, $final_ecpm);	//	Overlay wrapper ad
						}
					
					}
					
					if(!empty($vast_wrapper_temp))
					{					
					$file = round(microtime(true) * 1000).'.xml';	// Write XML in local file
					$file_obj = fopen($vast_path.$file, "w") or die("Unable to open file!");		
					fwrite($file_obj, $vast_wrapper_temp);
					fclose($file_obj);
					$xml_uri = base_url().$vast_path.$file; 
					$vast_wrapper = str_replace($uri->textContent,$xml_uri,$vast_wrapper); 	
					}
					else
					{
						$vast_wrapper ="";
					}		
					}
					}
					$i++;		
					}
					}
					}
					}
					else
					{				
					$dsp_data = $this->Do_ads->get_dsp_data($final_dsp, $video_type);
					
					if($dsp_data[0]['vast_version'] > 0)
					{
						$dsp_data[0]['vast_version'] = $vs;
					}				    
					$file = round(microtime(true) * 1000).'.xml';	// Write XML in local file
					$file_obj = fopen($vast_path.$file, "w") or die("Unable to open file!");		
					fwrite($file_obj, $xml);
					fclose($file_obj);
					$xml_uri = base_url().$vast_path.$file;
					if($video_type == 'V_IN')
					{
						$vast_wrapper = $this->vast_wrapper_inline($zone, $xml_uri, $dsp_data, $request_id, $final_ecpm);	//	Inline wrapper ad
					}
					else
					{
						$vast_wrapper = $this->vast_wrapper_overlay($zone, $xml_uri, $dsp_data, $request_id, $final_ecpm);	//	Overlay wrapper ad
					}
				}
				}
				else
				{
					// No video adnetwork response 
					$vast_wrapper = '';
					if($zone[0]['dj_passback_tag'] != '')
					$vast_wrapper = file_get_contents($zone[0]['dj_passback_tag']);	// passBack tag
				}
				$vast_wrapper = ($vast_wrapper != '') ? $vast_wrapper : '<?xml version="1.0" encoding="UTF-8"?><VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="vast.xsd" version="2.0"/>';
				//echo $vast_wrapper;exit;
				$this->output->set_content_type('application/xml', 'UTF-8');
				$this->output->set_output($vast_wrapper);
			}
			else
			{
				$error = array(
                        'response' => 'error',
                        'msg' => 'Zone ID is blocked / not exist'
                    );
            	$this->response($error);
			}
		}
		else
		{
			$error = array(
                        'response' => 'error',
                        'msg' => 'Invalid Zone ID'
                    );
            $this->response($error);
		}
	}

	function track_request($location, $zone)
	{
		$this->load->library('wurfl');
		$device = $this->wurfl->getDevice();
		$request = array();
		$viewer  = array(); 
		$request['date_time'] = date('Y-m-d H:i:s');
		$request['zone_id'] = $this->get('zone_id');
		$request['bidding_price'] = $zone[0]['dj_floor_price'];
		$request['user_agent'] = $device['user_agent'];
		$request['browser_version'] = $device['browser_version'];
		$request['browser_name'] = $device['browser'];
		$request['domain'] = $_SERVER['SERVER_NAME'];
		$request['site_url'] = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
		$request['country_code'] = isset($location['country_code']) ? $location['country_code'] : '';
		$request['user_latitude'] = isset($location['latitude']) ? $location['latitude'] : '';
		$request['user_longitude'] = isset($location['longitude']) ? $location['longitude'] : '';

		if(isset($_COOKIE['viewer_id']) && $_COOKIE['viewer_id'] != '') // Track request only
		{
			$request['viewer_id'] = $_COOKIE['viewer_id'];
		}
		else   				// Add viewer and track request
		{
			$viewer['viewer_id'] = '__'.substr(md5($_SERVER['REMOTE_ADDR'].mt_rand()), 0, 32);
			if($device['type'] == 'desktop'){
				$viewer['device_type'] = 'Display';
			}elseif($device['type'] == 'mobile'){
				$viewer['device_type'] = 'Mobile';
			}else{
				$viewer['device_type'] = 'Tablet';
			} 
			$viewer['ip_address'] = $location['ip_address'];
			$viewer['language'] = 'en-US';
			$viewer['country'] = $location['country_code'];
			$viewer['latitude'] = $location['latitude'];
			$viewer['longitude'] = $location['longitude'];
			$viewer['os'] = $device['os'];
			$viewer['os_version'] = isset($device['os_version']) ? $device['os_version'] : '';

			$request['viewer_id'] = $viewer['viewer_id'];
			setcookie('viewer_id', $viewer['viewer_id']);
		}
		return $this->Do_ads->track_request($viewer, $request);
	}

	function dynamic_url($dsp, $location, $input)
	{
		$url = $dsp['vast_mediation_url'];
		$this->load->library('wurfl');
		$device = $this->wurfl->getDevice();
		$url = @str_replace('${EX_ZONEID}', urlencode($input['zone_id']), $url);	// Zone Id macro					
		$url = @str_replace('${VAST_VERSION}', urlencode($dsp['vast_version']), $url);	// VAST version macro
		$url = @str_replace('${EX_VIDEO_LENGTH}', urlencode($dsp['video_length']), $url);	// Video length macro
		$url = @str_replace('${EX_INV_REFERER}', urlencode(isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : ''), $url); // Video display URL macro
		$url = @str_replace('${EX_DEV_OS}', urlencode($device['os']), $url);	// Device OS macro
		$url = @str_replace('${EX_DEV_OSV}', urlencode($device['os_version']), $url);	// Device OS Version macro
		$url = @str_replace('${EX_DEV_IP}', urlencode($location['ip_address']), $url);	// IP Address macro
		$url = @str_replace('${EX_DEV_UA}', urlencode($device['browser']), $url);	// User agent macro
		$url = @str_replace('${EX_DEV_MAKE}', urlencode($device['manufacturer']), $url);	// Device Manufacturer macro
		$url = @str_replace('${EX_DEV_MODEL}', urlencode($device['model']), $url);	// Device model macro
		$url = @str_replace('${EX_LOC_LAT}', urlencode($location['latitude']), $url);	// Latitude macro
		$url = @str_replace('${EX_LOC_LONG}', urlencode($location['longitude']), $url);	// Longitude macro
		$url = @str_replace('${EX_CB}', urlencode(substr(md5(uniqid(time(), true)), 0, 10)), $url);	// Cache buster macro
		$url = @str_replace('${EX_ADSPACE_WIDTH}', urlencode($input['width']), $url);	// Adblock width macro
		$url = @str_replace('${EX_ADSPACE_HEIGHT}', urlencode($input['height']), $url);	// Adblock height macro
		$url = @str_replace('${EX_USER_YOB}', urlencode($input['yob']), $url);	// Year Of Birth macro
		$url = @str_replace('${EX_USER_GENDER}', urlencode($input['gender']), $url);	// User Gender macro
		$url = @str_replace('${EX_VPI}', urlencode($input['vpi']), $url);	// VPI macro
		$url = @str_replace('${EX_SITE_CATEGORY_ID}', urlencode($input['category_id']), $url);	// Site Cat macro
		$url = @str_replace('${EX_MIN_VIDEO_LENGTH}', urlencode($input['min_dur']), $url);	// Video Min Duration macro
		$url = @str_replace('${EX_MAX_VIDEO_LENGTH}', urlencode($input['max_dur']), $url);	// Video Max Duration macro	
		//echo $url; exit;
		return $url;
	}

	function vast_wrapper_inline($zone, $xml_uri, $dsp_data, $request_id, $final_ecpm)
	{
		
		$wrapper = 	'<VAST version="'.$dsp_data[0]['vast_version'].'.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="vast.xsd">';
		$wrapper .= '<Ad id="preroll:0.0-0" ><Wrapper><AdSystem><![CDATA[Revive Adserver]]></AdSystem><AdTitle><![CDATA[wrapperad]]></AdTitle><Impression><![CDATA['.base_url().'ads/www/delivery/lg.php?bannerid='.$dsp_data[0]['bannerid'].'&campaignid='.$dsp_data[0]['campaignid'].'&zoneid='.$zone[0]['zoneid'].'&cb='.mt_rand().'&request_id='.$request_id.'&ecpm='.base64_encode($final_ecpm).']]></Impression><VASTAdTagURI><![CDATA['.$xml_uri.']]></VASTAdTagURI><Creatives><Creative><Linear><Duration></Duration>';
		$wrapper .= '<TrackingEvents>
				      <Tracking event="start"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=start]]></Tracking>
				      <Tracking event="firstQuartile"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=firstquartile]]></Tracking>
				      <Tracking event="midpoint"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=midpoint]]></Tracking>
				      <Tracking event="thirdQuartile"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=thirdquartile]]></Tracking>
				      <Tracking event="complete"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=complete]]></Tracking>
				      <Tracking event="pause"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=pause]]></Tracking>
				      <Tracking event="mute"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=mute]]></Tracking>
				      <Tracking event="fullscreen"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=fullscreen]]></Tracking>
				      <Tracking event="unmute"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=unmute]]></Tracking>
				      <Tracking event="creativeView"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=creativeView]]></Tracking>
				      <Tracking event="acceptInvitation"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=acceptInvitation]]></Tracking>	
				      <Tracking event="rewind"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=rewind]]></Tracking>
                   	  <Tracking event="resume"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=resume]]> </Tracking>	
                   	  <Tracking event="exitfullscreen"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=exitfullscreen]]> </Tracking>	
                   	  <Tracking event="acceptInvitationLinear"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=acceptInvitationLinear]]> </Tracking>
                   	  <Tracking event="closeLinear"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=closeLinear]]> </Tracking>
                   	  <Tracking event="progress"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=progress]]> </Tracking>
                   	  <Tracking event="skip"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=skip]]> </Tracking>
				    </TrackingEvents>';	
		$wrapper .= '<VideoClicks>
		                <ClickTracking>
		                    <![CDATA['.base_url().'ads/www/delivery/ck.php?oaparams=2__bannerid='.$dsp_data[0]['bannerid'].'__zoneid='.$zone[0]['zoneid'].'__cb='.mt_rand().'__oadest=]]>
		                </ClickTracking>
		            </VideoClicks>';		    	    
		$wrapper .=	'</Linear></Creative></Creatives></Wrapper></Ad>';
		$wrapper .= '</VAST>';
	
		return $wrapper;
	}

	function vast_wrapper_overlay($zone, $xml_uri, $dsp_data, $request_id, $final_ecpm)
	{
		$wrapper = 	'<VAST version="'.$dsp_data[0]['vast_version'].'.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="vast.xsd">';
		$wrapper .= '<Ad id="overlay:0.0-0" ><Wrapper><AdSystem><![CDATA[Revive Adserver]]></AdSystem><AdTitle><![CDATA[wrapperad]]></AdTitle><Impression><![CDATA['.base_url().'ads/www/delivery/lg.php?bannerid='.$dsp_data[0]['bannerid'].'&campaignid='.$dsp_data[0]['campaignid'].'&zoneid='.$zone[0]['zoneid'].'&cb='.mt_rand().'&request_id='.$request_id.'&ecpm='.base64_encode($final_ecpm).']]></Impression><VASTAdTagURI><![CDATA['.$xml_uri.']]></VASTAdTagURI><Creatives><Creative><NonLinearAds>';
		$wrapper .= '<TrackingEvents>
				      <Tracking event="expand"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=expand]]></Tracking>
				      <Tracking event="collapse"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=collapse]]></Tracking>
				      <Tracking event="close"><![CDATA['.base_url().'ads/www/delivery/fc.php?script=videoAds:vastEvent&bannerid='.$dsp_data[0]['bannerid'].'&zoneid='.$zone[0]['zoneid'].'&request_id='.$request_id.'&event=close]]></Tracking>
				    </TrackingEvents>';	
		$wrapper .= '<NonLinear id="overlay">
		                <NonLinearClickThrough>
		                    <![CDATA['.base_url().'ads/www/delivery/ck.php?oaparams=2__bannerid='.$dsp_data[0]['bannerid'].'__zoneid='.$zone[0]['zoneid'].'__cb='.mt_rand().'__oadest=]]>
		                </NonLinearClickThrough>
		            </NonLinear>';		    	    
		$wrapper .=	'</NonLinearAds></Creative></Creatives></Wrapper></Ad>';
		$wrapper .= '</VAST>';
		return $wrapper;
	}
	
	
}
