<?php 

class User_login extends CI_Controller {

	

	function __construct()

	{

		parent::__construct();

       

	   # $this->no_cache();

	   

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!



		$this->load->library('rest');



		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

		

	}

	

	

	/*

	 * 

	 * name		:index

	 * @param   :Null

	 * @return  :Login page

	 */	

	 

	 

	function index()

	{

		$this->admin();	

	}

	

	/*

	 * 

	 * name		:admin

	 * @param   :Null

	 * @return  :Login on success

	 */	

	

	

	function admin()

	{
		
		$data['page_title'] 	= $this->lang->line('admin_login');		

		$data['breadcrumb'] 	= 	'';

		$data['acc_type'] 		= 	'ADMIN';	

		$data['content'] 		= 	$this->load->view('user_login/loginPg',$data,TRUE);

		$this->template->set_theme('materialpro');
		$this->template->set_layout('user_login_layout');
		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:manager

	 * @param   :Null

	 * @return  :Login on success

	 */	

	

	

	function manager()

	{

		 $data['page_title'] = $this->lang->line('manager_login');
        $data['breadcrumb'] = '';
        $data['acc_type']   = 'MANAGER';
        $data['content']    = $this->load->view('user_login/loginPg', $data, TRUE);
        $this->template->set_theme('materialpro');
		$this->template->set_layout('user_login_layout');
        $this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:advertiser

	 * @param   :Null

	 * @return  :Login on success

	 */	

	

	

	function advertiser()

	{

		$data['page_title'] 	= $this->lang->line('manager_login');		

		$data['breadcrumb'] 	= 	'';

		$data['acc_type'] 		= 	'ADVERTISER';	

		$data['content'] 		= 	$this->load->view('user_login/loginPg',$data,TRUE);

		$this->template->set_theme('materialpro');
		$this->template->set_layout('user_login_layout');
		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:advertiser

	 * @param   :Null

	 * @return  :Login on success

	 */	

	

	

	function publisher()

	{

		$data['page_title'] 	= $this->lang->line('publisher_login');		

		$data['breadcrumb'] 	= 	'';

		$data['acc_type'] 		= 	'TRAFFICKER';		

		$data['content'] 		= 	$this->load->view('user_login/loginPg',$data,TRUE);

		$this->template->set_theme('materialpro');
		$this->template->set_layout('user_login_layout');

		$this->template->build('view', $data);

		

	}

	

	protected function no_cache(){

		header('Cache-Control: no-store, no-cache, must-revalidate');

		header('Cache-Control: post-check=0, pre-check=0',false);

		header('Pragma: no-cache'); 

	}

	

	

	/*

	 * 

	 * name		:forget_password

	 * @param   :Null

	 * @return  :Forget Password page

	 */	

	 

	

	function forget_password($acc_type = FALSE)

	{
       
		if(!empty($acc_type))

		{

			$data['page_title'] = $this->lang->line('forgot_password');		

			$data['breadcrumb'] = '';

			$data['acc_type']	= strtoupper($acc_type);

				

			$data['content'] = $this->load->view('user_login/forget_password',$data,TRUE);

			$this->template->set_layout('user_login_layout');

			$this->template->build('view', $data);

		}else{

			redirect('user_login/forget_password');	

		}

	}	

	

	function logout($acc_type = FALSE)

	{	

		// $hello = $this->rest->post('api/v1/user/logout_info',array('api_key'=>get_session('api_key'),'account_id'=>get_session('account_id')),'json');
		
		$session	  =	$this->session->all_userdata();

		$agen = $this->config->item('agen');
		$agency_id = get_session('agencyid');
		$account_type = get_session('account_type');

		

		if($session)

		{

			$this->session->unset_userdata($session);

		}		

		$this->session->sess_destroy();

		//clearstatcache();

		//$this->no_cache();

		if(strtoupper($acc_type)==='ADMIN'){

			redirect('user_login/'.$acc_type.'/'.$agency_id);

		}

		else

		{

			redirect('user_login/'.$acc_type.'/'.$agency_id);

		}

	}	

	

	function link_banners($zone_id=FALSE){

	

		if($zone_id){

		$SQL = "SELECT 

						oxb.bannerid,

						oxb.description,

						oxb.width,

						oxb.height,

						oxb.dj_banner_type,

						oxc.campaignid,

						oxc.campaignname,

						oxcl.clientid,

						oxcl.clientname,

						dj_is_default as HouseAds 

					FROM `ox_ad_zone_assoc` as t 

						JOIN ox_banners as oxb ON oxb.bannerid= t.ad_id

						JOIN ox_campaigns as oxc ON oxc.campaignid= oxb.campaignid

						JOIN ox_clients as oxcl ON oxcl.clientid= oxc.clientid

					WHERE t.zone_id={$zone_id}";

		$query = $this->db->query($SQL);

		

		if($query->num_rows() > 0){

			$t = $query->result_array();

			//print_r($t);

			$data['page_title'] = "Linked Banners";		

			$data['breadcrumb'] = '';

			$data['banners'] = $t;

			$data['content'] = $this->load->view('user_login/banners',$data,TRUE);

			

			echo $data['content'];

		}



		}

	}

	

	function view_child_banners($banner_id=FALSE){

	

		if($banner_id){

		$SQL = "SELECT `banner_id`,`file_path`,`width`,`height`,`content_type`,`display_type`FROM `djax_additional_banners` WHERE `banner_id`={$banner_id}";

		$query = $this->db->query($SQL);

		

		if($query->num_rows() > 0){

			$t = $query->result_array();

			//print_r($t);

			$data['page_title'] = " View Banners";		

			$data['breadcrumb'] = '';

			$data['banners'] = $t;

			$data['content'] = $this->load->view('user_login/vbanners',$data,TRUE);

			

			echo $data['content'];

		}



		}

	}
 function demo_viewers()
    {
        $SQL    = "SELECT * FROM djax_login_info";
        $query  = $this->db->query($SQL);
        $result = array();
        if ($query->num_rows() > 0)
        {
            $result = $query->result_array();
        }
        $data['page_title'] = " View Banners";
        $data['breadcrumb'] = '';
        $data['login_list'] = $result;
        $data['content']    = $this->load->view('user_login/view_logins', $data, TRUE);
        echo $data['content'];
    }
















}
