<?php 
class Web_ad_blocks extends CI_Controller {
	
	public $source_sel = '';
	
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('pdf');
	}
	
	function index($site_id=FALSE)
	{
		$this->web_ad_blocks($site_id);		
	}
	
	
	
	
	
	/*
	 * 
	 * name		:Web ad_blocks
	 * @param   :Null
	 * @return  :List all the Web adblocks for a particular
	 * 			 Publisher
	 */	
	
	public function web_ad_blocks($site_id=FALSE)
	{		
		$data['page_title'] = $this->lang->line('Ad blocks');	
		$data['pub_link'] =$this->default_configurations->get('linking_type');
		$data['breadcrumb'] = '';
		$data['site_id']	= $site_id;	
		$api_key = get_session('api_key');
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['sites']=$this->rest->get('api/v1/site/fetch/',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('adblocks/web_ad_blocks',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name: fetch_adblocks_get
	 * @param :
	 * @return : Array
	 * 
	 * Returns a sets off matched zones
	 */
	 
	public function link_ads($zone_id = FALSE)
	{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');

			$pub_id = $this->rest->get('api/v1/web_adblock/fetch_pub',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 	
				
			   if($acc_id == $pub_id)
			   {
				 /*end */												
					if(!$zone_id || !is_numeric($zone_id))
					{
						$this->web_ad_blocks();
					}
					else
					{
						$data['page_title'] 	= 	$this->lang->line('zone_ban_link');
						$data['breadcrumb']		= 	'';
						$data['zone_id']		=	$zone_id;
						
						$data['zone_data'] 		= 	$this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php');
						
						//print_r($data['zone_data']);
						//die();									
						// GET DEFAULT PERIOD FROM CONFIG FILE
						$data['content'] 		=	$this->load->view('adblocks/link_ads',$data,TRUE);
						$this->template->set_layout('publisher_layout');
						$this->template->build('view', $data);
					}
			/* added by karthika on dec-12 */
			}else{
			redirect( site_url('publisher/web_ad_blocks'), "refresh");				
			}
			/* end */	
				
	}
	
	/*
	 * 
	 * name		:add_web_adblocks
	 * @param   :Null
	 * @return  :Adds the website
	 * 			 
	 */	
	
	public function add_web_adblock()
	{
		$api_key=get_session('api_key');
		$data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
		$siteid = get_session('site_id');
		$data['sites']=$this->rest->get('api/v1/site/fetch',array('api_key'=>$api_key,'siteid'=>$siteid,'zone'=>1),'php');		
		$data['zone_sizes']=$this->rest->get('api/v1/web_adblock/zonesizelist',array('api_key'=>$api_key),'php');
        echo $this->load->view('adblocks/modal_adblocks/content/add_web_adblock',$data);
	}
	
	/*
	 * Edit the adblock
	 * 
	 * name		:edit_web_adblock
	 * @param   :Zone id
	 * @return  :Fetches the ad block content and view it
	 * 
	 * 			 
	 */
	
	public function edit_web_adblock($zone_id = FALSE)
	{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');

			$pub_id = $this->rest->get('api/v1/web_adblock/fetch_pub',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 	
				
			   if($acc_id == $pub_id)
			   {
				 /*end */										
				#$account_id=get_session('account_id');
				$api_key=get_session('api_key');
				$data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
				$data['sites']=$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
				$data['zone_sizes']=$this->rest->get('api/v1/web_adblock/zonesizelist',array("api_key"=>$api_key),'php');
				$web_adblock = $this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
				
				//$web_adblock = json_decode($web_adblock);
				
				
				
				//$data['web_adblock'] = (array)$web_adblock[0];
				
				$data['web_adblock'] = $web_adblock[0];
				
				//$this->rest->debug();
				
				
				
				echo $this->load->view('adblocks/modal_adblocks/content/edit_web_adblock',$data);
			/* added by karthika on dec-12 */
		}else{
		redirect( site_url('publisher/web_ad_blocks'), "refresh");				
		}
		/* end */	
	}
	
	
	
	
		/*
	 * Add OpenRTB Objects
	 * 
	 * name		:edit_web_adblock
	 * @param   :Zone id
	 * @return  :Adds the RTB Objects to the Zone
	 * 
	 * 			 
	 */
	
	public function add_rtb_object($zone_id = FALSE)
	{
		 $acc_id = get_session('account_id');

	 $pub_id = $this->rest->get('api/v1/web_adblock/fetch_pub',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 	
				if($acc_id == $pub_id)
			   {
				 /*end */										
				#$account_id=get_session('account_id');
				$api_key=get_session('api_key');
				//$data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
				//$data['sites']=$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
				$data['zone_sizes']='' ;//$this->rest->get('api/v1/web_adblock/zonesizelist',array("api_key"=>$api_key),'php');
				$web_adblock = $this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
				
				$data['web_adblock'] = $web_adblock[0];
				
				//$this->rest->debug();
				 
				
				
				//echo $this->load->view('adblocks/modal_adblocks/content/edit_web_adblock',$data);
			/* added by karthika on dec-12 */
		}else{
		redirect( site_url('publisher/web_ad_blocks'), "refresh");				
		}
		/* end */	
	}
	
	
	/*
	 * Lists the Web ad blocks
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblocks($site_id=FALSE)
	{
		$api_key = get_session('api_key');
		
		$siteid = get_session('site_id');
		
		$adblocks		= $this->rest->get('api/v1/web_adblock/fetch/'.$site_id,array("api_key"=>$api_key,"siteid"=>$siteid),'json');		
		echo convert_to_datatable_format($adblocks);
	}
	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: download ad tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */
	
	public function download_adcode($zone_id=FALSE,$zone_type= FALSE,$rand1= FALSE,$rand2= FALSE,$height= FALSE,$width= FALSE,$loc=FLASE)
	{
		
           $data['zoneid'] = $zone_id;
           $data['zonetype'] = $zone_type;
           if($zone_type=="iframe"){
			$data['rand1'] = $rand1; 
			$data['rand2'] = $rand2; 
			$data['height'] = $height; 
			$data['width'] = $width;   
			$data['loc'] = $loc;   
			}
			if($zone_type=="image"){
			$data['uniqueid'] = $rand1;   
			}
          //  $this->load->view('publisher/adblocks/download_adcode',$data);

			$pdf_name = 'Your_adcode';
			$this->pdf->load_view('publisher/adblocks/download_adcode',$data);
			$this->pdf->render();
			$this->pdf->stream("$pdf_name.pdf");
			
		}
		
		public function download_adcode_video($datas=FALSE)
	{
		$data['source']=$_POST['datas'];
         $pdf_name = 'Your_adcode';
			$this->pdf->load_view('publisher/adblocks/download_adcode_video',$data);
			$this->pdf->render();
			$this->pdf->stream("$pdf_name.pdf");
			
		}
		
		public function mail_adcode($zone_id=FALSE,$zone_type= FALSE,$rand1= FALSE,$rand2= FALSE,$height= FALSE,$width= FALSE,$loc=FLASE)
	{
	
		
		$api_key=get_session('api_key');
			
	$data['mail_details'] = $this->rest->get('api/v1/publisher/fetch_admail',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');

		$data['zoneid'] = $zone_id;
		$data['zonetype'] = $zone_type;
           if($zone_type=="iframe"){
			$data['rand1'] = $rand1; 
			$data['rand2'] = $rand2; 
			$data['height'] = $height; 
			$data['width'] = $width;   
			$data['loc'] = $loc;   
			}
			if($zone_type=="image"){
			$data['uniqueid'] = $rand1;   
			}
		
        $mail_content=array(
				"subject" 		=> "Ad Code",
				"to_name" 		=> $data['mail_details'][0]['name'],				
				"from_name"		=> $data['mail_details'][0]['manager_name'],
				"custom_content" =>$data,
				"custom_url" => base_url());
		//print_r($mail_content);
		//	die();
	send_mail("AD_MAIL",$data['mail_details'][0]['from_mail'],$data['mail_details'][0]['to_mail'],$mail_content);
		
		
		}	
	
	
public function mail_adcode_video()
	{
		$zone_id=$_POST['zoneid'];
	$api_key=get_session('api_key');
			
	$data['mail_details'] = $this->rest->get('api/v1/publisher/fetch_admail',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');

		$data['contents_mail'] = $_POST['datas'];
		
		
        $mail_content=array(
				"subject" 		=> "Ad Code",
				"to_name" 		=> $data['mail_details'][0]['name'],				
				"from_name"		=> $data['mail_details'][0]['manager_name'],
				"custom_content" =>$data,
				"custom_url" => base_url());
		//print_r($mail_content);
		//	die();
	send_mail("AD_MAIL_VIDEO",$data['mail_details'][0]['from_mail'],$data['mail_details'][0]['to_mail'],$mail_content);
		
		
		}	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_ad_tag($zone_id = FALSE)
	{
		if($zone_id)
		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');

			$pub_id = $this->rest->get('api/v1/web_adblock/fetch_pub',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 	
				
			   if($acc_id == $pub_id)
			   {
				 /*end */								
				 			
				$data['zone_id'] = $zone_id;
				
				$api_key=get_session('api_key');
				$data['zone_det'] = $this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
				//If Post values are given
				$data['zone_sizes']=$this->rest->get('api/v1/web_adblock/zonesizelist',array('api_key'=>$api_key),'php');
				if($this->input->post() !='')
				{
					$data['source_sel'] = $this->input->post('source');	
				}else{
					$data['source_sel'] = '';	
				}
				
				echo $this->load->view('adblocks/modal_adblocks/content/generate_adtag',$data);
			}else{
				return FALSE;	
			}	
			/* added by karthika on dec-12 */
		}else{
		redirect( site_url('publisher/web_ad_blocks'), "refresh");				
		}
		/* end */	
	}
	
	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_img_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_ad_img_tag($zone_id = FALSE)
	{
		if($zone_id)
		{
			$data['zone_id'] = $zone_id;
			
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}
			
			echo $this->load->view('adblocks/modal_adblocks/content/generate_img_adtag',$data);
		}else{
			return FALSE;	
		}	
	}
	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_video_ad_tag($zone_id = FALSE)
	{
		if($zone_id)
		{
			
			$data['zone_id'] = $zone_id;
			
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}
			
			echo $this->load->view('adblocks/modal_adblocks/content/generate_video_adtag',$data);
		}else{
			return FALSE;	
		}	
	}
	
	
	
}
