<?php 
class Sites extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->sites();		
	}
	
	/*
	 * 
	 * name		:sites
	 * @param   :Null
	 * @return  :List all the sites for a particular
	 * 			 Publisher
	 */	
	 	
	public function sites()
	{	
		$data['page_title'] = $this->lang->line('sites');		
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('sites/sites',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		:add_website
	 * @param   :Null
	 * @return  :Adds the website
	 * 			 
	 */	
	
	public function add_website()
	{
		$api_key = get_session('api_key');
		
		$category =$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');

		$agency_id=get_session('agencyid')?get_session('agencyid'):get_session('agency_id');

		$dsp_det =$this->rest->get('api/v1/utilities/dspdetails',array("api_key"=>$api_key,"agency"=>$agency_id),'php');

		$data['dsp'] = $dsp_det;
		
		if($data['dsp']!='')
		{
			
			array_push($data['dsp'],array("exchange_name" => "All DSP's","exchange_id"=>"all"));
		}
		//~ print_r($data['dsp']);exit;
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
	
		echo $this->load->view('sites/modal_sites/content/add_website',$data);
	}
	
	public function edit_website($site_id = FALSE)
	{
		$api_key = get_session('api_key');
				
		$site_info = $this->rest->get('api/v1/site/fetch_site',array('site_id'=>$site_id, "api_key"=>$api_key),'php');
		//print_r($site_info);exit;
		$sel_category_id = $this->rest->get('api/v1/site/fetch_site_cat',array('site_id'=>$site_id, "api_key"=>$api_key), 'json');

		$sel_block_category_id = $this->rest->get('api/v1/site/fetch_site_block_cat', array('site_id' => $site_id, "api_key" => $api_key), 'json');
		
         
		// $dsp_sel =$this->rest->get('api/v1/rtb/fetch_dspdetails',array('site_id'=>$site_id, "api_key"=>$api_key),'json');
	    
	   $dsp_sel =$this->rest->get('api/v1/rtb/fetch_dspdetails',array('site_id'=>$site_id, 'agency_id'=>$agency_id,"api_key"=>$api_key),'json');

	   $dsp_sel1=json_decode($dsp_sel);


	 
	   foreach($dsp_sel1 as $value)
	   {
		 
		   $data['dsp_select'] = explode(',',$value);
	   }
	  
	    
	   
		
	   
        $dsp_details=$this->rest->get('api/v1/utilities/dspdetails',array("api_key"=>$api_key),'php');
		$data['dsp_details'] = $dsp_details;
		
		if($data['dsp_details']!='')
		{
			
			array_push($data['dsp_details'],array("exchange_name" => "All DSP's","exchange_id"=>"all"));
		}
		
		
		//print_r( $data['dsp_select']);exit;
		$category=$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
		
		if(!empty($sel_category_id))
		{  
		  $data['sel_category'] = json_decode($sel_category_id);
			
		}else{
			$data['sel_category'] = '';
		}


		if (!empty($sel_block_category_id)) {
			$data['sel_block_category'] = json_decode($sel_block_category_id);

		} else {
			$data['sel_block_category'] = '';
		}
		
		
		$data['site_info'] = $site_info[0];
		
		echo $this->load->view('sites/modal_sites/content/edit_website',$data);
	}
	
	
	public function fetch_sites()
	{
		#$account_id = get_session('account_id');
		
		$api_key = get_session('api_key'); 
		
		$sites		= $this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'json');
		
		echo convert_to_datatable_format($sites);
	}
	
}
