<?php 
class Settings extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->personal_information();		
	}
	
	/*
	 * 
	 * name		:personal_information
	 * @param   :Null
	 * @return  :List personal_information for a particular
	 * 			 Publisher
	 */	
	
	public function personal_information()
	{	
		$data['page_title'] = $this->lang->line('personal_information');	
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');
		$personal_info=$this->rest->get('api/v1/publisher/user_information',array("api_key"=>$api_key),'php');	
		$data['personal_info']=$personal_info[0];	
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>$api_key),'php');			
		$data['content'] = $this->load->view('settings/personal_information',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:company_information
	 * @param   :Null
	 * @return  :List company_information for a particular
	 * 			 Publisher
	 */	
	
	public function company_information()
	{	
		$data['page_title'] = $this->lang->line('company_info');
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');	
		$company_info=$this->rest->get('api/v1/publisher/user_information',array("api_key"=>$api_key),'php');	
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>$api_key),'php');			
		$data['content'] = $this->load->view('settings/company_information',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:billing_information
	 * @param   :Null
	 * @return  :List billing_information for a particular
	 * 			 Publisher
	 */	
	
	public function billing_information()
	{		
		$data['page_title'] = $this->lang->line('billing_information');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/billing_information',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
		
	/*
	 * 
	 * name		:payment_settings
	 * @param   :Null
	 * @return  :List payment_settings for a particular
	 * 			 Publisher
	 */	
	
	public function payment_settings()
	{	
	    
		$data['page_title'] = $this->lang->line('payment_settings');	
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');	
		$payment_info=$this->rest->get('api/v1/network/fetch_payment_info',array("api_key"=>$api_key),'php');
		$paypal_info=$this->rest->get('api/v1/network/fetch_paypal_info',array("api_key"=>$api_key),'php');	
		$data['payment_details']=$payment_info[0];
		$data['paypal']=	$paypal_info[0];
		$data['content'] = $this->load->view('settings/payment_settings',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:email_preferences
	 * @param   :Null
	 * @return  :List email_preferences for a particular
	 * 			 Publisher
	 */	
	
	public function email_preferences()
	{		
		$data['page_title'] = $this->lang->line('email_preferences');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/email_preferences',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:referal_programs
	 * @param   :Null
	 * @return  :referal_programs for a particular
	 * 			 Publisher
	 */	
	
	public function referal_programs()
	{	
	
		$data['page_title'] = $this->lang->line('referal_program');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/referal_programs',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: account_settings
	 * @param   : Null
	 * @return  : account_settings for a particular
	 * 			 Publisher
	 */	
	
	public function account_settings()
	{		
		$data['page_title'] = $this->lang->line('account_settings');	
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');
		$account_info=$this->rest->get('api/v1/publisher/user_information',array("api_key"=>$api_key),'php');	
		$data['account_info']=$account_info[0];	
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array("api_key"=>$api_key),'php');			
		$data['content'] = $this->load->view('settings/account_settings',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
}
