<?php 
class Reports extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->config('report_configurations');
	}
	
	function index()
	{
		$this->overview();		
	}
	
	
		/*
	 * 
	 * name		:overview
	 * @param   :Null
	 * @return  :List all the statistics for a particular
	 * 			 Publisher
	 */	
		
	public function overview()
	{
		$data['page_title'] = $this->lang->line('overview_report');
		$data['breadcrumb'] = '';
		
		// GET ALL SITES FOR PUBLISHER
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>get_session('api_key')),'php');
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/overview',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_stats($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	    = get_session('api_key');
		$page			= 'REPORT_OVERVIEW';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		$input['result_type'] 	= 'DATA';			  
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
    
	}
	
	/*
	 * 
	 * name		:geographic
	 * @param   :Null
	 * @return  :List all the geo map for a particular
	 * 			 Publisher
	 */	
	
		
	public function geographic()
	{
		$data['page_title'] = $this->lang->line('geographic_report');

		$data['breadcrumb'] = '';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key=get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);	
		$data['content'] = $this->load->view('reports/geographic',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	public function fetch_country_stat($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_GEO_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'COUNTRY'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
				if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
	    $input['language'] = $this->config->item('language');
		echo $data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
	}
	
	/*
	 * 
	 * name		:sites
	 * @param   :Null
	 * @return  :List all the sites & Statistics for a particular
	 * 			 Publisher
	 */	
	 	
	public function sites()
	{
		$data['page_title'] = $this->lang->line('sites_report');
		$data['breadcrumb'] = '';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key=get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');
		
		
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_SITE']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/sites',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_site_stats($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_SITE';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
	   
	    if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
	    $input['result_type'] 	= 'DATA';
	    $input['language'] = $this->config->item('language');
	    $input['exchangeval'] = $this->config->item('exchangeRate');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	
	/*
	 * 
	 * name		:adblocks
	 * @param   :Null
	 * @return  :List all the  Addblocks & Statistics for a particular
	 * 			 Publisher
	 */	
	 	
	public function adblocks($site_id=FALSE)
	{
		$data['page_title'] = $this->lang->line('ad_block_report');
		$data['breadcrumb'] = '';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key=get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites/'.$site_id,array("api_key"=>$api_key),'php');
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['site_id'] = $site_id;
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/adblocks',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblock_stats($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_ADBLOCK';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		
		
		$input['result_type'] 	= 'DATA';
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		//echo $this->rest->debug();  exit; 
		
		echo $data;
	}
	
	 	public function video($site_id=FALSE)
	{
		$data['page_title'] = $this->lang->line('video_report');
		$data['breadcrumb'] = '';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key=get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites/'.$site_id,array("api_key"=>$api_key),'php');
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['site_id'] = $site_id;
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_VIDEOADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/video',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	
	public function fetch_video_stats($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_VIDEOADBLOCK';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'VIDEO',
						'site_id'=>$site_id
					  );
	
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';
		
		$input['language'] = $this->config->item('language');
		$input['exchangeval'] = $this->config->item('exchangeRate');
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	/*
	 * 
	 * name		:city
	 * @param   :Null
	 * @return  :List all the city map for a particular
	 * 			 Publisher
	 */	
	
		
	public function city()
	{
		$data['page_title'] = $this->lang->line('city_report');

		$data['breadcrumb'] = '';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key=get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_CITY_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);	
		$data['content'] = $this->load->view('reports/city',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	public function fetch_city_stat($env='all',$site_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CITY_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'CITY'
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
				if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
	    $input['language'] = $this->config->item('language');
		echo $data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
	}
}
