<?php 
class Payments extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('pdf');
	}
	
	function index()
	{
		$this->payments();		
	}
	
	/*
	 * 
	 * name		:payments
	 * @param   :Null
	 * @return  :payments for a particular
	 * 			 Publisher
	 */	
	 	
	public function payments()
	{	
		$data['page_title'] = $this->lang->line('payments');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('payments/payments',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:payments
	 * @param   :Null
	 * @return  :payments for a particular
	 * 			 Publisher
	 */	
	 	
	public function payments_invoice()
	{	
		$data['page_title'] = $this->lang->line('payment_inv');	
		$data['breadcrumb'] = '';		
		$invoice_id=$this->uri->segment(4);
		$exchangeval = $this->config->item('exchangeRate');
		$data['invoice_details']=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$invoice_id,'api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'php'); 
		//print_r($data['invoice_details']);exit;
		$data['content'] = $this->load->view('payments/payments_invoice',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	 /*
   * 
   * name: fetch_publisher_invoice_list
   * @param : account_id
   * @return : all payment invoice details using pub account_id
   */
   
	public function fetch_publisher_invoice_list()
	{
	  $exchangeval = $this->config->item('exchangeRate');
	  $invoice_list=$this->rest->get('api/v1/payments/fetch_publisher_invoice_list',array('api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json');	
	  echo convert_to_datatable_format($invoice_list);
	}
	
	
	/*
	 * 
	 * name		:payments_history
	 * @param   :Null
	 * @return  :payments for a particular
	 * 			 Publisher
	 */	
	public function payment_history()
	{	
		$data['page_title'] = $this->lang->line('payment_his');	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('payments/payments_history',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
  /*
   * 
   * name: fetch_publisher_history_list
   * @param : account_id
   * @return : all payment invoice details using pub account_id
   */
  	public function fetch_publisher_history_list()
	{
	  $exchangeval = $this->config->item('exchangeRate');
	  $pub_history_list=$this->rest->get('api/v1/payments/fetch_publisher_payment_history',array('api_key'=>get_session('api_key'),'exchangeval'=> $exchangeval),'json');
	  
	  echo convert_to_datatable_format($pub_history_list);
	}
	
   /*
   * 
   * name: get_payment_history_details
   * @param : account_id,month,year
   * @return : all payment invoice details using pub account_id
   */
   public function get_payment_history_details()
	{
	   $month=$this->input->post('month');
	   $year=$this->input->post('year');
	   $exchangeval = $this->config->item('exchangeRate');
	   #$account_id=$this->input->post('accountid');
	   $pub_history=$this->rest->post('api/v1/payments/fetch_pub_date_wise_payment',array('api_key'=>get_session('api_key'),'month'=>$month,'year'=>$year,'exchangeval'=>$exchangeval),'json');
	   
	//   print_r($pub_history); exit; 
	   
	   echo convert_to_datatable_format($pub_history);
	}
	
	public function download_invoice_details($invoice_id)
	{
	    $invoice_information=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('api_key'=>get_session('api_key'),'id'=>$invoice_id),'php');
	  // print_r($invoice_information); exit;
	 	if($invoice_information)
		{
			$data['invoice_details'] = $invoice_information;
			//$view = $this->load->view('admin/invoice_pub',$data,true);
			#$payment_date = date('Y-m-d',strtotime($data['payment_info']['invoice_paid_date']));
			#$pdf_name = 'invoice_'.$data['payment_info']['invoice_code'].'_'.$payment_date;
			$pdf_name = 'Your_invoice';
			$this->pdf->load_view('publisher/payments/download_invoice',$data);
			$this->pdf->render();
			$this->pdf->stream("$pdf_name.pdf");
			#$this->load->view('publisher/payments/download_invoice',$data);	
		}else{
			return FALSE;
		}
	}
	
}
