<?php 
class Onetime_wizard extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->personal_information();		
	}
	
	/*
	 * 
	 * name		:personal_information
	 * @param   :Null
	 * @return  :List all information for a particular
	 * 			 Publisher
	 */	
		
	public function personal_information()
	{
		$data['page_title'] = $this->lang->line('account_preferences');
		$data['breadcrumb'] = '';		
		$personal_info=$this->rest->get('api/v1/onetime_wizard/user_info',array('account_id'=>get_session('account_id'),'type'=>get_session('account_type')),'php');	
		$data['personal_info']=$personal_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		$data['payment_info']=$this->rest->get('api/v1/onetime_wizard/wire_paypal_info',array('account_id'=>get_session('account_id')),'php');	
		$paypal_info=$this->rest->get('api/v1/network/fetch_paypal_info',array("api_key"=>get_session('api_key')),'php');	
		$data['paypal']=	$paypal_info[0];
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array('api_key'=>get_session('api_key')),'php');	
		$data['content'] = $this->load->view('onetime_wizard',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}

	
	
	
}
