<?php 
class Mobile_ad_blocks extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->helper('download');
	}
	
	function index()
	{
		$this->mobile_ad_blocks();		
	}
	
	/*
	 * 
	 * name		:mobile_ad_blocks
	 * @param   :Null
	 * @return  :List all the Mobile Adblocks for a particular
	 * 			 Publisher
	 */	
		
	public function mobile_ad_blocks()
	{
		$data['page_title'] = $this->lang->line('mob_ad_block');
		$data['breadcrumb'] = '';	
		#$account_id = get_session('account_id');
		$api_key = get_session('api_key');
		$data['sites']=$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['CHART']['DEFAULT_INTERVAL']);	
		$data['content'] = $this->load->view('adblocks/mobile_ad_blocks',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	

	 
	 
	/*
	 * 
	 * name: fetch_adblocks_get
	 * @param :
	 * @return : Array
	 * 
	 * Returns a sets off matched zones
	 */
	 
	public function link_ads($zone_id = FALSE)
	{
		/* added by karthika on dec -12*/

			$acc_id = get_session('account_id');
			
			$pub_id = $this->rest->get('api/v1/web_adblock/fetch_pub',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 	
				
			   if($acc_id == $pub_id)
			   {
				 /*end */												
				if(!$zone_id || !is_numeric($zone_id))
				{
					$this->mobile_ad_blocks();
				}
				else
				{
					$data['page_title'] 	= 	$this->lang->line('zone_ban_link');
					$data['breadcrumb']		= 	'';
					$data['zone_id']		=	$zone_id;
					
					$data['zone_data'] 		= 	$this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php');								
					// GET DEFAULT PERIOD FROM CONFIG FILE
					$data['content'] 		=	$this->load->view('adblocks/link_ads',$data,TRUE);
					$this->template->set_layout('publisher_layout');
					$this->template->build('view', $data);
				}
				/* added by karthika on dec-12 */
				}else{
				redirect( site_url('publisher/web_ad_blocks'), "refresh");				
				}
				/* end */					
	}
		
		
		/*
	 * 
	 * name		:add_mobile_adblock
	 * @param   :Null
	 * @return  :Adds the mobile zone (or) adblock
	 * 			 
	 */	
	public function add_mobile_adblock()
	{
		#$account_id=get_session('account_id');
		$api_key = get_session('api_key');
		$data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
		$data['zone_sizes']=$this->rest->get('api/v1/web_adblock/zonesizelist',array('api_key'=>$api_key),'php');
		$data['sites']=$this->rest->get('api/v1/site/fetch1',array("api_key"=>$api_key),'php');
		$dsp_det =$this->rest->get('api/v1/utilities/dspdetails',array("api_key"=>$api_key,"agency"=>$agencyid),'php');
		$data['dsp'] = $dsp_det;		
		if($data['dsp']!='')
		{
			array_push($data['dsp'],array("exchange_name" => "All DSP's","exchange_id"=>"all"));
		}	
		//echo '<pre>';print_r($data['sites']);echo '</pre>';
		echo $this->load->view('adblocks/modal_adblocks/content/add_mobile_adblock',$data);
	}
	
	
	/*
	 * Edit the adblock
	 * 
	 * name		:edit_mobile_adblock
	 * @param   :Zone id
	 * @return  :Fetches the ad block content and view it
	 * 
	 * 			 
	 */
	
	public function edit_mobile_adblock($zone_id = FALSE)
	{

		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');

			$pub_id = $this->rest->get('api/v1/web_adblock/fetch_pub',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 	
				
			   if($acc_id == $pub_id)
			   {
				 /*end */								
				$api_key=get_session('api_key');
				$data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
				$data['sites']=$this->rest->get('api/v1/site/fetch1',array("api_key"=>$api_key),'php');
				$data['zone_sizes']=$this->rest->get('api/v1/web_adblock/zonesizelist',array('api_key'=>$api_key),'php');
				
				$mobile_adblock = $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
				$dsp_sel =$this->rest->get('api/v1/rtb/fetch_dspdetails',array('zone_id'=>$zone_id, 'agency_id'=>$agency_id,"api_key"=>$api_key),'json');
				if($mobile_adblock[0]['rtb_type'] == 1)
				{
					$rtb_params = $this->rest->get('api/v1/mobile_adblock/fetch_rtb_params',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
				}
				   $dsp_sel1=json_decode($dsp_sel);  
				   foreach($dsp_sel1 as $value)
				   {
					 
					   $data['dsp_select'] = explode(',',$value);
				   }
					$dsp_details=$this->rest->get('api/v1/utilities/dspdetails',array("api_key"=>$api_key),'php');
					
					$data['dsp'] = $dsp_details;
					
					if($data['dsp']!='')
					{
						
						array_push($data['dsp'],array("exchange_name" => "All DSP's","exchange_id"=>"all"));
					}
				//print_r($rtb_params); exit;
				$data['rtb_params'] = $rtb_params[0];	//print_r($web_adblock); exit;
				//$web_adblock = json_decode($web_adblock);
				if(!empty($data['rtb_params']['app_section']))
				{  
				  $data['sel_category'] = explode(',',$data['rtb_params']['app_section']);
					
				}else{
					$data['sel_category'] = '';
				}

				if(!empty($data['rtb_params']['app_page']))
				{  
				  $data['sel_category_page'] = explode(',',$data['rtb_params']['app_page']);
					
				}else{
					$data['sel_category_page'] = '';
				}

				if(!empty($data['rtb_params']['ban_battr']))
				{  
				  $data['sel_ban_battr'] = explode(',',$data['rtb_params']['ban_battr']);
					
				}else{
					$data['sel_ban_battr'] = '';
				}
				if(!empty($data['rtb_params']['ban_btype']))
				{  
				  $data['sel_ban_btype'] = explode(',',$data['rtb_params']['ban_btype']);
					
				}else{
					$data['sel_ban_btype'] = '';
				}
				//print_r($data['sel_ban_btype']);
				if(!empty($data['rtb_params']['ban_mimes']))
				{  
				  $data['sel_ban_mimes'] = explode(',',$data['rtb_params']['ban_mimes']);
					
				}else{
					$data['sel_ban_mimes'] = '';
				}
				//rtb params 
				$btypes = Array ( 0 => Array ( 'id' => 1 ,'name' => 'XHTML Text Ad' ),
								  1 => Array ('id' => 2 ,'name' => 'XHTML Banner Ad'),
								  2 => Array ('id' => 3 ,'name' => 'JavaScript Ad; must be valid XHTML'),
								  3 => Array ('id' => 4 ,'name' => 'iframe')
								);
				$data['btype'] = $btypes;		
				$text_mime = Array ( 0 => Array ( 'id' => 1 ,'name' => 'text/plain' ),
								  1 => Array ('id' => 2 ,'name' => 'text/html')
								  
								);
				$data['textmime'] = $text_mime;		
				$battrs = Array ( 0 => Array ( 'id' => 1 ,'name' => 'Expand' ),
								  1 => Array ('id' => 2 ,'name' => 'Creative')
								  
								);
				$data['battr'] = $battrs;
				//$web_adblock = json_decode($web_adblock);
				
				//$web_adblock = json_decode($web_adblock);
				
				//$data['web_adblock'] = (array)$web_adblock[0];
				
				$data['mobile_adblock'] = $mobile_adblock[0];
				if($mobile_adblock[0]['dj_zone_type'] == 'M_A_PV'){
					$data['rv_pause_settings']=$this->rest->get('api/v1/mobile_adblock/rv_pause_settings',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php');

					
				}

				
				echo $this->load->view('adblocks/modal_adblocks/content/edit_mobile_adblock',$data);
				/* added by karthika on dec-12 */
			}else{
			redirect( site_url('publisher/web_ad_blocks'), "refresh");				
			}
			/* end */				
	}
	
	/*
	 * Lists the Web ad blocks
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblocks()
	{
		#$account_id = get_session('account_id');
		$api_key	 = get_session('api_key');
		$siteid = get_session('site_id');
	
		$mob_adblocks	= $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key,"siteid"=>$siteid),'json');
		
		echo convert_to_datatable_format($mob_adblocks);
	}
	
		/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_ad_tag($zone_id = FALSE)
	{
		if($zone_id)
		{
		/* added by karthika on dec -12*/
			$acc_id = get_session('account_id');

			$pub_id = $this->rest->get('api/v1/web_adblock/fetch_pub',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 	
				
			   if($acc_id == $pub_id)
			   {
				 /*end */											
					$data['zone_id'] = $zone_id;
					
					//If Post values are given
					if($this->input->post() !='')
					{
						$data['zone_id'] = $zone_id;
						$api_key=get_session('api_key');
						$data['zone_det'] = $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
						$data['source_sel'] = $this->input->post('source');	
					}else{
						$data['zone_id'] = $zone_id;
						$api_key=get_session('api_key');
						$data['zone_det'] = $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
						$data['source_sel'] = '';	
					}
					  /* check for dsp status on zone related start*/
					  $data['dsp_site'] = $this->rest->get('api/v1/web_adblock/fetch_dsp',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php');
				     /* check for dsp status on zone related*/
				     $data['video_details'] = $this->rest->get('api/v1/web_adblock/fetch_video_details',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php');
				     //print_r($data['dsp_site']);die('welcome');
                     // print_r($data); exit;
						/* added by karthika on dec-12 */
						}else{
						redirect( site_url('publisher/web_ad_blocks'), "refresh");				
						}
						/* end */						
					
					echo $this->load->view('adblocks/modal_adblocks/content/generate_adtag',$data);
				}else{
					return FALSE;	
				}
			
	}
	
	
			/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: mobile sdk
	 * @param   : $zone_id
	 * @return  : Download the mobile SDK for android and ios
	 * 
	 * 			 
	 */	
	
	public function mobile_sdk($zone_id = FALSE)
	{
		if($zone_id)
		{
			#$account_id=get_session('account_id');
			$api_key=get_session('api_key');
			
			$data['zone_id'] = $zone_id;
			
			$mobile_adblock = $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
		
			//$web_adblock = json_decode($web_adblock);
		
		 	//$data['web_adblock'] = (array)$web_adblock[0];
		
			$data['mobile_adblock'] = $mobile_adblock[0];
			$data['zone_det'] =$mobile_adblock[0];
			echo $this->load->view('adblocks/modal_adblocks/content/mobile_sdk',$data);
		}else{
			return FALSE;	
		}	
	}
	
	 /*Dowmloads the android apps
	 * 
	 * 
	 * name		: download
	 * @param   : $zone_id
	 * @return  : Download the mobile SDK for android
	 * 
	 * 	
	 * $my_file = 'file.txt';
$handle = fopen($my_file, 'w') or die('Cannot open file:  '.$my_file);
$data = 'This is the data';
fwrite($handle, $data);		 
	 */	
	
	public function download($type)
	{
		switch($type)
		{
			case 'android':
					 $data = file_get_contents("support/mobile_sdk/dJAXAdexchangeAppAndroid.zip"); // Read the file's contents
					 $name = 'support/mobile_sdk/AppAndroid.zip'; 
					 $file="AppAndroid.zip";
					 $handle = fopen($name, 'w+') or die('Cannot open file:  '.$name);
					fwrite($handle, $data);		 
					fclose($handle);
					force_download($file, $data);
					break;
			case 'ios':
					$data = file_get_contents("support/mobile_sdk/dJAXAdexchangeAppiOS.zip"); // Read the file's contents
					$name = 'support/mobile_sdk/AppiOS.zip'; 
					$file="AppiOS.zip";
					$handle = fopen($name, 'w+') or die('Cannot open file:  '.$name);
					fwrite($handle, $data);		 
					fclose($handle);
					force_download($file, $data);
					break;
		}
		 
	}
	

	
}
